/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.RecoveryBackupValidator;

@UIRef(value="RecoveryBackupUI")
@ValidatorRef(value=RecoveryBackupValidator.class)
public class RecoveryBackupAction
implements Action {
    public final void execute(FlowContext flowContext) {
    }

    public final Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (dbBean.isUseDBControlCase()) {
            if (dbBean.isReceiveEmailNotification()) {
                System.setProperty("oracle.sysman.server.EMSMTPServer", dbBean.getEm_SMTPServer());
                System.setProperty("oracle.sysman.server.EMEmail", dbBean.getEm_EmailAddress());
                if (dbBean.isEnableAutoBackup()) {
                    System.setProperty("oracle.sysman.server.EMConfigureOption", "ALL");
                    System.setProperty("oracle.sysman.server.username", dbBean.getRecoveryBackUpUsername());
                    System.setProperty("oracle.sysman.server.userpwd", dbBean.getRecoveryBackUpPassword());
                    System.setProperty("oracle.sysman.server.autobackup", "ALL");
                } else {
                    System.setProperty("oracle.sysman.server.EMConfigureOption", "NOBACKUP");
                }
            } else if (dbBean.isEnableAutoBackup()) {
                System.setProperty("oracle.sysman.server.EMConfigureOption", "NOEMAIL");
                System.setProperty("oracle.sysman.server.username", dbBean.getRecoveryBackUpUsername());
                System.setProperty("oracle.sysman.server.userpwd", dbBean.getRecoveryBackUpPassword());
            } else {
                System.setProperty("oracle.sysman.server.EMConfigureOption", "LOCAL");
            }
        } else {
            System.setProperty("oracle.sysman.server.EMConfigureOption", "CENTRAL");
            System.setProperty("oracle.sysman.server.centralagent", dbBean.getEm_CentralAgentSelected());
        }
        if (dbBean.isEnableAutoBackup() && dbBean.isUseFileSystemForRecoverySelected()) {
            dbBean.setRecoveryAreaDestination(" -recoveryAreaDestination " + dbBean.getRecoveryBackUpLocation());
        } else if (!dbBean.isEnableAutoBackup()) {
            dbBean.setRecoveryAreaDestination(" -recoveryAreaDestination NO_VALUE ");
        }
        if (dbBean.getDatabase_StorageType_Chosen() == 2 || dbBean.isEnableAutoBackup() && !dbBean.isUseFileSystemForRecoverySelected()) {
            return new Route("asm_chosen_asm_present");
        }
        return new Route("asm_not_chosen");
    }
}

