/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.SchemaPasswordValidator;

@UIRef(value="SchemaPasswordUI")
@ValidatorRef(value=SchemaPasswordValidator.class)
public class SchemaPasswordAction
implements Action {
    private static final Logger logger = Logger.getLogger(SchemaPasswordAction.class.getName());

    public void execute(FlowContext flowContext) {
    }

    public Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (dbBean.isUseSamePasswordCase()) {
            System.setProperty("oracle.assistants.server.syspwd", dbBean.getGenericPassword());
            System.setProperty("oracle.assistants.server.sysmanpwd", dbBean.getGenericPassword());
            System.setProperty("oracle.assistants.server.dbsnmpwd", dbBean.getGenericPassword());
            System.setProperty("oracle.assistants.server.systempwd", dbBean.getGenericPassword());
        } else if (dbBean.getListOfSuperAdminPasswords().length == 4) {
            System.setProperty("oracle.assistants.server.syspwd", dbBean.getListOfSuperAdminPasswords()[0]);
            System.setProperty("oracle.assistants.server.systempwd", dbBean.getListOfSuperAdminPasswords()[1]);
            System.setProperty("oracle.assistants.server.sysmanpwd", dbBean.getListOfSuperAdminPasswords()[2]);
            System.setProperty("oracle.assistants.server.dbsnmpwd", dbBean.getListOfSuperAdminPasswords()[3]);
        }
        logger.info("dbBean.getDatabase_StorageType_Chosen() is :" + dbBean.getDatabase_StorageType_Chosen());
        logger.info("dbBean.isEnableAutoBackup() is:" + dbBean.isEnableAutoBackup());
        logger.info("dbBean.isUseFileSystemForRecoverySelected() is:" + dbBean.isUseFileSystemForRecoverySelected());
        return Route.SUCCESS;
    }
}

