/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.io.File;
import java.text.DecimalFormat;
import oracle.install.commons.base.interview.common.action.AbstractSummaryAction;
import oracle.install.commons.base.summary.Category;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.summary.Variable;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.util.DBInstallSupport;
import oracle.install.library.partition.PartitionInfoUnix;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.StageSizeInfo;

public class SummaryAction
extends AbstractSummaryAction {
    private static final DecimalFormat DISK_SPACE_FORMATTER = new DecimalFormat(".##");

    protected void buildSummary(FlowContext flowContext) {
        boolean showDBAGroup;
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        Summary summary = Summary.getInstance();
        summary.clear();
        summary.setTitle("Summary");
        summary.setDescription(application.getName());
        String description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_GLOBAL_SETTING_CATEGORY", "Global settings.", new Object[0]);
        Category globalSettingsCategory = new Category("GlobalSettings", description);
        summary.addCategory(globalSettingsCategory);
        try {
            boolean considerOracleHomeOffset = true;
            long requiredSpace = StageSizeInfo.getSize((String)dbBean.getInstall_Type().getValue(), (boolean)considerOracleHomeOffset);
            String oracleHomeFolder = SummaryAction.getLastExistingParent(dbBean.getOracleHome());
            long freeSpace = PartitionInfoUnix.getPartitionFreeSpace((String)oracleHomeFolder);
            String stringTotalSpace = this.readableSpace(freeSpace);
            String message = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DISK_SPACE_REQUIRED", "required {0} available {1}", new Object[]{this.readableSpace(requiredSpace), stringTotalSpace});
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DISK_SPACE", "Disk space", new Object[0]);
            globalSettingsCategory.addVariable(new Variable("requiredPercentage", description, (Object)message));
        }
        catch (InstallException e) {
            // empty catch block
        }
        String fromLoc = FunctionsUtil.pathify((String)dbBean.getProductDescriptorLocation());
        description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TITLE_SOURCE_LOC", "Source location", new Object[0]);
        Variable sourceVar = new Variable("Source", description, (Object)fromLoc);
        globalSettingsCategory.addVariable(sourceVar);
        description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_INSTALL_METHOD", "Install method", new Object[0]);
        String installMethodString = resource.getString("DB_QUICK_INSTALL_BASIC_LABEL", "Typical Installation", new Object[0]);
        DBInstallSettings.InstallOption optionSelected = dbBean.getSelectedInstallOption();
        if (dbBean.isAdvancedInstall() && optionSelected != DBInstallSettings.InstallOption.INSTALL_DB_SWONLY) {
            installMethodString = resource.getString("DB_QUICK_INSTALL_ADVANCED_LABEL", "Advanced Installation", new Object[0]);
        }
        Variable installMethod = new Variable("installMethod", description, (Object)installMethodString);
        globalSettingsCategory.addVariable(installMethod);
        description = resource.getString("INSTALL_DB_INSTALL_EDITION_LABEL", "Database edition", new Object[0]);
        String installEditionString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TYPE_SE_LABEL", "Standard Edition", new Object[0]);
        switch (dbBean.getDbInstallEdition()) {
            case EE: {
                installEditionString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TYPE_EE_LABEL", "Enterprise Edition", new Object[0]);
                break;
            }
            case SE: {
                installEditionString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TYPE_SE_LABEL", "Standard Edition", new Object[0]);
                break;
            }
            case SEONE: {
                installEditionString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TYPE_SE1_LABEL", "Standard Edition One", new Object[0]);
                break;
            }
            case PE: {
                installEditionString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TYPE_PE_LABEL", "Personal Edition", new Object[0]);
            }
        }
        String installOption = "";
        if (optionSelected == DBInstallSettings.InstallOption.INSTALL_DB_AND_CONFIG) {
            installOption = resource.getString("INSTALL_DB_INSTALL_OPTIONS_DLG_CREATE_DB_LABEL", "Create and Configure a Database", new Object[0]);
        }
        if (optionSelected == DBInstallSettings.InstallOption.INSTALL_DB_SWONLY) {
            installOption = resource.getString("INSTALL_DB_INSTALL_OPTIONS_DLG_DB_SOFTWARE_LABEL", "Install Database Software Only.", new Object[0]);
        }
        if (optionSelected == DBInstallSettings.InstallOption.UPGRADE_DB) {
            installOption = resource.getString("INSTALL_DB_INSTALL_OPTIONS_DLG_UPGRADE_LABEL", "Upgrade an existing instance", new Object[0]);
        }
        installOption = SwingUtils.getTextWithoutMnemonics((String)installOption);
        Variable installType = new Variable("installType", description, (Object)(installEditionString + " (" + installOption + ")"));
        globalSettingsCategory.addVariable(installType);
        description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TITLE_ORACLE_BASE", "Oracle base", new Object[0]);
        Variable oracleBaseVar = new Variable("OracleBase", description, (Object)dbBean.getOracleBase());
        globalSettingsCategory.addVariable(oracleBaseVar);
        description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_TITLE_ORACLE_HOME", "Software location", new Object[0]);
        Variable oracleHomevar = new Variable("OracleHome", description, (Object)dbBean.getOracleHome());
        globalSettingsCategory.addVariable(oracleHomevar);
        boolean bl = showDBAGroup = dbBean.getDbaGroupNameUsed() != null;
        if (showDBAGroup) {
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DBA_GROUP", "OSDBA group", new Object[0]);
            Variable groupVar = new Variable("dba", description, (Object)dbBean.getDbaGroupNameUsed());
            globalSettingsCategory.addVariable(groupVar);
        }
        if (!InventoryInfo.getInstance().isInventoryExist()) {
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_INVENTORY_CATEGORY", "Inventory information", new Object[0]);
            Category inventoryDetail = new Category("inventoryDetail", description);
            summary.addCategory(inventoryDetail);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_INVENTORY_LOCATION", "Inventory location.", new Object[0]);
            Variable invLoc = new Variable("invLoc", description, (Object)cenInv.getInventoryLocation());
            inventoryDetail.addVariable(invLoc);
            if (!PlatformInfo.getInstance().isWindows()) {
                description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_OPER_GROUP", "Unix inventory group:", new Object[0]);
                Variable groupVarOper = new Variable("oper", description, (Object)cenInv.getGroupOwnership());
                inventoryDetail.addVariable(groupVarOper);
            }
        }
        if (optionSelected == DBInstallSettings.InstallOption.INSTALL_DB_AND_CONFIG) {
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DBINFO_CATEGORY", "Database information", new Object[0]);
            Category dbDetail = new Category("zdbDetail", description);
            summary.addCategory(dbDetail);
            DBInstallSettings.StarterDatabaseType starterDBType = dbBean.getStarterDatabaseType();
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DB_CONFIG_TPYE", "Configuration", new Object[0]);
            String cfgTypeString = resource.getString("INSTALL_DB_CONFIGURATION_TYPE_DLG_GP_LABEL", "General Purpose / Transaction Processing", new Object[0]);
            if (starterDBType == DBInstallSettings.StarterDatabaseType.DATA_WAREHOUSE) {
                cfgTypeString = resource.getString("INSTALL_DB_CONFIGURATION_TYPE_DLG_DW_LABEL", "Data Warehousing", new Object[0]);
            }
            cfgTypeString = SwingUtils.getTextWithoutMnemonics((String)cfgTypeString);
            Variable cfgTypeSum = new Variable("cfgTypeSum", description, (Object)cfgTypeString);
            dbDetail.addVariable(cfgTypeSum);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_GLOBAL_DATABASE_NAME", "Global database Name", new Object[0]);
            Variable gdbName = new Variable("gdbName", description, (Object)dbBean.getGlobalDBName());
            dbDetail.addVariable(gdbName);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_SID_LABEL", "Oracle system identifier (SID)", new Object[0]);
            Variable dbSID = new Variable("dbSID", description, (Object)dbBean.getDb_SID());
            dbDetail.addVariable(dbSID);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_MEMORY_FACTOR_LABEL", "Allocated memory", new Object[0]);
            Variable memFactor = new Variable("memFactor", description, (Object)(String.valueOf(dbBean.getAllocatedMemory()) + " " + application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_MB_SUFFIX"), new Object[0])));
            dbDetail.addVariable(memFactor);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_AUTO_MEMORY_OPTION_LABEL", "Automatic memory management option", new Object[0]);
            Variable autoMemOption = new Variable("autoMemOption", description, (Object)String.valueOf(dbBean.getAutoMemoryOptionSelection()).toUpperCase());
            dbDetail.addVariable(autoMemOption);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_CHARSET_LABEL", "Database character set", new Object[0]);
            String charsetDesc = null;
            String charSet = null;
            if (dbBean.getCharacterSet() != null && dbBean.getCharacterSet().trim().length() > 0) {
                charsetDesc = DBInstallSupport.getCharsetDesc(dbBean.getCharacterSet());
            }
            if (charsetDesc != null) {
                charSet = charsetDesc + " (" + dbBean.getCharacterSet() + ")";
            }
            Variable dbCharset = new Variable("dbCharset", description, charSet);
            dbDetail.addVariable(dbCharset);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DB_MANAGE_METHOD", "Management method", new Object[0]);
            boolean isMgmtMethodGC = dbBean.getEm_CentralAgentSelected() != null && dbBean.getEm_CentralAgentSelected().trim().length() > 0;
            String mgmtMethodString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DB_MANAGE_METHOD_GC", "Grid control", new Object[0]);
            if (!isMgmtMethodGC) {
                mgmtMethodString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_DB_MANAGE_METHOD_DB", "Database  control", new Object[0]);
            }
            Variable mgmtMethod = new Variable("mgmtMethod", description, (Object)mgmtMethodString);
            dbDetail.addVariable(mgmtMethod);
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_STORAGE_TYPE", "Database storage mechanism", new Object[0]);
            boolean isFileStorage = dbBean.getDatabase_StorageType_Chosen() == 1;
            String storageTypeString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_STORAGE_TYPE_FS", "File system", new Object[0]);
            if (!isFileStorage) {
                storageTypeString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_STORAGE_TYPE_ASM", "ASM ", new Object[0]);
            }
            Variable storageType = new Variable("storageType", description, (Object)storageTypeString);
            dbDetail.addVariable(storageType);
            if (isFileStorage) {
                description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_STORAGE_LOCATION", "Database file location", new Object[0]);
                Variable storageLoc = new Variable("storageLoc", description, (Object)dbBean.getOraDataLocation());
                dbDetail.addVariable(storageLoc);
            }
            boolean isBackupAuto = dbBean.isEnableAutoBackup();
            description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_BACKUP_AUTO", "Automated backup", new Object[0]);
            String autoBackupString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_BACKUP_AUTO_DISABLED", "Disabled ", new Object[0]);
            if (isBackupAuto) {
                autoBackupString = resource.getString("INSTALL_DB_INSTALL_SUMMARY_BACKUP_AUTO_ENABLED", "Enabled ", new Object[0]);
            }
            Variable backupAuto = new Variable("backupAuto", description, (Object)autoBackupString);
            dbDetail.addVariable(backupAuto);
            if (isBackupAuto) {
                description = resource.getString("INSTALL_DB_INSTALL_SUMMARY_BACKUP_AUTO_STORAGE", "Backup storage mechanism", new Object[0]);
                String data = resource.getString("INSTALL_DB_INSTALL_SUMMARY_STORAGE_TYPE_FS", "File system ", new Object[0]);
                boolean useFileSystem = dbBean.isUseFileSystemForRecoverySelected();
                if (!useFileSystem) {
                    data = resource.getString("INSTALL_DB_INSTALL_SUMMARY_STORAGE_TYPE_ASM", "ASM ", new Object[0]);
                }
                Variable backupAutoFS = new Variable("backupAutoFS", description, (Object)data);
                dbDetail.addVariable(backupAutoFS);
            }
        }
    }

    private String readableSpace(long space) {
        String stringSpace = "";
        if ((float)space < 1024.0f) {
            stringSpace = space + " MB";
        } else {
            stringSpace = DISK_SPACE_FORMATTER.format((float)space / 1024.0f);
            stringSpace = stringSpace + " GB";
        }
        return stringSpace;
    }

    public static String getLastExistingParent(String inputPath) {
        File f = new File(inputPath);
        if (f.exists() && f.isDirectory()) {
            return inputPath;
        }
        return SummaryAction.getLastExistingParent(f.getParent().toString());
    }
}

