/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowHelper;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.bean.DBSetupBean;
import oracle.install.ivw.db.validator.SystemClassValidator;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.MachineInfo;

@UIRef(value="SystemClassUI")
@ValidatorRef(value=SystemClassValidator.class)
public class SystemClassAction
extends DefaultAction {
    private Logger logger = Logger.getLogger(SystemClassAction.class.getName());
    private static final Route DESKTOP_YES = new Route("desktop_class_yes");
    private static final Route SERVER_YES = new Route("server_class_yes");
    private static final String LOCALHOST = "localhost";

    public final Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        DBSetupBean setupBean = (DBSetupBean)((Object)flowContext.getBean(DBSetupBean.class));
        Route route = null;
        if (FlowHelper.isSilentMode((FlowContext)flowContext)) {
            dbBean.setSelectedSystemClass(DBInstallSettings.SystemClass.SERVER_CLASS);
        }
        DBInstallSettings.SystemClass selectedSystemClass = dbBean.getSelectedSystemClass();
        this.logger.log(Level.INFO, "selectedSystemClass is :" + (Object)((Object)selectedSystemClass));
        switch (selectedSystemClass) {
            case DESKTOP_CLASS: {
                route = DESKTOP_YES;
                dbBean.setAdvancedInstall(false);
                dbBean.setRACinstall(false);
                if (InstallHelper.getValue((String)"ORACLE_HOSTNAME") != null) break;
                setupBean.setOracleHostName(LOCALHOST);
                break;
            }
            case SERVER_CLASS: {
                if (InstallHelper.getValue((String)"ORACLE_HOSTNAME") == null) {
                    setupBean.setOracleHostName(MachineInfo.getInstance().getFullHostName());
                }
                route = SERVER_YES;
            }
        }
        return route;
    }
}

