/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.bean;

import java.util.Map;
import java.util.TreeMap;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.sysman.oii.oiix.OiixRegistryOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BeanDef(value="DBInstallSettings")
public class DBInstallSettings
extends InstallSettings {
    private boolean isOHOnOFS;
    private InstallType dbInstallType;
    private InstallEdition dbInstallEdition;
    private String unixGroupNameDBA;
    private String unixGroupName;
    private Integer oraMTSPortNumber;
    private boolean isCentrallyManageASMInstancePresent;
    private boolean isSecureConfigDisabled;
    private boolean isEnableAutoBackup;
    private boolean isLoadExampleSchemas;
    private boolean isReceiveEmailNotification;
    private boolean isStateOfUpgradeDBCheckboxChecked;
    private boolean isUseDBControlCase;
    private boolean isUseFileSystemForRecoverySelected;
    private boolean isUseSamePasswordCase;
    private boolean bAutoMemoryOption;
    private boolean customInstall;
    private boolean advancedInstall;
    private int configTabSelectedOption = 0;
    private int characterSet_Option_Selected = 3;
    private int upgradeableDatabaseSelectedByDefault = 0;
    private int database_StorageType_Chosen = 0;
    private Long allocatedMemory = null;
    private int performUpgradeOption = 0;
    private int upgradeDBOption = 0;
    private InstallOption selectedInstallOption = InstallOption.INSTALL_DB_AND_CONFIG;
    private SystemClass selectedSystemClass = SystemClass.DESKTOP_CLASS;
    private Map<String, String[]> componentDependencyMap = new TreeMap<String, String[]>();
    private Map<String, Boolean> componentBooleanMap = new TreeMap<String, Boolean>();
    private String oracleHomeSelectedForUpgrade = "";
    private String starterDatabaseCharacterSet = "AL32UTF8";
    private String selectedDatabaseUsesASM = "no";
    private String db_SID = "";
    private String db_SIDSelectedForUpgrade = "";
    private String em_CentralAgentSelected = "";
    private String em_EmailAddress = "";
    private String em_SMTPServer = "";
    private String recoveryBackUpPassword = "";
    private String recoveryBackUpLocation = "";
    private String recoveryBackUpUsername = "";
    private String globalDBName;
    private String oraDataLocation = "";
    private String diskGroupNameForASM = "";
    private String genericPassword = "";
    private String genericPasswordConfirm = "";
    private String asmsnmpPassword = "";
    private String[] listOfDiskGroupSelectedForASM = new String[]{"", "", ""};
    private String[] listOfSuperAdminPasswords = new String[]{""};
    private String[] listOfSuperAdminPasswdsAgain = new String[]{""};
    private String[] customComponents;
    private boolean isASMAlreadyUpgraded;
    private boolean isASMInstancePresent;
    private boolean isDBSelectedUsesASM;
    private boolean isASMCandidateDisksShown;
    private boolean isRACinstall;
    private boolean isLaunchDBCA;
    private boolean isLaunchNETCA;
    private boolean isLaunchODMA;
    private boolean isNoMigrationCase;
    private boolean isDBInstalling;
    private boolean isOracleBaseSet;
    private boolean isCCRAuthenticationUsed;
    private int varSelection = 0;
    private String[] listOfSelectedNodes = new String[0];
    private StarterDatabaseType starterDatabaseType = StarterDatabaseType.GENERAL_PURPOSE;
    private String characterSet = "";
    private String datafileDestination = "";
    private String dBNameToMigrate = "";
    private String diskGroupName = "";
    private String diskList = "";
    private String defaultRecoveryBackUpLocation = "";
    private String oCR_PartitionLocation = "";
    private String rawDeviceName = "";
    private String hTTP_PortRecorded = "";
    private String recoveryAreaDestination = "";
    private String redundancy = "";
    private String sampleSchema = "-sampleSchema true";
    private String storageType = "";
    private String upgradeASM = "";
    private String cs_dlgCfgNamingLabelSID = "SID:";
    private String asmcaArgs;
    private String em_CentralAgentHome = "";

    public DBInstallSettings() {
        this.setDbInstallEdition(InstallEdition.EE);
        this.isUseDBControlCase = true;
        String defaultPortNumber = null;
        if (PlatformInfo.getInstance().isWindows()) {
            try {
                String key = "HKEY_LOCAL_MACHINE";
                String subKey = "software\\oracle\\OracleMTSRecoveryService\\Protid_0";
                if (OiixRegistryOps.RegKeyExists((String)key, (String)subKey)) {
                    defaultPortNumber = OiixRegistryOps.RegGetValue((String)key, (String)subKey, (String)"Port");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (defaultPortNumber == null || defaultPortNumber == "") {
                defaultPortNumber = MachineInfo.getInstance().getFreePort(InstallConstants.WIN_PORT_NUMBER_RANGE_MIN.intValue(), InstallConstants.WIN_PORT_NUMBER_RANGE_MAX.intValue());
            }
            this.oraMTSPortNumber = Integer.parseInt(defaultPortNumber);
        }
        this.dbInstallType = InstallType.EE;
    }

    @PropertyDef(value="oracle_install_db_SecureConfigDisabled", persist=true)
    public boolean isSecureConfigDisabled() {
        return this.isSecureConfigDisabled;
    }

    public void setSecureConfigDisabled(boolean val) {
        this.isSecureConfigDisabled = val;
    }

    @PropertyDef(value="oracle_install_db_EnableAutoBackup", persist=true)
    public boolean isEnableAutoBackup() {
        return this.isEnableAutoBackup;
    }

    public void setEnableAutoBackup(boolean val) {
        this.isEnableAutoBackup = val;
    }

    @PropertyDef(value="oracle_install_db_LoadExampleSchemas", persist=true)
    public boolean isLoadExampleSchemas() {
        return this.isLoadExampleSchemas;
    }

    public void setLoadExampleSchemas(boolean val) {
        this.isLoadExampleSchemas = val;
    }

    @PropertyDef(value="oracle_install_db_ReceiveEmailNotification", persist=true)
    public boolean isReceiveEmailNotification() {
        return this.isReceiveEmailNotification;
    }

    public void setReceiveEmailNotification(boolean val) {
        this.isReceiveEmailNotification = val;
    }

    @PropertyDef(value="oracle_install_db_UseDBControl", persist=true)
    public boolean isUseDBControlCase() {
        return this.isUseDBControlCase;
    }

    public void setUseDBControlCase(boolean val) {
        this.isUseDBControlCase = val;
    }

    @PropertyDef(value="oracle_install_client_OraMTSPortNumber")
    public Integer getOraMTSPortNumber() {
        return this.oraMTSPortNumber;
    }

    public void setOraMTSPortNumber(Integer portNumber) {
        this.oraMTSPortNumber = portNumber;
    }

    @PropertyDef(value="oracle_install_db_UseFileSystemForRecovery", persist=true)
    public boolean isUseFileSystemForRecoverySelected() {
        return this.isUseFileSystemForRecoverySelected;
    }

    public void setUseFileSystemForRecoverySelected(boolean val) {
        this.isUseFileSystemForRecoverySelected = val;
    }

    @PropertyDef(value="oracle_install_db_UseSamePassword", persist=true)
    public boolean isUseSamePasswordCase() {
        return this.isUseSamePasswordCase;
    }

    public void setUseSamePasswordCase(boolean val) {
        this.isUseSamePasswordCase = val;
    }

    @PropertyDef(value="oracle_install_db_ConfigTabSelected", persist=true)
    public int getConfigTabSelectedOption() {
        return this.configTabSelectedOption;
    }

    public void setConfigTabSelectedOption(int intVal) {
        this.configTabSelectedOption = intVal;
    }

    @PropertyDef(value="oracle_install_db_CharSetOption", persist=true)
    public int getCharacterSet_Option_Selected() {
        return this.characterSet_Option_Selected;
    }

    public void setCharacterSet_Option_Selected(int intVal) {
        this.characterSet_Option_Selected = intVal;
    }

    @PropertyDef(value="oracle_install_db_StorageType", persist=true)
    public int getDatabase_StorageType_Chosen() {
        return this.database_StorageType_Chosen;
    }

    public void setDatabase_StorageType_Chosen(int intVal) {
        switch (intVal) {
            case 1: 
            case 2: {
                this.database_StorageType_Chosen = intVal;
                break;
            }
            default: {
                this.database_StorageType_Chosen = 1;
            }
        }
        this.database_StorageType_Chosen = intVal;
    }

    @PropertyDef(value="oracle_install_db_Type", persist=false)
    public int getDatabaseType_Chosen() {
        int databaseType_Chosen = 1;
        switch (this.starterDatabaseType) {
            case DATA_WAREHOUSE: {
                databaseType_Chosen = 2;
                break;
            }
            case GENERAL_PURPOSE: {
                databaseType_Chosen = 1;
            }
        }
        return databaseType_Chosen;
    }

    @PropertyDef(value="oracle_install_db_AutoMemoryOption", persist=true)
    public boolean getAutoMemoryOptionSelection() {
        return this.bAutoMemoryOption;
    }

    public void setAutoMemoryOptionSelection(boolean bSelection) {
        this.bAutoMemoryOption = bSelection;
    }

    @PropertyDef(value="oracle_install_db_AllocatedMemory", persist=true)
    public Long getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public void setAllocatedMemory(Long intVal) {
        this.allocatedMemory = intVal;
    }

    @PropertyDef(value="oracle_install_db_InstallOption", persist=true)
    public InstallOption getSelectedInstallOption() {
        return this.selectedInstallOption;
    }

    public void setSelectedInstallOption(InstallOption selectedOption) {
        this.selectedInstallOption = selectedOption;
    }

    @PropertyDef(value="oracle_install_db_InstallOptionSelected", persist=true)
    public int getInstallOptionSelected() {
        return this.selectedInstallOption.ordinal() + 1;
    }

    @PropertyDef(value="oracle_install_db_SystemClass", persist=true)
    public SystemClass getSelectedSystemClass() {
        return this.selectedSystemClass;
    }

    public void setSelectedSystemClass(SystemClass SystemClass2) {
        this.selectedSystemClass = SystemClass2;
    }

    @PropertyDef(value="oracle_install_db_SID", persist=true)
    public String getDb_SID() {
        return this.db_SID;
    }

    public void setDb_SID(String strVal) {
        this.db_SID = strVal;
    }

    @PropertyDef(value="oracle_install_db_DiskGroupNameForASM", persist=true)
    public String getDiskGroupNameForASM() {
        return this.diskGroupNameForASM;
    }

    public void setDiskGroupNameForASM(String strVal) {
        this.diskGroupNameForASM = strVal;
    }

    @PropertyDef(value="oracle_install_db_EMCentralAgentSelected", persist=true)
    public String getEm_CentralAgentSelected() {
        return this.em_CentralAgentSelected;
    }

    public void setEm_CentralAgentSelected(String strVal) {
        this.em_CentralAgentSelected = strVal;
    }

    public String getEm_CentralAgentHome() {
        return this.em_CentralAgentHome;
    }

    public void setEm_CentralAgentHome(String agentHome) {
        this.em_CentralAgentHome = agentHome;
    }

    @PropertyDef(value="oracle_install_db_EMEmailAddress", persist=true)
    public String getEm_EmailAddress() {
        return this.em_EmailAddress;
    }

    public void setEm_EmailAddress(String strVal) {
        this.em_EmailAddress = strVal;
    }

    @PropertyDef(value="oracle_install_db_EMSMTPServer", persist=true)
    public String getEm_SMTPServer() {
        return this.em_SMTPServer;
    }

    public void setEm_SMTPServer(String strVal) {
        this.em_SMTPServer = strVal;
    }

    @PropertyDef(value="oracle_install_db_RecoveryBackUpPassword", secure=true, persist=true)
    public String getRecoveryBackUpPassword() {
        return this.recoveryBackUpPassword;
    }

    public void setRecoveryBackUpPassword(String strVal) {
        this.recoveryBackUpPassword = strVal;
    }

    @PropertyDef(value="oracle_install_db_RecoveryBackUpLocation", persist=true)
    public String getRecoveryBackUpLocation() {
        return this.recoveryBackUpLocation;
    }

    public void setRecoveryBackUpLocation(String strVal) {
        this.recoveryBackUpLocation = strVal;
    }

    @PropertyDef(value="oracle_install_db_RecoveryBackUpUsername", persist=true)
    public String getRecoveryBackUpUsername() {
        return this.recoveryBackUpUsername;
    }

    public void setRecoveryBackUpUsername(String strVal) {
        this.recoveryBackUpUsername = strVal;
    }

    @PropertyDef(value="oracle_install_db_GlobalDBName", persist=true)
    public String getGlobalDBName() {
        return this.globalDBName;
    }

    public void setGlobalDBName(String strVal) {
        this.globalDBName = strVal;
    }

    @PropertyDef(value="oracle_install_db_MountPointLocation", persist=true)
    public String getOraDataLocation() {
        return this.oraDataLocation;
    }

    public void setOraDataLocation(String oraDataLocation) {
        this.oraDataLocation = oraDataLocation;
    }

    @PropertyDef(value="oracle_install_db_SuperAdminSamePasswdForAll", secure=true, persist=true)
    public String getGenericPassword() {
        return this.genericPassword;
    }

    public void setGenericPassword(String genericPassword) {
        this.genericPassword = genericPassword;
    }

    @PropertyDef(value="oracle_install_db_ASMSNMPUserPassword", secure=true, persist=true)
    public String getAsmsnmpPassword() {
        return this.asmsnmpPassword;
    }

    public void setAsmsnmpPassword(String asmsnmpPassword) {
        this.asmsnmpPassword = asmsnmpPassword;
    }

    @PropertyDef(value="oracle_install_db_SuperAdminPasswords", secure=true, persist=true)
    public String[] getListOfSuperAdminPasswords() {
        return this.listOfSuperAdminPasswords;
    }

    public void setListOfSuperAdminPasswords(String[] strArr) {
        this.listOfSuperAdminPasswords = strArr;
    }

    @PropertyDef(value="oracle_install_RACInstall", persist=false)
    public boolean isRACinstall() {
        return this.isRACinstall;
    }

    public void setRACinstall(boolean val) {
        this.isRACinstall = val;
    }

    @PropertyDef(value="oracle_install_db_LaunchDBCA", persist=false)
    public boolean isLaunchDBCA() {
        return this.isLaunchDBCA;
    }

    public void setLaunchDBCA(boolean val) {
        this.isLaunchDBCA = val;
    }

    @PropertyDef(value="oracle_install_LaunchNetCA", persist=false)
    public boolean isLaunchNETCA() {
        return this.isLaunchNETCA;
    }

    public void setLaunchNETCA(boolean val) {
        this.isLaunchNETCA = val;
    }

    @PropertyDef(value="oracle_install_db_LaunchODMA", persist=false)
    public boolean isLaunchODMA() {
        return this.isLaunchODMA;
    }

    public void setLaunchODMA(boolean val) {
        this.isLaunchODMA = val;
    }

    @PropertyDef(value="oracle_install_NoMigration", persist=false)
    public boolean isNoMigrationCase() {
        return this.isNoMigrationCase;
    }

    public void setNoMigrationCase(boolean val) {
        this.isNoMigrationCase = val;
    }

    @PropertyDef(value="oracle_install_RDBMSInstalling", persist=false)
    public boolean isDBInstalling() {
        return this.isDBInstalling;
    }

    public void setDBInstalling(boolean val) {
        this.isDBInstalling = val;
    }

    @PropertyDef(value="oracle_install_db_SetOracleBase", persist=false)
    public boolean isOracleBaseSet() {
        return this.isOracleBaseSet;
    }

    public void setOracleBaseSet(boolean val) {
        this.isOracleBaseSet = val;
    }

    @PropertyDef(value="oracle.install.db.isCCRAuthenticationUsed", persist=false)
    public boolean isCCRAuthenticationUsed() {
        return this.isCCRAuthenticationUsed;
    }

    public void setCCRAuthenticationUsed(boolean val) {
        this.isCCRAuthenticationUsed = val;
    }

    @PropertyDef(value="oracle_install_db_InstallEdition")
    public InstallEdition getDbInstallEdition() {
        return this.dbInstallEdition;
    }

    public void setDbInstallEdition(InstallEdition dbInstallEdition) {
        this.dbInstallEdition = dbInstallEdition;
        InstallType type = InstallType.EE;
        switch (this.dbInstallEdition) {
            case EE: {
                type = InstallType.EE;
                break;
            }
            case SE: {
                type = InstallType.SE;
                break;
            }
            case SEONE: {
                type = InstallType.SE;
                break;
            }
            case PE: {
                type = InstallType.PE;
            }
        }
        this.setDBInstallType(type);
    }

    @PropertyDef(value="oracle_install_db_CustomInstall")
    public boolean isCustomInstall() {
        return this.customInstall;
    }

    public void setCustomInstall(boolean customInstall) {
        this.customInstall = customInstall;
    }

    @PropertyDef(value="oracle_install_db_CharacterSet", persist=true)
    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String strVal) {
        this.characterSet = strVal;
    }

    @PropertyDef(value="oracle_install_db_DiskGroupName", persist=false)
    public String getDiskGroupName() {
        return this.diskGroupName;
    }

    public void setDiskGroupName(String strVal) {
        this.diskGroupName = strVal;
    }

    public String getDefaultRecoveryBackUpLocation() {
        return this.defaultRecoveryBackUpLocation;
    }

    public void setDefaultRecoveryBackUpLocation(String strVal) {
        this.defaultRecoveryBackUpLocation = strVal;
    }

    @PropertyDef(value="oracle_install_OCR_PartitionLocation", persist=false)
    public String getOCR_PartitionLocation() {
        return this.oCR_PartitionLocation;
    }

    public void setOCR_PartitionLocation(String strVal) {
        this.oCR_PartitionLocation = strVal;
    }

    public String getRecoveryAreaDestination() {
        return this.recoveryAreaDestination;
    }

    public void setRecoveryAreaDestination(String strVal) {
        this.recoveryAreaDestination = strVal;
    }

    public String getSampleSchema() {
        return this.sampleSchema;
    }

    public void setSampleSchema(String strVal) {
        this.sampleSchema = strVal;
    }

    @PropertyDef(value="CLUSTER_NODES", persist=true)
    public String[] getListOfSelectedNodes() {
        return this.listOfSelectedNodes;
    }

    public void setListOfSelectedNodes(String[] strArr) {
        this.listOfSelectedNodes = strArr;
    }

    public boolean isOHOnOFS() {
        return this.isOHOnOFS;
    }

    public void setOHOnOFS(boolean isOHOnOFS) {
        this.isOHOnOFS = isOHOnOFS;
    }

    @PropertyDef(value="oracle_install_db_InstallType")
    public InstallType getDBInstallType() {
        return this.dbInstallType;
    }

    public void setDBInstallType(InstallType dbInstallType) {
        this.dbInstallType = dbInstallType;
    }

    @PropertyDef(value="INSTALL_TYPE")
    public InstallType getInstall_Type() {
        return this.getDBInstallType();
    }

    public void setInstall_Type(InstallType dbInstallType) {
        this.setDBInstallType(dbInstallType);
    }

    @PropertyDef(value="oracle_install_db_StarterDatabaseType", persist=true)
    public StarterDatabaseType getStarterDatabaseType() {
        return this.starterDatabaseType;
    }

    public void setStarterDatabaseType(StarterDatabaseType starterDatabaseType) {
        this.starterDatabaseType = starterDatabaseType;
    }

    @PropertyDef(value="oracle_install_db_ConfigurationType", persist=false)
    public String getConfigurationTypeReturned() {
        String configurationTypeReturned = "Software Only";
        if (this.getSelectedInstallOption() == InstallOption.INSTALL_DB_SWONLY) {
            configurationTypeReturned = "Software Only";
        } else if (this.getStarterDatabaseType() == StarterDatabaseType.GENERAL_PURPOSE) {
            configurationTypeReturned = "&General Purpose / Transaction Processing";
        } else if (this.getStarterDatabaseType() == StarterDatabaseType.DATA_WAREHOUSE) {
            configurationTypeReturned = "&Data Warehouse";
        }
        return configurationTypeReturned;
    }

    @PropertyDef(value="oracle_install_OSDBA", persist=true)
    public String getDbaGroupNameUsed() {
        return this.unixGroupNameDBA;
    }

    public void setDbaGroupNameUsed(String strVal) {
        this.unixGroupNameDBA = strVal;
    }

    @PropertyDef(value="oracle_install_OSOPER", persist=true)
    public String getOperGroupNameUsed() {
        return this.unixGroupName;
    }

    public void setOperGroupNameUsed(String strVal) {
        this.unixGroupName = strVal;
    }

    public Map<String, String[]> getComponentDependencyMap() {
        return this.componentDependencyMap;
    }

    public void setComponentDependencyMap(Map<String, String[]> componentDependencyMap) {
        if (componentDependencyMap == null) {
            this.componentDependencyMap.clear();
        } else {
            this.componentDependencyMap = componentDependencyMap;
        }
    }

    public Map<String, Boolean> getComponentBooleanMap() {
        return this.componentBooleanMap;
    }

    public void setComponentBooleanMap(Map<String, Boolean> componentBooleanMap) {
        if (componentBooleanMap == null) {
            this.componentBooleanMap.clear();
        } else {
            this.componentBooleanMap = componentBooleanMap;
        }
    }

    @PropertyDef(value="oracle_install_db_CustomComponents", persist=true)
    public String[] getCustomComponents() {
        return this.customComponents;
    }

    public void setCustomComponents(String[] customComponents) {
        this.customComponents = customComponents;
    }

    public ConfigurationType getConfigurationType() {
        ConfigurationType configurationType = ConfigurationType.NO_CONFIGURATION;
        if (this.getSelectedInstallOption() == InstallOption.INSTALL_DB_SWONLY) {
            configurationType = ConfigurationType.NO_CONFIGURATION;
        } else if (this.getStarterDatabaseType() == StarterDatabaseType.GENERAL_PURPOSE) {
            configurationType = ConfigurationType.GENERAL_PURPOSE;
        } else if (this.getStarterDatabaseType() == StarterDatabaseType.DATA_WAREHOUSE) {
            configurationType = ConfigurationType.DATA_WAREHOUSE;
        }
        return configurationType;
    }

    @PropertyDef(value="oracle_install_db_QuickInstallOption", persist=true)
    public boolean isAdvancedInstall() {
        return this.advancedInstall;
    }

    public void setAdvancedInstall(boolean advancedInstall) {
        this.advancedInstall = advancedInstall;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigurationType {
        NO_CONFIGURATION,
        GENERAL_PURPOSE,
        DATA_WAREHOUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallEdition {
        EE("EE"),
        SE("STD"),
        SEONE("STD"),
        PE("PE");

        private String value;

        private InstallEdition(String strValue) {
            this.value = strValue;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallType {
        EE("EE"),
        SE("SE"),
        PE("PE"),
        Custom("Custom");

        private String value;

        private InstallType(String strValue) {
            this.value = strValue;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StarterDatabaseType {
        GENERAL_PURPOSE,
        DATA_WAREHOUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SystemClass {
        DESKTOP_CLASS,
        SERVER_CLASS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallOption {
        INSTALL_DB_AND_CONFIG,
        INSTALL_DB_SWONLY,
        UPGRADE_DB;

    }
}

