/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.driver;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.activehelp.ActiveHelpRegistry;
import oracle.install.commons.activehelp.DefaultActiveHelpRegistry;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.interview.common.action.AbstractPrereqAction;
import oracle.install.commons.base.interview.common.util.PrereqExecutor;
import oracle.install.commons.bean.xml.PropertyFileFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.db.action.PrereqAction;
import oracle.sysman.oii.oiif.oiifo.OiifoOCMInterfaceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBInstaller
extends Installer {
    public static final String FLOW_CONFIG = "/oracle/install/ivw/db/resource/dbinstall-flow-config.xml";
    public static final String APPLICATION_CONFIG = "/oracle/install/ivw/db/resource/application-config.xml";

    public DBInstaller() {
        this.init();
    }

    protected void init() {
        SetupDriver.registerDriver((String)"oracle.install.ivw.db.driver.DBSetupDriver");
        System.setProperty("oracle.sysman.ccr.supressregistration", "true");
        XmlBeanStoreFormatRegistry registry = XmlBeanStoreFormatRegistry.getInstance();
        URL xsd = DBInstaller.class.getResource("/oracle/install/ivw/db/resource/responsefile/dbinstall_rspfmt_response_schema_v11_2_0.xsd");
        URL raw2extTransformer = DBInstaller.class.getResource("/oracle/install/ivw/db/resource/responsefile/rspfmt_raw2ext_transformer_v11_2_0.xsl");
        URL ext2rawTransformer = DBInstaller.class.getResource("/oracle/install/ivw/db/resource/responsefile/rspfmt_ext2raw_transformer_v11_2_0.xsl");
        String namespaceURI = "/oracle/install/rspfmt_dbinstall_response_schema_v11_2_0";
        PropertyFileFormat rspFormat = new PropertyFileFormat(namespaceURI, raw2extTransformer, ext2rawTransformer, xsd);
        registry.registerFileFormat("rsp", (XmlBeanStoreFormat)rspFormat, true);
        try {
            ActiveHelpManager activeHelpManager = ActiveHelpManager.getInstance();
            activeHelpManager.setHelpRegistry((ActiveHelpRegistry)new DefaultActiveHelpRegistry("oracle.install.ivw.db.resource.ContextualHelpResource"));
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.setPrereqExecutor(new PrereqExecutor((AbstractPrereqAction)new PrereqAction()));
    }

    public void startup(String ... args) {
        super.startup(APPLICATION_CONFIG, FLOW_CONFIG, args);
    }

    protected void run() {
        Resource resource = super.getDefaultResource();
        boolean isSilent = Installer.isCommandLineSwitchEnabled((String)"-silent");
        OiifoOCMInterfaceManager manager = OiifoOCMInterfaceManager.getInstance((boolean)isSilent);
        resource.setProperty("getOCMDetails.name", (Object)manager.getTitle());
        resource.setProperty("getOCMDetails.tag", (Object)manager.getTitle());
        super.run();
    }

    protected void processArguments(List<String> args) throws IllegalArgumentException {
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String command = i.next();
            if (!"-enableGISupport".equals(command)) continue;
            i.remove();
            break;
        }
        super.processArguments(args);
    }

    public static void main(String[] args) {
        try {
            DBInstaller installer = (DBInstaller)Application.getInstance(DBInstaller.class);
            installer.startup(args);
        }
        catch (Exception e) {
            ExceptionManager.handle((Throwable)e);
        }
    }
}

