/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.driver;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.config.db.DBCAHelper;
import oracle.install.driver.oui.ConfigHelper;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.driver.oui.Configurable;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.PrepareConfigJob;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.driver.oui.config.ConfigClient;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.bean.DBSetupBean;
import oracle.install.ivw.db.resource.DBDialogLabelResID;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSetupDriver
extends OUISetupDriver<DBSetupBean> {
    private static final String OUI_VAR_MAPPING_FILE = "/oracle/install/ivw/db/resource/dboui_map.properties";
    private static Logger logger = Logger.getLogger(DBSetupDriver.class.getName());
    DBInstallSettings dbHome;

    public DBSetupDriver() {
        this.setupBean = new DBSetupBean();
    }

    public DBSetupBean getSetupBean() {
        return (DBSetupBean)((Object)this.setupBean);
    }

    public void load() throws SetupDriverException {
        super.load();
        boolean invFound = false;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        invFound = invInfo.isInventoryExist();
        this.dbHome = ((DBSetupBean)((Object)this.setupBean)).getDBInstallSettings();
        CentralInventorySettings cenInv = ((DBSetupBean)((Object)this.setupBean)).getCentralInventory();
        logger.log(Level.INFO, "Inventory exists: " + invFound);
        if (invFound) {
            cenInv.setGroupOwnership(invInfo.getUnixGroupName());
        }
        this.dbHome.setProductDescriptorLocation(System.getProperty("oracle.installer.sourceLoc"));
        this.dbHome.setDBInstalling(true);
        String hostName = PlatformInfo.getInstance().getFullHostName();
        ((DBSetupBean)((Object)this.setupBean)).setOracleHostName(hostName);
        try {
            String absPath = new File(System.getProperty("oracle.installer.sourceLoc")).getAbsolutePath();
            String parentDir = new File(absPath).getParent();
            String destLoc = System.getProperty("oracle.installer.scratchPath");
            System.setProperty("oracle.install.asm.util.KFOD_FROM_ORACLE_HOME", "true");
        }
        catch (Exception e) {
            throw new SetupDriverException((Throwable)e);
        }
    }

    protected void config(ConfigJob configJob) throws SetupDriverException, IOException {
        super.config(configJob);
    }

    protected CompositeJob prepareJob() throws SetupDriverException {
        CompositeJob installJob = new CompositeJob();
        PlatformInfo platInfo = PlatformInfo.getInstance();
        DBPrepareConfigJob prepareConfigJob = null;
        DBSetupJob dbSetupJob = null;
        DBInstallSettings.InstallOption option = this.dbHome.getSelectedInstallOption();
        boolean isRAC = this.dbHome.isRACinstall();
        boolean multinodeSetup = false;
        switch (option) {
            case INSTALL_DB_AND_CONFIG: {
                boolean ohOnCfs = false;
                List<String> nodes = Arrays.asList(this.dbHome.getListOfSelectedNodes());
                String oraHomePath = ((DBSetupBean)((Object)this.setupBean)).getDBInstallSettings().getOracleHome();
                String localNode = MachineInfo.getInstance().getFullHostName();
                if (isRAC) {
                    boolean bl = multinodeSetup = this.dbHome.getListOfSelectedNodes() != null && this.dbHome.getListOfSelectedNodes().length > 1;
                    if (multinodeSetup) {
                        try {
                            ohOnCfs = Cluster.isSharedPath((String)oraHomePath, (String[])nodes.toArray(new String[0]), (String)localNode);
                        }
                        catch (SharedDeviceException e) {
                            e.printStackTrace();
                        }
                        catch (InvalidNodeListException e) {
                            e.printStackTrace();
                        }
                    }
                }
                logger.log(Level.INFO, "Is multi node install {0}", multinodeSetup);
                dbSetupJob = new DBSetupJob(multinodeSetup, ohOnCfs);
                installJob.add((Job)dbSetupJob);
                if (this.isConfigDisabled()) {
                    prepareConfigJob = new DBPrepareConfigJob("prepareDBConfig", 0.8f, dbSetupJob);
                    installJob.add((Job)prepareConfigJob);
                }
                InventoryInfo inventoryInfo = InventoryInfo.getInstance();
                if (!this.isConfigDisabled()) {
                    installJob.add((Job)new DBConfigJob(dbSetupJob));
                }
                if (platInfo.isWindows()) break;
                installJob.add((Job)new RootScriptJob((SetupJob)dbSetupJob));
                break;
            }
            case INSTALL_DB_SWONLY: {
                dbSetupJob = new DBSetupJob();
                installJob.add((Job)dbSetupJob);
                InventoryInfo inventoryInfo = InventoryInfo.getInstance();
                if (platInfo.isWindows()) break;
                RootScriptJob rootScriptJob = new RootScriptJob((SetupJob)dbSetupJob);
                installJob.add((Job)rootScriptJob);
                break;
            }
            case UPGRADE_DB: {
                dbSetupJob = new DBSetupJob();
                installJob.add((Job)dbSetupJob);
                InventoryInfo inventoryInfo = InventoryInfo.getInstance();
                if (!this.isConfigDisabled()) {
                    installJob.add((Job)new DBConfigJob(dbSetupJob));
                }
                if (platInfo.isWindows()) break;
                installJob.add((Job)new RootScriptJob((SetupJob)dbSetupJob));
            }
        }
        return installJob;
    }

    private void addCustomDependencyList(Map<String, Object> submitDBMap) {
        Map<String, String[]> map = this.dbHome.getComponentDependencyMap();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            for (String comp : entry.getValue()) {
                buffer.append(",");
                buffer.append(comp);
            }
            if (entry.getValue().length > 0) {
                buffer.deleteCharAt(1);
            }
            buffer.append("}");
            submitDBMap.put(entry.getKey(), buffer.toString());
        }
    }

    private SessionDetails getDBDetails(Boolean multinodeSetup) throws SetupDriverException {
        SessionDetails sessionDetails = null;
        try {
            Object csiNumber;
            DBInstallSettings dbBean;
            HashMap<String, Object> submitDBMap = new HashMap<String, Object>();
            BeanStoreUtils.storeAsStringMap(submitDBMap, (Object[])new Object[]{this.setupBean});
            BeanStoreUtils.storeAsMap(submitDBMap, (Object)((DBSetupBean)((Object)this.setupBean)).getOcmSettings());
            ConfigHelper.populateConfigMap(submitDBMap);
            String version = InstallConstants.VERSION.toString();
            submitDBMap.put("TOPLEVEL_COMPONENT", new String[]{"oracle.server", version});
            submitDBMap.put("COMPONENT_LANGUAGES", ((DBSetupBean)((Object)this.setupBean)).getLanguages());
            submitDBMap.put("SELECTED_LANGUAGES", ((DBSetupBean)((Object)this.setupBean)).getLanguages());
            submitDBMap.put("CLUSTER_NODES", this.dbHome.getListOfSelectedNodes());
            if (InventoryInfo.getInstance().isInventoryExist()) {
                submitDBMap.remove("INVENTORY_LOCATION");
                submitDBMap.remove("UNIX_GROUP_NAME");
            }
            if ((dbBean = ((DBSetupBean)((Object)this.setupBean)).getDBInstallSettings()).isCustomInstall()) {
                Map<String, Boolean> compBooleans = this.dbHome.getComponentBooleanMap();
                submitDBMap.putAll(compBooleans);
            }
            if (dbBean.getSelectedInstallOption() == DBInstallSettings.InstallOption.INSTALL_DB_AND_CONFIG && dbBean.getSelectedSystemClass() == DBInstallSettings.SystemClass.DESKTOP_CLASS && System.getenv("ORACLE_HOSTNAME") == null) {
                if (PlatformInfo.getInstance().isWindows()) {
                    PlatformInfo.getInstance().setEnvForWindows("ORACLE_HOSTNAME", ((DBSetupBean)((Object)this.setupBean)).getOracleHostName());
                } else {
                    PlatformInfo.getInstance().setEnv("ORACLE_HOSTNAME", ((DBSetupBean)((Object)this.setupBean)).getOracleHostName());
                }
            }
            if (InventoryInfo.getInstance().isCRSConfigured() || InventoryInfo.getInstance().isHAConfigured()) {
                submitDBMap.put("oracle_install_db_isHAOrCRSConfigured", true);
            } else {
                submitDBMap.put("oracle_install_db_isHAOrCRSConfigured", false);
            }
            String globalPropLocation = System.getProperty("oracle.installer.startup_location");
            globalPropLocation = globalPropLocation + "/../stage/globalvariables/globalvar.xml";
            System.setProperty("oracle.install.tb.globalvarpath", globalPropLocation);
            System.setProperty("oracle.installer.force", "true");
            if (!this.dbHome.isAdvancedInstall() && this.dbHome.getSelectedInstallOption() == DBInstallSettings.InstallOption.INSTALL_DB_AND_CONFIG) {
                this.setGlobalSystemProperties();
            }
            if ((csiNumber = submitDBMap.get("s_csiNumber")) != null) {
                submitDBMap.put("s_csiNumber", "\"" + csiNumber + "\"");
            }
            sessionDetails = new SessionDetails("db", submitDBMap);
        }
        catch (Exception e) {
            throw new SetupDriverException((Throwable)e);
        }
        return sessionDetails;
    }

    private void setGlobalSystemProperties() {
        System.setProperty("oracle.assistants.server.absoluteMemory", String.valueOf(this.dbHome.getAllocatedMemory()));
        System.setProperty("oracle.assistants.server.autoMemoryOption", String.valueOf(this.dbHome.getAutoMemoryOptionSelection()));
        System.setProperty("oracle.assistants.server.disableSecurity", "no");
        System.setProperty("oracle.server.cfgType", this.dbHome.getConfigurationTypeReturned());
        System.setProperty("oracle.assistants.server.sid", this.dbHome.getDb_SID());
        System.setProperty("oracle.assistants.server.gdbname", this.dbHome.getGlobalDBName());
        System.setProperty("oracle.server.createtype", "-createDatabase");
        System.setProperty("oracle.sysman.server.EMConfigureOption", "");
        System.setProperty("oracle.sysman.server.centralagent", this.dbHome.getEm_CentralAgentSelected());
        System.setProperty("oracle.sysman.server.EMConfigureOption", "LOCAL");
        System.setProperty("oracle.server.isASM", "no");
        System.setProperty("s_isASM", "false");
        System.setProperty("oracle.assistants.server.dbfLocation", this.dbHome.getOraDataLocation());
    }

    class DBPrepareConfigJob
    extends PrepareConfigJob {
        public DBPrepareConfigJob(Object id, float weightage, SetupJob setupJob) {
            super(id, weightage, setupJob);
            ConfigAssistantParams params = DBCAHelper.constructConfigParams((Configurable)this, (DBSetupBean)((Object)DBSetupDriver.this.setupBean));
            ConfigClient.getConfigClient().addConfigAssistantParams(params);
        }
    }

    class DBConfigJob
    extends ConfigJob {
        public DBConfigJob(DBSetupJob setupJob) {
            super((Object)"Config", 0.2f, (SetupJob)setupJob);
            this.setDescription(Application.getInstance().getString(ResourceURL.resURL((String)DBDialogLabelResID.class.getName(), (String)"dbConfigJob.description"), "Oracle 11gTB Database Configuration", new Object[0]));
            ConfigAssistantParams params = null;
            if (((DBSetupBean)((Object)DBSetupDriver.this.setupBean)).getDBInstallSettings().isLaunchDBCA()) {
                params = DBCAHelper.constructConfigParams((Configurable)this, (DBSetupBean)((Object)DBSetupDriver.this.setupBean));
                ConfigClient.getConfigClient().addConfigAssistantParams(params);
            }
        }
    }

    class DBSetupJob
    extends SetupJob {
        public DBSetupJob() throws SetupDriverException {
            this(false, false);
        }

        public DBSetupJob(boolean multinodeSetup, boolean sharedHome) throws SetupDriverException {
            super((Object)"InstallDB", Application.getInstance().getString(ResourceURL.resURL((String)DBDialogLabelResID.class.getName(), (String)"dbSetupJob.description"), "Oracle 11gTB Database Installation", new Object[0]), 0.8f, DBSetupDriver.this.getDBDetails(multinodeSetup), multinodeSetup, sharedHome);
        }
    }
}

