/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.memory.MemoryInfo;
import oracle.install.library.util.PlatformInfo;

public class ConfigurationOptionsValidator
implements Validator {
    public void validate(FlowContext flowContext) throws ValidationException {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        Long allocateMemory = dbBean.getAllocatedMemory();
        boolean bAutoMemOption = dbBean.getAutoMemoryOptionSelection();
        String[] nodes = dbBean.getListOfSelectedNodes();
        if (allocateMemory == null) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ALLOCATED_MEMORY_UNDEFINED_ERR, new Object[0]);
        }
        this.validateAllocatedMemory(allocateMemory, bAutoMemOption, nodes);
    }

    public void validateAllocatedMemory(Long allocatedMemory, boolean bAutoMemOption, String[] nodes) throws ValidationException {
        int minRequiredMemory = 256;
        long totalPhysicalMemory = MemoryInfo.getInstance().getTotalPhysicalMemory();
        int minRequiredPercent = (int)Math.ceil((double)minRequiredMemory * 100.0 / (double)totalPhysicalMemory);
        if (bAutoMemOption && PlatformInfo.getInstance().isLinux()) {
            if (nodes != null && nodes.length > 0) {
                long avlblSharedMem = MemoryInfo.getInstance().getClusterMaxFreeDiskSpace(nodes, "/dev/shm");
                if (allocatedMemory > avlblSharedMem) {
                    throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ALLOCATED_AUTO_MEMORY_CLUSTER_LESSER_ERR, new Object[]{String.valueOf(avlblSharedMem), String.valueOf(allocatedMemory)});
                }
            } else {
                long avlblSharedMem = MemoryInfo.getInstance().getFreeDiskSpace("/dev/shm");
                if (allocatedMemory > avlblSharedMem) {
                    throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ALLOCATED_AUTO_MEMORY_SI_GREATER_ERR, new Object[]{String.valueOf(avlblSharedMem), String.valueOf(allocatedMemory)});
                }
            }
        }
        if (allocatedMemory < (long)minRequiredMemory) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ALLOCATED_MEMORY_LESSER_ERR, new Object[]{String.valueOf(minRequiredMemory), String.valueOf(minRequiredPercent)});
        }
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        if (platformInfo.isWin32System() && allocatedMemory > 3072L) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ALLOCATED_MEMORY_GREATER_ERR_WIN32, new Object[0]);
        }
        if (allocatedMemory >= totalPhysicalMemory) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ALLOCATED_MEMORY_GREATER_ERR, new Object[0]);
        }
    }
}

