/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.db.DatabaseInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.PlatformInfo;

public class DBIdentifierValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(DBIdentifierValidator.class.getName());
    public static final String specialCharsForSID = "!@%^&*()-+=\\|`~[{]};:'\",<>/?.#_$ ";

    public void validate(FlowContext flowContext) throws ValidationException {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        String gdbName = dbBean.getGlobalDBName();
        String sid = dbBean.getDb_SID();
        boolean isRAC = dbBean.isRACinstall();
        gdbName = gdbName == null ? "" : gdbName.trim();
        sid = sid == null ? "" : sid.trim();
        DBIdentifierValidator.validateGlobalDBName(gdbName);
        DBIdentifierValidator.validateSID(sid, isRAC);
    }

    public static void validateGlobalDBName(String gdbName) throws ValidationException {
        String specialChars = "!@%^&*()+=\\|`~[{]};:'\",<>/? ";
        if (GenericValidation.validateForEmptiness((String)gdbName) || gdbName.equals(".")) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_GDB_NAME_EMPTY_ERR, new Object[0]);
        }
        String badCharFound = GenericValidation.validateBadCharGetString((String)specialChars, (String)gdbName);
        if (badCharFound != null && badCharFound.length() > 0) {
            String gdbStr = DBIdentifierValidator.getDBLabel("INSTALL_DB_LABEL_GLOBAL_DATABASE_NAME");
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_BADCHARS_ERR, new Object[]{gdbStr});
        }
        char[] firstCharDbName = gdbName.substring(0, 1).toCharArray();
        if (Character.isDigit(firstCharDbName[0]) || !Character.isLetter(firstCharDbName[0])) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_GDB_STARTS_WITH_DIGIT_ERR, new Object[0]);
        }
        int periodIndex = gdbName.indexOf(46);
        String dbName = "";
        String domainName = "";
        if (periodIndex != -1) {
            dbName = gdbName.substring(0, periodIndex);
            domainName = gdbName.substring(periodIndex + 1, gdbName.length());
        } else {
            dbName = gdbName;
        }
        if (dbName.length() == 0) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_INVALID_GLOBAL_DBNAME_ZERO_LENGTH_ERR, new Object[0]);
        }
        if (dbName.length() > 30) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_INVALID_GLOBAL_DBNAME_LENGTH_ERR, new Object[0]);
        }
        if (domainName.length() > 128) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_INVALID_GLOBAL_DBNAME_DOMAIN_LENGTH_ERR, new Object[0]);
        }
        if (domainName.indexOf(36) != -1) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_INVALID_GLOBAL_DBNAME_DOMAIN_NAME_ERR, new Object[0]);
        }
        if (gdbName.endsWith(".")) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_BADCHARS_ERR, new Object[0]);
        }
    }

    public static void validateSID(String dbSid) throws ValidationException {
        DBIdentifierValidator.validateSID(dbSid, false);
    }

    public static void validateSID(String dbSid, boolean isRAC) throws ValidationException {
        DatabaseInfo dbInfo = DatabaseInfo.getInstance();
        PlatformInfo platInfo = PlatformInfo.getInstance();
        if (GenericValidation.validateForEmptiness((String)dbSid)) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_SID_EMPTY_ERR, new Object[0]);
        }
        char[] firstCharDbName = dbSid.substring(0, 1).toCharArray();
        if (Character.isDigit(firstCharDbName[0]) || !Character.isLetter(firstCharDbName[0])) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_SID_STARTS_WITH_DIGIT_ERR, new Object[0]);
        }
        String badCharFound = GenericValidation.validateBadCharGetString((String)specialCharsForSID, (String)dbSid);
        if (badCharFound != null && badCharFound.length() > 0) {
            String gdbStr = DBIdentifierValidator.getDBLabel("INSTALL_DB_LABEL_SID");
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_BADCHARS_ERR, new Object[]{gdbStr});
        }
        int curPlatId = platInfo.getCurrentPlatform();
        int curPlatGroup = platInfo.getPlatGroup(curPlatId);
        int maxLength = 0;
        if (curPlatGroup == -1) {
            maxLength = isRAC ? 8 : 12;
            if (dbSid.length() > maxLength) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_INVALID_SID_LENGTH_UNIX_ERR, new Object[0]);
            }
        } else {
            maxLength = isRAC ? 8 : 12;
            if (dbSid.length() > maxLength) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_INVALID_SID_LENGTH_WIN_ERR, new Object[]{12, 8});
            }
        }
        try {
            if (curPlatGroup == -1 && OracleServiceRegistry.getInstance().findServiceById(dbSid) != null) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_SID_ALREADY_EXISTS_UNIX_ERR, new Object[]{dbInfo.getOratabLocation()});
            }
            if (dbInfo.checkIfSIDAlreadyExists(dbSid)) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_SID_ALREADY_EXISTS_WIN_ERR, new Object[0]);
            }
        }
        catch (ApplicationException e) {
            logger.log(Level.FINEST, "The service is not be found, this means the SID is unique, so install can continue");
        }
        catch (InstallException e) {
            ExceptionManager.getInstance().reportException((Throwable)e);
        }
    }

    private static String getCommonErrorMessage(ErrorCode errorCode, Object ... args) {
        String key = errorCode.name();
        return Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.common.resource.CommonErrorResID", (String)key), args);
    }

    private static String getDBErrorMessage(ErrorCode errorCode, Object ... args) {
        String key = errorCode.name();
        return Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBErrorResID", (String)key), args);
    }

    private static String getDBLabel(String key) {
        return Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)key), new Object[0]);
    }
}

