/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.io.File;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.asm.ACFSUtil;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.StageSizeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallLocationValidator
extends BaseInstallLocationValidator {
    public InstallSettings getInstallSettings(FlowContext flowContext) {
        return (InstallSettings)flowContext.getBean(DBInstallSettings.class);
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        super.validate(flowContext);
        StatusMessages errorMessages = super.getValidationStatusMessages();
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        String location = dbBean.getOracleHome();
        ACFSUtil acfsUtil = ACFSUtil.getInstance();
        if (acfsUtil.isPathOnACFS(dbBean.getOracleHome()) && !acfsUtil.isPathOnRegisteredACFS(dbBean.getOracleHome())) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.HOME_SPECIFIED_ON_UNREGISTERED_ACFS, new Object[0]));
        }
        boolean ignoreFreeSpaceCheck = false;
        boolean considerOracleHomeOffset = true;
        try {
            if (GenericValidation.validateForFreeSpace((long)StageSizeInfo.getSize((String)dbBean.getInstall_Type().getValue(), (boolean)considerOracleHomeOffset), (String)location) < 0L) {
                ignoreFreeSpaceCheck = true;
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_MIN_FREE_DISK_SPACE_ERR, new Object[]{StageSizeInfo.getSize((String)dbBean.getInstall_Type().getValue())}));
            }
        }
        catch (InstallException e) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage(e.getErrorCode(), new Object[0]));
        }
        if (dbBean.isRACinstall() && dbBean.getListOfSelectedNodes().length > 1) {
            ErrorMessage err;
            Application.showStatus((String)Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID").getString("InstallLocationValidator.statusControl.text", "Checking specified location on remote nodes...", new Object[0]));
            String[] nodes = dbBean.getListOfSelectedNodes();
            errorMessages.addAll(this.validateRemoteWritablePermission(location, nodes));
            errorMessages.addAll(this.validateRemoteWritablePermission(dbBean.getOracleBase(), nodes));
            if (!ignoreFreeSpaceCheck && (err = FileSystemInfo.getInstance().checkFreeDiskSpace(nodes, location, Long.valueOf(StageSizeInfo.getSize((String)dbBean.getInstall_Type().getValue())).longValue())) != null) {
                errorMessages.add((StatusMessage)((ValidationStatusMessage)err));
            }
            Application.hideStatus();
        }
    }

    public StatusMessages<ValidationStatusMessage> validateRemoteWritablePermission(String location, String[] nodes) {
        StatusMessages errorMessages = new StatusMessages();
        if (!PlatformInfo.getInstance().isUnix()) {
            return errorMessages;
        }
        String localParent = FileInfo.getLastExistingParent((String)location);
        boolean isLocalLocationWritable = new File(localParent).canWrite();
        if (!isLocalLocationWritable) {
            return errorMessages;
        }
        for (String node : nodes) {
            if (MachineInfo.getInstance().isLocalHost(node)) continue;
            try {
                FileInfo fileInfo = FileInfo.getInstance();
                String oracleHomeRoot = fileInfo.getLastExistingRemoteParent(node, location);
                if (fileInfo.isRemoteDirWriatble(node, oracleHomeRoot)) continue;
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.DIRECTORY_NOT_WRITABLE_ON_NODE, new Object[]{location, node}));
            }
            catch (Throwable t) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage(t));
            }
        }
        return errorMessages;
    }
}

