/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.em.SMTPConnectionCheck;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InventoryInfo;

public class ManagementOptionsValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(ManagementOptionsValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (!dbBean.isUseDBControlCase()) {
            this.validateEmCentralAgent(dbBean.getEm_CentralAgentSelected());
        } else if (dbBean.isUseDBControlCase() && dbBean.isReceiveEmailNotification()) {
            String email = dbBean.getEm_EmailAddress();
            this.validateEmailAdress(email);
            this.isWellFormedEmail(email);
            this.validateEmailServer(dbBean.getEm_SMTPServer());
        }
    }

    public void validateEmailAdress(String email) throws ValidationException {
        String errMsg = "";
        if (!this.validateEmptiness(email)) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_MANAGEMENT_OPTIONS_EMAIL_ADDRESS_EMPTY, new Object[0]);
        }
    }

    public void isWellFormedEmail(String email) throws ValidationException {
        String errMsg = "";
        boolean isValid = false;
        isValid = GenericValidation.validateEmailAddress((String)email);
        if (!isValid) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_MANAGEMENT_OPTIONS_EMAIL_ADDRESS_INVALID, new Object[0]);
        }
    }

    public boolean validateEmptiness(String value) {
        return value != null && value.length() > 0;
    }

    public void validateEmailServer(String server) throws ValidationException {
        String errMsg = "";
        if (!this.validateEmptiness(server)) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_MANAGEMENT_OPTIONS_EMAIL_SERVER_EMPTY, new Object[0]);
        }
        int statusSMTPServer = SMTPConnectionCheck.testGateWay((String)server);
        logger.log(Level.INFO, "Validating SMTP server. status: " + statusSMTPServer);
        if (statusSMTPServer != 0) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_MANAGEMENT_OPTIONS_EMAIL_SERVER_INVALID, new Object[0]);
        }
    }

    public void validateEmCentralAgent(String emAgent) throws ValidationException {
        String emAgentNotFound = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_MGMT_NO_EM_AGENT_EXISTS"), new Object[0]);
        if (emAgent == null || emAgent.length() <= 0 || emAgent.equals(emAgentNotFound)) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_EM_CONFIG_AGENT_EMPTY, new Object[0]);
        }
        boolean agentFound = false;
        Map agentHomeMap = InventoryInfo.getInstance().getEMAgentsOnLocalNode();
        agentFound = agentHomeMap.containsKey(emAgent);
        if (!agentFound) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_EM_CONFIG_AGENT_INVALID, new Object[0]);
        }
    }
}

