/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallConstants;

public class NodeSelectionValidator
implements Validator {
    public void validate(FlowContext flowContext) throws ValidationException {
        String[] nodes;
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        CRSInfo crsInfo = CRSInfo.getInstance();
        if (Boolean.getBoolean("oracle.installer.silent") && (nodes = dbBean.getListOfSelectedNodes()) != null && nodes.length > 0) {
            if (!PreferenceHelper.isGISupported()) {
                if (dbBean.getSelectedInstallOption() == DBInstallSettings.InstallOption.UPGRADE_DB) {
                    throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RACUPGRADE_NOT_SUPPORTED, new Object[0]);
                }
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RACDB_NOT_SUPPORTED, new Object[0]);
            }
            String[] crsnodes = crsInfo.getNodesFromCRSstack();
            if (crsInfo.isCRSPresent() && crsnodes != null && crsnodes.length > 0) {
                for (int i = 0; i < nodes.length; ++i) {
                    boolean isNodeValid = false;
                    String nodeRSP = nodes[i];
                    if (nodes[i].indexOf(".") > 0) {
                        nodeRSP = nodes[i].substring(0, nodes[i].indexOf("."));
                    }
                    for (int j = 0; j < crsnodes.length; ++j) {
                        String nodeCRS = crsnodes[j];
                        if (!nodeRSP.equals(nodeCRS)) continue;
                        isNodeValid = true;
                        break;
                    }
                    if (isNodeValid) continue;
                    dbBean.setRACinstall(false);
                    throw new ValidationException((ErrorCode)DBErrorCode.INCORRECT_NODE_LIST_PROVIDED, new Object[]{nodes[i]});
                }
                dbBean.setRACinstall(true);
            } else {
                dbBean.setRACinstall(false);
                throw new ValidationException((ErrorCode)DBErrorCode.GRID_INFRASTRUCTURE_NOT_INSTALLED, new Object[0]);
            }
        }
        if (dbBean.isRACinstall()) {
            if (!PreferenceHelper.isGISupported()) {
                if (dbBean.getSelectedInstallOption() == DBInstallSettings.InstallOption.UPGRADE_DB) {
                    throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RACUPGRADE_NOT_SUPPORTED, new Object[0]);
                }
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RACDB_NOT_SUPPORTED, new Object[0]);
            }
            if (crsInfo.isCRSPresent()) {
                Version crsActiveVersion = Version.parseVersion((String)crsInfo.getCRSActiveVersion());
                if (InstallConstants.VERSION.compareTo(crsActiveVersion) > 0) {
                    throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_LOWER_CRS_ACTIVEVERSION, new Object[]{crsActiveVersion, InstallConstants.VERSION.toString(), InstallConstants.VERSION.toString()});
                }
            } else {
                throw new ValidationException((ErrorCode)DBErrorCode.GRID_INFRASTRUCTURE_NOT_INSTALLED, new Object[0]);
            }
            GenericValidation.validateSSHConnectivity((String[])dbBean.getListOfSelectedNodes());
            if (dbBean.getListOfSelectedNodes().length < crsInfo.getNodesFromCRSstack().length) {
                throw new ValidationException((ErrorCode)DBErrorCode.SUBSET_OF_NODES_SELECTED, new Object[0]);
            }
        }
    }
}

