/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.install.asm.bean.ASMSettings;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;

public class PrivilegedOSGroupsValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(PrivilegedOSGroupsValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        logger.info("... PrivilegedOSGroupValidator: entering validate()");
        ASMSettings asmBean = (ASMSettings)flowContext.getBean(ASMSettings.class);
        InventoryInfo invInfo = InventoryInfo.getInstance();
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (!PlatformInfo.getInstance().isWindows()) {
            String[] osUserGroups = invInfo.getOSGroups();
            ArrayList<String> alOsUserGroups = new ArrayList<String>();
            ArrayList<String> alNonMemberGroups = new ArrayList<String>();
            String dbaGroup = bean.getDbaGroupNameUsed();
            String operGroup = bean.getOperGroupNameUsed();
            alOsUserGroups.addAll(Arrays.asList(osUserGroups));
            if (!alOsUserGroups.contains(dbaGroup)) {
                alNonMemberGroups.add(dbaGroup);
            }
            if (!alOsUserGroups.contains(operGroup)) {
                alNonMemberGroups.add(operGroup);
            }
            if (alNonMemberGroups.size() > 0) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ADVANCED_NONMEMBER_OS_GROUPS, new Object[]{alNonMemberGroups.toString()});
            }
        }
    }
}

