/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.util.logging.Logger;
import oracle.install.asm.bean.ASMInputValidationHelper;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.ivw.db.validator.DBIdentifierValidator;
import oracle.install.ivw.db.validator.InstallLocationValidator;
import oracle.install.ivw.db.validator.SchemaPasswordValidator;
import oracle.install.ivw.db.validator.StorageOptionsValidator;
import oracle.install.library.util.GenericValidation;

public class QuickInstallValidator
extends InstallLocationValidator
implements CompositeValidator {
    public static final Logger logger = Logger.getLogger(QuickInstallValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        super.validate(flowContext);
        StatusMessages errorMessages = super.getValidationStatusMessages();
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        String oraDataLocation = dbBean.getOraDataLocation();
        String gdbName = dbBean.getGlobalDBName();
        String sid = dbBean.getDb_SID();
        String storageLocText = QuickInstallValidator.getCommonLabel((String)"INSTALL_COMMON_STORAGE_LOCATION_LABEL");
        int storageType = dbBean.getDatabase_StorageType_Chosen();
        try {
            if (storageType == 1) {
                StorageOptionsValidator s = new StorageOptionsValidator();
                s.validateMountPoint(oraDataLocation, gdbName, dbBean.isRACinstall(), dbBean.getListOfSelectedNodes());
            } else {
                if (!PreferenceHelper.isGISupported()) {
                    throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ASM_NOT_SUPPORTED, new Object[0]);
                }
                ASMInputValidationHelper.validateASMStorage();
                QuickInstallValidator.validateASMDiskGroup((String)dbBean.getDiskGroupNameForASM());
            }
        }
        catch (ValidationException e) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
        }
        try {
            DBIdentifierValidator.validateGlobalDBName(gdbName);
            String sidStr = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_LABEL_SID"), new Object[0]);
            String gdbStr = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_LABEL_GLOBAL_DATABASE_NAME"), new Object[0]);
            String badCharFound = GenericValidation.validateBadCharGetString((String)"!@%^&*()-+=\\|`~[{]};:'\",<>/?.#_$ ", (String)sid);
            if (badCharFound != null && badCharFound.length() > 0) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_SID_BADCHARS_ERR, new Object[]{sidStr, gdbStr, badCharFound});
            }
            DBIdentifierValidator.validateSID(sid);
        }
        catch (ValidationException e) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
        }
        String password = dbBean.getGenericPassword();
        password = password != null ? password : "";
        StatusMessages<ValidationStatusMessage> msgs = SchemaPasswordValidator.validatePassword(password, "ADMIN");
        if (msgs != null) {
            errorMessages.addAll(msgs);
        }
        if (storageType == 2) {
            password = dbBean.getAsmsnmpPassword();
            password = password != null ? password : "";
            ValidationStatusMessage msg = null;
            if (GenericValidation.isEmpty((String)dbBean.getAsmsnmpPassword())) {
                msg = new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_ASMSNMP_PASSWORD_INVALID, new Object[0]);
            }
            if (msg != null) {
                errorMessages.add(msg);
            }
        }
    }

    public InstallSettings getInstallSettings(FlowContext flowContext) {
        InstallSettings installSettings = (InstallSettings)flowContext.getBean(DBInstallSettings.class);
        return installSettings;
    }
}

