/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.ivw.db.validator.StorageOptionsValidator;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.InstallException;

public class RecoveryBackupValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(RecoveryBackupValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        this.unitTest(dbBean);
        if (dbBean.isEnableAutoBackup()) {
            if (dbBean.isUseFileSystemForRecoverySelected()) {
                String recoveryLocation = dbBean.getRecoveryBackUpLocation();
                Resource resource = Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
                BaseInstallLocationValidator.validateLocation((String)recoveryLocation, (String)resource.getString("INSTALL_DB_RECOVERY_OPTIONS_LOCATION_LABEL", "recovery area", new Object[0]));
                if (dbBean.isRACinstall()) {
                    boolean isShared = false;
                    List<String> publicNodes = Arrays.asList(dbBean.getListOfSelectedNodes());
                    if (publicNodes.size() > 1) {
                        try {
                            isShared = FileSystemInfo.getInstance().isLocationOnCFS(recoveryLocation, publicNodes);
                            if (!isShared) {
                                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RECOVERY_OPTIONS_LOC_NOT_SHARED, new Object[0]);
                            }
                        }
                        catch (InstallException ex) {
                            throw new ValidationException((Throwable)ex, ex.getErrorInfo());
                        }
                    }
                }
            } else {
                boolean rac = dbBean.isRACinstall();
                String[] selectedNodes = dbBean.getListOfSelectedNodes();
                boolean isUpgrade = dbBean.getInstallOptionSelected() == 3;
                StorageOptionsValidator.validateASMStorage(isUpgrade, rac, selectedNodes);
            }
            RecoveryBackupValidator.checkEmptyUsername(dbBean.getRecoveryBackUpUsername());
            RecoveryBackupValidator.checkEmptyPassword(dbBean.getRecoveryBackUpPassword());
        }
    }

    public void checkEmptyStorageLocation(String locn) throws ValidationException {
        if (!RecoveryBackupValidator.validateEmptiness(locn)) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RECOVERY_OPTIONS_LOCATION_EMPTY, new Object[0]);
        }
    }

    public static void checkEmptyUsername(String user) throws ValidationException {
        if (!RecoveryBackupValidator.validateEmptiness(user)) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RECOVERY_OPTIONS_USERNAME_EMPTY, new Object[0]);
        }
    }

    public static void checkEmptyPassword(String pass) throws ValidationException {
        if (!RecoveryBackupValidator.validateEmptiness(pass)) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_RECOVERY_OPTIONS_PASSWORD_EMPTY, new Object[0]);
        }
    }

    public static boolean validateEmptiness(String value) {
        return value != null && value.length() > 0;
    }

    public void log(String s) {
        logger.log(Level.FINEST, s);
    }

    public void unitTest(DBInstallSettings dbBean) {
        String isEnableAutoBackup = "" + dbBean.isEnableAutoBackup();
        String getRecoveryBackUpUsername = dbBean.getRecoveryBackUpUsername();
        String getRecoveryBackUpPassword = dbBean.getRecoveryBackUpPassword();
        String isUseFileSystemForRecoverySelected = "" + dbBean.isUseFileSystemForRecoverySelected();
        String getRecoveryBackUpLocation = dbBean.getRecoveryBackUpLocation();
        String getRecoveryAreaDestination = dbBean.getRecoveryAreaDestination();
        this.log("isEnableAutoBackup: " + isEnableAutoBackup);
        this.log("getRecoveryBackUpUsername: " + getRecoveryBackUpUsername);
        this.log("getRecoveryBackUpPassword: " + getRecoveryBackUpPassword);
        this.log("isUseFileSystemForRecoverySelected: " + isUseFileSystemForRecoverySelected);
        this.log("getRecoveryBackUpLocation: " + getRecoveryBackUpLocation);
        this.log("getRecoveryAreaDestination: " + getRecoveryAreaDestination);
    }

    public static String getErrorCode(String label) {
        return Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBErrorResID", (String)label), new Object[0]);
    }
}

