/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.util.Collection;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.util.GenericValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaPasswordValidator
implements CompositeValidator {
    private DBInstallSettings dbBean = null;
    private static final String SYS_USER = "SYS";
    private static final String SYSTEM_USER = "SYSTEM";
    private static final String SYSMAN_USER = "SYSMAN";
    private static final String DBSNMP_USER = "DBSNMP";
    private static final String GENERIC_USER = "ADMIN";
    private static final int MAX_PASSWORD_LENGTH = 30;
    private StatusMessages<ValidationStatusMessage> messages = new StatusMessages();

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.messages;
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        this.messages.clear();
        StatusMessages<ValidationStatusMessage> msgs = new StatusMessages<ValidationStatusMessage>();
        this.dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.dbBean.isUseSamePasswordCase()) {
            msgs = this.validateSamePassword();
            if (msgs != null) {
                this.messages.addAll(msgs);
            }
        } else {
            msgs = this.validateDifferentPasswords();
            if (msgs != null) {
                this.messages.addAll(msgs);
            }
        }
    }

    private StatusMessages<ValidationStatusMessage> validateSamePassword() throws ValidationException {
        String allSchemaPassword = this.dbBean.getGenericPassword();
        StatusMessages allMsgs = new StatusMessages();
        StatusMessages<ValidationStatusMessage> msgs = new StatusMessages<ValidationStatusMessage>();
        if (allSchemaPassword == null) {
            allSchemaPassword = "";
        }
        if ((msgs = SchemaPasswordValidator.validatePassword(allSchemaPassword, GENERIC_USER)) != null) {
            allMsgs.addAll(msgs);
        }
        return allMsgs;
    }

    private static String getPasswdBadChars() {
        String badChars = "!@%^&*()+=\\|`~[{]};:'\",<>/?";
        return badChars;
    }

    public static StatusMessages<ValidationStatusMessage> validatePassword(String password, String userDesc) {
        ValidationStatusMessage msg = null;
        StatusMessages messages = new StatusMessages();
        msg = GenericValidation.validatePasswordLen((String)password, (String)userDesc, (int)30);
        if (msg != null) {
            messages.add((StatusMessage)msg);
        }
        msg = null;
        msg = GenericValidation.validateForBadChars((String)password, (String)SchemaPasswordValidator.getPasswdBadChars(), (String)userDesc);
        if (msg != null) {
            messages.add((StatusMessage)msg);
        }
        StatusMessages msgs = new StatusMessages();
        msgs = GenericValidation.validateComplexPassword((String)password, (String)userDesc);
        if (msgs != null & msgs.size() > 0) {
            messages.addAll((Collection)msgs);
        }
        if ((msgs = SchemaPasswordValidator.validateForIllegalPasswds(password, userDesc)) != null) {
            messages.addAll(msgs);
        }
        return messages;
    }

    private StatusMessages<ValidationStatusMessage> validateDifferentPasswords() throws ValidationException {
        String[] schemaUsers = null;
        String[] schemaPasswds = null;
        StatusMessages allMsgs = new StatusMessages();
        StatusMessages<ValidationStatusMessage> msgs = new StatusMessages<ValidationStatusMessage>();
        schemaUsers = new String[]{SYS_USER, SYSTEM_USER, SYSMAN_USER, DBSNMP_USER};
        schemaPasswds = this.dbBean.getListOfSuperAdminPasswords();
        for (int i = 0; i < schemaUsers.length; ++i) {
            String schemaUserDesc;
            String password = schemaPasswds[i] == null ? "" : new String(schemaPasswds[i]);
            msgs = SchemaPasswordValidator.validatePassword(password, schemaUserDesc = new String(schemaUsers[i]));
            if (msgs == null) continue;
            allMsgs.addAll(msgs);
        }
        return allMsgs;
    }

    private static StatusMessages<ValidationStatusMessage> validateForIllegalPasswds(String password, String schemaUserDesc) {
        StatusMessages msgs = new StatusMessages();
        if (schemaUserDesc.equals(SYS_USER) && password.equalsIgnoreCase("CHANGE_ON_INSTALL")) {
            msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_PASSWORD_NOT_ALLOWED_ERR, new Object[]{schemaUserDesc, password}));
        }
        if (schemaUserDesc.equals(SYSTEM_USER) && password.equalsIgnoreCase("MANAGER")) {
            msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_PASSWORD_NOT_ALLOWED_ERR, new Object[]{schemaUserDesc, password}));
        }
        if (schemaUserDesc.equals(SYSMAN_USER) && password.equalsIgnoreCase(SYSMAN_USER)) {
            msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_PASSWORD_NOT_ALLOWED_ERR, new Object[]{schemaUserDesc, password}));
        }
        if (schemaUserDesc.equals(DBSNMP_USER) && password.equalsIgnoreCase(DBSNMP_USER)) {
            msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_PASSWORD_NOT_ALLOWED_ERR, new Object[]{schemaUserDesc, password}));
        }
        if (schemaUserDesc.equals(GENERIC_USER) && (password.equalsIgnoreCase("CHANGE_ON_INSTALL") || password.equalsIgnoreCase("MANAGER") || password.equalsIgnoreCase(SYSMAN_USER) || password.equalsIgnoreCase(DBSNMP_USER))) {
            msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_SUPER_PASSWORD_NOT_ALLOWED_ERR, new Object[0]));
        }
        return msgs;
    }
}

