/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.install.asm.bean.ASMInputValidationErrorCode;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityErrorCode;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.resource.CommonErrorResID;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBDialogLabelResID;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.ReleaseVersionComparator;

public class StorageOptionsValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(StorageOptionsValidator.class.getName());
    Resource commonRes = Application.getInstance().getResource(CommonErrorResID.class.getName());
    public static final String UNIX_SIDPATTERN = "\\+.+";
    public static final String WIN_SIDPATTERN = ".*\\+.+";

    public void validate(FlowContext flowContext) throws ValidationException {
        boolean isUpgrade;
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        int storageType = dbBean.getDatabase_StorageType_Chosen();
        String mountPoint = dbBean.getOraDataLocation();
        String gdbName = dbBean.getGlobalDBName();
        String[] selectedNodes = dbBean.getListOfSelectedNodes();
        boolean bl = isUpgrade = dbBean.getInstallOptionSelected() == 3;
        if (storageType == 1) {
            ValidationStatusMessage vMesg = null;
            vMesg = StorageOptionsValidator.validateFSOption(dbBean.getDbInstallEdition(), dbBean.isRACinstall(), storageType);
            if (vMesg != null) {
                throw new ValidationException(vMesg.getErrorInfo().getErrorCode(), new Object[0]);
            }
            this.validateMountPoint(mountPoint, gdbName, dbBean.isRACinstall(), selectedNodes);
        } else {
            if (!PreferenceHelper.isGISupported()) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ASM_NOT_SUPPORTED, new Object[0]);
            }
            if (GenericValidation.isEmpty((String)dbBean.getAsmsnmpPassword())) {
                throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_ASMSNMP_PASSWORD_INVALID, new Object[0]);
            }
            boolean rac = dbBean.isRACinstall();
            StorageOptionsValidator.validateASMStorage(isUpgrade, rac, selectedNodes);
        }
    }

    public static ValidationStatusMessage validateFSOption(DBInstallSettings.InstallEdition edition, boolean isRAC, int storageType) {
        if (edition == DBInstallSettings.InstallEdition.SE && isRAC && storageType == 1) {
            return new ValidationStatusMessage((ErrorCode)DBErrorCode.FS_NOT_ALLOWED_SE_RAC, new Object[0]);
        }
        return null;
    }

    public static void validateASMStorage(boolean isUpgrade, boolean rac, String ... selectedNodes) throws ValidationException {
        block14: {
            if (rac) {
                CRSInfo crsInfo = CRSInfo.getInstance();
                String[] nodes = crsInfo.getNodesFromCRSstack();
                ArrayList<String> selectedNodeList = new ArrayList<String>(Arrays.asList(selectedNodes));
                try {
                    ASMUtility asmUtility = ASMUtility.getInstance();
                    List list = asmUtility.detectASM(isUpgrade, nodes);
                    if (list == null || list.isEmpty()) {
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.RAC_ASM_INSTANCE_NOT_FOUND, new Object[0]);
                    }
                    boolean asmPresent = list.containsAll(selectedNodeList);
                    selectedNodeList.removeAll(list);
                    if (!asmPresent) {
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.NODE_DOES_NOT_HAVE_ASM, new Object[]{((Object)selectedNodeList).toString()});
                    }
                }
                catch (ASMUtilityException e) {
                    throw new ValidationException((Throwable)e, (ErrorCode)ASMInputValidationErrorCode.RAC_ASM_INSTANCE_NOT_FOUND, new Object[0]);
                }
            }
            try {
                ASMUtility asmUtility = ASMUtility.getInstance();
                ASMInstance instance = asmUtility.getASMInstance();
                if (instance != null) {
                    if (rac) {
                        StorageOptionsValidator.compareOracleProductVersion();
                    } else {
                        asmUtility.getDetails(instance);
                        Version versionFound = instance.getVersion();
                        Version prodVersion = InstallConstants.VERSION;
                        int result = ReleaseVersionComparator.compareVersion((Version)versionFound, (Version)prodVersion);
                        if (result == -1) {
                            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.OLDER_ASM_INSTANCE_VERSION_FOUND, new Object[]{versionFound, prodVersion});
                        }
                    }
                    List diskGroups = asmUtility.getDiskGroups(instance);
                    if (diskGroups.isEmpty()) {
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.NO_ASM_DISKGROUP_FOUND, new Object[]{instance.getSid()});
                    }
                    break block14;
                }
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_INSTANCE_NOT_FOUND, new Object[0]);
            }
            catch (ASMUtilityException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode == ASMUtilityErrorCode.ASM_INSTANCE_DOWN) {
                    StorageOptionsValidator.compareOracleProductVersion();
                    throw new ValidationException((ErrorCode)ASMUtilityErrorCode.ASM_INSTANCE_DOWN, new Object[0]);
                }
                if (errorCode == ASMUtilityErrorCode.ASM_ACCESS_DENIED) {
                    throw new ValidationException((ErrorCode)ASMUtilityErrorCode.ASM_ACCESS_DENIED, new Object[0]);
                }
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_INSTANCE_NOT_FOUND, new Object[0]);
            }
        }
    }

    private static void compareOracleProductVersion() throws ValidationException {
        String oracleHome;
        InventoryInfo inventory = InventoryInfo.getInstance();
        Version prodVersionFound = inventory.getProductVersion(oracleHome = StorageOptionsValidator.getASMHome());
        if (prodVersionFound == null) {
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_INSTANCE_NOT_FOUND, new Object[0]);
        }
        if (prodVersionFound == null) {
            return;
        }
        Version installVersion = InstallConstants.VERSION;
        int result = ReleaseVersionComparator.compareVersion((Version)prodVersionFound, (Version)installVersion);
        if (result == -1) {
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.OLDER_ASM_INSTANCE_VERSION_FOUND, new Object[]{prodVersionFound.toString(), installVersion.toString()});
        }
    }

    private static String getASMHome() {
        String asmSidRegex;
        Pattern pattern;
        String oracleHome = "";
        OracleServiceRegistry serviceRegistry = OracleServiceRegistry.getInstance();
        OracleService service = serviceRegistry.findServiceById(pattern = Pattern.compile(asmSidRegex = StorageOptionsValidator.getSIDPattern()));
        if (service != null) {
            oracleHome = service.getOracleHome().getAbsolutePath();
        }
        return oracleHome;
    }

    private void validateIfLocationOnACFS(String mountPoint, boolean isRAC) throws InstallException {
        if (!isRAC) {
            if (FileSystemInfo.getInstance().isLocationOnACFS(mountPoint)) {
                throw new InstallException((ErrorCode)DBErrorCode.ACFS_LOCATION_NOT_ALLOWED_SI, new Object[]{mountPoint});
            }
        } else if (FileSystemInfo.getInstance().isLocationOnACFS(mountPoint)) {
            throw new InstallException((ErrorCode)DBErrorCode.ACFS_LOCATION_NOT_ALLOWED_RAC, new Object[]{mountPoint});
        }
    }

    public void validateMountPoint(String mountPoint, String gdbName, boolean isRAC, String[] selectedNodes) throws ValidationException {
        Application application = Application.getInstance();
        Resource resource = application.getResource(DBDialogLabelResID.class.getName());
        String fileLocStr = resource.getString("INSTALL_DB_LABEL_FILE_LOCATION", "", new Object[0]);
        BaseInstallLocationValidator.validateLocation((String)mountPoint, (String)fileLocStr);
        if (isRAC && selectedNodes != null) {
            ArrayList<String> nodeList = new ArrayList<String>();
            for (String node : selectedNodes) {
                nodeList.add(node);
            }
            try {
                int remoteNodeSize;
                if (selectedNodes.length > 1 && !FileSystemInfo.getInstance().isLocationOnCFS(mountPoint, nodeList) && (remoteNodeSize = CRSInfo.getInstance().getRemoteNodes().size()) + 1 >= 2) {
                    throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_LOCATION_NOT_SHARED_ERR, new Object[0]);
                }
            }
            catch (InstallException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        BaseInstallLocationValidator.checkSpaceAvailForSoftware((String)mountPoint, (long)1800L);
        int index = gdbName.indexOf(".");
        String dbName = "";
        dbName = index >= 0 ? gdbName.substring(0, index) : gdbName;
        String dbfLoc = mountPoint + FunctionsUtil.pathify((String)("/" + dbName + "/system01.dbf"));
        if (new File(dbfLoc).exists()) {
            throw new ValidationException((ErrorCode)DBErrorCode.INSTALL_DB_LOCATION_ALREADY_IN_USE_ERR, new Object[]{dbName});
        }
        try {
            if (isRAC && selectedNodes.length >= 1) {
                this.validateIfLocationOnACFS(mountPoint, true);
            } else {
                this.validateIfLocationOnACFS(mountPoint, false);
            }
        }
        catch (InstallException e) {
            throw new ValidationException((Throwable)e, e.getErrorCode(), e.getErrorInfo().getMessageArgs());
        }
    }

    public static String getSIDPattern() {
        return PlatformInfo.getInstance().isWindows() ? WIN_SIDPATTERN : UNIX_SIDPATTERN;
    }
}

