/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.db.DatabaseInfo;
import oracle.install.library.db.RAC92Info;
import oracle.install.library.util.InstallConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeOptionValidator
implements CompositeValidator {
    private Logger logger = Logger.getLogger(UpgradeOptionValidator.class.getName());
    StatusMessages<ValidationStatusMessage> statusMessages = new StatusMessages();

    public void validate(FlowContext flowContext) throws ValidationException {
        this.statusMessages.clear();
        DBInstallSettings dbHome = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (dbHome.getSelectedInstallOption() == DBInstallSettings.InstallOption.UPGRADE_DB) {
            if (dbHome.isRACinstall()) {
                this.validateRACUpgradeOption(dbHome);
            } else {
                this.validateSIUpgradeOption();
                CRSInfo c = CRSInfo.getInstance();
                for (ValidationStatusMessage v : this.statusMessages) {
                    if (v.getErrorInfo().getErrorCode() != DBErrorCode.INSTALL_DB_NO_SI_DBS_DETECTED || !c.isCRSPresent() || Version.parseVersion((String)c.getCRSActiveVersion()).compareTo(InstallConstants.VERSION) >= 0 || !PreferenceHelper.isGISupported()) continue;
                    this.statusMessages.remove((Object)v);
                    this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_LOWER_CRS_ACTIVEVERSION, Severity.WARNING, new Object[]{Version.parseVersion((String)CRSInfo.getInstance().getCRSActiveVersion()), InstallConstants.VERSION.toString(), InstallConstants.VERSION.toString()}));
                    break;
                }
            }
            try {
                if (!this.isASMUpgraded()) {
                    if (!PreferenceHelper.isGISupported()) {
                        this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_UPGRADE_ASM_NOT_SUPPORTED, Severity.WARNING, new Object[0]));
                    } else {
                        this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_ONLY_UNUPGRADED_ASM_DETECTED, Severity.WARNING, new Object[0]));
                    }
                }
            }
            catch (ASMUtilityException e) {
                throw new ValidationException(e.getMessage());
            }
        }
    }

    private void validateRACUpgradeOption(DBInstallSettings dbHome) throws ValidationException {
        List<String> selectedNodes = Arrays.asList(dbHome.getListOfSelectedNodes());
        ArrayList<String> upgradableDBList = null;
        List allNodes = null;
        CRSInfo crsInfo = CRSInfo.getInstance();
        String crsHomeLoc = crsInfo.getCRSHome();
        allNodes = crsInfo.getRemoteNodes();
        allNodes.add(0, crsInfo.getLocalNodeName());
        if (crsHomeLoc != null && crsHomeLoc.trim().length() > 0) {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            List clusterDbs = null;
            clusterDbs = crsInfo.getHAManagedDatabases(crsHomeLoc);
            List rac92DBs = RAC92Info.getInstance().get92RACDatabasesUsingSRVCTL(selectedNodes);
            if (rac92DBs == null) {
                if (clusterDbs != null && clusterDbs.size() > 0) {
                    for (String db : clusterDbs) {
                        ArrayList<String> nodeMembers = null;
                        for (String node : allNodes) {
                            try {
                                if (!crsInfo.doesDatabaseExistsOnNode(crsHomeLoc, node, db)) continue;
                                if (nodeMembers == null) {
                                    nodeMembers = new ArrayList<String>();
                                }
                                nodeMembers.add(node);
                            }
                            catch (InstallException e) {
                                ExceptionManager.handle((Throwable)e);
                            }
                        }
                        if (nodeMembers == null || !selectedNodes.containsAll(nodeMembers)) continue;
                        if (upgradableDBList == null) {
                            upgradableDBList = new ArrayList<String>();
                        }
                        upgradableDBList.add(db);
                    }
                    if (upgradableDBList == null || upgradableDBList.size() == 0) {
                        this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_FOUND_NOT_CONTAINED_ON_SELECTED_NODES, new Object[0]));
                    }
                } else {
                    this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_NO_DB_TO_UPGRADE, new Object[0]));
                }
            }
        }
    }

    private void validateSIUpgradeOption() throws ValidationException {
        DatabaseInfo dbInfo = DatabaseInfo.getInstance();
        HashMap SIDBs = null;
        try {
            boolean anySIDexists;
            SIDBs = dbInfo.getListOfSIDatabasesLocalNode();
            boolean bl = anySIDexists = SIDBs != null && SIDBs.size() > 0;
            if (!anySIDexists) {
                this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_DB_NO_SI_DBS_DETECTED, Severity.WARNING, new Object[0]));
            }
        }
        catch (oracle.install.library.util.InstallException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.statusMessages;
    }

    public boolean isASMUpgraded() throws ASMUtilityException {
        ASMUtility utility = ASMUtility.getInstance();
        ASMInstance asmInst = utility.getASMInstance();
        if (asmInst != null) {
            if (!PreferenceHelper.isGISupported()) {
                return false;
            }
            utility.getDetails(asmInst);
            return asmInst.getVersion().compareTo(InstallConstants.VERSION) >= 0;
        }
        return true;
    }
}

