/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.util.concurrent.Callable;
import oracle.install.asm.util.DiskGroup;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.view.ASMDiskGroupSelectionPane;

@ViewDef(id="ASMDiskGroupSelectionUI")
public class ASMDiskGroupSelectionGUI
implements View {
    ASMDiskGroupSelectionPane view = new ASMDiskGroupSelectionPane();

    public Component getView() {
        return this.view;
    }

    public void localize(FlowContext flowContext) {
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        switch (eventType) {
            case INIT: {
                FlowWorker worker = FlowWorker.getInstance((FlowContext)flowContext);
                worker.perform((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ASMDiskGroupSelectionGUI.this.view.findDiskGroups();
                        return null;
                    }
                });
                break;
            }
            case LOAD: {
                boolean dataOnASM = bean.getDatabase_StorageType_Chosen() == 2;
                boolean backupOnASM = bean.isEnableAutoBackup() && !bean.isUseFileSystemForRecoverySelected();
                this.view.setAsmPurposes(dataOnASM, backupOnASM);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DiskGroup diskGroup = this.view.getDiskGroup();
        if (diskGroup != null) {
            DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
            bean.setDiskGroupNameForASM(diskGroup.getName());
        }
    }
}

