/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.validate.AbstractValidationComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.asm.bean.ASMInputValidationErrorCode;
import oracle.install.asm.bean.ASMInputValidationHelper;
import oracle.install.asm.ui.RedundancyTableCellRenderer;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.Redundancy;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.RadioTableCellEditor;
import oracle.install.commons.swing.RadioTableCellRenderer;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.progress.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMDiskGroupSelectionPane
extends JPanel {
    private static final String PROPERTY_ASM_PURPOSES = "ASMDiskGroupSelectionPane.asmPurposes";
    private static final String PROPERTY_ASM_INSTANCE = "ASMDiskGroupSelectionPane.asmInstance";
    private MultiLineLabel lblTitle;
    private JTable tblDiskGroups;
    private DiskGroupTableModel dataModel;
    private JButton btnRefresh;
    private Resource resource;
    private ASMInstance asmInstance;
    private boolean backupOnASM;
    private boolean dataOnASM;
    private Status diskGroupSearchStatus = Status.PENDING;

    public ASMDiskGroupSelectionPane() {
        this.dataModel = new DiskGroupTableModel();
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        this.buildUI();
    }

    public void setAsmPurposes(boolean dataOnASM, boolean backupOnASM) {
        this.dataOnASM = dataOnASM;
        this.backupOnASM = backupOnASM;
        super.firePropertyChange(PROPERTY_ASM_PURPOSES, null, null);
    }

    public ASMInstance getAsmInstance() {
        return this.asmInstance;
    }

    public void setAsmInstance(ASMInstance asmInstance) {
        ASMInstance oldValue = this.asmInstance;
        ASMInstance newValue = asmInstance;
        this.asmInstance = asmInstance;
        super.firePropertyChange(PROPERTY_ASM_INSTANCE, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findDiskGroups() {
        try {
            ASMUtility utility = ASMUtility.getInstance();
            ASMInstance asmInstance = utility.getASMInstance();
            this.setAsmInstance(asmInstance);
            if (asmInstance != null) {
                Application.showStatus((String)this.resource.getString("DiskGroupSelectionPane.findDiskGroups.status.text", "Searching for ASM Disk Groups...", new Object[0]));
                this.diskGroupSearchStatus = Status.INPROGRESS;
                final List diskGroups = utility.getDiskGroups(asmInstance);
                this.diskGroupSearchStatus = Status.SUCCEEDED;
                SwingUtils.invokeTask((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        ASMDiskGroupSelectionPane.this.setDiskGroups(diskGroups);
                        return null;
                    }
                });
            }
        }
        catch (ASMUtilityException e) {
            this.diskGroupSearchStatus = Status.FAILED;
            StandardDialog.showError((Component)this, (Throwable)e);
        }
        finally {
            Application.hideStatus();
        }
    }

    protected void buildUI() {
        this.lblTitle = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.tblDiskGroups = new JTable();
        this.btnRefresh = new JButton();
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(){

                    public void run() {
                        ASMDiskGroupSelectionPane.this.findDiskGroups();
                    }
                };
                t.start();
            }
        });
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblTitle, (Container)this, (int)0, (int)0, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)new JScrollPane(this.tblDiskGroups), (Container)this, (int)0, (int)1, (int)2, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnRefresh, (Container)this, (int)1, (int)2, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        this.localize();
        this.tblDiskGroups.setModel(this.dataModel);
        this.tblDiskGroups.getTableHeader().setReorderingAllowed(false);
        this.tblDiskGroups.setSelectionMode(0);
        this.tblDiskGroups.setDefaultRenderer(Redundancy.class, (TableCellRenderer)new RedundancyTableCellRenderer());
        this.tblDiskGroups.setDefaultRenderer(Boolean.class, (TableCellRenderer)new RadioTableCellRenderer());
        TableColumnModel columnModel = this.tblDiskGroups.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setCellEditor((TableCellEditor)new RadioTableCellEditor());
        column.setPreferredWidth(30);
        column = columnModel.getColumn(1);
        column.setPreferredWidth(300);
        column = columnModel.getColumn(2);
        column.setPreferredWidth(110);
        column = columnModel.getColumn(3);
        column.setPreferredWidth(110);
        column = columnModel.getColumn(3);
        column.setPreferredWidth(110);
        InlineValidationHelper.registerInlineValidator((Component)this, (ValidationComponent)new PageValidationComponent(this));
    }

    private void localize() {
        this.lblTitle.setText(this.resource.getString("DiskGroupSelectionPane.title", "Select one of the existing Disk Groups to be used for storage of the database you are creating during this installation session.", new Object[0]));
        this.dataModel.setColumnNames(new String[]{" ", this.resource.getString("DiskGroupSelectionPane.tblDiskGroup.column.diskGroupName", "Disk Group Name", new Object[0]), this.resource.getString("DiskGroupSelectionPane.tblDiskGroup.column.size", "Size (in MB)", new Object[0]), this.resource.getString("DiskGroupSelectionPane.tblDiskGroup.column.freeSpace", "Free (in MB)", new Object[0]), this.resource.getString("DiskGroupSelectionPane.tblDiskGroup.column.redundancy", "Redundancy", new Object[0])});
        this.btnRefresh.setText(this.resource.getString("DiskGroupSelectionPane.btnRefresh.text", "Refresh", new Object[0]));
    }

    public void setDiskGroups(List<DiskGroup> diskGroups) {
        this.dataModel.setDiskGroups(diskGroups);
    }

    public DiskGroup getDiskGroup() {
        return this.dataModel.getSelectedDiskGroup();
    }

    static class PageValidationComponent
    extends AbstractValidationComponent {
        private static Object INSTANCE_CHANGE_VALIDATOR = new Object();
        private ASMDiskGroupSelectionPane page;

        public PageValidationComponent(ASMDiskGroupSelectionPane _pane) {
            super((Component)new JPanel());
            this.page = _pane;
            this.page.dataModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    PageValidationComponent.this.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
                }
            });
            this.page.addPropertyChangeListener(ASMDiskGroupSelectionPane.PROPERTY_ASM_PURPOSES, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (PageValidationComponent.this.page.diskGroupSearchStatus != Status.PENDING && PageValidationComponent.this.page.diskGroupSearchStatus != Status.INPROGRESS) {
                        PageValidationComponent.this.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
                    }
                }
            });
            this.page.addPropertyChangeListener(ASMDiskGroupSelectionPane.PROPERTY_ASM_INSTANCE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    PageValidationComponent.this.validateComponent(INSTANCE_CHANGE_VALIDATOR);
                }
            });
            this.addValidator(ValidationComponent.MODEL_CHANGE_VALIDATOR, (Validator)new SimpleInlineValidator(){

                public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                    if (PageValidationComponent.this.page.dataModel.isEmpty()) {
                        return new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.NO_ASM_DISKGROUP_FOUND, new Object[0]);
                    }
                    DiskGroup diskGroup = PageValidationComponent.this.page.dataModel.getSelectedDiskGroup();
                    return ASMInputValidationHelper.validateFreeSpace((DiskGroup)diskGroup, (boolean)PageValidationComponent.this.page.dataOnASM, (boolean)PageValidationComponent.this.page.backupOnASM);
                }
            });
            this.addValidator(INSTANCE_CHANGE_VALIDATOR, (Validator)new SimpleInlineValidator(){

                public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                    ValidationStatusMessage errorMessage = null;
                    if (PageValidationComponent.this.page.asmInstance == null) {
                        errorMessage = new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_INSTANCE_NOT_FOUND, new Object[0]);
                    }
                    return errorMessage;
                }
            });
        }

        public Object getData() {
            return this.page;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiskGroupTableModel
    extends AbstractTableModel {
        private List<DiskGroup> diskGroups = new ArrayList<DiskGroup>();
        private String[] columnNames;
        private static final Class[] columnClass = new Class[]{Boolean.class, String.class, Long.class, Long.class, Redundancy.class};
        private DiskGroup selectedDiskGroup;

        public DiskGroup getSelectedDiskGroup() {
            return this.selectedDiskGroup;
        }

        public List<DiskGroup> getDiskGroups() {
            return this.diskGroups;
        }

        public void setDiskGroups(List<DiskGroup> diskGroups) {
            if (diskGroups == null) {
                this.diskGroups.clear();
            } else {
                this.diskGroups = diskGroups;
            }
            this.selectedDiskGroup = !this.diskGroups.isEmpty() ? this.diskGroups.get(0) : null;
            this.fireTableDataChanged();
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnClass[columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.selectedDiskGroup = this.diskGroups.get(rowIndex);
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.fireTableCellUpdated(i, 0);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.diskGroups.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DiskGroup diskGroup;
            Object value = null;
            if (rowIndex > -1 && rowIndex < this.diskGroups.size() && (diskGroup = this.diskGroups.get(rowIndex)) != null) {
                switch (columnIndex) {
                    case 0: {
                        value = diskGroup == this.selectedDiskGroup;
                        break;
                    }
                    case 1: {
                        value = diskGroup.getName();
                        break;
                    }
                    case 2: {
                        value = diskGroup.getSize();
                        break;
                    }
                    case 3: {
                        value = diskGroup.getFreeSpace();
                        break;
                    }
                    case 4: {
                        value = diskGroup.getRedundancy();
                    }
                }
            }
            return value;
        }

        public boolean isEmpty() {
            return this.diskGroups.isEmpty();
        }
    }
}

