/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.ivw.db.action.ConfigurationOptionsAction;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.util.DBInstallSupport;
import oracle.install.library.memory.MemoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.SystemInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ViewDef(id="ConfigurationOptionsUI")
public class ConfigurationOptionsUI
extends JPanel
implements View,
ChangeListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tpnConfigDetails = null;
    private JPanel pnlMemory = null;
    private JPanel subPnlMemory = null;
    private JPanel pnlCharsets = null;
    private JPanel pnlSecurity = null;
    private JPanel pnlSampleSchemas = null;
    private MultilineLabel lblMemoryDesc = null;
    private JLabel lblMemSlider = null;
    private JLabel lblSGAMemory = null;
    private JLabel lblPGAMemory = null;
    private JLabel lblTotalMemory = null;
    private JSlider selectedMemorySlider = null;
    private SpinnerNumberModel memFieldModel = null;
    private JLabel lblSelectedMemPercent = null;
    private JSpinner selectedMemorySpinner = null;
    private JCheckBox chbxAutoMemMgmtOptn = null;
    private String sMBSuffix = null;
    private MultilineLabel lblCharsetDesc = null;
    private JRadioButton rdoDefaultCharset = null;
    private JRadioButton rdoUnicodeCharset = null;
    private MultilineLabel lblDefaultCharsetDesc = null;
    private MultilineLabel lblUnicodeCharsetDesc = null;
    private JRadioButton rdoChooseCharset = null;
    private JLabel lblChooseCharsetDesc = null;
    private JComboBox cbxCharsets = null;
    private MultilineLabel lblSecurityDesc = null;
    private JCheckBox chxSecurityEnable = null;
    private MultilineLabel lblSampleSchemaDesc = null;
    private JCheckBox chxCreateSampleSchema = null;
    private long totalPhysicalMemory;
    private int sgaPercent;
    private long defaultAllocatedMemory;
    private HashMap<String, String> hashMap;

    private void initialize(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.getTpnConfigDetails(), (Container)this, (int)0, (int)1, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (Insets)new Insets(5, 15, 10, 10));
        String charSet = new String();
        this.sgaPercent = 75;
        int configType = dbBean.getDatabaseType_Chosen();
        if (configType == 1) {
            this.sgaPercent = 75;
        } else if (configType == 2) {
            this.sgaPercent = 60;
        }
        if (dbBean.getAllocatedMemory() == null) {
            ConfigurationOptionsAction.setDefaultMemoryOptionsInBean(dbBean);
        }
        this.defaultAllocatedMemory = dbBean.getAllocatedMemory();
        this.getChbxAutoMemMgmtOptn().setSelected(dbBean.getAutoMemoryOptionSelection());
        this.getSelectedMemorySlider().setValue((int)this.defaultAllocatedMemory);
        this.getSelectedMemorySpinner().setValue(this.defaultAllocatedMemory);
        this.updateLabels();
        charSet = dbBean.getCharacterSet();
        if (charSet != null && (charSet = charSet.trim()).length() > 0) {
            this.getRdoChooseCharset().setSelected(true);
            this.lblChooseCharsetDesc.setEnabled(true);
            this.cbxCharsets.setEnabled(true);
            this.cbxCharsets.setSelectedItem(charSet);
            ComboBoxRenderer renderer = new ComboBoxRenderer();
            this.cbxCharsets.setRenderer(renderer);
        }
        if (dbBean.isLoadExampleSchemas()) {
            this.chxCreateSampleSchema.setSelected(true);
        } else {
            this.chxCreateSampleSchema.setSelected(false);
        }
        if (dbBean.isSecureConfigDisabled()) {
            this.chxSecurityEnable.setSelected(false);
        } else {
            this.chxSecurityEnable.setSelected(true);
        }
    }

    private JTabbedPane getTpnConfigDetails() {
        if (this.tpnConfigDetails == null) {
            this.tpnConfigDetails = new JTabbedPane();
            Application application = Application.getInstance();
            String memoryTabTitle = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_MEMORY_TAB_TITLE"), new Object[0]);
            String charsetTabTitle = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_CHARSET_TAB_TITLE"), new Object[0]);
            String securityTabTitle = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_SECURITY_TAB_TITLE"), new Object[0]);
            String schemaTabTitle = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_SCHEMA_TAB_TITLE"), new Object[0]);
            SwingUtils.addTab((JTabbedPane)this.tpnConfigDetails, (String)memoryTabTitle, (Component)this.getPnlMemory());
            SwingUtils.addTab((JTabbedPane)this.tpnConfigDetails, (String)charsetTabTitle, (Component)this.getPnlCharsets());
            SwingUtils.addTab((JTabbedPane)this.tpnConfigDetails, (String)securityTabTitle, (Component)this.getPnlSecurity());
            SwingUtils.addTab((JTabbedPane)this.tpnConfigDetails, (String)schemaTabTitle, (Component)this.getPnlSampleSchemas());
        }
        return this.tpnConfigDetails;
    }

    private JPanel getPnlMemory() {
        if (this.pnlMemory == null) {
            this.lblMemoryDesc = new MultilineLabel();
            this.lblMemSlider = new JLabel();
            this.pnlMemory = new JPanel();
            this.totalPhysicalMemory = MemoryInfo.getInstance().getTotalPhysicalMemory();
            PlatformInfo platformInfo = PlatformInfo.getInstance();
            if (platformInfo.isWin32System() && this.totalPhysicalMemory >= 3072L) {
                this.totalPhysicalMemory = 3072L;
            }
            Insets INSETS = LayoutUtils.STANDARD_INSETS;
            this.pnlMemory.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.lblMemoryDesc, (Container)this.pnlMemory, (int)0, (int)0, (int)4, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)INSETS);
            LayoutUtils.addComponent((Component)this.getChbxAutoMemMgmtOptn(), (Container)this.pnlMemory, (int)0, (int)1, (int)4, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)INSETS);
            LayoutUtils.addComponent((Component)this.lblMemSlider, (Container)this.pnlMemory, (int)0, (int)2, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)INSETS);
            LayoutUtils.addComponent((Component)this.getSelectedMemorySlider(), (Container)this.pnlMemory, (int)1, (int)2, (int)1, (int)1, (int)2, (int)21, (double)1.0, (double)0.0, (Insets)INSETS);
            LayoutUtils.addComponent((Component)this.getSelectedMemorySpinner(), (Container)this.pnlMemory, (int)2, (int)2, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)INSETS);
            LayoutUtils.addComponent((Component)this.getSelectedMemPercent(), (Container)this.pnlMemory, (int)3, (int)2, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)INSETS);
            LayoutUtils.addComponent((Component)this.getMemLabelsSubPanel(), (Container)this.pnlMemory, (int)0, (int)3, (int)4, (int)1, (int)1, (int)21, (double)1.0, (double)1.0, (Insets)INSETS);
            this.lblMemSlider.setLabelFor(this.getSelectedMemorySlider());
            ActiveHelpManager.registerComponent((JComponent)this.getSelectedMemorySlider(), (String)"ConfigurationOptionsUI.txtPercentage");
            ActiveHelpManager.registerComponent((JComponent)this.chbxAutoMemMgmtOptn, (String)"ConfigurationOptionsUI.chbxAutoMemMgmtOptn");
        }
        return this.pnlMemory;
    }

    private JPanel getPnlCharsets() {
        if (this.pnlCharsets == null) {
            this.lblChooseCharsetDesc = new JLabel();
            this.lblUnicodeCharsetDesc = new MultilineLabel();
            this.lblDefaultCharsetDesc = new MultilineLabel();
            this.lblCharsetDesc = new MultilineLabel();
            this.pnlCharsets = new JPanel();
            this.pnlCharsets.setLayout(new GridBagLayout());
            ButtonGroup group = new ButtonGroup();
            group.add(this.getRdoDefaultCharset());
            group.add(this.getRdoUnicodeCharset());
            group.add(this.getRdoChooseCharset());
            this.getRdoDefaultCharset().setSelected(true);
            this.lblChooseCharsetDesc.setEnabled(false);
            this.getCbxCharsets().setEnabled(false);
            this.lblChooseCharsetDesc.setLabelFor(this.getCbxCharsets());
            LayoutUtils.addComponent((Component)this.lblCharsetDesc, (Container)this.pnlCharsets, (int)0, (int)0, (int)1, (int)1, (int)1, (int)21, (double)1.0, (double)0.0, (Insets)new Insets(5, 15, 5, 25));
            LayoutUtils.addComponent((Component)this.getRdoDefaultCharset(), (Container)this.pnlCharsets, (int)0, (int)1, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 25, 5, 25));
            LayoutUtils.addComponent((Component)this.getRdoUnicodeCharset(), (Container)this.pnlCharsets, (int)0, (int)3, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 25, 5, 25));
            LayoutUtils.addComponent((Component)this.lblDefaultCharsetDesc, (Container)this.pnlCharsets, (int)0, (int)2, (int)1, (int)1, (int)1, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 45, 5, 25));
            LayoutUtils.addComponent((Component)this.lblUnicodeCharsetDesc, (Container)this.pnlCharsets, (int)0, (int)4, (int)1, (int)1, (int)1, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 45, 5, 25));
            LayoutUtils.addComponent((Component)this.getRdoChooseCharset(), (Container)this.pnlCharsets, (int)0, (int)5, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 25, 5, 25));
            LayoutUtils.addComponent((Component)this.lblChooseCharsetDesc, (Container)this.pnlCharsets, (int)0, (int)6, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 45, 5, 25));
            LayoutUtils.addComponent((Component)this.getCbxCharsets(), (Container)this.pnlCharsets, (int)0, (int)7, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 45, 5, 25));
            ActiveHelpManager.registerComponent((JComponent)this.rdoChooseCharset, (String)"ConfigurationOptionsUI.rdoChooseCharset");
            ActiveHelpManager.registerComponent((JComponent)this.rdoDefaultCharset, (String)"ConfigurationOptionsUI.rdoDefaultCharset");
            ActiveHelpManager.registerComponent((JComponent)this.rdoUnicodeCharset, (String)"ConfigurationOptionsUI.rdoUnicodeCharset");
        }
        return this.pnlCharsets;
    }

    private JPanel getPnlSecurity() {
        if (this.pnlSecurity == null) {
            this.lblSecurityDesc = new MultilineLabel();
            this.pnlSecurity = new JPanel();
            this.pnlSecurity.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.lblSecurityDesc, (Container)this.pnlSecurity, (int)0, (int)0, (int)1, (int)1, (int)1, (int)21, (double)1.0, (double)0.0, (Insets)new Insets(30, 15, 15, 25), (int)0, (int)10);
            LayoutUtils.addComponent((Component)this.getCbxSecurityDisable(), (Container)this.pnlSecurity, (int)0, (int)1, (int)1, (int)1, (int)1, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(15, 15, 140, 25));
            ActiveHelpManager.registerComponent((JComponent)this.chxSecurityEnable, (String)"ConfigurationOptionsUI.chxSecurityEnable");
        }
        return this.pnlSecurity;
    }

    private JPanel getPnlSampleSchemas() {
        if (this.pnlSampleSchemas == null) {
            this.lblSampleSchemaDesc = new MultilineLabel();
            this.pnlSampleSchemas = new JPanel();
            this.pnlSampleSchemas.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.lblSampleSchemaDesc, (Container)this.pnlSampleSchemas, (int)0, (int)0, (int)1, (int)1, (int)1, (int)21, (double)1.0, (double)0.0, (Insets)new Insets(15, 15, 18, 25));
            LayoutUtils.addComponent((Component)this.getCbxCreateSampleSchema(), (Container)this.pnlSampleSchemas, (int)0, (int)1, (int)1, (int)1, (int)1, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(15, 15, 155, 25));
            ActiveHelpManager.registerComponent((JComponent)this.chxCreateSampleSchema, (String)"ConfigurationOptionsUI.chxCreateSampleSchema");
        }
        return this.pnlSampleSchemas;
    }

    private JRadioButton getRdoDefaultCharset() {
        if (this.rdoDefaultCharset == null) {
            this.rdoDefaultCharset = new JRadioButton();
        }
        return this.rdoDefaultCharset;
    }

    private JRadioButton getRdoUnicodeCharset() {
        if (this.rdoUnicodeCharset == null) {
            this.rdoUnicodeCharset = new JRadioButton();
        }
        return this.rdoUnicodeCharset;
    }

    private JRadioButton getRdoChooseCharset() {
        if (this.rdoChooseCharset == null) {
            this.rdoChooseCharset = new JRadioButton();
            this.rdoChooseCharset.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ConfigurationOptionsUI.this.lblChooseCharsetDesc.setEnabled(ConfigurationOptionsUI.this.rdoChooseCharset.isSelected());
                    ConfigurationOptionsUI.this.getCbxCharsets().setEnabled(ConfigurationOptionsUI.this.rdoChooseCharset.isSelected());
                }
            });
        }
        return this.rdoChooseCharset;
    }

    private JComboBox getCbxCharsets() {
        if (this.cbxCharsets == null) {
            this.hashMap = this.getAllCharsets();
            this.cbxCharsets = new JComboBox<Object>(this.hashMap.keySet().toArray());
            this.cbxCharsets.setSelectedItem(this.getDefaultCharset());
            ComboBoxRenderer renderer = new ComboBoxRenderer();
            this.cbxCharsets.setRenderer(renderer);
        }
        return this.cbxCharsets;
    }

    private JCheckBox getCbxSecurityDisable() {
        if (this.chxSecurityEnable == null) {
            this.chxSecurityEnable = new JCheckBox();
        }
        return this.chxSecurityEnable;
    }

    private JCheckBox getCbxCreateSampleSchema() {
        if (this.chxCreateSampleSchema == null) {
            this.chxCreateSampleSchema = new JCheckBox();
        }
        return this.chxCreateSampleSchema;
    }

    public Component getView() {
        return this;
    }

    public void localize(FlowContext flowContext) {
        Application application = Application.getInstance();
        String labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_ALLOCATE_MEMORY_LABEL"), new Object[0]);
        SwingUtils.setText((JLabel)this.lblMemSlider, (String)labelText);
        this.lblMemoryDesc.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_AUTO_MEMORY_MGMT_DESC"), new Object[0]));
        labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_AUTO_MEMORY_MGMT_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.getChbxAutoMemMgmtOptn(), (String)labelText);
        labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_SELECT_CHARSET_LABEL"), new Object[0]);
        SwingUtils.setText((JLabel)this.lblChooseCharsetDesc, (String)labelText);
        this.lblUnicodeCharsetDesc.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_UNICODE_CHARSET_DESC"), new Object[0]));
        String defaultCharset = this.getDefaultCharset();
        this.lblDefaultCharsetDesc.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_DEFAULT_CHARSET_DESC"), new Object[]{defaultCharset}));
        this.lblCharsetDesc.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_CHARSET_DESC"), new Object[0]));
        this.lblSecurityDesc.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_SECURITY_DESC"), new Object[0]));
        this.lblSampleSchemaDesc.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_SAMPLE_SCHEMA_DESC"), new Object[0]));
        labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_DEFAULT_CHARSET_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoDefaultCharset, (String)labelText);
        labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_UNICODE_CHARSET_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoUnicodeCharset, (String)labelText);
        labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_CHOOSE_CHARSET_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoChooseCharset, (String)labelText);
        labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_DISABLE_SECURITY_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.chxSecurityEnable, (String)labelText);
        labelText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_DLG_CREATE_SAMPLE_SCHEMA_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.chxCreateSampleSchema, (String)labelText);
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        if (eventType == EventType.INIT) {
            DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
            this.initialize(flowContext);
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        dbBean.setCharacterSet(this.getCharSet());
        dbBean.setAllocatedMemory(new Long(this.getSelectedMemorySlider().getValue()));
        dbBean.setAutoMemoryOptionSelection(this.isAutoMemMgmtSelected());
        if (this.getRdoDefaultCharset().isSelected()) {
            dbBean.setCharacterSet_Option_Selected(1);
        } else if (this.getRdoUnicodeCharset().isSelected()) {
            dbBean.setCharacterSet_Option_Selected(2);
        } else if (this.getRdoChooseCharset().isSelected()) {
            dbBean.setCharacterSet_Option_Selected(3);
        }
        dbBean.setSecureConfigDisabled(this.isSecureConfigDisabled());
        dbBean.setLoadExampleSchemas(this.chxCreateSampleSchema.isSelected());
        dbBean.setConfigTabSelectedOption(this.tpnConfigDetails.getSelectedIndex());
    }

    private String getDefaultCharset() {
        return SystemInfo.getInstance().getDefaultCharset();
    }

    private String getCharSet() {
        int index;
        String charset = "";
        if (this.rdoDefaultCharset.isSelected()) {
            charset = this.getDefaultCharset();
        } else if (this.rdoUnicodeCharset.isSelected()) {
            charset = "AL32UTF8";
        } else if (this.rdoChooseCharset.isSelected() && (index = (charset = (String)this.cbxCharsets.getSelectedItem()).lastIndexOf(" ")) != -1) {
            int length = charset.length();
            charset = charset.substring(index + 1, length);
        }
        return charset;
    }

    private HashMap<String, String> getAllCharsets() {
        HashMap<String, String> hashMap = new HashMap();
        hashMap = DBInstallSupport.getAllCharsets();
        return hashMap;
    }

    private boolean isSecureConfigDisabled() {
        return !this.chxSecurityEnable.isSelected();
    }

    private JPanel getMemLabelsSubPanel() {
        Application application = Application.getInstance();
        this.sMBSuffix = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_MB_SUFFIX"), new Object[0]);
        if (this.subPnlMemory == null) {
            this.subPnlMemory = new JPanel();
            this.lblSGAMemory = new JLabel();
            this.lblPGAMemory = new JLabel();
            this.lblTotalMemory = new JLabel();
            this.subPnlMemory.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)new JLabel(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_SGA_LABEL"), new Object[0])), (Container)this.subPnlMemory, (int)0, (int)0, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(10, 10, 0, 0));
            LayoutUtils.addComponent((Component)this.lblSGAMemory, (Container)this.subPnlMemory, (int)1, (int)0, (int)1, (int)1, (int)0, (int)22, (double)0.0, (double)0.0, (Insets)new Insets(10, 10, 0, 0));
            LayoutUtils.addComponent((Component)new JLabel(this.sMBSuffix), (Container)this.subPnlMemory, (int)2, (int)0, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(10, 10, 0, 5));
            LayoutUtils.addComponent((Component)new JLabel(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_PGA_LABEL"), new Object[0])), (Container)this.subPnlMemory, (int)0, (int)1, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 0, 0));
            LayoutUtils.addComponent((Component)this.lblPGAMemory, (Container)this.subPnlMemory, (int)1, (int)1, (int)1, (int)1, (int)0, (int)22, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 0, 0));
            LayoutUtils.addComponent((Component)new JLabel(this.sMBSuffix), (Container)this.subPnlMemory, (int)2, (int)1, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 0, 5));
            LayoutUtils.addComponent((Component)new JSeparator(0), (Container)this.subPnlMemory, (int)0, (int)2, (int)3, (int)1, (int)1, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 0, 0));
            LayoutUtils.addComponent((Component)new JLabel(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_CONFIGURATION_OPTION_TOTAL_LABEL"), new Object[0])), (Container)this.subPnlMemory, (int)0, (int)3, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 0, 0));
            LayoutUtils.addComponent((Component)this.lblTotalMemory, (Container)this.subPnlMemory, (int)1, (int)3, (int)1, (int)1, (int)0, (int)22, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 0, 0));
            LayoutUtils.addComponent((Component)new JLabel(this.sMBSuffix), (Container)this.subPnlMemory, (int)2, (int)3, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 0, 5));
        }
        return this.subPnlMemory;
    }

    private JCheckBox getChbxAutoMemMgmtOptn() {
        if (this.chbxAutoMemMgmtOptn == null) {
            this.chbxAutoMemMgmtOptn = new JCheckBox();
            this.chbxAutoMemMgmtOptn.addItemListener(this);
        }
        return this.chbxAutoMemMgmtOptn;
    }

    private JLabel getSelectedMemPercent() {
        if (this.lblSelectedMemPercent == null) {
            this.lblSelectedMemPercent = new JLabel(){
                private static final long serialVersionUID = 1L;

                public void setText(String text) {
                    if (text != null) {
                        super.setText(text + " %");
                    }
                }
            };
        }
        return this.lblSelectedMemPercent;
    }

    private JSpinner getSelectedMemorySpinner() {
        if (this.selectedMemorySpinner == null) {
            this.memFieldModel = new SpinnerNumberModel(256, 256, (int)this.totalPhysicalMemory, 1);
            this.selectedMemorySpinner = new JSpinner(this.memFieldModel);
            this.selectedMemorySpinner.addChangeListener(this);
        }
        return this.selectedMemorySpinner;
    }

    private JSlider getSelectedMemorySlider() {
        if (this.selectedMemorySlider == null) {
            this.selectedMemorySlider = new JSlider(256, (int)this.totalPhysicalMemory);
            this.selectedMemorySlider.setMajorTickSpacing(this.selectedMemorySlider.getMaximum() - this.selectedMemorySlider.getMinimum());
            this.selectedMemorySlider.addChangeListener(this);
            this.selectedMemorySlider.setPaintTrack(true);
            this.selectedMemorySlider.setPaintLabels(true);
        }
        return this.selectedMemorySlider;
    }

    private int getSelectedMemory() {
        return this.selectedMemorySlider.getValue();
    }

    private boolean isAutoMemMgmtSelected() {
        return this.getChbxAutoMemMgmtOptn().isSelected();
    }

    private void updateLabels() {
        int selectedMem = this.getSelectedMemory();
        int nMemPercent = (int)Math.round((double)selectedMem * 100.0 / (double)this.totalPhysicalMemory);
        this.getSelectedMemPercent().setText(String.valueOf(nMemPercent));
        this.lblTotalMemory.setText(String.valueOf(selectedMem));
        if (this.isAutoMemMgmtSelected()) {
            this.lblSGAMemory.setText("AUTO");
            this.lblPGAMemory.setText("AUTO");
        } else {
            int nSGAPortion = selectedMem * this.sgaPercent / 100;
            int nPGAPortion = selectedMem - nSGAPortion;
            this.lblSGAMemory.setText(String.valueOf(nSGAPortion));
            this.lblPGAMemory.setText(String.valueOf(nPGAPortion));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getChbxAutoMemMgmtOptn()) {
            this.updateLabels();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.getSelectedMemorySlider()) {
            this.getSelectedMemorySpinner().setValue(this.getSelectedMemorySlider().getValue());
        } else if (e.getSource() == this.getSelectedMemorySpinner()) {
            int spinnerValue = ((SpinnerNumberModel)this.getSelectedMemorySpinner().getModel()).getNumber().intValue();
            if (spinnerValue < 256) {
                this.getSelectedMemorySpinner().setValue(256);
            }
            this.getSelectedMemorySlider().setValue(spinnerValue);
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(this.getSelectedMemorySlider().getValue()), new JLabel(String.valueOf(this.getSelectedMemorySlider().getValue())));
        labelTable.put(new Integer(this.getSelectedMemorySlider().getMaximum()), new JLabel(String.valueOf(this.getSelectedMemorySlider().getMaximum())));
        labelTable.put(new Integer(this.getSelectedMemorySlider().getMinimum()), new JLabel(String.valueOf(this.getSelectedMemorySlider().getMinimum())));
        this.getSelectedMemorySlider().setLabelTable(labelTable);
        this.updateLabels();
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 2L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
        }

        public Component getListCellRendererComponent(JList list, Object obj, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String key = obj.toString();
            String value = (String)ConfigurationOptionsUI.this.hashMap.get(key);
            this.setText(value + " " + key);
            return this;
        }
    }
}

