/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.db.bean.DBInstallSettings;

@ViewDef(id="ConfigurationTypeUI")
public class ConfigurationTypeUI
extends JPanel
implements View {
    private static final long serialVersionUID = 1L;
    private MultilineLabel lblConfigTypePrompt = null;
    private JRadioButton rdoGeneralPurpose = null;
    private JRadioButton rdoDataWarehousing = null;
    private MultilineLabel lblGPDesc = null;
    private MultilineLabel lblDWDesc = null;

    public ConfigurationTypeUI() {
        this.initialize();
    }

    private void initialize() {
        this.lblConfigTypePrompt = new MultilineLabel();
        this.lblConfigTypePrompt.setName("ConfigurationTypeUI_lblConfigTypePrompt");
        this.lblGPDesc = new MultilineLabel();
        this.lblGPDesc.setName("ConfigurationTypeUI_lblGPDesc");
        this.lblDWDesc = new MultilineLabel();
        this.lblDWDesc.setName("ConfigurationTypeUI_lblDWDesc");
        this.rdoGeneralPurpose = new JRadioButton();
        this.rdoGeneralPurpose.setName("ConfigurationTypeUI_rdoGeneralPurpose");
        this.rdoDataWarehousing = new JRadioButton();
        this.rdoDataWarehousing.setName("ConfigurationTypeUI_rdoDataWarehousing");
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdoGeneralPurpose);
        group.add(this.rdoDataWarehousing);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblConfigTypePrompt, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent((Component)this.rdoGeneralPurpose, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)1, (int)10, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 2, 5));
        LayoutUtils.addComponent((Component)this.lblGPDesc, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)10, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 10, 5));
        LayoutUtils.addComponent((Component)this.rdoDataWarehousing, (Container)this, (int)0, (int)3, (int)1, (int)1, (int)1, (int)10, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 2, 5));
        LayoutUtils.addComponent((Component)this.lblDWDesc, (Container)this, (int)0, (int)4, (int)1, (int)1, (int)1, (int)10, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 10, 5));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)5, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (Insets)new Insets(5, 35, 10, 5));
        ActiveHelpManager.registerComponent((JComponent)this.rdoGeneralPurpose, (String)"ConfigurationTypeUI.rdoGeneralPurpose");
        ActiveHelpManager.registerComponent((JComponent)this.rdoDataWarehousing, (String)"ConfigurationTypeUI.rdoDataWarehousing");
    }

    public Component getView() {
        return this;
    }

    public void localize(FlowContext flowContext) {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        this.lblConfigTypePrompt.setText(resource.getString("INSTALL_DB_CONFIGURATION_TYPE_DLG_PROMPT", "Select the type of database you wish to create.", new Object[0]));
        String labelText = resource.getString("INSTALL_DB_CONFIGURATION_TYPE_DLG_GP_LABEL", "&General Purpose / Transaction Processing*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoGeneralPurpose, (String)labelText);
        this.lblGPDesc.setText(resource.getString("INSTALL_DB_CONFIGURATION_TYPE_DLG_GP_PROMPT", "A starter database designed for general purpose usage.", new Object[0]));
        labelText = resource.getString("INSTALL_DB_CONFIGURATION_TYPE_DLG_DW_LABEL", "&Data Warehousing*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoDataWarehousing, (String)labelText);
        this.lblDWDesc.setText(resource.getString("INSTALL_DB_CONFIGURATION_TYPE_DLG_DW_PROMPT", "A starter database optimized for data warehousing applications.", new Object[0]));
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        if (eventType == EventType.INIT) {
            DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
            switch (bean.getStarterDatabaseType()) {
                case DATA_WAREHOUSE: {
                    this.rdoDataWarehousing.setSelected(true);
                    break;
                }
                case GENERAL_PURPOSE: {
                    this.rdoGeneralPurpose.setSelected(true);
                }
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.rdoGeneralPurpose.isSelected()) {
            dbBean.setStarterDatabaseType(DBInstallSettings.StarterDatabaseType.GENERAL_PURPOSE);
        } else if (this.rdoDataWarehousing.isSelected()) {
            dbBean.setStarterDatabaseType(DBInstallSettings.StarterDatabaseType.DATA_WAREHOUSE);
        }
    }
}

