/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBDialogLabelResID;
import oracle.install.library.util.StageSizeInfo;

class DBEditionCellRenderer
extends DefaultListCellRenderer {
    Resource resource = Application.getInstance().getResource(DBDialogLabelResID.class.getName());

    DBEditionCellRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            boolean considerOracleHomeOffset = true;
            String text = value.toString();
            String seSize = StageSizeInfo.getSizeString((String)DBInstallSettings.InstallType.SE.getValue(), (boolean)considerOracleHomeOffset);
            switch ((DBInstallSettings.InstallEdition)((Object)value)) {
                case EE: {
                    String eeSize = StageSizeInfo.getSizeString((String)DBInstallSettings.InstallType.EE.getValue(), (boolean)considerOracleHomeOffset);
                    text = this.resource.getString("QuickInstallPane.EEOption.text", "Enterprise Edition*", new Object[]{eeSize});
                    break;
                }
                case SE: {
                    text = this.resource.getString("QuickInstallPane.SEOption.text", "Standard Edition*", new Object[]{seSize});
                    break;
                }
                case SEONE: {
                    text = this.resource.getString("QuickInstallPane.SEOneOption.text", "Standard Edition One*", new Object[]{seSize});
                    break;
                }
                case PE: {
                    String peSize = StageSizeInfo.getSizeString((String)DBInstallSettings.InstallType.PE.getValue());
                    text = this.resource.getString("QuickInstallPane.PEOption.text", "Personal Edition*", new Object[]{peSize});
                }
            }
            this.setText(text);
        }
        return renderer;
    }
}

