/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.base.util.ComponentConfig;
import oracle.install.commons.base.util.ComponentConfigBuilder;
import oracle.install.commons.base.util.ComponentConfigSource;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.view.ComponentChooser;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBDialogLabelResID;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.StageSizeInfo;

@ViewDef(id="DBEditionUI")
public class DBEditionGUI
extends JPanel
implements View {
    private static final long serialVersionUID = 1L;
    private final String COMPONENT_XML = "/oracle/install/ivw/db/resource/custom_component-config.xml";
    private MultilineLabel lblDBEditionPrompt;
    private JRadioButton rdoEnterpriseEdition;
    private JRadioButton rdoStandardEdition;
    private JRadioButton rdoStandardEditionOne;
    private JRadioButton rdoPersonalEdition;
    private MultilineLabel lblEEDesc;
    private MultilineLabel lblSEDesc;
    private MultilineLabel lblSEOneDesc;
    private MultilineLabel lblPEOneDesc;
    private JButton btnSelectOptions;
    private ComponentConfigSource componentSource;
    private String[] selectedComponentIds;
    private String[] defaultSelectedComponentIds;
    private boolean customSelection;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean rac;

    public DBEditionGUI() {
        URL url = DBEditionGUI.class.getResource("/oracle/install/ivw/db/resource/custom_component-config.xml");
        this.componentSource = this.getComponentConfigSource(url);
        this.buildUI();
    }

    private ComponentConfigSource getComponentConfigSource(URL url) {
        ComponentConfigSource source = new ComponentConfigSource(url);
        return source;
    }

    private ComponentConfig getComponentBean() {
        ComponentConfig bean = null;
        try {
            URL url = DBEditionGUI.class.getResource("/oracle/install/ivw/db/resource/custom_component-config.xml");
            ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
            bean = builder.getComponentBean(url);
        }
        catch (Exception e) {
            ExceptionManager.handle((Throwable)e);
        }
        return bean;
    }

    private void buildUI() {
        this.lblDBEditionPrompt = new MultilineLabel();
        this.lblEEDesc = new MultilineLabel();
        this.lblSEDesc = new MultilineLabel();
        this.lblSEOneDesc = new MultilineLabel();
        this.lblPEOneDesc = new MultilineLabel();
        this.btnSelectOptions = new JButton();
        this.rdoEnterpriseEdition = new JRadioButton();
        this.rdoEnterpriseEdition.setSelected(true);
        this.rdoStandardEdition = new JRadioButton();
        this.rdoStandardEditionOne = new JRadioButton();
        this.rdoPersonalEdition = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdoEnterpriseEdition);
        group.add(this.rdoStandardEdition);
        group.add(this.rdoStandardEditionOne);
        group.add(this.rdoPersonalEdition);
        this.btnSelectOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBEditionGUI.this.invokeOptionsDialog();
            }
        });
        this.rdoEnterpriseEdition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBEditionGUI.this.btnSelectOptions.setEnabled(true);
            }
        });
        this.rdoStandardEdition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBEditionGUI.this.btnSelectOptions.setEnabled(false);
            }
        });
        this.rdoStandardEditionOne.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBEditionGUI.this.btnSelectOptions.setEnabled(false);
            }
        });
        this.rdoPersonalEdition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBEditionGUI.this.btnSelectOptions.setEnabled(false);
            }
        });
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblDBEditionPrompt, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 15, 5, 20));
        LayoutUtils.addComponent((Component)this.rdoEnterpriseEdition, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 15, 0, 20));
        LayoutUtils.addComponent((Component)this.lblEEDesc, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 32, 5, 20));
        LayoutUtils.addComponent((Component)this.rdoStandardEdition, (Container)this, (int)0, (int)3, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 15, 0, 20));
        LayoutUtils.addComponent((Component)this.lblSEDesc, (Container)this, (int)0, (int)4, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 32, 5, 20));
        LayoutUtils.addComponent((Component)this.rdoStandardEditionOne, (Container)this, (int)0, (int)5, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 15, 0, 20));
        LayoutUtils.addComponent((Component)this.lblSEOneDesc, (Container)this, (int)0, (int)6, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 32, 5, 20));
        LayoutUtils.addComponent((Component)this.rdoPersonalEdition, (Container)this, (int)0, (int)7, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 15, 0, 20));
        LayoutUtils.addComponent((Component)this.lblPEOneDesc, (Container)this, (int)0, (int)8, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 32, 5, 20));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)9, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        LayoutUtils.addComponent((Component)this.btnSelectOptions, (Container)this, (int)0, (int)10, (int)1, (int)1, (int)0, (int)12, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 20));
        this.localize(null);
        ActiveHelpManager.registerComponent((JComponent)this.rdoEnterpriseEdition, (String)"DBEditionUI.rdoEnterpriseEdition");
        ActiveHelpManager.registerComponent((JComponent)this.rdoStandardEdition, (String)"DBEditionUI.rdoStandardEdition");
        ActiveHelpManager.registerComponent((JComponent)this.rdoPersonalEdition, (String)"DBEditionUI.rdoPersonalEdition");
        ActiveHelpManager.registerComponent((JComponent)this.rdoStandardEditionOne, (String)"DBEditionUI.rdoStandardEditionOne");
    }

    private void invokeOptionsDialog() {
        ComponentConfig componentConfig;
        String[] componentIds = null;
        if (this.selectedComponentIds != null) {
            componentIds = this.selectedComponentIds;
        }
        if ((componentConfig = ComponentChooser.showDialog((Component)this, (ComponentConfigSource)this.componentSource, (String[])componentIds)) != null) {
            this.selectedComponentIds = componentConfig.getSelectedVisibleComponents();
            this.customSelection = !componentConfig.areComponentsSelected(this.defaultSelectedComponentIds) || this.defaultSelectedComponentIds != null && this.selectedComponentIds != null && this.defaultSelectedComponentIds.length != this.selectedComponentIds.length;
        }
    }

    public Component getView() {
        return this;
    }

    public void localize(FlowContext flowContext) {
        Application application = Application.getInstance();
        Resource resource = application.getResource(DBDialogLabelResID.class.getName());
        boolean considerOracleHomeOffset = true;
        this.lblDBEditionPrompt.setText(resource.getString("DBEditionGUI.lblDBEditionPrompt.text", "Which database edition do you want to install?*", new Object[0]));
        String eeSize = StageSizeInfo.getSizeString((String)DBInstallSettings.InstallType.EE.getValue(), (boolean)considerOracleHomeOffset);
        String seSize = StageSizeInfo.getSizeString((String)DBInstallSettings.InstallType.SE.getValue(), (boolean)considerOracleHomeOffset);
        String labelText = resource.getString("DBEditionGUI.rdoEnterpriseEdition.text", "&Enterprise Edition (3.4 GB)*", new Object[]{eeSize});
        SwingUtils.setText((AbstractButton)this.rdoEnterpriseEdition, (String)labelText);
        labelText = resource.getString("DBEditionGUI.rdoStandardEdition.text", "&Standard Edition (3.29 GB)*", new Object[]{seSize});
        SwingUtils.setText((AbstractButton)this.rdoStandardEdition, (String)labelText);
        labelText = resource.getString("DBEditionGUI.rdoStandardEditionOne.text", "Standard Edition&One (3.29 GB)*", new Object[]{seSize});
        SwingUtils.setText((AbstractButton)this.rdoStandardEditionOne, (String)labelText);
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        boolean windows = platformInfo.isWindows();
        if (windows) {
            String peSize = StageSizeInfo.getSizeString((String)DBInstallSettings.InstallType.PE.getValue());
            labelText = resource.getString("DBEditionGUI.rdoPersonalEditionOne.text", "Personal Edition (2.69 GB)*", new Object[]{peSize});
            SwingUtils.setText((AbstractButton)this.rdoPersonalEdition, (String)labelText);
        }
        this.lblEEDesc.setText(resource.getString("DBEditionGUI.lblEEDesc.text", "Oracle Database 11g Enterprise Edition is a self-managing database that has the scalability, performance, high availability, and security features required to run the most demanding, mission critical applications.", new Object[0]));
        this.lblSEDesc.setText(resource.getString("DBEditionGUI.lblSEDesc.text", "Oracle Database 11g Standard Edition is ideal for work groups, departments, and small to medium sized businesses looking for lower-cost offering.", new Object[0]));
        this.lblSEOneDesc.setText(resource.getString("DBEditionGUI.lblSEOneDesc.text", "Oracle Database 11g Standard EditionOne is ideal for work groups, departments, and small to medium sized businesses looking for lower-cost offering.**", new Object[0]));
        this.lblPEOneDesc.setText(resource.getString("DBEditionGUI.lblPEOneDesc.text", "Supports single user development and deployment that require full compatibility with Oracle Enterprise Edition 11g and Oracle Standard Edition 11g.*", new Object[0]));
        String buttonText = resource.getString("DBEditionGUI.btnSelectOptions.text", "Select Op&tions*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnSelectOptions, (String)buttonText);
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        switch (eventType) {
            case INIT: {
                DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
                String[] customComponents = dbBean.getCustomComponents();
                ComponentConfig componentConfig = this.getComponentBean();
                if (componentConfig != null) {
                    this.defaultSelectedComponentIds = componentConfig.getSelectedVisibleComponents();
                    componentConfig.setSelectedVisibleComponents(customComponents);
                }
                this.selectedComponentIds = customComponents == null ? this.defaultSelectedComponentIds : customComponents;
            }
        }
        switch (bean.getDbInstallEdition()) {
            case EE: {
                this.rdoEnterpriseEdition.setSelected(true);
                this.btnSelectOptions.setEnabled(true);
                break;
            }
            case SE: {
                this.rdoStandardEdition.setSelected(true);
                this.btnSelectOptions.setEnabled(false);
                break;
            }
            case SEONE: {
                this.rdoStandardEditionOne.setSelected(true);
                this.btnSelectOptions.setEnabled(false);
                break;
            }
            case PE: {
                this.rdoPersonalEdition.setSelected(true);
                this.btnSelectOptions.setEnabled(false);
            }
        }
        this.rac = bean.isRACinstall();
        if (this.rac) {
            this.showSEOne(false);
        } else {
            this.showSEOne(true);
        }
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        boolean windows = platformInfo.isWindows();
        if (windows) {
            if (this.rac) {
                this.showPE(false);
            } else {
                this.showPE(true);
            }
        } else {
            this.showPE(false);
        }
    }

    private void showSEOne(boolean visible) {
        this.rdoStandardEditionOne.setVisible(visible);
        this.lblSEOneDesc.setVisible(visible);
    }

    private void showPE(boolean visible) {
        this.rdoPersonalEdition.setVisible(visible);
        this.lblPEOneDesc.setVisible(visible);
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        DBInstallSettings.InstallEdition dbInstallEdition = DBInstallSettings.InstallEdition.SE;
        if (this.rdoEnterpriseEdition.isSelected()) {
            dbInstallEdition = DBInstallSettings.InstallEdition.EE;
            dbBean.setCustomInstall(this.customSelection);
        } else if (this.rdoStandardEdition.isSelected()) {
            dbInstallEdition = DBInstallSettings.InstallEdition.SE;
            dbBean.setCustomInstall(this.customSelection);
        } else if (this.rdoStandardEditionOne.isSelected()) {
            dbInstallEdition = DBInstallSettings.InstallEdition.SEONE;
        } else if (this.rdoPersonalEdition.isSelected()) {
            dbInstallEdition = DBInstallSettings.InstallEdition.PE;
        }
        this.logger.info("Install edition selected in UI: " + dbInstallEdition.getValue());
        dbBean.setDbInstallEdition(dbInstallEdition);
        if (this.customSelection) {
            dbBean.setCustomComponents(this.selectedComponentIds);
        }
    }
}

