/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.DBIdentifierValidator;
import oracle.install.library.util.PlatformInfo;

@ViewDef(id="DBIdentifierUI")
public class DBIdentifierUI
extends JPanel
implements View {
    private static final long serialVersionUID = 1L;
    private MultilineLabel lblGDBdesc = null;
    private JLabel lblGDBPrompt = null;
    private JTextField txtGDB = null;
    private MultilineLabel lblSIDdesc = null;
    private JLabel lblSIDprompt = null;
    private JTextField txtSID = null;
    private boolean isRAC = false;

    public DBIdentifierUI() {
        this.initialize();
    }

    private void initialize() {
        this.lblSIDprompt = new JLabel();
        this.lblSIDdesc = new MultilineLabel();
        this.lblGDBPrompt = new JLabel();
        this.lblGDBdesc = new MultilineLabel();
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblGDBdesc, (Container)this, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 10, 15, 10));
        LayoutUtils.addComponent((Component)this.lblGDBPrompt, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 30, 5));
        LayoutUtils.addComponent((Component)this.getTxtGDB(), (Container)this, (int)1, (int)1, (int)1, (int)1, (int)2, (int)12, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 30, 5));
        LayoutUtils.addComponent((Component)Box.createHorizontalGlue(), (Container)this, (int)2, (int)1, (int)1, (int)1, (int)2, (int)12, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 30, 130));
        LayoutUtils.addComponent((Component)this.lblSIDdesc, (Container)this, (int)0, (int)2, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 10, 15, 10));
        LayoutUtils.addComponent((Component)this.lblSIDprompt, (Container)this, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 10, 30, 5));
        LayoutUtils.addComponent((Component)this.getTxtSID(), (Container)this, (int)1, (int)3, (int)1, (int)1, (int)2, (int)12, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 30, 5));
        LayoutUtils.addComponent((Component)Box.createHorizontalGlue(), (Container)this, (int)2, (int)3, (int)1, (int)1, (int)2, (int)12, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 30, 130));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)3, (int)3, (int)1, (int)2, (int)12, (double)1.0, (double)1.0, (Insets)new Insets(5, 5, 25, 5));
        this.lblSIDprompt.setLabelFor(this.getTxtSID());
        this.lblGDBPrompt.setLabelFor(this.getTxtGDB());
        ActiveHelpManager.registerComponent((JComponent)this.txtGDB, (String)"DBIdentifierUI.txtGDB");
        ActiveHelpManager.registerComponent((JComponent)this.txtSID, (String)"DBIdentifierUI.txtSID");
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.txtGDB, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                DBIdentifierValidator.validateGlobalDBName(data.toString());
                return null;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.txtSID, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                DBIdentifierValidator.validateSID(data.toString(), DBIdentifierUI.this.isRAC);
                return null;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
    }

    private JTextField getTxtGDB() {
        if (this.txtGDB == null) {
            this.txtGDB = new JTextField();
            this.txtGDB.setColumns(10);
            this.txtGDB.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    DBIdentifierUI.this.gdbTextFieldChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    DBIdentifierUI.this.gdbTextFieldChanged();
                }
            });
        }
        return this.txtGDB;
    }

    private JTextField getTxtSID() {
        if (this.txtSID == null) {
            this.txtSID = new JTextField();
            this.txtSID.setColumns(10);
        }
        return this.txtSID;
    }

    private void gdbTextFieldChanged() {
        int curPlatId;
        PlatformInfo platInfo = PlatformInfo.getInstance();
        int curPlatGroup = platInfo.getPlatGroup(curPlatId = platInfo.getCurrentPlatform());
        int autoFillLength = curPlatGroup == -1 ? (this.isRAC ? 8 : 12) : (this.isRAC ? 8 : 12);
        String gdb = this.getTxtGDB().getText();
        String sid = "";
        sid = gdb.length() >= 0 && gdb.length() <= autoFillLength ? gdb : gdb.substring(0, autoFillLength);
        if (sid.indexOf(".") != -1) {
            sid = sid.substring(0, sid.indexOf("."));
        }
        this.getTxtSID().setText(sid);
    }

    public Component getView() {
        return this;
    }

    public void localize(FlowContext flowContext) {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        this.lblGDBdesc.setText(resource.getString("INSTALL_DB_GDBANDSID_DLG_GDB_NAME_PROMPT", "An Oracle database is uniquely identified by a Global Database Name, typically of the form \"name.domain\".", new Object[0]));
        this.lblSIDdesc.setText(resource.getString("INSTALL_DB_GDBANDSID_DLG_SID_PROMPT", "A database is referenced by atleast one Oracle instance which is uniquely identified from any other instance on this computer by an Oracle System Identifier (SID).", new Object[0]));
        String labelText = resource.getString("INSTALL_DB_GDBANDSID_DLG_GDB_LABEL", "&Global Database Name*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblGDBPrompt, (String)labelText);
        labelText = resource.getString("INSTALL_DB_GDBANDSID_DLG_SID_LABEL", "&Oracle System Identifier (SID)*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblSIDprompt, (String)labelText);
    }

    private String getDefaultSID() {
        String sid = "";
        PlatformInfo platInfo = PlatformInfo.getInstance();
        String existingSid = platInfo.getEnv("ORACLE_SID");
        int len_existingSid = 0;
        if (existingSid != null && !existingSid.equals("")) {
            len_existingSid = existingSid.trim().length();
        }
        int maxLength = 8;
        sid = len_existingSid == 0 ? "orcl" : (len_existingSid <= maxLength ? existingSid.substring(0, len_existingSid) : existingSid.substring(0, maxLength));
        return sid;
    }

    private String getDefaultGlobalDBName() {
        PlatformInfo platInfo = PlatformInfo.getInstance();
        String domainName = "";
        if (platInfo.getFullHostName() != null || !platInfo.getFullHostName().equals("")) {
            domainName = platInfo.getDomainName(platInfo.getFullHostName());
        }
        String gdbName = "";
        gdbName = domainName == null || domainName.equals("") ? "orcl" : "orcl." + domainName;
        return gdbName;
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (eventType == EventType.INIT) {
            String globalDBName = dbBean.getGlobalDBName();
            if (globalDBName == null || globalDBName.length() == 0) {
                globalDBName = this.getDefaultGlobalDBName();
            }
            this.txtGDB.setText(globalDBName);
            String sid = dbBean.getDb_SID();
            if (sid == null || sid.length() == 0) {
                sid = this.getDefaultSID();
            }
            this.txtSID.setText(sid);
        } else if (eventType == EventType.LOAD) {
            this.isRAC = dbBean.isRACinstall();
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        dbBean.setGlobalDBName(this.txtGDB.getText().trim());
        dbBean.setDb_SID(this.txtSID.getText().trim());
    }
}

