/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;

public class DiskDiscoveryPathDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel lblDiskDiscoverPathDescription = null;
    private JLabel lblDiskPath = null;
    private JTextField txtDiscoveryPath = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private String diskRecoveryPath = "";
    private String defaultDiskRecoveryPath = "";
    private boolean okButtonPressed = false;
    private Frame owner;

    public DiskDiscoveryPathDialog(Frame owner, String defPath) {
        super(owner);
        this.defaultDiskRecoveryPath = defPath;
        this.owner = owner;
        this.initialize();
    }

    private void initialize() {
        this.setSize(530, 165);
        this.setLocationRelativeTo(this.owner);
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setLocalizedTexts();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblDiskPath = new JLabel();
            this.lblDiskDiscoverPathDescription = new JLabel();
            this.jContentPane = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            this.jContentPane.setLayout(gbl);
            this.addComponent(this.lblDiskDiscoverPathDescription, this.jContentPane, gbl, gbc, 0, 21, 0, 0, 3, 1, 0, 0, 1.0, 0.0, new Insets(15, 15, 15, 15));
            this.addComponent(this.lblDiskPath, this.jContentPane, gbl, gbc, 0, 21, 0, 1, 1, 1, 10, 0, 0.0, 0.0, new Insets(10, 15, 5, 5));
            this.addComponent(this.getTxtDiscoveryPath(), this.jContentPane, gbl, gbc, 1, 10, 1, 1, 2, 1, 280, 0, 1.0, 0.0, new Insets(10, 5, 6, 15));
            this.addComponent(this.getBtnOk(), this.jContentPane, gbl, gbc, 22, 10, 1, 2, 1, 1, 35, 0, 0.0, 0.0, new Insets(10, 220, 10, 5));
            this.addComponent(this.getBtnCancel(), this.jContentPane, gbl, gbc, 22, 10, 2, 2, 1, 1, 10, 0, 0.0, 0.0, new Insets(10, 10, 10, 15));
        }
        return this.jContentPane;
    }

    private JTextField getTxtDiscoveryPath() {
        if (this.txtDiscoveryPath == null) {
            this.txtDiscoveryPath = new JTextField();
            this.txtDiscoveryPath.setText(this.defaultDiskRecoveryPath);
        }
        return this.txtDiscoveryPath;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            final DiskDiscoveryPathDialog dialog = this;
            this.btnOk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DiskDiscoveryPathDialog.this.diskRecoveryPath = DiskDiscoveryPathDialog.this.getTxtDiscoveryPath().getText().trim();
                    DiskDiscoveryPathDialog.this.okButtonPressed = true;
                    dialog.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            final DiskDiscoveryPathDialog dialog = this;
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DiskDiscoveryPathDialog.this.okButtonPressed = false;
                    dialog.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private void setLocalizedTexts() {
        this.setTitle(this.getDBLabel("INSTALL_DB_ASM_CONFIG_DISK_RECOVERY_DLG_TITLE"));
        this.btnOk.setText(this.getDBLabel("INSTALL_DB_ASM_CONFIG_DISK_RECOVERY_DLG_OK"));
        this.btnCancel.setText(this.getDBLabel("INSTALL_DB_ASM_CONFIG_DISK_RECOVERY_DLG_CANCEL"));
        this.lblDiskPath.setText(this.getDBLabel("INSTALL_DB_ASM_CONFIG_DISK_RECOVERY_DLG_LABEL"));
        this.lblDiskDiscoverPathDescription.setText(this.getDBLabel("INSTALL_DB_ASM_CONFIG_DISK_RECOVERY_DLG_DESC"));
    }

    private String getDBLabel(String key) {
        return Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)key), new Object[0]);
    }

    public String getDiskRecoveryPath() {
        if (this.okButtonPressed) {
            return this.diskRecoveryPath;
        }
        return this.defaultDiskRecoveryPath;
    }

    public boolean isOkPressed() {
        return this.okButtonPressed;
    }

    private void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int iFill, int iAnchor, int x, int y, int iWidth, int iHeight, int iPadx, int iPady, double weightx, double weighty, Insets insets) {
        gbc.fill = iFill;
        gbc.anchor = iAnchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = iWidth;
        gbc.gridheight = iHeight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.ipadx = iPadx;
        gbc.ipady = iPady;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }
}

