/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.util.List;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.view.InstallLocationPane;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.library.asm.ACFSUtil;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.OFAWrapper;

@ViewDef(id="InstallLocationUI")
public class InstallLocationUI
implements View {
    private InstallLocationPane installLocationPane = new InstallLocationPane();

    private void initialize(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        String oraBase = new String();
        String oraHome = new String();
        oraHome = dbBean.getOracleHome();
        oraBase = dbBean.getOracleBase();
        if (GenericValidation.isEmpty((String)oraBase)) {
            oraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation();
        }
        if (GenericValidation.isEmpty((String)oraHome) || InventoryInfo.getInstance().isHomeWithLocationExist(oraHome)) {
            String loc;
            oraHome = null;
            ACFSUtil acfsUtil = ACFSUtil.getInstance();
            List registeredAcfsMounts = null;
            registeredAcfsMounts = acfsUtil.getRegisteredACFSMountPoints();
            if (registeredAcfsMounts != null && registeredAcfsMounts.size() > 0 && (loc = FileSystemInfo.getInstance().getLocationWithMaxFreespace(registeredAcfsMounts)) != null && loc.trim().length() > 0) {
                oraHome = OFAWrapper.getInstance().getDBHomeLoc(loc);
                this.installLocationPane.setOracleHomeLocEditied(true);
            }
            if (GenericValidation.isEmpty((String)oraHome)) {
                oraHome = OFAWrapper.getInstance().getDBHomeLoc(oraBase);
                this.installLocationPane.setDefOracleHomeLocation(oraHome);
            }
        }
        this.installLocationPane.setOracleHomeLocation(oraHome);
        if (!GenericValidation.isEmpty((String)OFAWrapper.getInstance().getBaseForLocation(oraHome))) {
            oraBase = OFAWrapper.getInstance().getBaseForLocation(oraHome);
            this.installLocationPane.dissableOracleBase();
        }
        this.installLocationPane.setOracleBase(oraBase);
        this.installLocationPane.setOracleBaseActiveHelpId("InstallLocationPane.cbxOracleBases");
        this.installLocationPane.setOracleHomeActiveHelpId("InstallLocationPane.cbxSoftwareLoc");
    }

    public Component getView() {
        return this.installLocationPane;
    }

    public void localize(FlowContext flowContext) {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        String oraBaseDesc = resource.getString("INSTALL_DB_INSTALL_LOCATION_DLG_LABEL_ORABASE_DESC", "Specify an Oracle base path to place all Oracle software and configuration-related files.  This location is the Oracle base directory.", new Object[0]);
        String oraHomeDesc = resource.getString("INSTALL_DB_INSTALL_LOCATION_DLG_LABEL_ORAHOME_DESC", "Specify a location for storing Oracle software files.  This location is the Oracle home directory.", new Object[0]);
        this.installLocationPane.setOracleBaseDesc(oraBaseDesc);
        this.installLocationPane.setOracleHomeDesc(oraHomeDesc);
        this.installLocationPane.localize();
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        if (eventType == EventType.INIT) {
            this.initialize(flowContext);
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        String oracleBase = this.installLocationPane.getOracleBase();
        dbBean.setOracleBase(oracleBase);
        cenInv.setInventoryLocation(InventoryInfo.computeInventoryLocation((String)oracleBase));
        dbBean.setOracleHome(this.installLocationPane.getOracleHomeLocation());
    }
}

