/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.db.bean.DBInstallSettings;

@ViewDef(id="InstallOptionsUI")
public class InstallOptionsUI
implements View {
    private JPanel installOptionsPanel;
    private Logger logger = Logger.getLogger(InstallOptionsUI.class.getName());
    private MultilineLabel pageDesc;
    private JRadioButton createDBType;
    private JRadioButton createDBSoftwareType;
    private JRadioButton upgradeType;
    private ButtonGroup group;

    public InstallOptionsUI() {
        this.logger.log(Level.INFO, "InstallOptionsUI Entering Constructor");
        this.installOptionsPanel = new JPanel();
        this.pageDesc = new MultilineLabel();
        this.createDBType = new JRadioButton();
        this.createDBSoftwareType = new JRadioButton();
        this.upgradeType = new JRadioButton();
        this.group = new ButtonGroup();
        this.group.add(this.createDBType);
        this.group.add(this.createDBSoftwareType);
        this.group.add(this.upgradeType);
        this.installOptionsPanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.pageDesc, (Container)this.installOptionsPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent((Component)this.createDBType, (Container)this.installOptionsPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 10, 10, 5));
        LayoutUtils.addComponent((Component)this.createDBSoftwareType, (Container)this.installOptionsPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 10, 10, 5));
        LayoutUtils.addComponent((Component)this.upgradeType, (Container)this.installOptionsPanel, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 10, 10, 5));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this.installOptionsPanel, (int)0, (int)4, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (Insets)new Insets(5, 5, 5, 5));
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == InstallOptionsUI.this.createDBType || e.getSource() == InstallOptionsUI.this.createDBSoftwareType || e.getSource() == InstallOptionsUI.this.upgradeType) {
                    // empty if block
                }
            }
        };
        this.createDBType.addActionListener(listener);
        this.createDBSoftwareType.addActionListener(listener);
        this.upgradeType.addActionListener(listener);
        ActiveHelpManager.registerComponent((JComponent)this.createDBType, (String)"InstallOptionsUI.rdoCreateDB");
        ActiveHelpManager.registerComponent((JComponent)this.createDBSoftwareType, (String)"InstallOptionsUI.rdoSoftwareOnly");
        ActiveHelpManager.registerComponent((JComponent)this.upgradeType, (String)"InstallOptionsUI.rdoUpgrade");
        this.logger.log(Level.INFO, "InstallOptionsUI Exiting Constructor");
    }

    public Component getView() {
        return this.installOptionsPanel;
    }

    public void localize(FlowContext arg0) {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        this.pageDesc.setText(resource.getString("INSTALL_DB_INSTALL_OPTIONS_DLG_PAGE_DESC", "Select one of the following installation options.*", new Object[0]));
        String buttonText = resource.getString("INSTALL_DB_INSTALL_OPTIONS_DLG_CREATE_DB_LABEL", "&Create and Configure a Database*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.createDBType, (String)buttonText);
        buttonText = resource.getString("INSTALL_DB_INSTALL_OPTIONS_DLG_DB_SOFTWARE_LABEL", "&Install Database Software Only*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.createDBSoftwareType, (String)buttonText);
        buttonText = resource.getString("INSTALL_DB_INSTALL_OPTIONS_DLG_UPGRADE_LABEL", "&Upgrade an Existing Database*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.upgradeType, (String)buttonText);
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        switch (eventType) {
            case INIT: {
                this.init(flowContext);
            }
        }
    }

    protected void init(FlowContext flowContext) {
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        switch (bean.getSelectedInstallOption()) {
            case INSTALL_DB_AND_CONFIG: {
                this.createDBType.setSelected(true);
                break;
            }
            case INSTALL_DB_SWONLY: {
                this.createDBSoftwareType.setSelected(true);
                break;
            }
            case UPGRADE_DB: {
                this.upgradeType.setSelected(true);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.createDBType.isSelected()) {
            dbBean.setSelectedInstallOption(DBInstallSettings.InstallOption.INSTALL_DB_AND_CONFIG);
        } else if (this.createDBSoftwareType.isSelected()) {
            dbBean.setSelectedInstallOption(DBInstallSettings.InstallOption.INSTALL_DB_SWONLY);
        } else if (this.upgradeType.isSelected()) {
            dbBean.setSelectedInstallOption(DBInstallSettings.InstallOption.UPGRADE_DB);
        }
        this.logger.log(Level.INFO, "InstallOptions UI Entering & Exiting processInput");
    }
}

