/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.library.util.UIUtil;

public class InstallTypePane
extends JPanel {
    JRadioButton rdoTypicalInstall;
    JRadioButton rdoAdvancedInstall;
    MultilineLabel lblTypicalInstallDesc;
    MultilineLabel lblAdvancedInstallDesc;

    public InstallTypePane() {
        this.buildUI();
    }

    public boolean isAdvancedInstall() {
        return this.rdoAdvancedInstall.isSelected();
    }

    public void setAdvancedInstall(boolean advancedInstall) {
        if (advancedInstall) {
            this.rdoAdvancedInstall.setSelected(true);
        } else {
            this.rdoTypicalInstall.setSelected(true);
        }
    }

    private void buildUI() {
        this.lblTypicalInstallDesc = new MultilineLabel();
        this.lblAdvancedInstallDesc = new MultilineLabel();
        this.rdoTypicalInstall = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblTypicalInstallDesc);
        this.rdoAdvancedInstall = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblAdvancedInstallDesc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdoTypicalInstall);
        group.add(this.rdoAdvancedInstall);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoTypicalInstall, (Component)this.lblTypicalInstallDesc), (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoAdvancedInstall, (Component)this.lblAdvancedInstallDesc), (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.localize();
        this.rdoTypicalInstall.setSelected(true);
        ActiveHelpManager.registerComponent((JComponent)this.rdoTypicalInstall, (String)"InstallTypeUI.rdoTypicalInstall");
        ActiveHelpManager.registerComponent((JComponent)this.rdoAdvancedInstall, (String)"InstallTypeUI.rdoAdvancedInstall");
    }

    public void localize() {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        String buttonText = resource.getString("InstallTypePane.rdoTypicalInstall.text", "Typical Installation*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoTypicalInstall, (String)buttonText);
        this.lblTypicalInstallDesc.setText(resource.getString("InstallTypePane.lblTypicalInstallDesc.text", "Perform full Database installation with basic configuration.*", new Object[0]));
        buttonText = resource.getString("InstallTypePane.rdoAdvancedInstall.text", "Advanced Installation*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoAdvancedInstall, (String)buttonText);
        this.lblAdvancedInstallDesc.setText(resource.getString("InstallTypePane.lblAdvancedInstallDesc.text", "Allows advanced selections such as different passwords for the SYS, SYSMAN, SYSTEM and DBSNMP accounts, database character set, product languages, automated backups, custom installation, and alternative storage options such as Automatic Storage Management.*", new Object[0]));
    }
}

