/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.ManagementOptionsValidator;
import oracle.install.library.util.InventoryInfo;

@ViewDef(id="ManagementOptionsUI")
public class ManagementOptionsUI
implements View {
    private FlowContext flowContext;
    private JPanel rootPanel;
    private JPanel topPanel;
    private JPanel botPanel;
    private GridBagConstraints gbc;
    private MultilineLabel dialogDescLabel;
    private MultilineLabel dialogDescLabel2;
    private JRadioButton radioGridControl;
    private JRadioButton radioDBControl;
    private ButtonGroup installGroup = new ButtonGroup();
    private JLabel labelGridControl = new JLabel();
    private JLabel labelSMTP = new JLabel();
    private JLabel labelEmail = new JLabel();
    private JComboBox comboGridControl;
    private JCheckBox checkboxUseEmail;
    private JTextField textSMTP;
    private JTextField textEmail;
    public static final int COMBOWIDTH = 160;
    public static final Insets DIALOG_INDENT = new Insets(0, 18, 0, 0);
    public static final Insets NO_INSET = new Insets(0, 0, 0, 0);
    public static final GridBagLayout GBL = new GridBagLayout();
    public static String NO_EM_AGENT_FOUND = "";
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public ManagementOptionsUI() {
        this.logger.log(Level.INFO, this.getClass().getName() + " in constructor");
        this.getRootPanel();
    }

    public void initialize(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (dbBean.isUseDBControlCase()) {
            this.radioDBControl.setSelected(true);
        } else {
            this.radioGridControl.setEnabled(true);
            this.radioGridControl.setSelected(true);
        }
        if (dbBean.getEm_CentralAgentSelected() != null && dbBean.getEm_CentralAgentSelected().length() > 0) {
            this.comboGridControl.setSelectedItem(dbBean.getEm_CentralAgentSelected());
        }
        if (dbBean.isReceiveEmailNotification()) {
            this.checkboxUseEmail.setSelected(true);
        } else {
            this.checkboxUseEmail.setSelected(false);
        }
        if (dbBean.getEm_EmailAddress() != null && dbBean.getEm_EmailAddress().length() > 0) {
            this.textEmail.setText(dbBean.getEm_EmailAddress());
        }
        if (dbBean.getEm_SMTPServer() != null && dbBean.getEm_SMTPServer().length() > 0) {
            this.textSMTP.setText(dbBean.getEm_SMTPServer());
        }
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        this.initialize(flowContext);
    }

    public void processInput(FlowContext flowContext) {
        this.logger.log(Level.INFO, "entering processInput");
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.radioGridControl.isEnabled() && this.radioGridControl.isSelected()) {
            dbBean.setEm_CentralAgentSelected(this.comboGridControl.getSelectedItem().toString());
            dbBean.setReceiveEmailNotification(false);
            dbBean.setEm_EmailAddress(null);
            dbBean.setEm_SMTPServer(null);
            dbBean.setUseDBControlCase(false);
        } else {
            dbBean.setUseDBControlCase(true);
            dbBean.setEm_CentralAgentSelected(null);
            if (this.checkboxUseEmail.isSelected()) {
                dbBean.setReceiveEmailNotification(true);
                dbBean.setEm_EmailAddress(this.textEmail.getText());
                dbBean.setEm_SMTPServer(this.textSMTP.getText());
            } else {
                dbBean.setReceiveEmailNotification(false);
                dbBean.setEm_EmailAddress(null);
                dbBean.setEm_SMTPServer(null);
            }
        }
    }

    public Component getView() {
        return this.getRootPanel();
    }

    public void localize(FlowContext flowContext) {
        this.setLocalizedText();
    }

    public void setLocalizedText() {
        if (this.rootPanel != null) {
            this.dialogDescLabel.setText(this.getTextFromResourceBundle("INSTALL_DB_MGMT_OPTIONS_DESCRIPTION"));
            this.dialogDescLabel2.setText(this.getTextFromResourceBundle("INSTALL_DB_MGMT_OPTIONS_LABEL"));
            String text = this.getTextFromResourceBundle("INSTALL_DB_MGMT_LABEL_USE_GRID");
            SwingUtils.setText((AbstractButton)this.radioGridControl, (String)text);
            text = this.getTextFromResourceBundle("INSTALL_DB_MGMT_LABEL_USE_DB");
            SwingUtils.setText((AbstractButton)this.radioDBControl, (String)text);
            text = this.getTextFromResourceBundle("INSTALL_DB_MGMT_LABEL_MGMT_SERVICE");
            SwingUtils.setText((JLabel)this.labelGridControl, (String)text);
            text = this.getTextFromResourceBundle("INSTALL_DB_MGMT_LABEL_EMAIL_SERVER");
            SwingUtils.setText((JLabel)this.labelSMTP, (String)text);
            text = this.getTextFromResourceBundle("INSTALL_DB_MGMT_LABEL_EMAIL_ADDRESS");
            SwingUtils.setText((JLabel)this.labelEmail, (String)text);
            text = this.getTextFromResourceBundle("INSTALL_DB_MGMT_LABEL_EMAIL_ENABLE");
            SwingUtils.setText((AbstractButton)this.checkboxUseEmail, (String)text);
            NO_EM_AGENT_FOUND = this.getTextFromResourceBundle("INSTALL_DB_MGMT_NO_EM_AGENT_EXISTS");
        }
    }

    private JPanel getRootPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            this.rootPanel.setLayout(GBL);
            this.gbc = new GridBagConstraints();
            this.dialogDescLabel = new MultilineLabel();
            this.dialogDescLabel2 = new MultilineLabel();
            this.getTopPanel();
            this.addComponent(this.topPanel, this.rootPanel, this.gbc, 1, 17, 0, 0, 0, 1, 1.0, 1.0, NO_INSET, 0, 0);
            this.getBotPanel();
            this.addComponent(this.botPanel, this.rootPanel, this.gbc, 2, 18, 0, 1, 0, 1, 1.0, 1.0, DIALOG_INDENT, 0, 0);
            this.setLocalizedText();
            this.initView();
            this.enableEmailNotifications(false);
            this.setEMGCOptionSelected(false);
        }
        return this.rootPanel;
    }

    public void getTopPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(GBL);
        this.addComponent((Component)this.dialogDescLabel, this.topPanel, this.gbc, 2, 17, 0, 0, 0, 1, 1.0, 1.0, NO_INSET, 0, 0);
        this.addComponent((Component)this.dialogDescLabel2, this.topPanel, this.gbc, 2, 17, 0, 1, 0, 1, 1.0, 1.0, NO_INSET, 0, 0);
        this.addComponent(this.getRadioGridControl(), this.topPanel, this.gbc, 2, 17, 0, 2, 0, 1, 1.0, 1.0, NO_INSET, 0, 0);
        this.addComponent(this.labelGridControl, this.topPanel, this.gbc, 0, 17, 0, 3, 1, 1, 0.0, 1.0, DIALOG_INDENT, 0, 0);
        this.addComponent(this.getComboGridControl(), this.topPanel, this.gbc, 0, 17, 1, 3, 1, 1, 0.0, 1.0, DIALOG_INDENT, 0, 0);
        this.addComponent(this.getRadioDBControl(), this.topPanel, this.gbc, 2, 16, 0, 4, 0, 2, 1.0, 1.0, NO_INSET, 0, 0);
        this.labelGridControl.setLabelFor(this.getComboGridControl());
    }

    public void getBotPanel() {
        this.botPanel = new JPanel();
        this.botPanel.setLayout(GBL);
        Insets BOT_INDENT = new Insets(5, 18, 0, 0);
        this.addComponent(this.getCheckboxUseEmail(), this.botPanel, this.gbc, 2, 17, 0, 0, 0, 1, 1.0, 1.0, NO_INSET, 0, 0);
        this.addComponent(this.labelSMTP, this.botPanel, this.gbc, 0, 13, 0, 1, 1, 1, 0.0, 1.0, BOT_INDENT, 0, 0);
        this.addComponent(this.getTextSMTP(), this.botPanel, this.gbc, 2, 17, 1, 1, 0, 1, 1.0, 1.0, BOT_INDENT, 0, 0);
        this.addComponent(this.labelEmail, this.botPanel, this.gbc, 0, 13, 0, 2, 1, 1, 0.0, 1.0, BOT_INDENT, 0, 0);
        this.addComponent(this.getTextEmail(), this.botPanel, this.gbc, 2, 17, 1, 2, 0, 1, 1.0, 1.0, BOT_INDENT, 0, 0);
        this.labelSMTP.setLabelFor(this.getTextSMTP());
        this.labelEmail.setLabelFor(this.getTextEmail());
    }

    public JComboBox getComboGridControl() {
        if (this.comboGridControl == null) {
            this.comboGridControl = new JComboBox();
            char[] comboWidth = new char[160];
            Arrays.fill(comboWidth, ' ');
            String comboWide = new String(comboWidth);
            this.comboGridControl.setPrototypeDisplayValue(comboWide);
        }
        return this.comboGridControl;
    }

    private void initView() {
        boolean agentExists = false;
        Map agentHomeMap = InventoryInfo.getInstance().getEMAgentsOnLocalNode();
        if (agentHomeMap != null && !agentHomeMap.isEmpty()) {
            agentExists = true;
            Iterator agents = agentHomeMap.keySet().iterator();
            while (agents.hasNext()) {
                this.comboGridControl.addItem(agents.next());
            }
        }
        if (agentExists) {
            this.radioGridControl.setSelected(true);
        } else {
            this.comboGridControl.addItem(NO_EM_AGENT_FOUND);
            this.radioDBControl.setSelected(true);
            this.radioGridControl.setEnabled(false);
        }
        ActiveHelpManager.registerComponent((JComponent)this.radioDBControl, (String)"ManagementOptionsUI.radioDBControl");
        ActiveHelpManager.registerComponent((JComponent)this.radioGridControl, (String)"ManagementOptionsUI.radioGridControl");
        ActiveHelpManager.registerComponent((JComponent)this.comboGridControl, (String)"ManagementOptionsUI.comboGridControl");
        ActiveHelpManager.registerComponent((JComponent)this.checkboxUseEmail, (String)"ManagementOptionsUI.checkboxUseEmail");
        ActiveHelpManager.registerComponent((JComponent)this.textEmail, (String)"ManagementOptionsUI.textEmail");
        ActiveHelpManager.registerComponent((JComponent)this.textSMTP, (String)"ManagementOptionsUI.textSMTP");
        final ManagementOptionsValidator validator = new ManagementOptionsValidator();
        InlineValidationHelper.registerInlineValidator((Component)this.rootPanel, (Component)this.textSMTP, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                validator.validateEmailServer(data.toString());
                return null;
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this.rootPanel, (Component)this.textEmail, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                validator.validateEmailAdress(data.toString());
                return null;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
    }

    public JRadioButton getRadioGridControl() {
        if (this.radioGridControl == null) {
            this.radioGridControl = new JRadioButton();
            this.installGroup.add(this.radioGridControl);
            this.radioGridControl.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    ManagementOptionsUI.this.setEMGCOptionSelected(ManagementOptionsUI.this.radioGridControl.isSelected());
                }
            });
        }
        return this.radioGridControl;
    }

    public void setEMGCOptionSelected(boolean flag) {
        if (flag) {
            this.checkboxUseEmail.setEnabled(false);
            this.enableEmailNotifications(false);
            this.labelGridControl.setEnabled(true);
            this.comboGridControl.setEnabled(true);
        }
    }

    public void setEMDBOptionSelected(boolean flag) {
        if (flag) {
            this.checkboxUseEmail.setEnabled(true);
            this.labelGridControl.setEnabled(false);
            this.comboGridControl.setEnabled(false);
            if (this.checkboxUseEmail.isSelected()) {
                this.enableEmailNotifications(true);
            } else {
                this.enableEmailNotifications(false);
            }
        }
    }

    public JRadioButton getRadioDBControl() {
        if (this.radioDBControl == null) {
            this.radioDBControl = new JRadioButton();
            this.installGroup.add(this.radioDBControl);
            this.radioDBControl.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    ManagementOptionsUI.this.setEMDBOptionSelected(ManagementOptionsUI.this.radioDBControl.isSelected());
                }
            });
        }
        return this.radioDBControl;
    }

    private JCheckBox getCheckboxUseEmail() {
        if (this.checkboxUseEmail == null) {
            this.checkboxUseEmail = new JCheckBox();
            this.checkboxUseEmail.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent arg0) {
                    ManagementOptionsUI.this.enableEmailNotifications(ManagementOptionsUI.this.checkboxUseEmail.isSelected());
                }
            });
        }
        return this.checkboxUseEmail;
    }

    private JTextField getTextSMTP() {
        if (this.textSMTP == null) {
            this.textSMTP = new JTextField();
        }
        return this.textSMTP;
    }

    private JTextField getTextEmail() {
        if (this.textEmail == null) {
            this.textEmail = new JTextField();
        }
        return this.textEmail;
    }

    public void enableEmailNotifications(boolean flag) {
        this.labelSMTP.setEnabled(flag);
        this.textSMTP.setEnabled(flag);
        this.labelEmail.setEnabled(flag);
        this.textEmail.setEnabled(flag);
    }

    private String getTextFromResourceBundle(String label) {
        return Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)label), new Object[0]);
    }

    private void addComponent(Component src, Container dest, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets, int ipadx, int ipady) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        dest.add(src, gbc);
    }
}

