/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.ivw.common.view.SSHSetupPane;
import oracle.install.ivw.common.view.SSHSetupToggleButton;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.Node;

@ViewDef(id="NodeSelectionUI")
public class NodeSelectionUI
implements View {
    private NodeSelectionUITableModel tmSpreadTable;
    private GridBagLayout gridBag;
    private JPanel gridInstallOptionsPanel;
    private JPanel nodeSelectionCardPanel;
    private JPanel nodeSelectionPanel;
    private JPanel nodeTablePanel;
    private CardLayout nodeSelectionLayout;
    private MultilineLabel pageDesc;
    private MultilineLabel pmtClusterInstallation;
    private JRadioButton rdbClusterInstall;
    private JRadioButton rdbLocalInstall;
    private JScrollPane spNodeTable;
    private JButton btnSelectAll;
    private JButton btnDeSelectAll;
    private SSHSetupToggleButton btnSSHSetup;
    private SSHSetupPane pnlSSHSetupPane;
    private Logger logger;
    private String m_pageDescPromptText;
    private String m_clusterInstallPromptText;
    private String m_clusterInstallLabelTxt;
    private String m_localInstallLabelTxt;
    private String m_nodeNameTxt;
    private String m_selectAllTxt;
    private String m_deSelectAllTxt;
    private final String resourceName = "oracle.install.ivw.db.resource.DBDialogLabelResID";
    private String[] strColHeader = new String[2];
    private JTable tblNodeDetails;
    private ButtonGroup group;

    public NodeSelectionUI() {
        this.logger = Logger.getLogger(NodeSelectionUI.class.getName());
        this.logger.log(Level.INFO, "NodeSelectionUI Entering Constructor");
        this.gridInstallOptionsPanel = new JPanel();
        this.gridBag = new GridBagLayout();
        this.pageDesc = new MultilineLabel();
        this.rdbLocalInstall = new JRadioButton();
        this.rdbClusterInstall = new JRadioButton();
        this.group = new ButtonGroup();
        this.group.add(this.rdbClusterInstall);
        this.group.add(this.rdbLocalInstall);
        this.gridInstallOptionsPanel.setLayout(this.gridBag);
        this.buildNodeSelectionUI();
        TogglePane togglePane = new TogglePane((JToggleButton)this.rdbClusterInstall, (Component)this.nodeSelectionCardPanel);
        togglePane.setContentDisabledOnDeselect(true);
        LayoutUtils.addComponent((Component)this.pageDesc, (Container)this.gridInstallOptionsPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.rdbLocalInstall, (Container)this.gridInstallOptionsPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)togglePane, (Container)this.gridInstallOptionsPanel, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.tblNodeDetails.setSelectionMode(0);
        this.tblNodeDetails.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblNodeDetails.getTableHeader().setReorderingAllowed(false);
        SwingUtils.setRowWiseFocusTraveralEnabled((JTable)this.tblNodeDetails, (boolean)true);
        this.addListenersToComponents();
        this.addActiveHelp();
        this.setTemptext();
    }

    public Component getView() {
        return this.gridInstallOptionsPanel;
    }

    public void localize(FlowContext arg0) {
        Application appObj = Application.getInstance();
        this.m_pageDescPromptText = appObj.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_NODE_SELECTION_DLG_PROMPT"), new Object[0]);
        this.m_clusterInstallPromptText = appObj.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_NODE_SELECTION_DLG_CLUSTER_PROMPT"), new Object[0]);
        this.m_clusterInstallLabelTxt = appObj.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_NODE_SELECTION_DLG_CLUSTER_LABEL"), new Object[0]);
        this.m_localInstallLabelTxt = appObj.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_NODE_SELECTION_DLG_LOCAL_LABEL"), new Object[0]);
        this.m_nodeNameTxt = appObj.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_NODE_SELECTION_DLG_NODENAME_LABEL"), new Object[0]);
        this.m_selectAllTxt = appObj.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_NODE_SELECTION_DLG_SELECT_ALL_PROMPT"), new Object[0]);
        this.m_deSelectAllTxt = appObj.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_NODE_SELECTION_DLG_DESELECT_ALL_PROMPT"), new Object[0]);
        this.pageDesc.setText(this.m_pageDescPromptText);
        this.pmtClusterInstallation.setText(this.m_clusterInstallPromptText);
        SwingUtils.setText((AbstractButton)this.rdbClusterInstall, (String)this.m_clusterInstallLabelTxt);
        SwingUtils.setText((AbstractButton)this.rdbLocalInstall, (String)this.m_localInstallLabelTxt);
        this.btnSelectAll.setText(this.m_selectAllTxt);
        this.btnDeSelectAll.setText(this.m_deSelectAllTxt);
        this.strColHeader[0] = " ";
        this.strColHeader[1] = this.m_nodeNameTxt;
        this.logger.info("strColHeader[0]:" + this.strColHeader[0]);
        this.logger.info("strColHeader[1]:" + this.strColHeader[1]);
        this.setTableColumnNames();
    }

    public void addActiveHelp() {
        ActiveHelpManager.registerComponent((JComponent)this.rdbClusterInstall, (String)"NodeSelectionUI.rdbClusterInstall");
        ActiveHelpManager.registerComponent((JComponent)this.rdbLocalInstall, (String)"NodeSelectionUI.rdbLocalInstall");
    }

    public void onEvent(FlowContext flowContext, EventType event) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (event == EventType.INIT) {
            CRSInfo crsInfo = CRSInfo.getInstance();
            String[] clusterwareNodes = new String[1];
            String localNode = "";
            if (crsInfo.isCRSPresent()) {
                clusterwareNodes = crsInfo.getNodesFromCRSstack();
                localNode = crsInfo.getLocalNodeName();
            }
            this.tmSpreadTable = new NodeSelectionUITableModel(clusterwareNodes, this.strColHeader, localNode);
            if (dbBean.getListOfSelectedNodes() != null) {
                this.tmSpreadTable.setSelectedNodes(dbBean.getListOfSelectedNodes());
            }
            this.tmSpreadTable.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    switch (e.getType()) {
                        case -1: 
                        case 0: 
                        case 1: {
                            boolean empty = NodeSelectionUI.this.tmSpreadTable.getRowCount() == 0;
                            NodeSelectionUI.this.btnSSHSetup.setEnabled(!empty);
                            if (!empty) break;
                            NodeSelectionUI.this.btnSSHSetup.setSelected(false);
                        }
                    }
                }
            });
            this.tblNodeDetails.setModel(this.tmSpreadTable);
            this.tblNodeDetails.getTableHeader().setBorder(BorderFactory.createRaisedBevelBorder());
            TableColumn col = this.tblNodeDetails.getColumnModel().getColumn(0);
            col.setCellRenderer(new NodeSelectionUIRendererModel());
            col.setCellEditor(new DefaultCellEditor(new JCheckBox()));
            col.setMaxWidth(20);
            col.setResizable(false);
            if (crsInfo.isCRSPresent()) {
                this.rdbClusterInstall.setSelected(true);
                this.nodeSelectionLayout.show(this.nodeSelectionCardPanel, "nodes");
            } else {
                this.rdbLocalInstall.setSelected(true);
                this.nodeSelectionLayout.show(this.nodeSelectionCardPanel, "empty");
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        String[] selectedNodeArray = null;
        if (this.rdbClusterInstall.isSelected()) {
            dbBean.setRACinstall(true);
            selectedNodeArray = ((NodeSelectionUITableModel)this.tblNodeDetails.getModel()).getSelectedNodes().toArray(new String[0]);
        } else {
            dbBean.setRACinstall(false);
            selectedNodeArray = new String[]{};
        }
        dbBean.setListOfSelectedNodes(selectedNodeArray);
    }

    private void addListenersToComponents() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == NodeSelectionUI.this.btnSelectAll) {
                    for (int i = 1; i < NodeSelectionUI.this.tblNodeDetails.getRowCount(); ++i) {
                        NodeSelectionUI.this.tblNodeDetails.setValueAt(new Boolean("true"), i, 0);
                    }
                    NodeSelectionUI.this.tblNodeDetails.repaint();
                } else if (event.getSource() == NodeSelectionUI.this.btnDeSelectAll) {
                    for (int i = 1; i < NodeSelectionUI.this.tblNodeDetails.getRowCount(); ++i) {
                        NodeSelectionUI.this.tblNodeDetails.setValueAt(new Boolean("false"), i, 0);
                    }
                    NodeSelectionUI.this.tblNodeDetails.repaint();
                } else if (event.getSource() == NodeSelectionUI.this.rdbLocalInstall) {
                    NodeSelectionUI.this.tblNodeDetails.setEnabled(false);
                    NodeSelectionUI.this.btnSelectAll.setEnabled(false);
                    NodeSelectionUI.this.btnDeSelectAll.setEnabled(false);
                } else if (event.getSource() == NodeSelectionUI.this.rdbClusterInstall) {
                    NodeSelectionUI.this.tblNodeDetails.setEnabled(true);
                    NodeSelectionUI.this.btnSelectAll.setEnabled(true);
                    NodeSelectionUI.this.btnDeSelectAll.setEnabled(true);
                }
            }
        };
        this.btnSelectAll.addActionListener(listener);
        this.btnDeSelectAll.addActionListener(listener);
        this.rdbLocalInstall.addActionListener(listener);
        this.rdbClusterInstall.addActionListener(listener);
    }

    private void setTableColumnNames() {
        TableColumnModel tcm = this.tblNodeDetails.getColumnModel();
        for (int iLoop = 0; iLoop < tcm.getColumnCount(); ++iLoop) {
            tcm.getColumn(iLoop).setHeaderValue(this.strColHeader[iLoop]);
        }
    }

    private void setTemptext() {
        this.m_pageDescPromptText = "Select the type of database installation you want to perform.";
        this.m_clusterInstallPromptText = "Select nodes (in addition to the local node) in the cluster where the installer should install Oracle RAC.";
        this.m_clusterInstallLabelTxt = "Real Application Clusters database installation.";
        this.m_localInstallLabelTxt = "Single instance database installation.";
        this.m_nodeNameTxt = "Node Name";
        this.m_selectAllTxt = "Select All";
        this.m_deSelectAllTxt = "Deselect All";
        this.pageDesc.setText(this.m_pageDescPromptText);
        this.pmtClusterInstallation.setText(this.m_clusterInstallPromptText);
        this.rdbClusterInstall.setText(this.m_clusterInstallLabelTxt);
        this.rdbLocalInstall.setText(this.m_localInstallLabelTxt);
        this.btnSelectAll.setText(this.m_selectAllTxt);
        this.btnDeSelectAll.setText(this.m_deSelectAllTxt);
        this.strColHeader[0] = " ";
        this.strColHeader[1] = this.m_nodeNameTxt;
        this.logger.info("strColHeader[0]:" + this.strColHeader[0]);
        this.logger.info("strColHeader[1]:" + this.strColHeader[1]);
        this.setTableColumnNames();
    }

    private void buildNodeSelectionUI() {
        this.nodeSelectionCardPanel = new JPanel();
        this.nodeSelectionLayout = new CardLayout();
        this.nodeSelectionCardPanel.setLayout(this.nodeSelectionLayout);
        this.nodeSelectionPanel = new JPanel();
        this.nodeSelectionPanel.setLayout(new GridBagLayout());
        this.pmtClusterInstallation = new MultilineLabel();
        this.buildNodeTableUI();
        LayoutUtils.addComponent((Component)this.pmtClusterInstallation, (Container)this.nodeSelectionPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 5));
        LayoutUtils.addComponent((Component)this.nodeTablePanel, (Container)this.nodeSelectionPanel, (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)new Insets(0, 0, 5, 5));
        this.nodeSelectionCardPanel.add((Component)this.nodeSelectionPanel, "nodes");
        this.nodeSelectionCardPanel.add((Component)new JPanel(), "empty");
        this.nodeSelectionLayout.show(this.nodeSelectionCardPanel, "empty");
    }

    private void buildNodeTableUI() {
        this.nodeTablePanel = new JPanel();
        this.nodeTablePanel.setLayout(new GridBagLayout());
        this.tblNodeDetails = new JTable();
        this.spNodeTable = new JScrollPane(this.tblNodeDetails);
        this.spNodeTable.getViewport().setBackground(this.tblNodeDetails.getBackground());
        this.btnSelectAll = new JButton();
        this.btnDeSelectAll = new JButton();
        this.pnlSSHSetupPane = new SSHSetupPane();
        this.btnSSHSetup = new SSHSetupToggleButton((Component)this.pnlSSHSetupPane);
        this.pnlSSHSetupPane.setNodeSetProvider(new SSHSetupPane.NodeSetProvider(){

            public Set<? extends Node> getNodeSet() {
                List<String> selectedNodes = NodeSelectionUI.this.tmSpreadTable.getSelectedNodes();
                TreeSet<Node> nodes = new TreeSet<Node>();
                for (String selectedNode : selectedNodes) {
                    if (selectedNode == null) continue;
                    nodes.add(new Node(selectedNode));
                }
                return nodes;
            }
        });
        LayoutUtils.addComponent((Component)this.spNodeTable, (Container)this.nodeTablePanel, (int)0, (int)0, (int)4, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)new Insets(5, 0, 5, 5));
        LayoutUtils.addComponent((Component)this.btnSSHSetup, (Container)this.nodeTablePanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this.nodeTablePanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnSelectAll, (Container)this.nodeTablePanel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnDeSelectAll, (Container)this.nodeTablePanel, (int)3, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.pnlSSHSetupPane, (Container)this.nodeTablePanel, (int)0, (int)2, (int)4, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 0, 5, 5));
    }

    private class NodeSelectionUIRendererModel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        JCheckBox chkBxNodeSelection = new JCheckBox();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (table == null || value == null) {
                return null;
            }
            this.chkBxNodeSelection.setSelected((Boolean)value);
            this.chkBxNodeSelection.setEnabled(rowIndex != 0);
            if (isSelected) {
                this.chkBxNodeSelection.setForeground(table.getSelectionForeground());
                this.chkBxNodeSelection.setBackground(table.getSelectionBackground());
            } else {
                this.chkBxNodeSelection.setForeground(table.getForeground());
                this.chkBxNodeSelection.setBackground(table.getBackground());
            }
            return this.chkBxNodeSelection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeSelectionUITableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private String[] strData;
        private List<String> selectedNodes;

        NodeSelectionUITableModel(String[] strData, String[] columnNames, String localNodeName) {
            super(columnNames, columnNames.length);
            this.strData = strData;
            this.selectedNodes = new ArrayList<String>();
            this.setSelectedNodes(strData);
        }

        public List<String> getSelectedNodes() {
            return this.selectedNodes;
        }

        public void setSelectedNodes(String[] nodesList) {
            if (nodesList != null) {
                for (String node : nodesList) {
                    if (this.selectedNodes.contains(node)) continue;
                    this.selectedNodes.add(node);
                }
            }
        }

        @Override
        public int getRowCount() {
            if (this.strData != null) {
                return this.strData.length;
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int iRow, int iCol) {
            return iRow != 0 && iCol != 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0) {
                if (Boolean.valueOf(aValue.toString()).booleanValue()) {
                    if (!this.selectedNodes.contains(this.strData[row])) {
                        this.selectedNodes.add(this.strData[row]);
                    }
                } else {
                    this.selectedNodes.remove(this.strData[row]);
                }
                super.fireTableCellUpdated(row, column);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object value = null;
            if (this.strData != null) {
                switch (col) {
                    case 0: {
                        String nodeName = this.strData[row];
                        value = this.selectedNodes.contains(nodeName);
                        break;
                    }
                    case 1: {
                        value = this.strData[row];
                    }
                }
            }
            return value;
        }
    }
}

