/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.OracleProduct;
import oracle.install.ivw.common.bean.PrivilegedOSGroup;
import oracle.install.ivw.common.view.PrivilegedOSGroupsPane;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.library.util.InventoryInfo;

@ViewDef(id="PrivilegedOSGroupsUI")
public class PrivilegedOSGroupsGUI
implements View {
    private static final Logger logger = Logger.getLogger(PrivilegedOSGroupsGUI.class.getName());
    private PrivilegedOSGroupsPane view = new PrivilegedOSGroupsPane();

    public Component getView() {
        return this.view;
    }

    public void localize(FlowContext flowContext) {
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        switch (eventType) {
            case INIT: {
                String[] osGroups = InventoryInfo.getInstance().getOSGroups();
                this.view.setOsGroups(osGroups);
                Resource resource = Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
                ArrayList<PrivilegedOSGroup> privilegedOSGroups = new ArrayList<PrivilegedOSGroup>();
                String defaultGroupName = bean.getDbaGroupNameUsed() != null ? bean.getDbaGroupNameUsed() : "dba";
                PrivilegedOSGroup privilegedOSGroup = new PrivilegedOSGroup(OracleProduct.RDBMS, PrivilegedOSGroup.Privilege.SYSDBA, defaultGroupName);
                privilegedOSGroup.setDescription(resource.getString("PrivilegedOSGroupsUI.OSDBA.title", "Database &Administrator (OSDBA) Group*:", new Object[0]));
                privilegedOSGroups.add(privilegedOSGroup);
                this.view.associateHelpId(privilegedOSGroup, "PrivilegedOSGroupsUI.OSDBA");
                defaultGroupName = bean.getOperGroupNameUsed() != null ? bean.getOperGroupNameUsed() : "oper";
                privilegedOSGroup = new PrivilegedOSGroup(OracleProduct.RDBMS, PrivilegedOSGroup.Privilege.SYSOPER, defaultGroupName);
                privilegedOSGroup.setDescription(resource.getString("PrivilegedOSGroupsUI.OSOPER.title", "Database &Operator (OSOPER) Group*:", new Object[0]));
                privilegedOSGroups.add(privilegedOSGroup);
                this.view.associateHelpId(privilegedOSGroup, "PrivilegedOSGroupsUI.OSOPER");
                this.view.setTitle(resource.getString("PrivilegedOSGroupsUI.title.withoutSYSASM", "SYSDBA and SYSOPER privileges are required to create a database using operating system (OS) authentication. These are granted through membership in the UNIX groups, OSDBA and OSOPER, respectively. Select the name of the UNIX group of which you are a member, to be used for OSDBA and OSOPER.", new Object[0]));
                this.view.setPrivilegedOSGroups(privilegedOSGroups.toArray(new PrivilegedOSGroup[0]));
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        PrivilegedOSGroup[] groups = this.view.getPrivilegedOSGroups();
        if (groups != null) {
            DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
            block4: for (PrivilegedOSGroup group : groups) {
                switch (group.getPrivilege()) {
                    case SYSDBA: {
                        bean.setDbaGroupNameUsed(group.getGroupName());
                        continue block4;
                    }
                    case SYSOPER: {
                        bean.setOperGroupNameUsed(group.getGroupName());
                    }
                }
            }
            logger.log(Level.INFO, "OSDBA = " + bean.getDbaGroupNameUsed());
            logger.log(Level.INFO, "OSOPER = " + bean.getOperGroupNameUsed());
        }
    }
}

