/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.validate.AbstractValidationComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.asm.bean.ASMInputValidationHelper;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.DiskGroup;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.CompositeInlineValidator;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.resource.DBDialogLabelResID;
import oracle.install.ivw.db.validator.DBIdentifierValidator;
import oracle.install.ivw.db.validator.SchemaPasswordValidator;
import oracle.install.ivw.db.validator.StorageOptionsValidator;
import oracle.install.ivw.db.view.ASMDiskGroupSelectionPane;
import oracle.install.ivw.db.view.DBEditionCellRenderer;
import oracle.install.library.asm.ACFSUtil;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PathInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.SystemInfo;
import oracle.install.library.util.UIUtil;

public class QuickInstallPane
extends JPanel {
    private static final Logger logger = Logger.getLogger(QuickInstallPane.class.getName());
    public static final int COMBOWIDTH = 100;
    Resource resource;
    MultilineLabel lblPageDesc;
    JLabel lblOracleBase;
    JLabel lblDestPath;
    JLabel lblStorageLoc;
    JLabel lblDBEdition;
    JLabel lblUnixGroup;
    JLabel lblGDBName;
    JLabel lblAdminPassword;
    JLabel lblConfirmPassword;
    JLabel lblASMSNMPPassword;
    JLabel lblStorageType;
    JLabel lblCharacterType;
    JComboBox cbxOracleBase;
    JComboBox cbxDestPath;
    JComboBox cbxDBEdition;
    JComboBox cbxUnixGroup;
    JComboBox cbxStorageType;
    JComboBox cbxCharacterType;
    JTextField txtStorageLoc;
    JPanel pnlSystemClass;
    JTextField txtGDBName;
    JPasswordField pwdAdminPassword;
    JPasswordField pwdConfirmPassword;
    JPasswordField pwdASMSNMPPassword;
    JButton btnBrowseOracleBase;
    JButton btnBrowseDestPath;
    JButton btnBrowseStorageLoc;
    JFileChooser fileChooser;
    ASMStorageChooser asmChooser;
    public static final String DBA_GROUP = "dba";
    boolean destinationPathEdited = false;
    boolean oracleStorageLocEdited = false;
    boolean oracleBaseLocEdited = false;
    boolean isRAC;
    boolean ASMExists;
    int storageType = 1;
    String oracleBase;
    String oracleHome;
    String tmpStorageLoc;
    String tmpDiskGroupName;
    List<DiskGroup> asmDiskGroups;
    DiskGroup selectedDiskGroup;
    DBInstallSettings.SystemClass systemClass;
    private boolean updatingOB = false;
    private boolean updatingOH = false;
    private String defaultOraHome;
    private String defaultOraBase;
    private boolean bEnableInlineValidation = false;
    ValidationComponent validationComponent;

    public QuickInstallPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource(DBDialogLabelResID.class.getName());
        this.buildUI();
    }

    private void buildUI() {
        this.lblPageDesc = new MultilineLabel();
        this.pnlSystemClass = new JPanel();
        this.pnlSystemClass.setLayout(new BorderLayout());
        this.lblOracleBase = new JLabel();
        this.lblDestPath = new JLabel();
        this.lblStorageLoc = new JLabel();
        this.lblDBEdition = new JLabel();
        this.lblUnixGroup = new JLabel();
        this.lblGDBName = new JLabel();
        this.lblAdminPassword = new JLabel();
        this.lblConfirmPassword = new JLabel();
        this.lblASMSNMPPassword = new JLabel();
        this.lblStorageType = new JLabel();
        this.cbxOracleBase = new JComboBox();
        this.cbxDestPath = new JComboBox();
        this.cbxDBEdition = new JComboBox();
        this.cbxUnixGroup = new JComboBox();
        this.cbxStorageType = new JComboBox();
        this.txtStorageLoc = new JTextField();
        this.txtGDBName = new JTextField(20);
        this.pwdAdminPassword = new JPasswordField(20);
        this.pwdConfirmPassword = new JPasswordField(20);
        this.pwdASMSNMPPassword = new JPasswordField(20);
        this.btnBrowseOracleBase = new JButton();
        this.btnBrowseDestPath = new JButton();
        this.btnBrowseStorageLoc = new JButton();
        this.lblCharacterType = new JLabel();
        this.cbxCharacterType = new JComboBox();
        this.fileChooser = new JFileChooser();
        Frame asmParent = (Frame)SwingUtilities.windowForComponent(this.btnBrowseStorageLoc);
        this.asmChooser = new ASMStorageChooser(asmParent);
        this.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblOracleBase, (Container)mainPanel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.cbxOracleBase, (Container)mainPanel, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnBrowseOracleBase, (Container)mainPanel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblDestPath, (Container)mainPanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.cbxDestPath, (Container)mainPanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnBrowseDestPath, (Container)mainPanel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.pnlSystemClass, (Container)mainPanel, (int)0, (int)2, (int)3, (int)2, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblDBEdition, (Container)mainPanel, (int)0, (int)5, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.cbxDBEdition, (Container)mainPanel, (int)1, (int)5, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblCharacterType, (Container)mainPanel, (int)0, (int)6, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.cbxCharacterType, (Container)mainPanel, (int)1, (int)6, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        if (!PlatformInfo.getInstance().isWindows()) {
            LayoutUtils.addComponent((Component)this.lblUnixGroup, (Container)mainPanel, (int)0, (int)7, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.cbxUnixGroup, (Container)mainPanel, (int)1, (int)7, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }
        LayoutUtils.addComponent((Component)this.lblGDBName, (Container)mainPanel, (int)0, (int)8, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtGDBName, (Container)mainPanel, (int)1, (int)8, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblAdminPassword, (Container)mainPanel, (int)0, (int)9, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.pwdAdminPassword, (Container)mainPanel, (int)1, (int)9, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblConfirmPassword, (Container)mainPanel, (int)0, (int)10, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.pwdConfirmPassword, (Container)mainPanel, (int)1, (int)10, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblPageDesc, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 10, 5));
        LayoutUtils.addComponent((Component)mainPanel, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.localize();
        this.lblOracleBase.setLabelFor(this.cbxOracleBase);
        this.lblDestPath.setLabelFor(this.cbxDestPath);
        this.lblDBEdition.setLabelFor(this.cbxDBEdition);
        this.lblUnixGroup.setLabelFor(this.cbxUnixGroup);
        this.lblGDBName.setLabelFor(this.txtGDBName);
        this.lblAdminPassword.setLabelFor(this.pwdAdminPassword);
        this.lblConfirmPassword.setLabelFor(this.pwdConfirmPassword);
        this.lblASMSNMPPassword.setLabelFor(this.pwdASMSNMPPassword);
        this.lblStorageLoc.setLabelFor(this.txtStorageLoc);
        this.lblStorageType.setLabelFor(this.cbxStorageType);
        this.lblCharacterType.setLabelFor(this.cbxCharacterType);
        this.cbxCharacterType.setEditable(false);
        this.cbxCharacterType.setSelectedIndex(0);
        this.cbxOracleBase.setEditable(true);
        this.cbxUnixGroup.setEditable(false);
        this.cbxStorageType.setEditable(false);
        this.cbxStorageType.setSelectedIndex(0);
        this.cbxDBEdition.setRenderer(new DBEditionCellRenderer());
        this.fileChooser.setFileSelectionMode(1);
        this.cbxDestPath.setEditable(true);
        char[] comboWidth = new char[100];
        Arrays.fill(comboWidth, ' ');
        String comboWide = new String(comboWidth);
        this.cbxDestPath.setPrototypeDisplayValue(comboWide);
        this.initialize();
        this.addListeners();
        this.oracleBase = (String)this.cbxOracleBase.getSelectedItem();
        this.oracleHome = (String)this.cbxDestPath.getSelectedItem();
        ActiveHelpManager.registerComponent((JComponent)this.cbxOracleBase, (String)"QuickInstallUI.txtOracleBase");
        ActiveHelpManager.registerComponent((JComponent)this.cbxDestPath, (String)"QuickInstallUI.txtOracleHome");
        ActiveHelpManager.registerComponent((JComponent)this.txtStorageLoc, (String)"QuickInstallUI.txtStorageLocation");
        ActiveHelpManager.registerComponent((JComponent)this.cbxDBEdition, (String)"QuickInstallUI.cbxInstallationType");
        ActiveHelpManager.registerComponent((JComponent)this.cbxUnixGroup, (String)"QuickInstallUI.cbxUnixGroup");
        ActiveHelpManager.registerComponent((JComponent)this.txtGDBName, (String)"QuickInstallUI.txtGlobalDB");
        ActiveHelpManager.registerComponent((JComponent)this.pwdAdminPassword, (String)"QuickInstallUI.txtPassword");
        ActiveHelpManager.registerComponent((JComponent)this.pwdConfirmPassword, (String)"QuickInstallUI.txtConfirmPassword");
        ActiveHelpManager.registerComponent((JComponent)this.pwdASMSNMPPassword, (String)"QuickInstallUI.txtASMSNMPPassword");
        ActiveHelpManager.registerComponent((JComponent)this.cbxStorageType, (String)"QuickInstallUI.cbxStorageType");
        ActiveHelpManager.registerComponent((JComponent)this.cbxCharacterType, (String)"QuickInstallUI.cbxCharacterType");
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.cbxDestPath, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return BaseInstallLocationValidator.validateOracleHomeLocation((String)data.toString());
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.cbxOracleBase, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return BaseInstallLocationValidator.validateOracleBase((String)data.toString());
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.txtGDBName, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                DBIdentifierValidator.validateGlobalDBName(data.toString());
                return null;
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.txtStorageLoc, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                StatusMessages messages = new StatusMessages();
                String storageLoc = data.toString();
                String storageLocText = BaseInstallLocationValidator.getCommonLabel((String)"INSTALL_COMMON_STORAGE_LOCATION_LABEL");
                if (QuickInstallPane.this.bEnableInlineValidation && QuickInstallPane.this.storageType == 1) {
                    try {
                        BaseInstallLocationValidator.validateLocation((String)storageLoc, (String)storageLocText);
                    }
                    catch (ValidationException e) {
                        messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
                    }
                }
                return messages;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        UIUtil.registerInlineValidator((Component)this, (JPasswordField)this.pwdAdminPassword, (JPasswordField)this.pwdConfirmPassword, (String)"", (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return SchemaPasswordValidator.validatePassword(data.toString(), "ADMIN");
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        this.validationComponent = new StorageTypeValidationComponent(this.cbxStorageType, this.cbxDBEdition);
        this.validationComponent.addValidator(ValidationComponent.MODEL_CHANGE_VALIDATOR, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                StatusMessages messages = new StatusMessages();
                if (QuickInstallPane.this.systemClass == DBInstallSettings.SystemClass.SERVER_CLASS) {
                    if (QuickInstallPane.this.storageType == 1 && QuickInstallPane.this.isRAC) {
                        messages.add((StatusMessage)StorageOptionsValidator.validateFSOption(QuickInstallPane.this.getDbEdition(), QuickInstallPane.this.isRAC, QuickInstallPane.this.storageType));
                    }
                    if (QuickInstallPane.this.storageType == 2) {
                        try {
                            ASMInputValidationHelper.validateASMStorage();
                        }
                        catch (ValidationException e) {
                            messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
                        }
                    }
                }
                return messages;
            }
        });
        InlineValidationHelper.registerInlineValidator((Component)this, (ValidationComponent)this.validationComponent);
    }

    private JPanel createServerTypicalPane() {
        JPanel pnlServerTypical = new JPanel();
        pnlServerTypical.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblStorageType, (Container)pnlServerTypical, (int)0, (int)0, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent((Component)this.cbxStorageType, (Container)pnlServerTypical, (int)1, (int)0, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(0, 19, 5, 0));
        LayoutUtils.addComponent((Component)this.lblStorageLoc, (Container)pnlServerTypical, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(10, 10, 5, 0));
        LayoutUtils.addComponent((Component)this.txtStorageLoc, (Container)pnlServerTypical, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(10, 19, 0, 0));
        LayoutUtils.addComponent((Component)this.btnBrowseStorageLoc, (Container)pnlServerTypical, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(10, 10, 0, 0));
        LayoutUtils.addComponent((Component)this.lblASMSNMPPassword, (Container)pnlServerTypical, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(10, 10, 5, 0));
        LayoutUtils.addComponent((Component)this.pwdASMSNMPPassword, (Container)pnlServerTypical, (int)1, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(10, 19, 0, 0));
        return pnlServerTypical;
    }

    private JPanel createDesktopTypicalPane() {
        JPanel pnlDesktopTypical = new JPanel();
        pnlDesktopTypical.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblStorageLoc, (Container)pnlDesktopTypical, (int)0, (int)0, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 5, 5));
        LayoutUtils.addComponent((Component)this.txtStorageLoc, (Container)pnlDesktopTypical, (int)1, (int)0, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)new Insets(0, 24, 0, 0));
        LayoutUtils.addComponent((Component)this.btnBrowseStorageLoc, (Container)pnlDesktopTypical, (int)2, (int)0, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(0, 10, 0, 0));
        return pnlDesktopTypical;
    }

    public void initialize() {
        String base;
        String key;
        String home;
        try {
            String[] homes;
            String oraBase = new String();
            String oraHome = new String();
            OFAWrapper ofa = OFAWrapper.getInstance();
            String[] oraBases = ofa.getOracleBases();
            if (oraBases != null) {
                for (String location : oraBases) {
                    if (this.containsItem(this.cbxOracleBase, location)) continue;
                    this.cbxOracleBase.addItem(location);
                }
            }
            if ((homes = ofa.getAllOracleHomeLocs()) != null) {
                for (String location : homes) {
                    if (this.containsItem(this.cbxDestPath, location)) continue;
                    this.cbxDestPath.addItem(location);
                }
            }
            oraBase = ofa.getDefaultOracleBaseLocation();
            oraHome = ofa.getOracleHomeFromEnv();
            if (GenericValidation.isEmpty((String)oraHome) || InventoryInfo.getInstance().isHomeWithLocationExist(oraHome)) {
                ACFSUtil acfsUtil = ACFSUtil.getInstance();
                List registeredAcfsMounts = null;
                registeredAcfsMounts = acfsUtil.getRegisteredACFSMountPoints();
                if (registeredAcfsMounts != null && registeredAcfsMounts.size() > 0) {
                    String loc = FileSystemInfo.getInstance().getLocationWithMaxFreespace(registeredAcfsMounts);
                    if (loc != null && loc.trim().length() > 0) {
                        oraHome = ofa.getDBHomeLoc(loc);
                        this.destinationPathEdited = true;
                    }
                } else {
                    oraHome = ofa.getDBHomeLoc(oraBase);
                }
                this.defaultOraBase = ofa.getDefaultOracleBaseLocation();
                this.defaultOraHome = oraHome;
            } else {
                this.destinationPathEdited = true;
            }
            if (!this.containsItem(this.cbxDestPath, oraHome)) {
                this.cbxDestPath.addItem(oraHome);
            }
            this.cbxDestPath.setSelectedItem(oraHome);
            if (!GenericValidation.isEmpty((String)ofa.getBaseForLocation(oraHome))) {
                oraBase = ofa.getBaseForLocation(oraHome);
                SwingUtils.setComponentEnabled((Component)this.cbxOracleBase, (boolean)false);
                this.cbxOracleBase.setEnabled(false);
            }
            if (!this.containsItem(this.cbxOracleBase, oraBase)) {
                this.cbxOracleBase.addItem(oraBase);
            }
            this.cbxOracleBase.setSelectedItem(oraBase);
            this.oracleBase = oraBase;
        }
        catch (InstallException e) {
            ExceptionManager.getInstance().reportException(e.getCause(), Severity.WARNING, e.getErrorCode(), e.getHint(), e.getMessage(), new Object[0]);
        }
        boolean isWindows = PlatformInfo.getInstance().isWindows();
        for (DBInstallSettings.InstallEdition edition : DBInstallSettings.InstallEdition.values()) {
            if (edition == DBInstallSettings.InstallEdition.PE && !isWindows) continue;
            this.cbxDBEdition.addItem(edition);
        }
        if (!PlatformInfo.getInstance().isWindows()) {
            InventoryInfo invInfo = InventoryInfo.getInstance();
            String[] osGroups = invInfo.getOSGroups();
            boolean isDBAgroupPresent = false;
            if (osGroups != null) {
                for (String group : osGroups) {
                    this.cbxUnixGroup.addItem(group);
                    if (!group.trim().equals(DBA_GROUP)) continue;
                    isDBAgroupPresent = true;
                    this.cbxUnixGroup.setSelectedItem(group);
                }
            }
            if (!isDBAgroupPresent) {
                String primaryUserGroup = this.getPrimaryUserGroup();
                this.cbxUnixGroup.setSelectedItem(primaryUserGroup);
                logger.log(Level.INFO, "setting users primary group as default selected group");
            }
        }
        if ((home = InstallHelper.getValue((String)(key = "ORACLE_HOME"))) != null && home.length() > 0) {
            this.destinationPathEdited = true;
        }
        if ((base = InstallHelper.getValue((String)(key = "ORACLE_BASE"))) != null && base.length() > 0) {
            this.oracleBaseLocEdited = true;
        }
        this.lblASMSNMPPassword.setEnabled(false);
        this.pwdASMSNMPPassword.setEnabled(false);
    }

    public void initStorageLocation() {
        this.cbxStorageType.setSelectedIndex(0);
        this.ASMExists = false;
        try {
            ASMUtility utility = ASMUtility.getInstance();
            ASMInstance asmInstance = utility.getASMInstance();
            if (asmInstance != null) {
                this.asmDiskGroups = utility.getDiskGroups(asmInstance);
                if (!this.asmDiskGroups.isEmpty()) {
                    this.cbxStorageType.setSelectedIndex(1);
                    this.lblASMSNMPPassword.setEnabled(true);
                    this.pwdASMSNMPPassword.setEnabled(true);
                    this.selectedDiskGroup = this.asmDiskGroups.get(0);
                    this.tmpDiskGroupName = this.selectedDiskGroup.getName();
                    this.txtStorageLoc.setText(this.tmpDiskGroupName);
                    this.storageType = 2;
                    this.ASMExists = true;
                }
            }
        }
        catch (ASMUtilityException aSMUtilityException) {
            // empty catch block
        }
    }

    public String getPrimaryUserGroup() {
        String primaryUserGroup = null;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        String user = System.getProperty("user.name");
        String currentGroup = invInfo.getCurrentGroupOfUser(user);
        String activeGroup = invInfo.getCurrentActiveUserGroup(user);
        if (currentGroup != null && !currentGroup.equals("ErrorException")) {
            primaryUserGroup = currentGroup;
        } else if (activeGroup != null && !activeGroup.equals("ErrorException")) {
            primaryUserGroup = activeGroup;
        }
        String[] osGroups = invInfo.getOSGroups();
        if (this.contains(osGroups, primaryUserGroup)) {
            return primaryUserGroup;
        }
        return null;
    }

    private boolean contains(String[] list, String item) {
        boolean contains = false;
        for (String str : list) {
            if (!item.equalsIgnoreCase(str)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private boolean containsItem(JComboBox combo, String item) {
        boolean contains = false;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!item.equalsIgnoreCase((String)combo.getItemAt(i))) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public void localize() {
        this.lblPageDesc.setText(this.resource.getString("QuickInstallPane.lblPageDesc.text", "Perform full Database installation with basic configuration. *", new Object[0]));
        String text = this.resource.getString("QuickInstallPane.lblOracleBase.text", "Oracle Ba&se*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblOracleBase, (String)text);
        text = this.resource.getString("QuickInstallPane.lblDestPath.text", "Software &Location*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblDestPath, (String)text);
        text = this.resource.getString("QuickInstallPane.lblStorageLoc.text", "&Database File Location*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblStorageLoc, (String)text);
        text = this.resource.getString("QuickInstallPane.lblStorageType.text", "Storage &Type*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblStorageType, (String)text);
        text = this.resource.getString("QuickInstallPane.lblCharacterType.text", "Character Se&t:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblCharacterType, (String)text);
        this.cbxStorageType.addItem(this.resource.getString("QuickInstallPane.cbxStorageType.item0", "File System*", new Object[0]));
        this.cbxStorageType.addItem(this.resource.getString("QuickInstallPane.cbxStorageType.item1", "Automatic Storage Management*", new Object[0]));
        String defaultCharset = SystemInfo.getInstance().getDefaultCharset();
        this.cbxCharacterType.addItem(this.resource.getString("QuickInstallPane.cbxCharacterType.item0", "Default *", new Object[]{defaultCharset}));
        this.cbxCharacterType.addItem(this.resource.getString("QuickInstallPane.cbxCharacterType.item1", "Unicode *", new Object[]{"AL32UTF8"}));
        text = this.resource.getString("QuickInstallPane.lblDBEdition.text", "Database &Edition*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblDBEdition, (String)text);
        text = this.resource.getString("QuickInstallPane.lblUnixGroup.text", "OSDB&A Group*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblUnixGroup, (String)text);
        text = this.resource.getString("QuickInstallPane.lblGDBName.text", "&Global Database Name*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblGDBName, (String)text);
        text = this.resource.getString("QuickInstallPane.lblAdminPassword.text", "Administrative &Password*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblAdminPassword, (String)text);
        text = this.resource.getString("QuickInstallPane.lblASMSNMPPassword.text", "AS&MSNMP Password*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblASMSNMPPassword, (String)text);
        text = this.resource.getString("QuickInstallPane.lblConfirmPassword.text", "&Confirm Password*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblConfirmPassword, (String)text);
        String browseOBBtnText = this.resource.getString("QuickInstallPane.btnOBBrowse.text", "B&rowse*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowseOracleBase, (String)browseOBBtnText);
        String browseOHBtnText = this.resource.getString("QuickInstallPane.btnOHBrowse.text", "Br&owse*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowseDestPath, (String)browseOHBtnText);
        String browseDFBtnText = this.resource.getString("QuickInstallPane.btnDFBrowse.text", "Bro&wse*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowseStorageLoc, (String)browseDFBtnText);
        if (this.fileChooser != null) {
            this.fileChooser.setDialogTitle(Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID").getString("INSTALL_COMMON_CHOOSE_FILE_LABEL", "Select File*", new Object[0]));
            this.fileChooser.setApproveButtonText(Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID").getString("INSTALL_COMMON_SELECT_LABEL", "Select*", new Object[0]));
        }
    }

    private void addListeners() {
        KeyAdapter destPathKeyAdapter = new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\n') {
                    QuickInstallPane.this.destinationPathEdited = true;
                }
            }
        };
        KeyAdapter BaseLocKeyAdapter = new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\n') {
                    QuickInstallPane.this.oracleBaseLocEdited = true;
                }
            }
        };
        DocumentListener oracleBaseDocListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (!QuickInstallPane.this.updatingOH) {
                    QuickInstallPane.this.updatingOB = true;
                    try {
                        String newBase = e.getDocument().getText(0, e.getDocument().getLength());
                        if (newBase != null && !newBase.equalsIgnoreCase("")) {
                            String newHome = QuickInstallPane.this.getNewOracleHome(newBase);
                            if (newHome != null) {
                                QuickInstallPane.this.cbxDestPath.getEditor().setItem(newHome);
                                QuickInstallPane.this.oracleHome = newHome;
                            }
                            QuickInstallPane.this.tmpStorageLoc = QuickInstallPane.this.getNewStorageLocation(newBase);
                            if (QuickInstallPane.this.tmpStorageLoc != null && QuickInstallPane.this.storageType == 1) {
                                QuickInstallPane.this.txtStorageLoc.setText(QuickInstallPane.this.tmpStorageLoc);
                            }
                            QuickInstallPane.this.oracleBase = newBase;
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                    QuickInstallPane.this.updatingOB = false;
                }
            }

            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        KeyAdapter storageLocationKeyAdapter = new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\n') {
                    QuickInstallPane.this.oracleStorageLocEdited = true;
                }
            }
        };
        this.btnBrowseDestPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = (String)QuickInstallPane.this.cbxDestPath.getSelectedItem();
                File newFile = QuickInstallPane.this.showFileChooserFor(path);
                if (newFile != null) {
                    QuickInstallPane.this.cbxDestPath.setSelectedItem(newFile.getPath());
                }
            }
        });
        this.btnBrowseOracleBase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = (String)QuickInstallPane.this.cbxOracleBase.getSelectedItem();
                File newFile = QuickInstallPane.this.showFileChooserFor(path);
                if (newFile != null) {
                    QuickInstallPane.this.cbxOracleBase.setSelectedItem(newFile.getPath());
                }
            }
        });
        this.btnBrowseStorageLoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (QuickInstallPane.this.storageType == 1) {
                    String path = QuickInstallPane.this.txtStorageLoc.getText();
                    File newFile = QuickInstallPane.this.showFileChooserFor(path);
                    if (newFile != null) {
                        QuickInstallPane.this.tmpStorageLoc = newFile.getPath();
                        QuickInstallPane.this.txtStorageLoc.setText(QuickInstallPane.this.tmpStorageLoc);
                    }
                } else {
                    QuickInstallPane.this.selectedDiskGroup = QuickInstallPane.this.showASMStorageChooser();
                    if (QuickInstallPane.this.selectedDiskGroup != null) {
                        QuickInstallPane.this.tmpDiskGroupName = QuickInstallPane.this.selectedDiskGroup.getName();
                        QuickInstallPane.this.txtStorageLoc.setText(QuickInstallPane.this.tmpDiskGroupName);
                    }
                }
            }
        });
        this.cbxStorageType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int typeIx = QuickInstallPane.this.cbxStorageType.getSelectedIndex();
                if (QuickInstallPane.this.storageType == 2) {
                    QuickInstallPane.this.tmpDiskGroupName = QuickInstallPane.this.txtStorageLoc.getText();
                } else {
                    QuickInstallPane.this.tmpStorageLoc = QuickInstallPane.this.txtStorageLoc.getText();
                }
                if (typeIx == 0) {
                    QuickInstallPane.this.storageType = 1;
                    QuickInstallPane.this.lblASMSNMPPassword.setEnabled(false);
                    QuickInstallPane.this.pwdASMSNMPPassword.setEnabled(false);
                    QuickInstallPane.this.txtStorageLoc.setText(QuickInstallPane.this.tmpStorageLoc);
                } else {
                    QuickInstallPane.this.storageType = 2;
                    QuickInstallPane.this.lblASMSNMPPassword.setEnabled(true);
                    QuickInstallPane.this.pwdASMSNMPPassword.setEnabled(true);
                    QuickInstallPane.this.txtStorageLoc.setText(QuickInstallPane.this.tmpDiskGroupName);
                }
            }
        });
        this.cbxDBEdition.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (QuickInstallPane.this.getDbEdition() == DBInstallSettings.InstallEdition.SE && QuickInstallPane.this.isRAC) {
                    QuickInstallPane.this.cbxStorageType.setSelectedIndex(1);
                }
            }
        });
        this.cbxDestPath.getEditor().getEditorComponent().addKeyListener(destPathKeyAdapter);
        ((JTextComponent)this.cbxDestPath.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                if (!QuickInstallPane.this.updatingOB) {
                    QuickInstallPane.this.updatingOH = true;
                    try {
                        String newOraHome;
                        QuickInstallPane.this.oracleHome = newOraHome = e.getDocument().getText(0, e.getDocument().getLength());
                        String oraBase = OFAWrapper.getInstance().getBaseForLocation(QuickInstallPane.this.oracleHome);
                        QuickInstallPane.this.cbxOracleBase.setEnabled(true);
                        SwingUtils.setComponentEnabled((Component)QuickInstallPane.this.btnBrowseOracleBase, (boolean)true);
                        if (OFAWrapper.getInstance().isHomeWithLocationExist(QuickInstallPane.this.oracleHome) && oraBase != null && oraBase.trim().length() > 0) {
                            if (!QuickInstallPane.this.containsItem(QuickInstallPane.this.cbxOracleBase, oraBase)) {
                                QuickInstallPane.this.cbxOracleBase.addItem(oraBase);
                            }
                            QuickInstallPane.this.cbxOracleBase.setSelectedItem(oraBase);
                            QuickInstallPane.this.oracleBase = oraBase;
                            QuickInstallPane.this.cbxOracleBase.setEnabled(false);
                            SwingUtils.setComponentEnabled((Component)QuickInstallPane.this.btnBrowseOracleBase, (boolean)false);
                        } else if (!QuickInstallPane.this.oracleBaseLocEdited && QuickInstallPane.this.oracleHome.equals(QuickInstallPane.this.defaultOraHome) && QuickInstallPane.this.containsItem(QuickInstallPane.this.cbxOracleBase, QuickInstallPane.this.defaultOraBase)) {
                            QuickInstallPane.this.cbxOracleBase.setSelectedItem(QuickInstallPane.this.defaultOraBase);
                            QuickInstallPane.this.oracleBase = QuickInstallPane.this.defaultOraBase;
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    QuickInstallPane.this.updatingOH = false;
                }
            }

            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }
        });
        JTextField oField = (JTextField)this.cbxOracleBase.getEditor().getEditorComponent();
        oField.getDocument().addDocumentListener(oracleBaseDocListener);
        this.cbxOracleBase.addKeyListener(BaseLocKeyAdapter);
        this.cbxOracleBase.getEditor().getEditorComponent().addKeyListener(BaseLocKeyAdapter);
    }

    private DiskGroup showASMStorageChooser() {
        this.asmChooser.setVisible(true);
        if (!this.asmChooser.isCancelled()) {
            return this.asmChooser.getDiskGroup();
        }
        return null;
    }

    private File showFileChooserFor(String path) {
        Frame parent;
        int returnVal;
        File resultFile = null;
        if (path != null) {
            File file = new File(path);
            if (file.isDirectory()) {
                this.fileChooser.setCurrentDirectory(file);
            } else if (file.isFile()) {
                this.fileChooser.setSelectedFile(file);
            }
        }
        if ((returnVal = this.fileChooser.showOpenDialog(parent = (Frame)SwingUtilities.windowForComponent(this.btnBrowseDestPath))) == 0) {
            resultFile = this.fileChooser.getSelectedFile();
        }
        return resultFile;
    }

    private String getNewOracleHome(String newBase) {
        String newHome = null;
        String location = this.oracleHome;
        if (!this.destinationPathEdited && location != null && location.trim().length() > 0) {
            newHome = this.replacePath(location, this.oracleBase, newBase);
            if (newHome.lastIndexOf(95) != -1) {
                newHome = newHome.substring(0, newHome.lastIndexOf(95));
                newHome = newHome + "_" + this.getNextIndex(newHome);
            }
            PathInfo pathInfo = PathInfo.getInstance();
            newHome = pathInfo.getNativeForm(newHome);
        }
        return newHome;
    }

    private String replacePath(String source, String findPath, String replacePath) {
        int i;
        String result = source;
        if (source != null && (i = source.indexOf(findPath)) >= 0) {
            String partBefore = source.substring(0, i);
            String partAfter = source.substring(i + findPath.length());
            if (!replacePath.endsWith(File.separator)) {
                replacePath = replacePath + File.separator;
            }
            if (partAfter.startsWith(File.separator) && partAfter.length() > 1) {
                partAfter = partAfter.substring(1, partAfter.length());
            }
            result = partBefore + replacePath + partAfter;
        }
        return result;
    }

    private int getNextIndex(String sNewHome) {
        int idx = 1;
        boolean bPathExists = true;
        while (bPathExists) {
            String sPath = sNewHome + "_" + idx;
            bPathExists = new File(sPath).exists();
            if (!bPathExists) continue;
            ++idx;
        }
        return idx;
    }

    private String getNewStorageLocation(String newBase) {
        String newLocation = null;
        String location = this.tmpStorageLoc;
        if (!this.isRAC && !this.oracleStorageLocEdited && location != null && location.trim().length() > 0) {
            newLocation = this.replacePath(location, this.oracleBase, newBase);
            PathInfo pathInfo = PathInfo.getInstance();
            newLocation = pathInfo.getNativeForm(newLocation);
        }
        return newLocation;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public String getAdminPassword() {
        return new String(this.pwdAdminPassword.getPassword());
    }

    public void setAdminPassword(String adminPassword) {
        if (adminPassword != null && adminPassword.trim().length() > 0) {
            this.pwdAdminPassword.setText(adminPassword);
        }
    }

    public String getConfirmPassword() {
        return new String(this.pwdConfirmPassword.getPassword());
    }

    public void setConfirmPassword(String confirmPassword) {
        if (confirmPassword != null && confirmPassword.trim().length() > 0) {
            this.pwdConfirmPassword.setText(confirmPassword);
        }
    }

    public String getASMSNMPPassword() {
        return new String(this.pwdASMSNMPPassword.getPassword());
    }

    public void setASMSNMPPassword(String password) {
        if (password != null && password.trim().length() > 0) {
            this.pwdASMSNMPPassword.setText(password);
        }
    }

    public DBInstallSettings.InstallEdition getDbEdition() {
        return (DBInstallSettings.InstallEdition)((Object)this.cbxDBEdition.getSelectedItem());
    }

    public void setDbEdition(DBInstallSettings.InstallEdition edition) {
        this.cbxDBEdition.setSelectedItem((Object)edition);
    }

    public String getDestPath() {
        return this.oracleHome;
    }

    public void setDestPath(String destPath) {
        if (destPath != null && destPath.trim().length() > 0) {
            if (!this.containsItem(this.cbxDestPath, destPath)) {
                this.cbxDestPath.addItem(destPath);
            }
            this.cbxDestPath.setSelectedItem(destPath);
        }
    }

    public String getGdbName() {
        return this.txtGDBName.getText();
    }

    public void setGdbName(String gdbName) {
        if (gdbName != null && gdbName.trim().length() > 0) {
            this.txtGDBName.setText(gdbName);
        }
    }

    public String getOracleBase() {
        return (String)this.cbxOracleBase.getSelectedItem();
    }

    public void setOracleBase(String oracleBase) {
        if (oracleBase != null && oracleBase.trim().length() > 0) {
            if (!this.containsItem(this.cbxOracleBase, oracleBase)) {
                this.cbxOracleBase.addItem(oracleBase);
            }
            this.cbxOracleBase.setSelectedItem(oracleBase);
        }
    }

    public String getStorageLoc() {
        return this.txtStorageLoc.getText();
    }

    public void setStorageLoc(String storageLoc) {
        if (storageLoc != null && storageLoc.trim().length() > 0) {
            this.tmpStorageLoc = storageLoc;
            if (this.storageType == 1) {
                this.bEnableInlineValidation = false;
                this.txtStorageLoc.setText(this.tmpStorageLoc);
                this.bEnableInlineValidation = true;
            }
        }
    }

    public String getUnixGroup() {
        return (String)this.cbxUnixGroup.getSelectedItem();
    }

    public void setUnixGroup(String unixGroup) {
        if (unixGroup != null && unixGroup.trim().length() > 0) {
            this.cbxUnixGroup.setSelectedItem(unixGroup);
        }
    }

    public void removeSE1ForRAC() {
        this.isRAC = true;
        for (int i = 0; i < this.cbxDBEdition.getItemCount(); ++i) {
            if (!this.cbxDBEdition.getItemAt(i).equals((Object)DBInstallSettings.InstallEdition.SEONE)) continue;
            this.cbxDBEdition.removeItemAt(i);
            break;
        }
    }

    public void addSE1ForSI() {
        this.isRAC = false;
        boolean contains = false;
        for (int i = 0; i < this.cbxDBEdition.getItemCount(); ++i) {
            if (!this.cbxDBEdition.getItemAt(i).equals((Object)DBInstallSettings.InstallEdition.SEONE)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            this.cbxDBEdition.addItem(DBInstallSettings.InstallEdition.SEONE);
        }
        this.validationComponent.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
    }

    public void setCharacterSet(String charset) {
        int characterset = 0;
        if (charset.equals("AL32UTF8")) {
            characterset = 1;
        }
        this.cbxCharacterType.setSelectedIndex(characterset);
    }

    public String getCharacterSet() {
        String charset = null;
        if (this.systemClass == DBInstallSettings.SystemClass.DESKTOP_CLASS && this.cbxCharacterType.isVisible()) {
            int val = this.cbxCharacterType.getSelectedIndex();
            switch (val) {
                case 0: {
                    charset = SystemInfo.getInstance().getDefaultCharset();
                    break;
                }
                case 1: {
                    charset = "AL32UTF8";
                }
            }
        }
        return charset;
    }

    public void setDefaultforStorageType(int val) {
        this.cbxStorageType.setSelectedIndex(--val);
    }

    public void setSystemClass(DBInstallSettings.SystemClass systemClass) {
        if (this.systemClass != systemClass) {
            this.pnlSystemClass.removeAll();
            if (systemClass == DBInstallSettings.SystemClass.DESKTOP_CLASS) {
                this.pnlSystemClass.add(this.createDesktopTypicalPane());
                this.lblCharacterType.setVisible(true);
                this.cbxCharacterType.setVisible(true);
                this.setDefaultforStorageType(1);
            } else {
                try {
                    ASMUtility utility = ASMUtility.getInstance();
                    ASMInstance asm = utility.getASMInstance();
                    if (asm != null) {
                        this.setDefaultforStorageType(2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pnlSystemClass.add(this.createServerTypicalPane());
                this.lblCharacterType.setVisible(false);
                this.cbxCharacterType.setVisible(false);
            }
            this.systemClass = systemClass;
        }
    }

    class StorageTypeValidationComponent
    extends AbstractValidationComponent
    implements ValidationComponent {
        public StorageTypeValidationComponent(JComboBox cbxStorageType, JComboBox cbxInstallType) {
            super((Component)cbxStorageType);
            CompositeListener cl = new CompositeListener();
            cbxStorageType.addItemListener(cl);
            cbxStorageType.addFocusListener(cl);
            cbxInstallType.addItemListener(cl);
            cbxInstallType.addFocusListener(cl);
        }

        public Object getData() {
            return ((JComboBox)super.getComponent()).getSelectedItem();
        }

        class CompositeListener
        implements ItemListener,
        FocusListener {
            CompositeListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                StorageTypeValidationComponent.this.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
            }

            public void focusGained(FocusEvent e) {
                StorageTypeValidationComponent.this.validateComponent(ValidationComponent.FOCUS_CHANGE_VALIDATOR);
            }

            public void focusLost(FocusEvent e) {
                StorageTypeValidationComponent.this.validateComponent(ValidationComponent.FOCUS_CHANGE_VALIDATOR);
            }
        }
    }

    public class ASMStorageChooser
    extends JDialog {
        JPanel pnlButtonPanel;
        JButton btnASMChoose;
        JButton btnASMCancel;
        Application application;
        Resource resource;
        ASMDiskGroupSelectionPane pnlASMChooserPanel;
        private boolean isCancelled;
        static final long serialVersionUID = 0L;

        public ASMStorageChooser() {
            this(null);
        }

        public ASMStorageChooser(Frame parent) {
            this(parent, Application.getInstance().getResource(DBDialogLabelResID.class.getName()).getString("QuickInstallPane.asmChooser.title", "ASM Group Selection", new Object[0]), true);
        }

        public ASMStorageChooser(Frame parent, String title) {
            this(parent, title, true);
        }

        public ASMStorageChooser(Frame parent, String title, boolean modal) {
            super(parent, title, modal);
            this.application = Application.getInstance();
            this.resource = this.application.getResource(DBDialogLabelResID.class.getName());
            this.init();
        }

        private void init() {
            int MAX_HEIGHT = 300;
            int MAX_WIDTH = 500;
            int x = 0;
            int y = 0;
            int parentX = 0;
            int parentY = 0;
            Rectangle parentBounds = null;
            Object parentDim = null;
            boolean parentWidth = false;
            boolean parentHeight = false;
            this.setDefaultCloseOperation(1);
            if (this.getParent() != null) {
                parentBounds = this.getParent().getBounds();
                parentX = (int)Math.round(parentBounds.getX());
                parentY = (int)Math.round(parentBounds.getY());
            }
            x = parentX + 250;
            y = parentY + 150;
            this.setBounds(parentX + x, parentY + y, 500, 300);
            this.pnlButtonPanel = new JPanel();
            this.btnASMChoose = new JButton();
            this.btnASMCancel = new JButton();
            this.pnlASMChooserPanel = new ASMDiskGroupSelectionPane();
            this.pnlASMChooserPanel.setBorder(BorderFactory.createEtchedBorder());
            this.pnlButtonPanel.add(this.btnASMCancel);
            this.pnlButtonPanel.add(this.btnASMChoose);
            this.add((Component)this.pnlButtonPanel, "South");
            this.add((Component)this.pnlASMChooserPanel, "Center");
            this.btnASMChoose.setText(this.resource.getString("QuickInstallPane.ASMStorageChooser.btnASMChoose.text", "Ok*", new Object[0]));
            this.btnASMCancel.setText(this.resource.getString("QuickInstallPane.ASMStorageChooser.btnASMCancel.text", "Cancel*", new Object[0]));
            this.pnlASMChooserPanel.findDiskGroups();
            this.setSize(500, 300);
            this.setResizable(false);
            this.btnASMChoose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ASMStorageChooser.this.setVisible(false);
                    ASMStorageChooser.this.isCancelled = false;
                }
            });
            this.btnASMCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ASMStorageChooser.this.setVisible(false);
                    ASMStorageChooser.this.isCancelled = true;
                }
            });
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ASMStorageChooser.this.isCancelled = true;
                }
            });
        }

        public DiskGroup getDiskGroup() {
            return this.pnlASMChooserPanel.getDiskGroup();
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }
}

