/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.cluster.install.InstallException;
import oracle.install.asm.bean.ASMSettings;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.bean.DBSetupBean;
import oracle.install.ivw.db.view.QuickInstallPane;
import oracle.install.ivw.db.view.StorageOptionsUI;
import oracle.install.library.db.DatabaseInfo;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;

@ViewDef(id="QuickInstallUI")
public class QuickInstallUI
implements View,
Validator {
    public static final String ORADATA = "oradata";
    private Logger logger = Logger.getLogger(QuickInstallUI.class.getName());
    QuickInstallPane view = new QuickInstallPane();

    public Component getView() {
        return this.view;
    }

    public void localize(FlowContext flowContext) {
    }

    /*
     * Unable to fully structure code
     */
    public void onEvent(FlowContext flowContext, EventType eventType) {
        bean = (DBInstallSettings)flowContext.getBean(DBInstallSettings.class);
        switch (2.$SwitchMap$oracle$install$commons$flow$EventType[eventType.ordinal()]) {
            case 1: {
                this.view.initStorageLocation();
                charset = bean.getCharacterSet();
                this.view.setCharacterSet(charset);
                this.view.setSystemClass(DBInstallSettings.SystemClass.SERVER_CLASS);
                storageLocation = bean.getOraDataLocation();
                if (bean.getOracleBase() == null || bean.getOracleBase().trim().length() == 0) {
                    bean.setOracleBase(this.view.getOracleBase());
                }
                if (!bean.isRACinstall()) ** GOTO lbl17
                if (storageLocation == null || storageLocation.trim().length() == 0) {
                    flowWorker = FlowWorker.getInstance((FlowContext)flowContext);
                    flowWorker.perform((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Application.showStatus((String)Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID").getString("QuickInstallUi.statusControl.text", "Fetching Shared Locations...", new Object[0]));
                            String defMountPoint = null;
                            try {
                                defMountPoint = StorageOptionsUI.getDefMountPoint(true, bean.getListOfSelectedNodes(), bean.getOracleBase());
                            }
                            catch (oracle.install.library.util.InstallException e) {
                                QuickInstallUI.this.logger.log(Level.INFO, "Oradata location is not defaulted as the partition could not be checked for rawness" + e.getCause());
                            }
                            Application.hideStatus();
                            if (defMountPoint != null) {
                                bean.setOraDataLocation(new File(defMountPoint, QuickInstallUI.ORADATA).getPath());
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        QuickInstallUI.this.view.setStorageLoc(bean.getOraDataLocation());
                                    }
                                });
                            }
                            return null;
                        }
                    });
                }
                ** GOTO lbl20
lbl17:
                // 1 sources

                if (storageLocation == null || storageLocation.trim().length() == 0) {
                    bean.setOraDataLocation(new File(bean.getOracleBase(), "oradata").getPath());
                    this.view.setStorageLoc(bean.getOraDataLocation());
                }
            }
lbl20:
            // 5 sources

            case 2: {
                if (bean.getSelectedSystemClass() == DBInstallSettings.SystemClass.DESKTOP_CLASS) {
                    this.view.setSystemClass(DBInstallSettings.SystemClass.DESKTOP_CLASS);
                } else {
                    this.view.setSystemClass(DBInstallSettings.SystemClass.SERVER_CLASS);
                }
                if (bean.isRACinstall()) {
                    if (bean.getDbInstallEdition() == DBInstallSettings.InstallEdition.SE) {
                        this.view.setDefaultforStorageType(2);
                    }
                    this.view.removeSE1ForRAC();
                } else {
                    this.view.addSE1ForSI();
                }
                oracleBase = bean.getOracleBase();
                dbHome = bean.getOracleHome();
                storageLocation = bean.getOraDataLocation();
                unixGroupName = bean.getDbaGroupNameUsed();
                dbPassword = bean.getGenericPassword();
                edition = bean.getDbInstallEdition();
                globalDBName = bean.getGlobalDBName();
                if (globalDBName == null || globalDBName.length() == 0) {
                    globalDBName = DatabaseInfo.getInstance().getDefaultGlobalDBName();
                }
                this.view.setOracleBase(oracleBase);
                this.view.setDestPath(dbHome);
                this.view.setStorageLoc(storageLocation);
                this.view.setUnixGroup(unixGroupName);
                this.view.setGdbName(globalDBName);
                this.view.setAdminPassword(dbPassword);
                this.view.setConfirmPassword(dbPassword);
                this.view.setDbEdition(edition);
            }
        }
    }

    public void processInput(FlowContext flowContext) throws UncheckedValidationException {
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        DBSetupBean setupBean = (DBSetupBean)((Object)flowContext.getBean(DBSetupBean.class));
        ASMSettings asmBean = (ASMSettings)flowContext.getBean(ASMSettings.class);
        int storageType = this.view.getStorageType();
        String asmPassword = storageType == 2 ? this.view.getASMSNMPPassword() : null;
        String oracleBase = this.view.getOracleBase();
        String dbHome = this.view.getDestPath();
        String storageLocation = this.view.getStorageLoc();
        String unixGroupName = this.view.getUnixGroup();
        String globalDBName = this.view.getGdbName();
        String dbPassword = this.view.getAdminPassword();
        DBInstallSettings.InstallEdition edition = this.view.getDbEdition();
        bean.setOracleBase(oracleBase);
        setupBean.getCentralInventory().setInventoryLocation(InventoryInfo.computeInventoryLocation((String)oracleBase));
        bean.setOracleHome(dbHome);
        if (storageType == 2) {
            bean.setAsmsnmpPassword(this.view.getASMSNMPPassword());
            bean.setDiskGroupNameForASM(storageLocation);
        } else {
            bean.setOraDataLocation(storageLocation);
        }
        bean.setDatabase_StorageType_Chosen(storageType);
        bean.setDbInstallEdition(edition);
        bean.setDbaGroupNameUsed(unixGroupName);
        bean.setOperGroupNameUsed(unixGroupName);
        bean.setGlobalDBName(globalDBName);
        bean.setUseSamePasswordCase(true);
        bean.setGenericPassword(dbPassword);
        bean.setCharacterSet(this.view.getCharacterSet());
        PlatformInfo platInfo = PlatformInfo.getInstance();
        int curPlatId = platInfo.getCurrentPlatform();
        int curPlatGroup = platInfo.getPlatGroup(curPlatId);
        int autoFillLength = curPlatGroup == -1 ? (bean.isRACinstall() ? 8 : 12) : (bean.isRACinstall() ? 8 : 12);
        String sid = "";
        sid = globalDBName.length() >= 0 && globalDBName.length() <= autoFillLength ? globalDBName : globalDBName.substring(0, autoFillLength);
        if (sid.indexOf(".") != -1) {
            sid = sid.substring(0, sid.indexOf("."));
        }
        bean.setDb_SID(sid);
        try {
            InventoryInfo invInfo = InventoryInfo.getInstance();
            if (invInfo.isCRSConfigured()) {
                bean.setLaunchNETCA(false);
            } else {
                bean.setLaunchNETCA(true);
            }
        }
        catch (InstallException e) {
            ExceptionManager.handle((Throwable)e);
        }
        bean.setLaunchDBCA(true);
        bean.setLaunchODMA(false);
        bean.setNoMigrationCase(true);
        bean.setLoadExampleSchemas(true);
        bean.setSampleSchema("-sampleSchema true");
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        String dbPassword = this.view.getAdminPassword();
        String confirmPassword = this.view.getConfirmPassword();
        if (dbPassword == null || dbPassword.trim().length() == 0) {
            throw new ValidationException((ErrorCode)CommonErrorCode.PASSWORD_IS_EMPTY_ERR, new Object[0]);
        }
        if (!dbPassword.equals(confirmPassword)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[0]);
        }
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$oracle$install$commons$flow$EventType;

        static {
            $SwitchMap$oracle$install$commons$flow$EventType = new int[EventType.values().length];
            try {
                2.$SwitchMap$oracle$install$commons$flow$EventType[EventType.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$oracle$install$commons$flow$EventType[EventType.LOAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

