/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.CompositeInlineValidator;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.RecoveryBackupValidator;
import oracle.install.library.util.UIUtil;

@ViewDef(id="RecoveryBackupUI")
public class RecoveryBackupUI
implements View,
ItemListener,
ActionListener {
    JPanel rootPanel;
    private JPanel topPanel;
    private JPanel midPanel;
    private JPanel botPanel;
    private GridBagConstraints gbc;
    private MultilineLabel dialogDescLabel;
    private JRadioButton radioEnableAutoBackup;
    private JRadioButton radioDisableAutoBackup;
    private ButtonGroup autoBackupGroup;
    private JRadioButton radioFileStorage;
    private JRadioButton radioASMStorage;
    private ButtonGroup storageGroup;
    private JLabel labelRecoveryLocation;
    private JLabel labelRecoveryStorage;
    private JLabel labelBackupCredentials1;
    private JLabel labelUserName;
    private JLabel labelPassword;
    private JTextField textRecoveryStorage;
    private JTextField textUserName;
    private JPasswordField textPassword;
    private JButton buttonRecoveryStorage;
    private boolean defaultToFileStorage = true;
    public static final Resource resource = Application.getInstance().getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
    public static final Resource commonResource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
    public static final Insets DIALOG_INDENT = new Insets(0, 18, 0, 0);
    public static final Insets DIALOG_INDENT1 = new Insets(0, 18, 100, 0);
    public static final Insets NO_INSET = new Insets(0, 0, 0, 0);
    public static final GridBagLayout GBL = new GridBagLayout();

    public RecoveryBackupUI() {
        this.getRootPanel();
    }

    public void initialize(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        dbBean.setDefaultRecoveryBackUpLocation(this.pathify(dbBean.getOracleBase()) + "recovery_area");
        if (dbBean.isEnableAutoBackup()) {
            this.radioEnableAutoBackup.setSelected(true);
            if (dbBean.getRecoveryBackUpUsername() != null) {
                this.textUserName.setText(dbBean.getRecoveryBackUpUsername());
            }
            if (dbBean.getRecoveryBackUpPassword() != null) {
                this.textPassword.setText(dbBean.getRecoveryBackUpPassword());
            }
            if (dbBean.getRecoveryBackUpLocation() != null && dbBean.getRecoveryBackUpLocation().trim().length() > 0) {
                this.textRecoveryStorage.setText(dbBean.getRecoveryBackUpLocation());
            } else {
                this.textRecoveryStorage.setText(dbBean.getDefaultRecoveryBackUpLocation());
            }
        } else {
            this.radioDisableAutoBackup.setSelected(true);
            this.textRecoveryStorage.setText(dbBean.getDefaultRecoveryBackUpLocation());
        }
        this.radioFileStorage.setSelected(dbBean.getDatabase_StorageType_Chosen() == 1);
        this.radioASMStorage.setSelected(dbBean.getDatabase_StorageType_Chosen() == 2);
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (eventType == EventType.INIT) {
            this.initialize(flowContext);
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.radioFileStorage.isEnabled() && this.radioEnableAutoBackup.isSelected()) {
            dbBean.setEnableAutoBackup(true);
            if (this.radioFileStorage.isEnabled() && this.radioFileStorage.isSelected()) {
                dbBean.setUseFileSystemForRecoverySelected(true);
                String recoveryLocation = this.textRecoveryStorage.getText();
                dbBean.setRecoveryBackUpLocation(recoveryLocation);
                dbBean.setRecoveryAreaDestination(" -recoveryAreaDestination " + recoveryLocation + " ");
            } else {
                dbBean.setUseFileSystemForRecoverySelected(false);
                dbBean.setRecoveryBackUpLocation(null);
                dbBean.setRecoveryAreaDestination(null);
            }
            dbBean.setRecoveryBackUpUsername(this.textUserName.getText());
            String passwd = new String(this.textPassword.getPassword());
            dbBean.setRecoveryBackUpPassword(passwd);
        } else {
            dbBean.setRecoveryBackUpUsername(null);
            dbBean.setRecoveryBackUpPassword(null);
            dbBean.setEnableAutoBackup(false);
        }
    }

    public Component getView() {
        return this.getRootPanel();
    }

    public void localize(FlowContext flowContext) {
        this.setLocalizedText();
    }

    private JPanel getRootPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            this.rootPanel.setLayout(GBL);
            this.gbc = new GridBagConstraints();
            this.dialogDescLabel = new MultilineLabel();
            this.getTopPanel();
            this.addComponent(this.topPanel, this.rootPanel, this.gbc, 1, 17, 0, 0, 0, 1, 1.0, 1.0, NO_INSET);
            this.getMidPanel();
            this.addComponent(this.midPanel, this.rootPanel, this.gbc, 1, 17, 0, 1, 0, 1, 1.0, 1.0, DIALOG_INDENT);
            this.getBotPanel();
            this.addComponent(this.botPanel, this.rootPanel, this.gbc, 2, 17, 0, 2, 0, 1, 1.0, 1.0, DIALOG_INDENT1);
            this.setLocalizedText();
            this.initView();
        }
        return this.rootPanel;
    }

    public void initView() {
        ActiveHelpManager.registerComponent((JComponent)this.radioDisableAutoBackup, (String)"RecoveryBackupUI.radioDisableAutoBackup");
        ActiveHelpManager.registerComponent((JComponent)this.radioEnableAutoBackup, (String)"RecoveryBackupUI.radioEnableAutoBackup");
        ActiveHelpManager.registerComponent((JComponent)this.radioFileStorage, (String)"RecoveryBackupUI.radioFileStorage");
        ActiveHelpManager.registerComponent((JComponent)this.radioASMStorage, (String)"RecoveryBackupUI.radioASMStorage");
        ActiveHelpManager.registerComponent((JComponent)this.textRecoveryStorage, (String)"RecoveryBackupUI.textRecoveryStorage");
        ActiveHelpManager.registerComponent((JComponent)this.textUserName, (String)"RecoveryBackupUI.textUserName");
        InlineValidationHelper.registerInlineValidator((Component)this.rootPanel, (Component)this.textRecoveryStorage, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                StatusMessages messages = new StatusMessages();
                String location = data.toString();
                try {
                    BaseInstallLocationValidator.validateLocation((String)location, (String)resource.getString("INSTALL_DB_RECOVERY_OPTIONS_LOCATION_LABEL", "recovery area", new Object[0]));
                }
                catch (ValidationException e) {
                    messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
                }
                return messages;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this.rootPanel, (Component)this.textUserName, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                RecoveryBackupValidator.checkEmptyUsername(data.toString());
                return null;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this.rootPanel, (Component)this.textPassword, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                RecoveryBackupValidator.checkEmptyPassword(data.toString());
                return null;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
    }

    public void setLocalizedText() {
        if (this.rootPanel != null) {
            this.dialogDescLabel.setText(resource.getString("DB_BACKUP_RECOVERY_DLG_PROMPT", null, new Object[0]));
            String text = resource.getString("DB_BACKUP_RECOVERY_ENABLE_BACKUP_LABEL", null, new Object[0]);
            SwingUtils.setText((AbstractButton)this.radioEnableAutoBackup, (String)text);
            text = resource.getString("DB_BACKUP_RECOVERY_DO_NOT_ENABLE_BACKUP_LABEL", null, new Object[0]);
            SwingUtils.setText((AbstractButton)this.radioDisableAutoBackup, (String)text);
            this.labelRecoveryStorage.setText(resource.getString("DB_BACKUP_RECOVERY_AREA_STORAGE_LABEL", null, new Object[0]));
            text = resource.getString("DB_BACKUP_RECOVERY_FILE_SYSTEM_LABEL", null, new Object[0]);
            SwingUtils.setText((AbstractButton)this.radioFileStorage, (String)text);
            text = resource.getString("DB_BACKUP_RECOVERY_ASM_LABEL", null, new Object[0]);
            SwingUtils.setText((AbstractButton)this.radioASMStorage, (String)text);
            text = resource.getString("DB_BACKUP_RECOVERY_FILE_LOCATION_LABEL", null, new Object[0]);
            SwingUtils.setText((JLabel)this.labelRecoveryLocation, (String)text);
            this.labelBackupCredentials1.setText(resource.getString("DB_BACKUP_RECOVERY_BACKUPJOB_LABEL", null, new Object[0]));
            text = resource.getString("DB_BACKUP_RECOVERY_BACKUPJOB_USERNAME_LABEL", null, new Object[0]);
            SwingUtils.setText((JLabel)this.labelUserName, (String)text);
            text = resource.getString("DB_BACKUP_RECOVERY_BACKUPJOB_PASSWORD_LABEL", null, new Object[0]);
            SwingUtils.setText((JLabel)this.labelPassword, (String)text);
            text = resource.getString("DB_QUICK_INSTALL_BASIC_BROWSE_LABEL", null, new Object[0]);
            SwingUtils.setText((AbstractButton)this.buttonRecoveryStorage, (String)text);
        }
    }

    public void getTopPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(GBL);
        this.radioEnableAutoBackup = new JRadioButton();
        this.radioEnableAutoBackup.addItemListener(this);
        this.radioDisableAutoBackup = new JRadioButton();
        this.radioDisableAutoBackup.addItemListener(this);
        this.autoBackupGroup = new ButtonGroup();
        this.autoBackupGroup.add(this.radioEnableAutoBackup);
        this.autoBackupGroup.add(this.radioDisableAutoBackup);
        this.addComponent((Component)this.dialogDescLabel, this.topPanel, this.gbc, 2, 17, 0, 0, 0, 1, 1.0, 1.0, NO_INSET);
        this.addComponent(this.radioDisableAutoBackup, this.topPanel, this.gbc, 2, 17, 0, 1, 0, 1, 1.0, 1.0, NO_INSET);
        this.addComponent(this.radioEnableAutoBackup, this.topPanel, this.gbc, 2, 17, 0, 2, 0, 1, 1.0, 1.0, NO_INSET);
    }

    public void getMidPanel() {
        this.midPanel = new JPanel();
        this.midPanel.setLayout(GBL);
        this.radioFileStorage = new JRadioButton();
        this.radioFileStorage.addItemListener(this);
        this.radioASMStorage = new JRadioButton();
        this.radioASMStorage.addItemListener(this);
        this.storageGroup = new ButtonGroup();
        this.storageGroup.add(this.radioFileStorage);
        this.storageGroup.add(this.radioASMStorage);
        this.labelRecoveryLocation = new JLabel();
        this.labelRecoveryStorage = new JLabel();
        this.addComponent(this.labelRecoveryStorage, this.midPanel, this.gbc, 2, 17, 0, 0, 0, 1, 1.0, 1.0, NO_INSET);
        this.addComponent(this.radioFileStorage, this.midPanel, this.gbc, 2, 17, 0, 1, 0, 1, 1.0, 1.0, NO_INSET);
        this.addComponent(this.labelRecoveryLocation, this.midPanel, this.gbc, 0, 17, 0, 2, 1, 1, 0.05f, 0.0, DIALOG_INDENT);
        this.addComponent(this.getTextRecoveryStorage(), this.midPanel, this.gbc, 2, 17, 1, 2, -1, 1, 0.95f, 1.0, NO_INSET);
        this.addComponent(this.getButtonRecoveryStorage(), this.midPanel, this.gbc, 0, 13, 2, 2, 1, 1, 0.05f, 0.0, NO_INSET);
        this.addComponent(this.radioASMStorage, this.midPanel, this.gbc, 2, 17, 0, 3, 0, 1, 1.0, 1.0, NO_INSET);
        this.labelRecoveryLocation.setLabelFor(this.getTextRecoveryStorage());
    }

    public void getBotPanel() {
        this.botPanel = new JPanel();
        this.botPanel.setLayout(GBL);
        Insets BOT_INDENT = new Insets(5, 0, 0, 0);
        this.labelBackupCredentials1 = new JLabel();
        this.labelUserName = new JLabel();
        this.labelPassword = new JLabel();
        this.addComponent(this.labelBackupCredentials1, this.botPanel, this.gbc, 2, 17, 0, 0, 0, 1, 1.0, 1.0, NO_INSET);
        this.addComponent(this.labelUserName, this.botPanel, this.gbc, 0, 17, 0, 2, 1, 1, 0.1f, 0.05f, BOT_INDENT);
        this.addComponent(this.getTextUserName(), this.botPanel, this.gbc, 2, 17, 1, 2, 1, 1, 0.99f, 0.0, new Insets(5, 0, 0, 10));
        this.addComponent(this.labelPassword, this.botPanel, this.gbc, 0, 17, 2, 2, 1, 1, 0.1f, 0.0, new Insets(5, 10, 0, 0));
        this.addComponent(this.getTextPassword(), this.botPanel, this.gbc, 2, 17, 3, 2, 1, 1, 0.99f, 0.0, BOT_INDENT);
        this.labelUserName.setLabelFor(this.getTextUserName());
        this.labelPassword.setLabelFor(this.getTextPassword());
    }

    public JTextField getTextRecoveryStorage() {
        if (this.textRecoveryStorage == null) {
            this.textRecoveryStorage = new JTextField();
        }
        return this.textRecoveryStorage;
    }

    public JButton getButtonRecoveryStorage() {
        if (this.buttonRecoveryStorage == null) {
            this.buttonRecoveryStorage = new JButton();
            this.buttonRecoveryStorage.addActionListener(this);
        }
        return this.buttonRecoveryStorage;
    }

    public JTextField getTextUserName() {
        if (this.textUserName == null) {
            this.textUserName = new JTextField();
            this.textUserName.setText(System.getProperty("user.name"));
        }
        return this.textUserName;
    }

    public JTextField getTextPassword() {
        if (this.textPassword == null) {
            this.textPassword = new JPasswordField();
        }
        return this.textPassword;
    }

    public void selectAll(boolean bool) {
        this.radioFileStorage.setEnabled(bool);
        this.radioASMStorage.setEnabled(bool);
        this.textRecoveryStorage.setEnabled(bool);
        this.textUserName.setEnabled(bool);
        this.textPassword.setEnabled(bool);
        this.buttonRecoveryStorage.setEnabled(bool);
        this.labelBackupCredentials1.setEnabled(bool);
        this.labelPassword.setEnabled(bool);
        this.labelRecoveryLocation.setEnabled(bool);
        this.labelRecoveryStorage.setEnabled(bool);
        this.labelUserName.setEnabled(bool);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.radioDisableAutoBackup) {
            if (this.radioDisableAutoBackup.isSelected()) {
                // empty if block
            }
            this.selectAll(false);
        }
        if (e.getSource() == this.radioEnableAutoBackup && this.radioEnableAutoBackup.isSelected()) {
            this.selectAll(true);
        }
        if (e.getSource() == this.radioFileStorage && this.radioFileStorage.isSelected() && this.radioEnableAutoBackup.isSelected()) {
            this.labelRecoveryLocation.setEnabled(true);
            this.textRecoveryStorage.setEnabled(true);
            this.buttonRecoveryStorage.setEnabled(true);
        }
        if (e.getSource() == this.radioASMStorage && this.radioASMStorage.isSelected()) {
            this.labelRecoveryLocation.setEnabled(false);
            this.textRecoveryStorage.setEnabled(false);
            this.buttonRecoveryStorage.setEnabled(false);
        }
    }

    private String pathify(String input) {
        String sep = File.separator;
        if (input.endsWith(sep)) {
            return input;
        }
        return input + sep;
    }

    private void browseButtonClicked() {
        UIUtil.setCursor((int)3, (Component)this.rootPanel);
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(commonResource.getString("INSTALL_COMMON_CHOOSE_DIRECTORY_LABEL", null, new Object[0]));
        chooser.setApproveButtonText(commonResource.getString("INSTALL_COMMON_SELECT_LABEL", null, new Object[0]));
        String defaultDir = this.textRecoveryStorage.getText();
        if (defaultDir.length() == 0) {
            defaultDir = File.separator;
        }
        File curDir = new File(defaultDir);
        chooser.setCurrentDirectory(curDir);
        int returnVal = chooser.showOpenDialog(this.rootPanel);
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.textRecoveryStorage.setText(path);
        }
        UIUtil.setCursor((int)0, (Component)this.rootPanel);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonRecoveryStorage) {
            this.browseButtonClicked();
        }
    }

    private void addComponent(Component src, Container dest, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets, int ipadx, int ipady) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        dest.add(src, gbc);
    }

    private void addComponent(Component src, Container dest, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        this.addComponent(src, dest, gbc, fill, anchor, x, y, w, h, weightx, weighty, insets, 0, 0);
    }

    public void log(String s) {
        System.out.println("-->" + s);
    }
}

