/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.swing.validate.CompositeInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.SchemaPasswordValidator;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.UIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ViewDef(id="SchemaPasswordUI")
public class SchemaPasswordUI
extends JPanel
implements View,
CompositeValidator {
    private static final long serialVersionUID = 1L;
    private StatusMessages<ValidationStatusMessage> messages = new StatusMessages();
    private MultilineLabel lblPageDesc;
    private TogglePane multiPassTogglePane;
    private TogglePane singlePassTogglePane;
    private JRadioButton rdoMultiPassword;
    private JRadioButton rdoSinglePassword;
    private JLabel lblPassword;
    private JPasswordField pFieldSinglePassword;
    private JLabel lblConfirmPwd;
    private JPasswordField pFieldSingleConfirm;
    private JLabel lblPasswordColumn;
    private JLabel lblConfirmColumn;
    private JLabel lblSys;
    private JLabel lblSystem;
    private JLabel lblSysman;
    private JLabel lblDBsnmp;
    private JPasswordField pFieldSys;
    private JPasswordField pFieldSystem;
    private JPasswordField pFieldSysman;
    private JPasswordField pFieldDBsnmp;
    private JPasswordField pFieldSysConfirm;
    private JPasswordField pFieldSystemConfirm;
    private JPasswordField pFieldSysMANConfirm;
    private JPasswordField pFieldDBsnmpConfirm;

    public SchemaPasswordUI() {
        this.initialize();
    }

    private void initialize() {
        this.lblPageDesc = new MultilineLabel();
        this.rdoMultiPassword = new JRadioButton();
        this.rdoSinglePassword = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdoMultiPassword);
        group.add(this.rdoSinglePassword);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblPageDesc, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.getPnlDiffPasswords(), (Container)this, (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        LayoutUtils.addComponent((Component)this.getPnlSamePasswords(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)3, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.rdoMultiPassword.setSelected(true);
        this.enableSamePasswordFields(false);
        ActiveHelpManager.registerComponent((JComponent)this.rdoMultiPassword, (String)"SchemaPasswordUI.rdoDifferentPasswords");
        ActiveHelpManager.registerComponent((JComponent)this.rdoSinglePassword, (String)"SchemaPasswordUI.rdoSamePasswords");
        ActiveHelpManager.registerComponent((JComponent)this.pFieldSinglePassword, (String)"SchemaPasswordUI.txtPassword");
        ActiveHelpManager.registerComponent((JComponent)this.pFieldSingleConfirm, (String)"SchemaPasswordUI.txtConfirmPasswd");
        ActiveHelpManager.registerComponent((JComponent)this.pFieldSys, (String)"SchemaPasswordUI.txtSysPassword");
        ActiveHelpManager.registerComponent((JComponent)this.pFieldSystem, (String)"SchemaPasswordUI.txtSystemPassword");
        ActiveHelpManager.registerComponent((JComponent)this.pFieldSysman, (String)"SchemaPasswordUI.txtSysmanPassword");
        ActiveHelpManager.registerComponent((JComponent)this.pFieldDBsnmp, (String)"SchemaPasswordUI.txtDBSNMPPassword");
        UIUtil.registerInlineValidator((Component)this, (JPasswordField)this.pFieldSinglePassword, (JPasswordField)this.pFieldSingleConfirm, (String)"", (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return SchemaPasswordValidator.validatePassword(data.toString(), "ADMIN");
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        UIUtil.registerInlineValidator((Component)this, (JPasswordField)this.pFieldSys, (JPasswordField)this.pFieldSysConfirm, (String)"SYS", (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return SchemaPasswordValidator.validatePassword(data.toString(), "SYS");
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        UIUtil.registerInlineValidator((Component)this, (JPasswordField)this.pFieldSystem, (JPasswordField)this.pFieldSystemConfirm, (String)"SYSTEM", (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return SchemaPasswordValidator.validatePassword(data.toString(), "SYSTEM");
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        UIUtil.registerInlineValidator((Component)this, (JPasswordField)this.pFieldSysman, (JPasswordField)this.pFieldSysMANConfirm, (String)"SYSMAN", (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return SchemaPasswordValidator.validatePassword(data.toString(), "SYSMAN");
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        UIUtil.registerInlineValidator((Component)this, (JPasswordField)this.pFieldDBsnmp, (JPasswordField)this.pFieldDBsnmpConfirm, (String)"DBSNMP", (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return SchemaPasswordValidator.validatePassword(data.toString(), "DBSNMP");
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
    }

    public Component getView() {
        return this;
    }

    public void localize(FlowContext flowContext) {
        String text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_SAME_PASSWORD_LABEL", "Use sa&me passwords for these accounts*");
        SwingUtils.setText((AbstractButton)this.rdoSinglePassword, (String)text);
        text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_DIFF_PASSWORD_LABEL", "&Use different passwords for these accounts*");
        SwingUtils.setText((AbstractButton)this.rdoMultiPassword, (String)text);
        text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_ENTER_PASSWORD_LABEL", "&Password*:");
        SwingUtils.setText((JLabel)this.lblPassword, (String)text);
        text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_CONFIRM_PASSWORD_LABEL", "Confirm Password*");
        SwingUtils.setText((JLabel)this.lblConfirmPwd, (String)text);
        text = "The Starter Database contains pre-loaded schemas, most of which have passwords that will expire and be locked at the end of install. After the install is complete, you must unlock and set new passwords for those accounts you wish to use. Schemas used for the database management and post-install functions are left unlocked, and passwords for these accounts will not expire. Specify the passwords for these accounts.";
        this.lblPageDesc.setText(this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_PROMPT", text));
        this.lblPasswordColumn.setText(this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_PASSWORD_COLUMN", "Password*"));
        this.lblConfirmColumn.setText(this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_CONFIRM_COLUMN", "Confirm Password*"));
        text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_SYS_PASSWORD", "SYS*");
        SwingUtils.setText((JLabel)this.lblSys, (String)text);
        text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_SYSTEM_PASSWORD", "SYSTEM*");
        SwingUtils.setText((JLabel)this.lblSystem, (String)text);
        text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_SYSMAN_PASSWORD", "SYSM&AN*");
        SwingUtils.setText((JLabel)this.lblSysman, (String)text);
        text = this.getDBLabel("INSTALL_DB_SCHEMA_PASSWORD_DLG_DBSNMP_PASSWORD", "DBSNMP*");
        SwingUtils.setText((JLabel)this.lblDBsnmp, (String)text);
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (eventType == EventType.INIT) {
            if (!GenericValidation.isEmpty((String)dbBean.getGenericPassword())) {
                this.rdoSinglePassword.setSelected(true);
                this.pFieldSinglePassword.setText(dbBean.getGenericPassword());
                this.pFieldSingleConfirm.setText(dbBean.getGenericPassword());
            } else if (dbBean.getListOfSuperAdminPasswords() != null && dbBean.getListOfSuperAdminPasswords().length == 4) {
                this.rdoMultiPassword.setSelected(true);
                String[] listOfSuperAdminPasswds = dbBean.getListOfSuperAdminPasswords();
                this.pFieldSys.setText(listOfSuperAdminPasswds[0]);
                this.pFieldSysConfirm.setText(listOfSuperAdminPasswds[0]);
                this.pFieldSystem.setText(listOfSuperAdminPasswds[1]);
                this.pFieldSystemConfirm.setText(listOfSuperAdminPasswds[1]);
                this.pFieldSysman.setText(listOfSuperAdminPasswds[2]);
                this.pFieldSysMANConfirm.setText(listOfSuperAdminPasswds[2]);
                this.pFieldDBsnmp.setText(listOfSuperAdminPasswds[3]);
                this.pFieldDBsnmpConfirm.setText(listOfSuperAdminPasswds[3]);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.rdoSinglePassword.isSelected()) {
            dbBean.setUseSamePasswordCase(true);
            String allSchemaPassword = new String(this.pFieldSinglePassword.getPassword()).trim();
            dbBean.setGenericPassword(allSchemaPassword);
        } else if (this.rdoMultiPassword.isSelected()) {
            dbBean.setUseSamePasswordCase(false);
            String[] superAdminPasswds = new String[4];
            String sysPassword = new String(this.pFieldSys.getPassword()).trim();
            String systemPassword = new String(this.pFieldSystem.getPassword()).trim();
            String sysmanPassword = new String(this.pFieldSysman.getPassword()).trim();
            String dbsnmpPassword = new String(this.pFieldDBsnmp.getPassword()).trim();
            superAdminPasswds[0] = sysPassword;
            superAdminPasswds[1] = systemPassword;
            superAdminPasswds[2] = sysmanPassword;
            superAdminPasswds[3] = dbsnmpPassword;
            dbBean.setListOfSuperAdminPasswords(superAdminPasswds);
        }
    }

    private JPanel getPnlDiffPasswords() {
        if (this.multiPassTogglePane == null) {
            JPanel multiPassPanel = new JPanel();
            this.lblPasswordColumn = new JLabel("Password");
            this.lblConfirmColumn = new JLabel("Confirm Password");
            this.lblSys = new JLabel("SYS");
            this.lblSystem = new JLabel("SYSTEM");
            this.lblSysman = new JLabel("SYSMAN");
            this.lblDBsnmp = new JLabel("DBSNMP");
            this.pFieldSys = new JPasswordField(20);
            this.pFieldSystem = new JPasswordField(20);
            this.pFieldSysman = new JPasswordField(20);
            this.pFieldDBsnmp = new JPasswordField(20);
            this.pFieldSysConfirm = new JPasswordField(20);
            this.pFieldSystemConfirm = new JPasswordField(20);
            this.pFieldSysMANConfirm = new JPasswordField(20);
            this.pFieldDBsnmpConfirm = new JPasswordField(20);
            multiPassPanel.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.lblPasswordColumn, (Container)multiPassPanel, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.lblConfirmColumn, (Container)multiPassPanel, (int)2, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.lblSys, (Container)multiPassPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 10));
            LayoutUtils.addComponent((Component)this.pFieldSys, (Container)multiPassPanel, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            LayoutUtils.addComponent((Component)this.pFieldSysConfirm, (Container)multiPassPanel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            LayoutUtils.addComponent((Component)this.lblSystem, (Container)multiPassPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 10));
            LayoutUtils.addComponent((Component)this.pFieldSystem, (Container)multiPassPanel, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            LayoutUtils.addComponent((Component)this.pFieldSystemConfirm, (Container)multiPassPanel, (int)2, (int)2, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            LayoutUtils.addComponent((Component)this.lblSysman, (Container)multiPassPanel, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 10));
            LayoutUtils.addComponent((Component)this.pFieldSysman, (Container)multiPassPanel, (int)1, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            LayoutUtils.addComponent((Component)this.pFieldSysMANConfirm, (Container)multiPassPanel, (int)2, (int)3, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            LayoutUtils.addComponent((Component)this.lblDBsnmp, (Container)multiPassPanel, (int)0, (int)4, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 10));
            LayoutUtils.addComponent((Component)this.pFieldDBsnmp, (Container)multiPassPanel, (int)1, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            LayoutUtils.addComponent((Component)this.pFieldDBsnmpConfirm, (Container)multiPassPanel, (int)2, (int)4, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 0, 2, 2));
            this.lblSys.setLabelFor(this.pFieldSys);
            this.lblSystem.setLabelFor(this.pFieldSystem);
            this.lblSysman.setLabelFor(this.pFieldSysman);
            this.lblDBsnmp.setLabelFor(this.pFieldDBsnmp);
            this.multiPassTogglePane = new TogglePane((JToggleButton)this.rdoMultiPassword, (Component)multiPassPanel);
            this.multiPassTogglePane.setContentDisabledOnDeselect(true);
        }
        return this.multiPassTogglePane;
    }

    private JPanel getPnlSamePasswords() {
        if (this.singlePassTogglePane == null) {
            JPanel singlePassPanel = new JPanel();
            this.lblPassword = new JLabel("Enter Password");
            this.lblConfirmPwd = new JLabel("Confirm Password");
            this.pFieldSinglePassword = new JPasswordField(20);
            this.pFieldSingleConfirm = new JPasswordField(20);
            singlePassPanel.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.lblPassword, (Container)singlePassPanel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.pFieldSinglePassword, (Container)singlePassPanel, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.5, (double)0.0);
            LayoutUtils.addComponent((Component)this.lblConfirmPwd, (Container)singlePassPanel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.pFieldSingleConfirm, (Container)singlePassPanel, (int)3, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.5, (double)0.0);
            this.lblPassword.setLabelFor(this.pFieldSinglePassword);
            this.lblConfirmPwd.setLabelFor(this.pFieldSingleConfirm);
            this.singlePassTogglePane = new TogglePane((JToggleButton)this.rdoSinglePassword, (Component)singlePassPanel);
            this.singlePassTogglePane.setContentDisabledOnDeselect(true);
        }
        return this.singlePassTogglePane;
    }

    private void enableSamePasswordFields(boolean enabled) {
        if (this.lblPassword != null) {
            this.lblPassword.setEnabled(enabled);
        }
        if (this.lblConfirmPwd != null) {
            this.lblConfirmPwd.setEnabled(enabled);
        }
        if (this.pFieldSingleConfirm != null) {
            this.pFieldSingleConfirm.setEnabled(enabled);
        }
        if (this.pFieldSinglePassword != null) {
            this.pFieldSinglePassword.setEnabled(enabled);
        }
    }

    private String getDBLabel(String key, String defaultValue) {
        return Application.getInstance().getString(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)key), defaultValue, new Object[0]);
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.messages;
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        this.messages.clear();
        if (this.rdoSinglePassword.isSelected()) {
            String allSchemaPassword = new String(this.pFieldSinglePassword.getPassword()).trim();
            String allSchemaPasswordAgain = new String(this.pFieldSingleConfirm.getPassword()).trim();
            if (allSchemaPassword == null || allSchemaPassword.trim().length() == 0) {
                throw new ValidationException((ErrorCode)CommonErrorCode.PASSWORD_IS_EMPTY_ERR, new Object[]{"ADMIN"});
            }
            if (!allSchemaPassword.equals(allSchemaPasswordAgain)) {
                throw new ValidationException((ErrorCode)CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[]{"ADMIN"});
            }
        } else if (this.rdoMultiPassword.isSelected()) {
            String sysPassword = new String(this.pFieldSys.getPassword()).trim();
            String systemPassword = new String(this.pFieldSystem.getPassword()).trim();
            String sysmanPassword = new String(this.pFieldSysman.getPassword()).trim();
            String dbsnmpPassword = new String(this.pFieldDBsnmp.getPassword()).trim();
            String confirmSysPassword = new String(this.pFieldSysConfirm.getPassword()).trim();
            String confirmSystemPassword = new String(this.pFieldSystemConfirm.getPassword()).trim();
            String confirmSysmanPassword = new String(this.pFieldSysMANConfirm.getPassword()).trim();
            String confirmDBsnmpPassword = new String(this.pFieldDBsnmpConfirm.getPassword()).trim();
            if (sysPassword != null && !sysPassword.equals(confirmSysPassword)) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[]{"SYS"}));
            }
            if (systemPassword != null && !systemPassword.equals(confirmSystemPassword)) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[]{"SYSTEM"}));
            }
            if (sysmanPassword != null && !sysmanPassword.equals(confirmSysmanPassword)) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[]{"SYSMAN"}));
            }
            if (dbsnmpPassword != null && !dbsnmpPassword.equals(confirmDBsnmpPassword)) {
                this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[]{"DBSNMP"}));
            }
        }
    }
}

