/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.library.partition.PartitionInfoUnix;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.UIUtil;

@ViewDef(id="StorageOptionsUI")
public class StorageOptionsUI
extends JPanel
implements View {
    private static final long serialVersionUID = 1L;
    private MultilineLabel lblStorageOptionPrompt = null;
    private JRadioButton rdoFileSystem = null;
    private JRadioButton rdoASM = null;
    private MultilineLabel lblFileSystem = null;
    private MultilineLabel lblASM = null;
    private int storageType = 1;
    private JPanel pnlFileLocation = null;
    private JLabel lblFileLocation = null;
    private JTextField txtFileLocation = null;
    private JButton btnBrowse = null;
    private Logger logger = Logger.getLogger(StorageOptionsUI.class.getName());
    private JPanel pnlASM = null;
    private JLabel lblASMMonitor = null;
    private JPasswordField passwdASMSMonitor = null;

    public StorageOptionsUI() {
        this.buildUI();
    }

    private void buildUI() {
        this.lblStorageOptionPrompt = new MultilineLabel();
        this.lblFileSystem = new MultilineLabel();
        this.lblASM = new MultilineLabel();
        ButtonGroup group = new ButtonGroup();
        group.add(this.getFileSystemRadioButton());
        group.add(this.getASMRadioButton());
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.getFileSystemRadioButton(), (Container)this, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblFileSystem, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.getPnlFileLocation(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.getASMRadioButton(), (Container)this, (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblASM, (Container)this, (int)0, (int)4, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.getPnlASMMonitor(), (Container)this, (int)0, (int)5, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)6, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        ActiveHelpManager.registerComponent((JComponent)this.rdoFileSystem, (String)"StorageOptionsUI.rdoFileSystem");
        ActiveHelpManager.registerComponent((JComponent)this.rdoASM, (String)"StorageOptionsUI.rdoASM");
        ActiveHelpManager.registerComponent((JComponent)this.txtFileLocation, (String)"StorageOptionsUI.txtFileLocation");
        ActiveHelpManager.registerComponent((JComponent)this.passwdASMSMonitor, (String)"StorageOptionsUI.asmsnmpPassword");
    }

    private void initialize(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        String defOradataLocation = dbBean.getOraDataLocation();
        if (defOradataLocation == null || defOradataLocation.length() == 0) {
            String defMountPoint = null;
            try {
                defMountPoint = StorageOptionsUI.getDefMountPoint(dbBean.isRACinstall(), dbBean.getListOfSelectedNodes(), dbBean.getOracleBase());
                defOradataLocation = OFAWrapper.getInstance().getDefaultOraDataLocation(defMountPoint);
            }
            catch (InstallException e) {
                this.logger.log(Level.INFO, "Oradata location is not defaulted as the partition could not be checked for rawness" + e.getCause());
            }
        }
        this.getTxtFileLocation().setText(defOradataLocation);
        ASMInstance asm = null;
        try {
            ASMUtility utility = ASMUtility.getInstance();
            asm = utility.getASMInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dbBean.getDatabase_StorageType_Chosen() == 2 || dbBean.getDatabase_StorageType_Chosen() == 0 && asm != null) {
            this.rdoASM.setSelected(true);
            this.enableFileLocationFields(false);
            String asmsnmpPassword = dbBean.getAsmsnmpPassword();
            if (!GenericValidation.isEmpty((String)asmsnmpPassword)) {
                this.passwdASMSMonitor.setText(asmsnmpPassword);
            }
        } else {
            this.rdoFileSystem.setSelected(true);
            this.passwdASMSMonitor.setEnabled(false);
            this.lblASMMonitor.setEnabled(false);
        }
    }

    public static String getDefMountPoint(boolean isRAC, String[] nodes, String oracleBase) throws InstallException {
        String defMountPoint;
        block8: {
            defMountPoint = new String();
            if (isRAC && nodes != null && nodes.length > 1) {
                try {
                    List sharedPartList = PartitionInfoUnix.getSharedFSList(Arrays.asList(nodes));
                    if (sharedPartList != null && sharedPartList.size() > 0) {
                        try {
                            if (sharedPartList.contains(OFAWrapper.getInstance().getDefaultOraDataLocation(oracleBase))) {
                                defMountPoint = oracleBase;
                                break block8;
                            }
                            defMountPoint = (String)sharedPartList.get(0);
                        }
                        catch (InstallException e) {
                            defMountPoint = (String)sharedPartList.get(0);
                        }
                        break block8;
                    }
                    defMountPoint = oracleBase;
                }
                catch (UnhandledDriverException e) {
                    defMountPoint = oracleBase;
                }
            } else {
                defMountPoint = oracleBase;
            }
        }
        return defMountPoint;
    }

    public Component getView() {
        return this;
    }

    public void localize(FlowContext flowContext) {
        Application application = Application.getInstance();
        this.lblStorageOptionPrompt.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_PROMPT"), new Object[0]));
        String text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_FILESYS_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoFileSystem, (String)text);
        text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_ASM_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoASM, (String)text);
        this.lblFileSystem.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_FILESYS_PROMPT"), new Object[0]));
        this.lblASM.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_ASM_PROMPT"), new Object[0]));
        text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_FILESYS_LOCATION_LABEL"), new Object[0]);
        SwingUtils.setText((JLabel)this.lblFileLocation, (String)text);
        text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_BROWSE_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowse, (String)text);
        text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_ASMSNMP_LABEL"), new Object[0]);
        SwingUtils.setText((JLabel)this.lblASMMonitor, (String)text);
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        if (eventType == EventType.INIT) {
            this.initialize(flowContext);
        }
        if (eventType == EventType.LOAD) {
            DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
            if (dbBean.getDbInstallEdition() == DBInstallSettings.InstallEdition.SE && dbBean.isRACinstall()) {
                this.rdoFileSystem.setSelected(false);
                this.rdoFileSystem.setEnabled(false);
                this.rdoASM.setSelected(true);
            } else {
                this.rdoFileSystem.setEnabled(true);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.storageType == 1) {
            String mountPoint = this.getTxtFileLocation().getText();
            if (mountPoint == null) {
                mountPoint = "";
            }
            dbBean.setOraDataLocation(mountPoint.trim());
        } else if (this.storageType == 2) {
            dbBean.setAsmsnmpPassword(new String(this.passwdASMSMonitor.getPassword()));
        }
        dbBean.setDatabase_StorageType_Chosen(this.storageType);
    }

    private JRadioButton getFileSystemRadioButton() {
        if (this.rdoFileSystem == null) {
            this.rdoFileSystem = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblFileSystem);
            this.rdoFileSystem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    StorageOptionsUI.this.enableFileLocationFields(StorageOptionsUI.this.rdoFileSystem.isSelected());
                    if (StorageOptionsUI.this.rdoFileSystem.isSelected()) {
                        StorageOptionsUI.this.storageType = 1;
                    }
                }
            });
        }
        return this.rdoFileSystem;
    }

    private void enableFileLocationFields(boolean enable) {
        if (this.lblFileLocation != null) {
            this.lblFileLocation.setEnabled(enable);
        }
        this.getTxtFileLocation().setEnabled(enable);
        this.getBtnBrowse().setEnabled(enable);
    }

    private JRadioButton getASMRadioButton() {
        if (this.rdoASM == null) {
            this.rdoASM = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblASM);
            this.rdoASM.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    StorageOptionsUI.this.lblASMMonitor.setEnabled(StorageOptionsUI.this.rdoASM.isSelected());
                    StorageOptionsUI.this.passwdASMSMonitor.setEnabled(StorageOptionsUI.this.rdoASM.isSelected());
                    if (StorageOptionsUI.this.rdoASM.isSelected()) {
                        StorageOptionsUI.this.storageType = 2;
                    }
                }
            });
        }
        return this.rdoASM;
    }

    private JPanel getPnlFileLocation() {
        if (this.pnlFileLocation == null) {
            this.lblFileLocation = new JLabel();
            this.pnlFileLocation = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            this.pnlFileLocation.setLayout(gbl);
            LayoutUtils.addComponent((Component)this.lblFileLocation, (Container)this.pnlFileLocation, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.getTxtFileLocation(), (Container)this.pnlFileLocation, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.getBtnBrowse(), (Container)this.pnlFileLocation, (int)2, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            this.lblFileLocation.setLabelFor(this.getTxtFileLocation());
        }
        return this.pnlFileLocation;
    }

    private JTextField getTxtFileLocation() {
        if (this.txtFileLocation == null) {
            this.txtFileLocation = new JTextField(25);
        }
        return this.txtFileLocation;
    }

    private JButton getBtnBrowse() {
        if (this.btnBrowse == null) {
            this.btnBrowse = new JButton();
            final StorageOptionsUI rootPanel = this;
            this.btnBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int returnVal;
                    JFileChooser filechooser = new JFileChooser();
                    filechooser.setFileSelectionMode(1);
                    Application application = Application.getInstance();
                    String title = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_BROWSE_DLG_TITLE"), new Object[0]);
                    String btnText = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.db.resource.DBDialogLabelResID", (String)"INSTALL_DB_STORAGE_OPTION_DLG_BROWSE_DLG_PROMPT"), new Object[0]);
                    filechooser.setDialogTitle(title);
                    filechooser.setApproveButtonText(btnText);
                    if (StorageOptionsUI.this.txtFileLocation.getText() != null && !StorageOptionsUI.this.txtFileLocation.getText().equals("")) {
                        filechooser.setCurrentDirectory(new File(StorageOptionsUI.this.txtFileLocation.getText()));
                    }
                    if ((returnVal = filechooser.showOpenDialog(rootPanel)) == 0) {
                        StorageOptionsUI.this.txtFileLocation.setText(filechooser.getSelectedFile().getPath());
                    }
                }
            });
        }
        return this.btnBrowse;
    }

    private JPanel getPnlASMMonitor() {
        if (this.pnlASM == null) {
            this.lblASMMonitor = new JLabel();
            this.passwdASMSMonitor = new JPasswordField(25);
            this.pnlASM = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            this.pnlASM.setLayout(gbl);
            LayoutUtils.addComponent((Component)this.lblASMMonitor, (Container)this.pnlASM, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
            LayoutUtils.addComponent((Component)this.passwdASMSMonitor, (Container)this.pnlASM, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0);
            this.lblASMMonitor.setLabelFor(this.passwdASMSMonitor);
        }
        return this.pnlASM;
    }
}

