/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.library.util.UIUtil;

public class SystemClassPane
extends JPanel {
    private static final long serialVersionUID = 5239016122827279781L;
    MultilineLabel lblDesktopClassDesc;
    MultilineLabel lblServerClassDesc;
    JRadioButton rdoDesktopClass;
    JRadioButton rdoServerClass;

    public SystemClassPane() {
        this.buildUI();
    }

    private void buildUI() {
        this.lblDesktopClassDesc = new MultilineLabel();
        this.lblServerClassDesc = new MultilineLabel();
        this.rdoDesktopClass = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblDesktopClassDesc);
        this.rdoServerClass = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblServerClassDesc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdoDesktopClass);
        group.add(this.rdoServerClass);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoDesktopClass, (Component)this.lblDesktopClassDesc), (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoServerClass, (Component)this.lblServerClassDesc), (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == SystemClassPane.this.rdoDesktopClass || e.getSource() == SystemClassPane.this.rdoServerClass) {
                    // empty if block
                }
            }
        };
        this.rdoDesktopClass.addActionListener(listener);
        this.rdoServerClass.addActionListener(listener);
        ActiveHelpManager.registerComponent((JComponent)this.rdoDesktopClass, (String)"SystemClassUI.rdoDesktopClass");
        ActiveHelpManager.registerComponent((JComponent)this.rdoServerClass, (String)"SystemClassUI.rdoServerClass");
        this.localize();
        this.rdoDesktopClass.setSelected(true);
    }

    public void localize() {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
        String buttonText = resource.getString("INSTALL_DB_SYSTEM_CLASS_DLG_DESKTOP_CLASS_LABEL", "Desktop Class*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoDesktopClass, (String)buttonText);
        this.lblDesktopClassDesc.setText(resource.getString("INSTALL_DB_SYSTEM_CLASS_DLG_DESKTOP_CLASS_DESC", "Choose this option if you are installing on a laptop or desktop class system. This option includes a starter database and allows minimal configuration.", new Object[0]));
        buttonText = resource.getString("INSTALL_DB_SYSTEM_CLASS_DLG_SERVER_CLASS_LABEL", "Server Class*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoServerClass, (String)buttonText);
        this.lblServerClassDesc.setText(resource.getString("INSTALL_DB_SYSTEM_CLASS_DLG_SERVER_CLASS_DESC", "Choose this option if you are installing on a server class system, such as what you would use when deploying Oracle in a production data center. This option allows for more advanced configuration options.", new Object[0]));
    }

    public boolean isDesktopClassSelected() {
        return this.rdoDesktopClass.isSelected();
    }

    public void setServerClassSelected(boolean selected) {
        this.rdoServerClass.setSelected(selected);
        this.rdoDesktopClass.setSelected(!selected);
    }
}

