/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.view;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.view.SystemClassPane;
import oracle.install.library.crs.CRSInfo;

@ViewDef(id="SystemClassUI")
public class SystemClassUI
implements View {
    private Logger logger = Logger.getLogger(SystemClassUI.class.getName());
    SystemClassPane view;

    public SystemClassUI() {
        this.logger.log(Level.INFO, "SystemClassUI Entering Constructor");
        this.view = new SystemClassPane();
        this.logger.log(Level.INFO, "SystemClassUI Exiting Constructor");
    }

    public Component getView() {
        return this.view;
    }

    public void localize(FlowContext flowContext) {
    }

    protected void init(FlowContext flowContext) {
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        switch (eventType) {
            case INIT: {
                CRSInfo crsInfo = CRSInfo.getInstance();
                if (!crsInfo.isCRSPresent()) break;
                bean.setSelectedSystemClass(DBInstallSettings.SystemClass.SERVER_CLASS);
                break;
            }
            case LOAD: {
                this.view.setServerClassSelected(bean.getSelectedSystemClass().equals((Object)DBInstallSettings.SystemClass.SERVER_CLASS));
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.view.isDesktopClassSelected()) {
            dbBean.setSelectedSystemClass(DBInstallSettings.SystemClass.DESKTOP_CLASS);
        } else {
            dbBean.setSelectedSystemClass(DBInstallSettings.SystemClass.SERVER_CLASS);
        }
        this.logger.log(Level.INFO, "SystemClassUI Entering & Exiting processInput");
    }
}

