/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ApacheParser;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ContainerDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveFactory;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveIterator;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FileLevelContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.IncludeDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Parser;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserException;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserIOException;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserTree;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserTreeNode;

public class ApacheConfig
implements ParserTree {
    private boolean parsed = false;
    private String filePath;
    private InputStream inputStream;
    private String tempFileSuffix = ".tmp";
    private String backupFileSuffix = ".bak";
    private Parser parser;
    private FileLevelContainer rootFileLevelCntr;

    public ApacheConfig(String string) {
        this.filePath = string;
    }

    public ApacheConfig() {
    }

    public void init(String string) {
        this.filePath = string;
    }

    public ApacheConfig(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public FileLevelContainer read() throws ParserException {
        try {
            InputStreamReader inputStreamReader = null;
            inputStreamReader = this.inputStream != null ? new InputStreamReader(this.inputStream) : new InputStreamReader(new FileInputStream(this.filePath));
            this.parser = this.createParser(inputStreamReader);
            this.rootFileLevelCntr = this.parser.parse();
            this.rootFileLevelCntr.setFilePath(this.filePath, false);
            inputStreamReader.close();
            this.parsed = true;
        }
        catch (Exception exception) {
            throw new ParserException(exception.getMessage());
        }
        return this.rootFileLevelCntr;
    }

    protected Parser createParser(InputStreamReader inputStreamReader) throws ParserException {
        return new ApacheParser(inputStreamReader);
    }

    private void cancelTempCloneRecursively(Directive directive) {
        if (directive == null) {
            return;
        }
        if (directive.hasTempClone()) {
            directive.cancelTempClone();
        }
        if (directive instanceof ContainerDirective) {
            DirectiveIterator directiveIterator = ((ContainerDirective)directive).getChildren();
            while (directiveIterator.hasNext()) {
                this.cancelTempCloneRecursively((Directive)directiveIterator.next());
            }
        }
    }

    private void commitTempCloneRecursively(Directive directive) {
        if (directive == null) {
            return;
        }
        if (directive.hasTempClone()) {
            directive.commitTempClone();
        }
        if (directive instanceof ContainerDirective) {
            DirectiveIterator directiveIterator = ((ContainerDirective)directive).getChildren();
            while (directiveIterator.hasNext()) {
                this.commitTempCloneRecursively((Directive)directiveIterator.next());
            }
        }
    }

    public ParserTreeNode getRootNode() throws ParserException {
        if (this.rootFileLevelCntr == null && !this.isParsed()) {
            this.read();
        }
        return this.rootFileLevelCntr;
    }

    public FileLevelContainer getRootFileLevelContainer() {
        return this.rootFileLevelCntr;
    }

    public ParserTreeNode createNode(String string, String string2) {
        return DirectiveFactory.create(string, string2);
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void cancelChanges() throws ParserIOException {
        this.cancelTempCloneRecursively(this.rootFileLevelCntr);
        DirectiveIterator directiveIterator = this.getFileLevelContainers();
        while (directiveIterator.hasNext()) {
            FileLevelContainer fileLevelContainer = (FileLevelContainer)directiveIterator.next();
            String string = fileLevelContainer.getFilePath();
            File file = new File(String.valueOf(string) + this.tempFileSuffix);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    public void writeChangesToTempFile() throws ParserIOException {
        DirectiveIterator directiveIterator = this.getFileLevelContainers();
        while (directiveIterator.hasNext()) {
            FileLevelContainer fileLevelContainer = (FileLevelContainer)directiveIterator.next();
            byte by = fileLevelContainer.getStatus();
            if (by != 4 && by != 1) continue;
            fileLevelContainer.writeChanges(this.tempFileSuffix);
        }
    }

    public void commitChanges() throws ParserIOException {
        DirectiveIterator directiveIterator = this.getFileLevelContainers();
        while (directiveIterator.hasNext()) {
            FileLevelContainer fileLevelContainer = (FileLevelContainer)directiveIterator.next();
            byte by = fileLevelContainer.getStatus();
            if (by == 0) continue;
            String string = fileLevelContainer.getFilePath();
            File file = new File(string);
            File file2 = new File(String.valueOf(string) + this.tempFileSuffix);
            File file3 = new File(String.valueOf(string) + this.backupFileSuffix);
            try {
                if (!file.canWrite()) {
                    throw new ParserIOException(String.valueOf(file.getAbsolutePath()) + ": write permission denied");
                }
                if (file3.exists()) {
                    if (!file3.canWrite()) {
                        throw new ParserIOException(String.valueOf(file3.getAbsolutePath()) + ": write permission denied");
                    }
                    file3.delete();
                }
                file.renameTo(file3);
                if (by == 4 || by == 1) {
                    file2.renameTo(file);
                }
            }
            catch (Exception exception) {
                throw new ParserIOException(exception.getMessage());
            }
            this.commitTempCloneRecursively(this.rootFileLevelCntr);
        }
    }

    public void restoreFromBackup() throws ParserIOException {
        DirectiveIterator directiveIterator = this.getFileLevelContainers();
        while (directiveIterator.hasNext()) {
            FileLevelContainer fileLevelContainer = (FileLevelContainer)directiveIterator.next();
            String string = fileLevelContainer.getFilePath();
            File file = new File(string);
            File file2 = new File(String.valueOf(string) + this.backupFileSuffix);
            try {
                if (!file.canWrite()) {
                    throw new ParserIOException(String.valueOf(file.getAbsolutePath()) + ": write permission denied");
                }
                if (file.exists()) {
                    file.delete();
                }
                file2.renameTo(file);
            }
            catch (Exception exception) {
                throw new ParserIOException(exception.getMessage());
            }
        }
    }

    public DirectiveIterator getFileLevelContainers() {
        return new DirectiveIterator(this.getFileLevelCntrs(this.rootFileLevelCntr));
    }

    private DirectiveList getFileLevelCntrs(Directive directive) {
        DirectiveList directiveList = new DirectiveList();
        if (directive instanceof FileLevelContainer) {
            directiveList.add(directive);
        }
        if (directive instanceof ContainerDirective) {
            DirectiveIterator directiveIterator = ((ContainerDirective)directive).getChildren(true, false);
            while (directiveIterator.hasNext()) {
                DirectiveList directiveList2 = this.getFileLevelCntrs((Directive)directiveIterator.next());
                directiveList.add(directiveList2);
            }
        } else if (directive instanceof IncludeDirective) {
            DirectiveList directiveList3 = this.getFileLevelCntrs(((IncludeDirective)directive).getIncludedConfig());
            directiveList.add(directiveList3);
        }
        return directiveList;
    }
}

