// Point.java

import java.sql.*;
import oracle.sql.*;
import oracle.jdbc.driver.*;

public class Point
{
  double x;
  double y;

  public Point (STRUCT s) throws SQLException {
    Datum[] attributes = s.getOracleAttributes();
    x = attributes[0].doubleValue();
    y = attributes[1].doubleValue();
  }

  public STRUCT toSTRUCT () throws SQLException {
    OracleConnection conn = (OracleConnection)
      new oracle.jdbc.driver.OracleDriver().defaultConnection ();
    StructDescriptor sd =
      StructDescriptor.createDescriptor ("SCOTT.POINT", conn);
    Object [] attributes = { new Double (x), new Double (y) };
    STRUCT struct = new STRUCT (sd, conn, attributes);
    return struct;
  }

  public double distance (Point p) {
    return Math.sqrt ((y - p.y) * (y - p.y) + (x - p.x) * (x - p.x));
  }

  public void moveBy (Point p) {
    x += p.x;
    y += p.y;
  }
}
