// Point3.java

import java.sql.*;

public class Point3 implements SQLData
{
  String type_name;

  double x;
  double y;

  public Point3 () {}

  public void readSQL (SQLInput stream, String type_name) throws SQLException {
    this.type_name = type_name;
    x = stream.readDouble ();
    y = stream.readDouble ();
  }
 
  public String getSQLTypeName () throws SQLException { 
    return type_name; 
  } 
 
  public void writeSQL (SQLOutput stream) throws SQLException { 
    stream.writeDouble (x);
    stream.writeDouble (y);
  }

  public double distance (Point3 p) {
    return Math.sqrt ((y - p.y) * (y - p.y) + (x - p.x) * (x - p.x));
  }

  public void moveBy (Point3 p) {
    x += p.x;
    y += p.y;
  }
}
