set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4309 - APEX - Data Workshop
--
-- Application Export:
--   Application:     4309
--   Name:            APEX - Data Workshop
--   Date and Time:   08:02 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                33
--     Items:             112
--     Computations:       27
--     Validations:        75
--     Processes:          38
--     Regions:           134
--     Buttons:            75
--   Shared Components
--     Breadcrumbs:         1
--        Entries          34
--     Items:               6
--     Computations:        1
--     Processes:           1
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             2
--     Lists:              13
--     Shortcuts:           1
--     Themes:              0
--     Templates:
--        Page:             3
--        List:             7
--        Report:           2
--        Label:            3
--        Region:          10
--     Messages:            0
--     Build Options:       1
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4309;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4309);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4309);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4309,
  p_display_id=> 4309,
  p_owner => 'APEX_030200',
  p_name  => 'APEX - Data Workshop',
  p_alias => 'A198388700210433157',
  p_page_view_logging => 'YES',
  p_default_page_template=> 3485606247566446.4309 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 9113661096283.4309 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 9113673096289.4309 + wwv_flow_api.g_id_offset,
  p_error_template    => 3485606247566446.4309 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4300:9:&SESSION.',
  p_flow_language     => 'ja',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => 'development_service_home_login',
  p_logout_url        => 'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(60872513468265716 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_security_scheme=>'FLOW: DATA_LOADER',
  p_csv_encoding    => 'Y',
  p_theme_id => 3,
  p_default_label_template => 103909823939152778.4309 + wwv_flow_api.g_id_offset,
  p_default_report_template => 10583525904875984.4309 + wwv_flow_api.g_id_offset,
  p_default_list_template => 119835024987557728.4309 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 6680621597641306.4309 + wwv_flow_api.g_id_offset,
  p_substitution_string_01 => 'LOGOUT',
  p_substitution_value_01  => 'ログアウト',
  p_substitution_string_02 => 'PRODUCT_NAME',
  p_substitution_value_02  => 'Application Express',
  p_substitution_string_03 => 'MSG_COMPANY',
  p_substitution_value_03  => '作業領域: &COMPANY.',
  p_substitution_string_04 => 'MSG_LANGUAGE',
  p_substitution_value_04  => '言語',
  p_substitution_string_05 => 'MSG_COPYRIGHT',
  p_substitution_value_05  => 'Copyright &copy; 1999, 2009, Oracle. All rights reserved.',
  p_substitution_string_06 => 'MSG_USER',
  p_substitution_value_06  => 'ユーザー',
  p_substitution_string_07 => 'MSG_JSCRIPT',
  p_substitution_value_07  => 'この製品は、JavaScriptが有効な状態で実行する必要があります。',
  p_substitution_string_08 => 'MSG_TBL_SUMMARY',
  p_substitution_value_08  => 'ページ・レイアウト表',
  p_substitution_string_09 => 'DONE',
  p_substitution_value_09  => '完了',
  p_substitution_string_10 => 'TOP',
  p_substitution_value_10  => 'トップ',
  p_substitution_string_11 => 'CLOSE',
  p_substitution_value_11  => '閉じる',
  p_substitution_string_12 => 'DATE_FORMAT',
  p_substitution_value_12  => 'rr-mm-dd',
  p_substitution_string_13 => 'LONG_DATE_FORMAT',
  p_substitution_value_13  => 'yyyy mm dd fmDay',
  p_substitution_string_14 => 'TIME_FORMAT',
  p_substitution_value_14  => 'hh24:mi:ss',
  p_substitution_string_15 => 'DATE_TIME_FORMAT',
  p_substitution_value_15  => 'rr-mm-dd hh24:mi:ss',
  p_substitution_string_16 => 'RETURN_TO_APPLICATION',
  p_substitution_value_16  => 'アプリケーションに戻る',
  p_substitution_string_17 => 'DELETE_MSG',
  p_substitution_value_17  => 'この削除操作を実行しますか。',
  p_substitution_string_18 => 'FIND',
  p_substitution_value_18  => '検索',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518141932',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39891301589182701.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 1,
  p_icon_image     => '',
  p_icon_subtext   => 'ヘルプ',
  p_icon_target    => 'javascript:popupURL(''wwv_flow_help.show_help?p_lang=&BROWSER_LANGUAGE.&p_session=&APP_SESSION.&p_flow_id=&APP_TRANSLATION_ID.&p_step_id=&APP_TRANSLATION_PAGE_ID.'');',
  p_icon_image_alt => 'ヘルプ',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39955524108615064.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 10,
  p_icon_image     => '',
  p_icon_subtext   => 'ログアウト',
  p_icon_target    => 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_icon_image_alt => 'ログアウト',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/ajax_collect_clob
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'    l_code clob := empty_clob;'||chr(10)||
'begin'||chr(10)||
'   dbms_lob.createtemporary( l_code, false, dbms_lob.SESSION );'||chr(10)||
'   for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'        dbms_lob.writeappend(l_code,length(wwv_flow.g_f01(i)),wwv_flow.g_f01(i));'||chr(10)||
'    end loop;'||chr(10)||
'apex_collection.create_or_truncate_collection(p_collection_name=>''CLOB_CONTENT'');'||chr(10)||
'apex_collection.add_member(p_collection_name=>''CLOB_CONTENT'',p_clob001=>';

p:=p||'l_code);'||chr(10)||
'htp.prn(''SUCCESS'');'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 49906314503034042.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'AJAX_COLLECT_CLOB',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/company
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 5126097226.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'COMPANY',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'name of company for mutli company oracle platform');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4300_imex_batch_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 25339931440732484.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4300_IMEX_BATCH_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4300_last_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 48603115971458169.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4300_LAST_VIEW',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4300_load_job
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 242549145362.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4300_LOAD_JOB',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 147029609296398557.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by Custom2 authentication for deep linking support');
 
null;
 
end;
/

--application/shared_components/logic/application_items/last_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 48610196642071039.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'LAST_VIEW',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/company
wwv_flow_api.create_flow_computation (
  p_id => 5128100953.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'COMPANY',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'FUNCTION_BODY',
  p_computation_processed=> 'ON_NEW_INSTANCE',
  p_computation => 'return wwv_flow.get_company_name;',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/case_sensitive_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87923517360560740.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CASE.SENSITIVE.Y',
  p_lov_query=> '.'||to_char(87923517360560740 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87923721904560740.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87923517360560740.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'大/小文字区別',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_table_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23546816846659473.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE_TABLE_SCHEMAS',
  p_lov_query=> 'declare'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  q:=q||''select htf.escape_sc(c.schema) d, c.schema v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  if wwv_flow_global.g_xe then'||chr(10)||
'    q:=q||''  and exists (select null '';'||chr(10)||
'    q:=q||''              from sys.dba_sys_privs '';'||chr(10)||
'    q:=q||''              where privilege = ''''CREATE TABLE'''' '';'||chr(10)||
'    q:=q||''              and grantee = c.schema '';'||chr(10)||
'    q:=q||''              union all '';'||chr(10)||
'    q:=q||''              select null '';'||chr(10)||
'    q:=q||''              from sys.dba_sys_privs s, sys.dba_role_privs r '';'||chr(10)||
'    q:=q||''              where r.granted_role=s.grantee '';'||chr(10)||
'    q:=q||''              and r.grantee = c.schema '';'||chr(10)||
'    q:=q||''              and s.privilege = ''''CREATE TABLE'''') '';'||chr(10)||
'  else'||chr(10)||
'    q:=q||''  and exists (select null '';'||chr(10)||
'    q:=q||''               from sys.dba_sys_privs '';'||chr(10)||
'    q:=q||''               where privilege = ''''CREATE TABLE'''' '';'||chr(10)||
'    q:=q||''                 and grantee = c.schema)     '';'||chr(10)||
'  end if;         '||chr(10)||
'  q:=q||''  and exists (select null '';'||chr(10)||
'  q:=q||''                from sys.dba_users '';'||chr(10)||
'  q:=q||''               where username = c.schema) '';'||chr(10)||
'  q:=q||''order by 1 '';'||chr(10)||
'  '||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/export_as_file_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87944005995777613.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPORT.AS.FILE.Y',
  p_lov_query=> '.'||to_char(87944005995777613 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87944229029777613.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87944005995777613.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'ファイルとしてエクスポート',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/export_file_format
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 143183002952786622.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPORT.FILE_FORMAT',
  p_lov_query=> '.'||to_char(143183002952786622 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>143183319798786629.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>143183002952786622.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'UNIX',
  p_lov_return_value=>'UNIX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>143183511674786632.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>143183002952786622.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'DOS',
  p_lov_return_value=>'DOS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_iana_charset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_IANA_CHARSET',
  p_reference_id=> 144796827445692396,
  p_lov_query=> '.'||to_char(135399325911344822 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70982304215423500.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'アラビア語(ISO-8859-6)',
  p_lov_return_value=>'iso-8859-6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70982502342423500.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'アラビア語(Windows 1256)',
  p_lov_return_value=>'windows-1256',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70982721979423500.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'中国語(Big5)',
  p_lov_return_value=>'big5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70982904632423500.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'中国語(GBK)',
  p_lov_return_value=>'gbk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70983131546423500.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'キリル語(ISO-8859-5)',
  p_lov_return_value=>'iso-8859-5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70983303089423501.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'キリル語(KOI8-R)',
  p_lov_return_value=>'koi8-r',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70983516076423501.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'キリル語(KOI8-U)',
  p_lov_return_value=>'koi8-u',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70983709919423501.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'キリル語(Windows 1251)',
  p_lov_return_value=>'windows-1251',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70983918411423501.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'東ヨーロッパ語(ISO-8859-2)',
  p_lov_return_value=>'iso-8859-2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70984123082423502.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'東ヨーロッパ語(Windows 1250)',
  p_lov_return_value=>'windows-1250',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70984306836423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'ギリシャ語(ISO-8859-7)',
  p_lov_return_value=>'iso-8859-7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70984532472423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'ギリシャ語(Windows 1253)',
  p_lov_return_value=>'windows-1253',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70984727853423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'ヘブライ語(ISO-8859-8-i)',
  p_lov_return_value=>'iso-8859-8-i',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70984900365423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'ヘブライ語(Windows 1255)',
  p_lov_return_value=>'windows-1255',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70985116658423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'日本語(EUC)',
  p_lov_return_value=>'euc-jp',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70985320706423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'日本語(Shift JIS)',
  p_lov_return_value=>'shift_jis',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70985502577423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'韓国語(EUC)',
  p_lov_return_value=>'euc-kr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70985721929423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'北ヨーロッパ語(ISO-8859-4)',
  p_lov_return_value=>'iso-8859-4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70985923459423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'北ヨーロッパ語(Windows 1257)',
  p_lov_return_value=>'windows-1257',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70986113653423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'南ヨーロッパ語(ISO-8859-3)',
  p_lov_return_value=>'iso-8859-3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70986331235423503.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'タイ語(TIS-620)',
  p_lov_return_value=>'tis-620',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70986512702423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'トルコ語(ISO-8859-9)',
  p_lov_return_value=>'iso-8859-9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70986726925423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'トルコ語(Windows 1254)',
  p_lov_return_value=>'windows-1254',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70986925310423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'Unicode(UTF-8)',
  p_lov_return_value=>'utf-8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70987104467423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>242,
  p_lov_disp_value=>'Unicode (UTF-16 Big Endian)',
  p_lov_return_value=>'utf-16be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70987313654423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>244,
  p_lov_disp_value=>'Unicode (UTF-16 Little Endian)',
  p_lov_return_value=>'utf-16le',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70987511911423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>248,
  p_lov_disp_value=>'US-ASCII',
  p_lov_return_value=>'us-ascii',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70987715835423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'ベトナム語(Windows 1258)',
  p_lov_return_value=>'windows-1258',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70987907270423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'西ヨーロッパ語(ISO-8859-1)',
  p_lov_return_value=>'iso-8859-1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70988132193423504.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>135399325911344822.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'西ヨーロッパ語(Windows 1252)',
  p_lov_return_value=>'windows-1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_iana_db_charset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_IANA_DB_CHARSET',
  p_reference_id=> 144802427115692411,
  p_lov_query=> '.'||to_char(139941401949707953 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70963429018421249.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'アラビア語(ISO-8859-6)',
  p_lov_return_value=>'AR8ISO8859P6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70963607302421249.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'アラビア語(Windows 1256)',
  p_lov_return_value=>'AR8MSWIN1256',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70963801762421249.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'中国語(Big5)',
  p_lov_return_value=>'ZHT16MSWIN950',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70964002767421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'中国語(GBK)',
  p_lov_return_value=>'ZHS16GBK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70964217909421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'キリル語(ISO-8859-5)',
  p_lov_return_value=>'CL8ISO8859P5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70964409183421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'キリル語(KOI8-R)',
  p_lov_return_value=>'CL8KOI8R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70964604460421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'キリル語(KOI8-U)',
  p_lov_return_value=>'CL8KOI8U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70964804920421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'キリル語(Windows 1251)',
  p_lov_return_value=>'CL8MSWIN1251',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70965031359421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'東ヨーロッパ語(ISO-8859-2)',
  p_lov_return_value=>'EE8ISO8859P2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70965231606421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'東ヨーロッパ語(Windows 1250)',
  p_lov_return_value=>'EE8MSWIN1250',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70965424117421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'ギリシャ語(ISO-8859-7)',
  p_lov_return_value=>'EL8ISO8859P7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70965603027421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'ギリシャ語(Windows 1253)',
  p_lov_return_value=>'EL8MSWIN1253',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70965818420421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'ヘブライ語(ISO-8859-8-i)',
  p_lov_return_value=>'IW8ISO8859P8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70966015024421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'ヘブライ語(Windows 1255)',
  p_lov_return_value=>'IW8MSWIN1255',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70966219264421250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'日本語(EUC)',
  p_lov_return_value=>'JA16EUC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70966421516421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'日本語(Shift JIS)',
  p_lov_return_value=>'JA16SJIS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70966607691421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'韓国語(EUC)',
  p_lov_return_value=>'KO16MSWIN949',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70966823352421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'北ヨーロッパ語(ISO-8859-4)',
  p_lov_return_value=>'NEE8ISO8859P4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70967023086421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'北ヨーロッパ語(Windows 1257)',
  p_lov_return_value=>'BLT8MSWIN1257',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70967219758421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'南ヨーロッパ語(ISO-8859-3)',
  p_lov_return_value=>'SE8ISO8859P3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70967416340421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'タイ語(TIS-620)',
  p_lov_return_value=>'TH8TISASCII',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70967611593421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'トルコ語(ISO-8859-9)',
  p_lov_return_value=>'WE8ISO8859P9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70967827650421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'トルコ語(Windows 1254)',
  p_lov_return_value=>'TR8MSWIN1254',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70968000086421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'Unicode(UTF-8)',
  p_lov_return_value=>'AL32UTF8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70968201422421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>242,
  p_lov_disp_value=>'Unicode (UTF-16 Big Endian)',
  p_lov_return_value=>'AL16UTF16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70968400569421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>244,
  p_lov_disp_value=>'Unicode (UTF-16 Little Endian)',
  p_lov_return_value=>'AL16UTF16LE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70968614356421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>248,
  p_lov_disp_value=>'US-ASCII',
  p_lov_return_value=>'US7ASCII',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70968802200421251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'ベトナム語(Windows 1258)',
  p_lov_return_value=>'VN8MSWIN1258',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70969016331421252.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'西ヨーロッパ語(ISO-8859-1)',
  p_lov_return_value=>'WE8ISO8859P1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70969214663421252.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>139941401949707953.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'西ヨーロッパ語(Windows 1252)',
  p_lov_return_value=>'WE8MSWIN1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_col_names_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87945815476789819.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE.COL.NAMES.Y',
  p_lov_query=> '.'||to_char(87945815476789819 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87946002718789820.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87945815476789819.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'列名を含める',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/iscolumn_name_text
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87953325959849588.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ISCOLUMN.NAME.TEXT',
  p_lov_query=> 'select ''<span class="instructiontext">''||'||chr(10)||
'wwv_flow_lang.system_message(''F4300_INSTRUCT_TEXT'')||''</span>'' d, ''Y'' r from dual');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_schema_owners
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 182776719411.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_SCHEMA_OWNERS',
  p_lov_query=> 'select htf.escape_sc(c.schema) d, c.schema v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/load_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87921416882551159.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOAD.OPTION',
  p_lov_query=> '.'||to_char(87921416882551159 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87921609839551159.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87921416882551159.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'ファイルをアップロード(カンマ区切りまたはタブ区切り)',
  p_lov_return_value=>'UPLOAD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87921801389551160.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87921416882551159.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'コピー・アンド・ペースト',
  p_lov_return_value=>'PASTE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/load_data_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20828314943711235.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOAD_DATA_TYPES',
  p_lov_query=> '.'||to_char(20828314943711235 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20828624229711248.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>20828314943711235.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'NUMBER',
  p_lov_return_value=>'NUMBER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20828808097711250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>20828314943711235.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'VARCHAR2',
  p_lov_return_value=>'VARCHAR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20829026553711250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>20828314943711235.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'DATE',
  p_lov_return_value=>'DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20829212946711250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>20828314943711235.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'CLOB',
  p_lov_return_value=>'CLOB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20829421949711250.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>20828314943711235.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'BINARY_FLOAT',
  p_lov_return_value=>'BINARY_FLOAT',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_utilities.db_version_is_at_least(''10.1'');',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20829612125711251.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>20828314943711235.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'BINARY_DOUBLE',
  p_lov_return_value=>'BINARY_DOUBLE',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_utilities.db_version_is_at_least(''10.1'');',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p16_tables
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 162716910286446218.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P16_TABLES',
  p_lov_query=> 'select table_name a, table_name b'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner=:F4300_P14_TARGET_SCHEMA'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p2_load
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 236956028332134846.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P2_LOAD',
  p_lov_query=> '.'||to_char(236956028332134846 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236956315568134853.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>236956028332134846.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'インポート',
  p_lov_return_value=>'MY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236956532195134859.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>236956028332134846.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'すべてのインポート',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 29232624018252340.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_TYPES',
  p_reference_id=> 20561306137429854,
  p_lov_query=> '.'||to_char(29232624018252340 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51627621271152564.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>29232624018252340.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'新しい順序から生成',
  p_lov_return_value=>'NEW_SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51627831065152564.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>29232624018252340.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'既存の順序から生成',
  p_lov_return_value=>'EXISTING_SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51628012394152565.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>29232624018252340.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'生成しない',
  p_lov_return_value=>'NOT_GENERATED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/preserve_case_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87931511182663028.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRESERVE.CASE.Y',
  p_lov_query=> '.'||to_char(87931511182663028 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87931730659663028.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87931511182663028.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'大/小文字を保持',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/restrict_load_files
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87918702852509211.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'RESTRICT.LOAD.FILES',
  p_lov_query=> '.'||to_char(87918702852509211 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87918901897509212.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87918702852509211.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'インポート・ファイル',
  p_lov_return_value=>'MY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87919109206509212.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87918702852509211.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'すべてのインポート・ファイル',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/table_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87922429003554589.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TABLE.OPTION',
  p_lov_query=> '.'||to_char(87922429003554589 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87922602291554590.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87922429003554589.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'既存の表',
  p_lov_return_value=>'EXIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87922820756554590.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87922429003554589.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'新しい表',
  p_lov_return_value=>'NEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/use_existing_col
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87933423434676001.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'USE.EXISTING.COL',
  p_lov_query=> '.'||to_char(87933423434676001 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87933602623676001.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87933423434676001.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'既存の列を使用',
  p_lov_return_value=>'EXISTING_KEY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87933822194676002.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87933423434676001.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'新しい列の作成',
  p_lov_return_value=>'NEW_KEY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_y_or_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87930425596657700.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES.NO.RETURNS_Y_OR_N',
  p_lov_query=> '.'||to_char(87930425596657700 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87930609321657701.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87930425596657700.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'いいえ',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87930802381657701.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>87930425596657700.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'はい',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 182782926995.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES_NO',
  p_lov_query=> '.'||to_char(182782926995 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>182785927024.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>182782926995.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'はい',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>182787927024.4309 + wwv_flow_api.g_id_offset,
  p_lov_id=>182782926995.4309 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'いいえ',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_.4309
prompt  ...PAGE .4309: ページ0(ゼロ)
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => .4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'ページ0(ゼロ)',
  p_step_title=> '',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216950505720834051+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 7505408382227958.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163402',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'1452315428006354';

wwv_flow_api.create_page_plug (
  p_id=> 1456614651025020.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4309,
  p_plug_name=> 'Application Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_07',
  p_plug_source=> s,
  p_plug_source_type=> 1452315428006354 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page .4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_1.430
prompt  ...PAGE 1.4309: データのロード/アンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt_imprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード/アンロード',
  p_step_title=> 'データのロード/アンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216950505720834051+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163402',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'2202106852499122';

wwv_flow_api.create_page_plug (
  p_id=> 2209528931524495.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4309,
  p_plug_name=> 'Data Workshop',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 2202106852499122 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2211411747528919.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4309,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_2.430
prompt  ...PAGE 2.4309: スプレッドシートのロードの詳細
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 2.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'スプレッドシートのロードの詳細',
  p_step_title=> 'スプレッドシートのロードの詳細',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 7505408382227958.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163402',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>2.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページには、スプレッドシートのインポートに関する情報が表示されます。 インポートに失敗した行がある場合は、このページにエラー・メッセージが表示されます。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 236908207860041215.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4309,
  p_plug_name=> 'スプレッドシートのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_no_data_found=>'失敗した行が見つかりません。',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select ''<span class="htmldbError">'' || errm || ''</span>'' Error,'||chr(10)||
'          data Data'||chr(10)||
'   from wwv_flow_data_load_bad_log'||chr(10)||
'  where load_id = :P2_LOAD_ID';

wwv_flow_api.create_report_region (
  p_id=> 236908624285041216.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4309,
  p_name=> '失敗した行',
  p_region_name=>'',
  p_template=> 101735615849237059.4309+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 10583525904875984.4309+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '失敗した行が見つかりません。',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236909010953041218.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236908624285041216.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ERROR',
  p_column_display_sequence=> 1,
  p_column_heading=> 'エラー',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236909111520041218.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236908624285041216.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DATA',
  p_column_display_sequence=> 2,
  p_column_heading=> 'データ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 236909231803041218.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4309,
  p_plug_name=> 'button bar',
  p_region_name=>'',
  p_plug_template=> 3918621721760114.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Select CREATED_ON Load_Date, CREATED_BY Loaded_By, DATA_SCHEMA Schema2, DATA_TABLE Table2, SUCCESS_ROWS Rows_Loaded, FAILED_ROWS Rows_Failed from wwv_flow_data_load_unload where id=:P2_LOAD_ID';

wwv_flow_api.create_report_region (
  p_id=> 236910023245041222.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4309,
  p_name=> '概要',
  p_region_name=>'',
  p_template=> 101735615849237059.4309+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 25,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'データが見つかりません。',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236910621733041225.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236910023245041222.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'LOAD_DATE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'インポート日',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236910704793041225.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236910023245041222.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LOADED_BY',
  p_column_display_sequence=> 2,
  p_column_heading=> 'インポート者',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236910825625041225.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236910023245041222.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA2',
  p_column_display_sequence=> 3,
  p_column_heading=> 'スキーマ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236910911224041225.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236910023245041222.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE2',
  p_column_display_sequence=> 4,
  p_column_heading=> '表',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236910405016041225.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236910023245041222.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ROWS_LOADED',
  p_column_display_sequence=> 5,
  p_column_heading=> 'インポートされた行',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 236910524132041225.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 236910023245041222.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ROWS_FAILED',
  p_column_display_sequence=> 6,
  p_column_heading=> '失敗した行',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 236916722090057358.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4309,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 236911018188041226.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 2.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 236909231803041218+wwv_flow_api.g_id_offset,
  p_button_name    => 'BACK',
  p_button_image_alt=> 'リポジトリに戻る',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>236912309292041255.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4309,
  p_branch_action=> 'f?p=&FLOW_ID.:11:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 30,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-JUL-2004 18:04 by CBCHO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>236911408920041236.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4309,
  p_name=>'P2_LOAD_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_4.430
prompt  ...PAGE 4.4309: アンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 4.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'アンロード',
  p_step_title=> 'アンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216950505720834051+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 7505408382227958.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163403',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>4.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2219929417559213.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4309,
  p_plug_name=> 'Data Unload',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 75585889878824332 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_customized_name=>'「データのアンロード」アイコン',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Extract data from database schemas online to files on your computer.');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2225825431570758.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4309,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_7.430
prompt  ...PAGE 7.4309: テキスト・データのロードの詳細
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 7.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'テキスト・データのロードの詳細',
  p_step_title=> 'テキスト・データのロードの詳細',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 7505408382227958.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163403',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>7.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3913203962745120.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4309,
  p_plug_name=> 'button bar',
  p_region_name=>'',
  p_plug_template=> 3918621721760114.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select ''<span class="htmldbError">'' || errm || ''</span>'' Error,'||chr(10)||
'          data Data'||chr(10)||
'   from wwv_flow_data_load_bad_log'||chr(10)||
'  where load_id = :F4300_P7_LOAD_ID';

wwv_flow_api.create_report_region (
  p_id=> 55112340569377996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4309,
  p_name=> '失敗した行',
  p_region_name=>'',
  p_template=> 101735615849237059.4309+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 24534016112516813.4309+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '失敗した行が見つかりません。',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 26396310164851868.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 55112340569377996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ERROR',
  p_column_display_sequence=> 1,
  p_column_heading=> 'エラー',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 26396413604851868.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 55112340569377996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DATA',
  p_column_display_sequence=> 2,
  p_column_heading=> 'データ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 75398916706711544.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Select CREATED_ON Load_Date, CREATED_BY Loaded_By, DATA_SCHEMA Schema2, DATA_TABLE Table2, SUCCESS_ROWS Rows_Loaded, FAILED_ROWS Rows_Failed from wwv_flow_data_load_unload where id=:F4300_P7_LOAD_ID';

wwv_flow_api.create_report_region (
  p_id=> 234740508574260035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4309,
  p_name=> '概要',
  p_region_name=>'',
  p_template=> 101735615849237059.4309+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 25,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<p>このページには、テキスト・データファイルのインポートに関する情報が表示されます。 インポートに失敗した行がある場合は、このページにエラー・メッセージが表示されます。</p>',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'データが見つかりません。',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234741120589260051.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234740508574260035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'LOAD_DATE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'インポート日',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234741209381260051.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234740508574260035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LOADED_BY',
  p_column_display_sequence=> 2,
  p_column_heading=> 'インポート者',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234741308348260051.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234740508574260035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA2',
  p_column_display_sequence=> 3,
  p_column_heading=> 'スキーマ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234741425535260051.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234740508574260035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE2',
  p_column_display_sequence=> 4,
  p_column_heading=> '表',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234741507868260052.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234740508574260035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ROWS_LOADED',
  p_column_display_sequence=> 5,
  p_column_heading=> 'インポートされた行',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234741628809260052.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234740508574260035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ROWS_FAILED',
  p_column_display_sequence=> 6,
  p_column_heading=> '失敗した行',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 192104604688817535.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3913203962745120+wwv_flow_api.g_id_offset,
  p_button_name    => 'BACK',
  p_button_image_alt=> 'リポジトリに戻る',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>234998201152447134.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4309,
  p_branch_action=> 'f?p=&FLOW_ID.:8:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 30,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-JUL-2004 18:04 by CBCHO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27172013799279694.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4309,
  p_name=>'F4300_P7_LOAD_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>234980910062392922.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4309,
  p_name=>'P7_PREV_PAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3913203962745120.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 7.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_8.430
prompt  ...PAGE 8.4309: テキスト・データのロード・リポジトリ
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_imprt_rep.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 8.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'テキスト・データのロード・リポジトリ',
  p_step_title=> 'テキスト・データのロード・リポジトリ',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 7505408382227958.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163403',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>8.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3921012881766600.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4309,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 108205605860896611.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6836912352738319.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'    q           varchar2(4000);    '||chr(10)||
'begin    '||chr(10)||
'  q:= q || ''select '';'||chr(10)||
'  q:= q || ''''''<label for="f01_''''||rownum||''''" class="hideMe508">Select Import</label><input id="f01_''''||rownum||''''" type="checkbox" name="f01" value="''''||dat.id||''''">'''' cb,'';'||chr(10)||
'  q:= q || ''htf.anchor(''''f?p=4300:2:''||:flow_session||''::::P2_LOAD_ID:'''' || dat.id, '';'||chr(10)||
'  q:= q || '' htf.img (''''#IMAGE_PREFIX#24find.gif'''', NULL, NULL';

s:=s||', NULL,''''border="0" alt="''||wwv_flow_lang.system_message(''DETAILS_FOR_ALT_TAG'')||''" height="24" width="24"'''')) "Details",'';'||chr(10)||
'  q:= q || '' dat.created_by "Created By", '';'||chr(10)||
'  q:= q || '' dat.created_on  "Created on", '';'||chr(10)||
'  q:= q || '' decode (data_type, ''''EXCEL IMPORT'''', wwv_flow_lang.system_message(''''F4300.SPREADSHEET_IMPORT'''')) "Type", '';'||chr(10)||
'  q:= q || ''data_Schema "Schema", '';'||chr(10)||
''||chr(10)||
'q := q||''data_table "Table';

s:=s||'", '';'||chr(10)||
''||chr(10)||
'  q:= q || '' success_rows "Succeeded",'';'||chr(10)||
'  q:= q || '' decode(failed_rows,0,''''0'''',htf.anchor(''''f?p=4300:2:''||:flow_session||''::::P2_LOAD_ID:'''' || dat.id,'';'||chr(10)||
'  q:= q || '' failed_rows))     "Failed"'';'||chr(10)||
'  q:= q || '' from wwv_flow_data_load_unload dat, sys.dba_objects o '';  '||chr(10)||
'  q:= q || '' where o.owner = dat.data_schema '';'||chr(10)||
'  q:= q || '' and o.object_name = dat.data_table '';'||chr(10)||
'  q:= q || '' and o.object';

s:=s||'_type = ''''TABLE'''' '';'||chr(10)||
'  q:= q || '' and dat.security_group_id =:FLOW_SECURITY_GROUP_ID '';'||chr(10)||
'  q:= q || '' and data_type = ''''EXCEL IMPORT'''''';'||chr(10)||
''||chr(10)||
'  if (:F4300_P8_RESTRICT_BY = ''MY'' or :F4300_P8_RESTRICT_BY is NULL)  then'||chr(10)||
'      q:= q || '' and dat.created_by = :FLOW_USER '';'||chr(10)||
'  end if;  '||chr(10)||
'return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4309,
  p_name=> 'スプレッドシートのロード',
  p_region_name=>'',
  p_template=> 101735615849237059.4309+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_condition_type=> 'NEVER',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 24534016112516813.4309+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'データが見つかりません。',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24539318125531393.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CB',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24539430463531393.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'Details',
  p_column_display_sequence=> 2,
  p_column_heading=> '詳細',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24539527121531393.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'Created By',
  p_column_display_sequence=> 3,
  p_column_heading=> 'インポート者',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24539629611531393.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'Created on',
  p_column_display_sequence=> 4,
  p_column_heading=> 'インポート日',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24539722210531394.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'Type',
  p_column_display_sequence=> 5,
  p_column_heading=> 'タイプ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24539810609531394.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'Schema',
  p_column_display_sequence=> 6,
  p_column_heading=> 'スキーマ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24539901035531394.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'Table',
  p_column_display_sequence=> 7,
  p_column_heading=> '表',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24540002599531394.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'Succeeded',
  p_column_display_sequence=> 8,
  p_column_heading=> '成功',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24540122211531394.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 24539117171531389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'Failed',
  p_column_display_sequence=> 9,
  p_column_heading=> '失敗',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページには、ロードされたテキスト・データのステータスが表示されます。</p> '||chr(10)||
'<p>ロードされたファイルにアクセスするには、そのファイル名を選択してください。</p> '||chr(10)||
'<p>ステータス・エントリを削除するには、そのステータスを選択し、「<b>チェックした項目の削除</b>」をクリックしてください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 220725321769721592.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4309,
  p_plug_name=> 'リポジトリ',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'3648913903408259';

wwv_flow_api.create_page_plug (
  p_id=> 220741417024852608.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4309,
  p_plug_name=> 'タスク',
  p_region_name=>'',
  p_plug_template=> 3477413584526840.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 3648913903408259 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'    q      varchar2(4000);'||chr(10)||
'begin'||chr(10)||
'  q := ''select '';'||chr(10)||
'  q:= q || ''''''<label for="f01_''''||rownum||''''" title="Select File"><input type="checkbox" id="f01_''''||rownum||''''" name="f01" value="''''||f.id||''''" /></label>'''' cb,'';'||chr(10)||
'  q:= q || ''htf.anchor(''''f?p=4300:7:''||:flow_session||''::::F4300_P7_LOAD_ID:'''' || dat.id, '';'||chr(10)||
'  q:= q || '' htf.img (''''#IMAGE_PREFIX#24find.gif'''', NULL, NULL, NULL,''''border="0" al';

s:=s||'t="''||wwv_flow_lang.system_message(''F4500.FIND'')||''" height="24" width="24"'''')) "Details",'';'||chr(10)||
'  q:= q || '' htf.anchor (''''wwv_flow_file_mgr.get_file?p_id='''' || to_char(f.id), f.filename) "File", '';'||chr(10)||
'  q:= q || '' dat.created_by "Created By", '';'||chr(10)||
'  q:= q || '' dat.created_on  "Created on", '';'||chr(10)||
'  q:= q || '' decode(data_type,''''ASCII IMPORT'''',wwv_flow_lang.system_message(''''F4300_TEXT_IMPORT'''')) "Type", '';'||chr(10)||
'  ';

s:=s||'q:= q || ''data_Schema "Schema", '';'||chr(10)||
'  q:= q || ''data_table "Table", '';'||chr(10)||
'  q:= q || '' nvl(dbms_lob.getlength (f.blob_content),0) "Bytes",'';'||chr(10)||
'  q:= q || '' success_rows "Succeeded",'';  '||chr(10)||
'  q:= q || '' decode(failed_rows,0,''''0'''',htf.anchor(''''f?p=4300:7:''||:flow_session||''::::F4300_P7_LOAD_ID:'''' || dat.id,'';'||chr(10)||
'  q:= q || '' failed_rows))     "Failed"'';'||chr(10)||
'  q:= q || '' from wwv_flow_file_objects$ f, wwv_flow_data_';

s:=s||'load_unload dat '';'||chr(10)||
'  q:= q || '' where f.id=dat.data_id'' ;'||chr(10)||
'  q:= q || '' and dat.security_group_id =:FLOW_SECURITY_GROUP_ID '';'||chr(10)||
''||chr(10)||
'  if (:F4300_P8_RESTRICT_BY = ''MY'' or :F4300_P8_RESTRICT_BY is NULL)  then'||chr(10)||
'      q:= q || '' and dat.created_by = :FLOW_USER '';'||chr(10)||
'  end if;  '||chr(10)||
'return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4309,
  p_name=> 'リポジトリ',
  p_region_name=>'',
  p_template=> 101735615849237059.4309+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 24534016112516813.4309+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'ファイルが見つかりません',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961216430338008.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CB',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961308847338008.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'Details',
  p_column_display_sequence=> 2,
  p_column_heading=> '詳細',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961403149338008.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'File',
  p_column_display_sequence=> 3,
  p_column_heading=> 'ファイル',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961531529338008.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'Created By',
  p_column_display_sequence=> 4,
  p_column_heading=> 'インポート者',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961610894338008.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'Created on',
  p_column_display_sequence=> 5,
  p_column_heading=> 'インポート日',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961731890338010.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'Type',
  p_column_display_sequence=> 6,
  p_column_heading=> 'タイプ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961804936338010.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'Schema',
  p_column_display_sequence=> 7,
  p_column_heading=> 'スキーマ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234961924524338011.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'Table',
  p_column_display_sequence=> 8,
  p_column_heading=> '表',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234962026814338011.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'Bytes',
  p_column_display_sequence=> 9,
  p_column_heading=> 'バイト',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234962102068338011.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'Succeeded',
  p_column_display_sequence=> 10,
  p_column_heading=> '成功',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234962213306338011.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234960616202337996.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'Failed',
  p_column_display_sequence=> 11,
  p_column_heading=> '失敗',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 130487609243007078.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8.4309,
  p_button_sequence=> 30,
  p_button_plug_id => 3921012881766600+wwv_flow_api.g_id_offset,
  p_button_name    => 'Delete',
  p_button_image_alt=> 'チェックした項目の削除',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'select 1'||chr(10)||
'from wwv_flow_file_objects$ f, wwv_flow_data_load_unload dat'||chr(10)||
'where f.id=dat.data_id'||chr(10)||
'and dat.security_group_id =:FLOW_SECURITY_GROUP_ID',
  p_button_condition_type=> 'EXISTS',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>130488219172007162.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4309,
  p_branch_action=> '8',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>51804488943808398.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4309,
  p_name=>'F4300_P8_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3921012881766600.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'実行',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'ユーザーのファイルまたはすべてのファイルを表示するように指定してください。';

wwv_flow_api.create_page_item(
  p_id=>51821394189864043.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4309,
  p_name=>'F4300_P8_RESTRICT_BY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3921012881766600.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表示',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RESTRICT.LOAD.FILES',
  p_lov => '.'||to_char(87918702852509211 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 346584010124457412.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 165133620695131261.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 8.4309,
  p_validation_name => 'SelectAtLeastOne',
  p_validation_sequence=> 10,
  p_validation => 'wwv_flow.g_f01.count > 0',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => '削除するファイルを1つ以上選択する必要があります。',
  p_when_button_pressed=> 130487609243007078.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 51823819555198806.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'rest pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'    delete from wwv_flow_file_objects$'||chr(10)||
'     where id = wwv_flow.g_f01(i)'||chr(10)||
'     and security_group_id = :flow_security_group_id;'||chr(10)||
''||chr(10)||
'    delete from wwv_flow_data_load_unload'||chr(10)||
'    where data_id = wwv_flow.g_f01(i)'||chr(10)||
'    and security_group_id = :flow_security_group_id;'||chr(10)||
'end loop;';

wwv_flow_api.create_page_process(
  p_id     => 130807727310131197.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete file',
  p_process_sql_clob => p, 
  p_process_error_message=> 'ファイルの削除中にエラーが発生しました。',
  p_process_when_button_id=>130487609243007078.4309 + wwv_flow_api.g_id_offset,
  p_process_when=>'wwv_flow.g_f01.count > 0',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'ファイルが削除されました。',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_9.430
prompt  ...PAGE 9.4309: ロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_imprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 9.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'ロード',
  p_step_title=> 'ロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216950505720834051+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 7505408382227958.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163403',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>9.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6680925060642280.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 51830015797676143.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4309,
  p_plug_name=> 'Data Load',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 74707671328250039 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_customized_name=>'「データのロード」アイコン',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Load data from your computer from various file formats into your online database.');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 9.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_11.43
prompt  ...PAGE 11.4309: スプレッドシートのリポジトリ
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 11.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'スプレッドシートのリポジトリ',
  p_step_title=> 'スプレッドシートのリポジトリ',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 7505408382227958.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163403',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>11.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'3648913903408259';

wwv_flow_api.create_page_plug (
  p_id=> 3655019491438205.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4309,
  p_plug_name=> 'タスク',
  p_region_name=>'',
  p_plug_template=> 3477413584526840.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 3648913903408259 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3925626518780012.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4309,
  p_plug_name=> 'button bar',
  p_region_name=>'',
  p_plug_template=> 108205605860896611.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 9390411712273861.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページには、インポートされたスプレッドシート・データのステータスが表示されます。</p> '||chr(10)||
'<p>ステータス・エントリを削除するには、そのエントリを選択し、「<b>チェックした項目の削除</b>」をクリックしてください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 114705422835023938.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4309,
  p_plug_name=> 'スプレッドシートのリポジトリ',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'    q           varchar2(4000);    '||chr(10)||
'begin    '||chr(10)||
'  q:= q || ''select '';'||chr(10)||
'  q:= q || ''''''<label for="f01_''''||rownum||''''" class="hideMe508">Select Import</label><input id="f01_''''||rownum||''''" type="checkbox" name="f01" value="''''||dat.id||''''">'''' cb,'';'||chr(10)||
'  q:= q || ''htf.anchor(''''f?p=4300:2:''||:flow_session||''::::P2_LOAD_ID:'''' || dat.id, '';'||chr(10)||
'  q:= q || '' htf.img (''''#IMAGE_PREFIX#24find.gif'''', NULL, NULL';

s:=s||', NULL,''''border="0" alt="''||wwv_flow_lang.system_message(''DETAILS_FOR_ALT_TAG'')||''" title="''||wwv_flow_lang.system_message(''DETAILS_FOR_ALT_TAG'')||''" height="24" width="24"'''')) "Details",'';'||chr(10)||
'  q:= q || '' dat.created_by "Created By", '';'||chr(10)||
'  q:= q || '' dat.created_on  "Created on", '';'||chr(10)||
'  q:= q || '' decode (data_type, ''''EXCEL IMPORT'''', wwv_flow_lang.system_message(''''F4300.SPREADSHEET_IMPORT'''')) "Type", ''';

s:=s||';'||chr(10)||
'  q:= q || ''data_Schema "Schema", '';'||chr(10)||
''||chr(10)||
''||chr(10)||
'  q:= q || ''data_table "TABLE", '';  '||chr(10)||
'  q:= q || '' success_rows "Succeeded",'';'||chr(10)||
'  q:= q || '' decode(failed_rows,0,''''0'''',htf.anchor(''''f?p=4300:2:''||:flow_session||''::::P2_LOAD_ID:'''' || dat.id,'';'||chr(10)||
'  q:= q || '' failed_rows))     "Failed", '';'||chr(10)||
'  q:= q || '' o.object_id object_id, o.owner object_owner '';'||chr(10)||
'  q:= q || '' from wwv_flow_data_load_unload dat, sys.dba_object';

s:=s||'s o '';  '||chr(10)||
'  q:= q || '' where o.owner = dat.data_schema '';'||chr(10)||
'  q:= q || '' and o.object_name = dat.data_table '';'||chr(10)||
'  q:= q || '' and o.object_type = ''''TABLE'''' '';'||chr(10)||
'  q:= q || '' and dat.security_group_id =:FLOW_SECURITY_GROUP_ID '';'||chr(10)||
'  q:= q || '' and data_type = ''''EXCEL IMPORT'''''';'||chr(10)||
''||chr(10)||
'  if (:F4300_P11_RESTRICT_BY = ''MY'' or :F4300_P11_RESTRICT_BY is NULL)  then'||chr(10)||
'      q:= q || '' and dat.created_by = :FLOW_USER '';'||chr(10)||
' ';

s:=s||' end if;  '||chr(10)||
'return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4309,
  p_name=> 'Loads',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 10583525904875984.4309+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'データが見つかりません。',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718032272209012.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CB',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718112718209012.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'Details',
  p_column_display_sequence=> 2,
  p_column_heading=> '詳細',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718206872209012.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'Created By',
  p_column_display_sequence=> 3,
  p_column_heading=> 'インポート者',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718310926209013.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'Created on',
  p_column_display_sequence=> 4,
  p_column_heading=> 'インポート日',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718429023209013.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'Type',
  p_column_display_sequence=> 5,
  p_column_heading=> 'タイプ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718526244209013.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'Schema',
  p_column_display_sequence=> 6,
  p_column_heading=> 'スキーマ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718631100209013.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE',
  p_column_display_sequence=> 7,
  p_column_heading=> '表',
  p_column_link=>'f?p=4500:1001:&SESSION.:FOCUS:::OB_OBJECT_ID,OB_CURRENT_TYPE,OB_SCHEMA:#OBJECT_ID#,TABLE,#OBJECT_OWNER#',
  p_column_linktext=>'#TABLE#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718712148209013.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'Succeeded',
  p_column_display_sequence=> 8,
  p_column_heading=> '成功',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234718804458209013.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'Failed',
  p_column_display_sequence=> 9,
  p_column_heading=> '失敗',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 268495509916252852.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'OBJECT_ID',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Object',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 268502322084284781.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 234717428566209000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'OBJECT_OWNER',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Object Owner',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 192155317097767347.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 11.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3925626518780012+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_image_alt=> 'チェックした項目の削除',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'select 1'||chr(10)||
'from wwv_flow_data_load_unload dat, sys.dba_objects o '||chr(10)||
'where o.owner = dat.data_schema'||chr(10)||
'and o.object_name = dat.data_table'||chr(10)||
'and o.object_type = ''TABLE'''||chr(10)||
'and dat.security_group_id =:FLOW_SECURITY_GROUP_ID'||chr(10)||
'and data_type = ''EXCEL IMPORT''',
  p_button_condition_type=> 'EXISTS',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>114703320184023921.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4309,
  p_branch_action=> '11',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>114704228365023929.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4309,
  p_name=>'F4300_P11_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3925626518780012.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'実行',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'ご使用のスプレッドシートのインポートを表示するか、すべてのスプレッドシートのインポートを表示するかを指定してください。';

wwv_flow_api.create_page_item(
  p_id=>114704528502023930.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4309,
  p_name=>'F4300_P11_RESTRICT_BY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3925626518780012.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表示',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RESTRICT.LOAD.FILES',
  p_lov => '.'||to_char(87918702852509211 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 346584010124457412.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 165128603595116797.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 11.4309,
  p_validation_name => 'SelectAtLeastOne',
  p_validation_sequence=> 10,
  p_validation => 'wwv_flow.g_f01.count > 0',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => '削除するファイルを1つ以上選択する必要があります。',
  p_when_button_pressed=> 192155317097767347.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 114704811615023932.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'rest pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'forall i in 1..wwv_flow.g_f01.count'||chr(10)||
'    delete from wwv_flow_data_load_unload'||chr(10)||
'     where id = wwv_flow.g_f01(i)'||chr(10)||
'     and security_group_id = :flow_security_group_id;'||chr(10)||
'commit;';

wwv_flow_api.create_page_process(
  p_id     => 192159607728774014.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete load_unload detail',
  p_process_sql_clob => p, 
  p_process_error_message=> '削除中にエラーが発生しました。',
  p_process_when_button_id=>192155317097767347.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'スプレッドシート・データのロードの詳細が削除されました。',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 11.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_14.43
prompt  ...PAGE 14.4309: XMLデータのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_imprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 14.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'XMLデータのロード',
  p_step_title=> 'XMLデータのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731303316584395+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163403',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>14.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6686730517662783.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 184012102771654838.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 184273927814400294 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 184012414812654843.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4309,
  p_plug_name=> 'XMLデータのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>データをロードする表を所有するデータベース・スキーマを選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 220809403283406944.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4309,
  p_plug_name=> 'XMLデータのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:18');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 184013324637654861.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 184012414812654843+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 184013029848654860.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4309,
  p_button_sequence=> 20,
  p_button_plug_id => 184012414812654843+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>184013925361654916.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4309,
  p_branch_action=> '16',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>184013029848654860.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする表を所有するデータベース・スキーマを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>184013614902654876.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4309,
  p_name=>'F4300_P14_TARGET_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 184012414812654843.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_SCHEMA_OWNERS',
  p_lov => 'select htf.escape_sc(c.schema) d, c.schema v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1'||chr(10)||
'',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- スキーマを選択 - ',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 184014831290654966.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_LAST_VIEW',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '14',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 184015120393654977.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14.4309,
  p_validation_name => 'owner req',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P14_TARGET_SCHEMA',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'スキーマ所有者を指定する必要があります。',
  p_associated_item=> 184013614902654876.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 14.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_16.43
prompt  ...PAGE 16.4309: XMLデータのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 16.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'XMLデータのロード',
  p_step_title=> 'XMLデータのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731303316584395+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163403',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>16.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 75401014067720212.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 184017914613657018.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4309,
  p_plug_name=> 'XMLデータのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 184019711689657038.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 184273927814400294 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>データをロードするデータベース表を選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 220811421637412285.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4309,
  p_plug_name=> 'XMLデータのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 184018802177657027.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 16.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 184017914613657018+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 184018530878657026.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 16.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 184017914613657018+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 184018203910657023.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 16.4309,
  p_button_sequence=> 1,
  p_button_plug_id => 184017914613657018+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREV',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>184020011177657040.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4309,
  p_branch_action=> '17',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>184020313577657044.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4309,
  p_branch_action=> '14',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>184018203910657023.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 06-MAR-2001 16:15 by FLOWS');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>77511523486965113.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4309,
  p_name=>'P16_CASE_SENSITIVE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 184017914613657018.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'CASE.SENSITIVE.Y',
  p_lov => '.'||to_char(87923517360560740 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードするデータベース表を選択してください。デフォルトでは、すべての表名は大文字に変換されます。このデフォルトの動作を無効にするには「<span class="fielddatabold">大/小文字区別</span>」を選択してください。';

wwv_flow_api.create_page_item(
  p_id=>184019113402657028.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4309,
  p_name=>'F4300_P16_TARGET_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 184017914613657018.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP',
  p_named_lov=> 'P16_TABLES',
  p_lov => 'select table_name a, table_name b'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner=:F4300_P14_TARGET_SCHEMA'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表を選択するスキーマの名前';

wwv_flow_api.create_page_item(
  p_id=>184968013620011483.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4309,
  p_name=>'F4300_P16_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 184017914613657018.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ:',
  p_source=>'F4300_P14_TARGET_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 77516011281980481.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P16_TARGET_TABLE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(:F4300_P16_TARGET_TABLE)',
  p_compute_when => 'P16_CASE_SENSITIVE',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 77513614613972038.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4309,
  p_validation_name => 'table exists',
  p_validation_sequence=> 10,
  p_validation => 'select 1'||chr(10)||
'from sys.dba_objects'||chr(10)||
'where owner = :F4300_P14_TARGET_SCHEMA'||chr(10)||
'and object_name = :F4300_P16_TARGET_TABLE'||chr(10)||
'and object_type in (''TABLE'')',
  p_validation_type => 'EXISTS',
  p_error_message => '表が存在しません。',
  p_validation_condition=> 'F4300_P16_TARGET_TABLE',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 184018530878657026.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 184019113402657028.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 184020605388657045.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4309,
  p_validation_name => 'table required',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P16_TARGET_TABLE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '表を指定する必要があります。',
  p_associated_item=> 184019113402657028.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P14_TARGET_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 69930004303898689.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 16.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 16.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_17.43
prompt  ...PAGE 17.4309: XMLデータのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 17.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'XMLデータのロード',
  p_step_title=> 'XMLデータのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731303316584395+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163404',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>17.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 75402620647722110.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 184023412772659950.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4309,
  p_plug_name=> 'XMLデータのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 184025503752659961.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 184273927814400294 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>アップロードするXML文書を検索してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 220812507916417794.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4309,
  p_plug_name=> 'XMLデータのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:17');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 184024300234659954.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 184023412772659950+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 184024014061659952.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 184023412772659950+wwv_flow_api.g_id_offset,
  p_button_name    => 'LOAD',
  p_button_image_alt=> 'データのロード',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 184023723336659951.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4309,
  p_button_sequence=> 1,
  p_button_plug_id => 184023412772659950+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREV',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>184025801444659963.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4309,
  p_branch_action=> '9',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>184024014061659952.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>184026128584659964.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4309,
  p_branch_action=> '16',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>184023723336659951.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 06-MAR-2001 16:15 by FLOWS');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'「<span class="fielddatabold">参照</span>」をクリックして、アップロードするXMLファイルを検索してください。';

wwv_flow_api.create_page_item(
  p_id=>184024932604659957.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4309,
  p_name=>'F4300_P17_FILE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 184023412772659950.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ファイル',
  p_source_type=> 'STATIC',
  p_display_as=> 'FILE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':F4300_P17_FILE is NULL',
  p_display_when_type=>'FLOW_ITEM_IS_NULL',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表のスキーマの名前';

wwv_flow_api.create_page_item(
  p_id=>184976328920019627.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4309,
  p_name=>'F4300_P17_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 184023412772659950.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ:',
  p_source=>'F4300_P14_TARGET_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをアップロードする表の名前';

wwv_flow_api.create_page_item(
  p_id=>184979620725023347.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4309,
  p_name=>'F4300_P17_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 184023412772659950.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名:',
  p_source=>'F4300_P16_TARGET_TABLE',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 184026427466659965.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4309,
  p_validation_name => 'file required',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P17_FILE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'ファイル名を指定する必要があります。',
  p_associated_item=> 184024932604659957.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 288726628477940731.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4309,
  p_validation_name => 'file not 0 byte',
  p_validation_sequence=> 20,
  p_validation => 'declare'||chr(10)||
'  l_doc_size number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select doc_size                     '||chr(10)||
'             from wwv_flow_file_objects$'||chr(10)||
'             where name = :F4300_P17_FILE)'||chr(10)||
'  loop'||chr(10)||
'    l_doc_size := c1.doc_size;'||chr(10)||
'  end loop;'||chr(10)||
'  if l_doc_size = 0 then'||chr(10)||
'    return false;'||chr(10)||
'  end if;'||chr(10)||
'  return true;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'アップロードされたファイルが無効か、コンテンツが含まれていません。  有効なファイルをアップロードしてください。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_blob blob;'||chr(10)||
'  l_clob clob;'||chr(10)||
'  l_sql  varchar2(32767) := null;'||chr(10)||
'  n      wwv_flow_global.vc_arr2;'||chr(10)||
'  r      wwv_flow_global.vc_arr2;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select blob_content'||chr(10)||
'             from  wwv_flow_file_objects$'||chr(10)||
'              where  name = :F4300_P17_FILE) loop'||chr(10)||
'    l_blob := c1.blob_content;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  declare'||chr(10)||
'    l_dest_offset  number := 1;'||chr(10)||
'    l_src_offset   number := 1;'||chr(10)||
'    l_lang_';

p:=p||'context number := dbms_lob.default_lang_ctx;'||chr(10)||
'    l_warning      number;'||chr(10)||
'  begin     '||chr(10)||
'    dbms_lob.createtemporary ( l_clob, FALSE, dbms_lob.SESSION );'||chr(10)||
'    dbms_lob.open( l_blob, dbms_lob.lob_readonly );'||chr(10)||
''||chr(10)||
'    dbms_lob.convertToCLOB('||chr(10)||
'        dest_lob      => l_clob,'||chr(10)||
'        src_blob      => l_blob,'||chr(10)||
'        amount        => dbms_lob.lobmaxsize,'||chr(10)||
'        dest_offset   => l_dest_offset,'||chr(10)||
'        src_offs';

p:=p||'et    => l_src_offset,'||chr(10)||
'        blob_csid     => nls_charset_id(''AL32UTF8''),'||chr(10)||
'        lang_context  => l_lang_context,'||chr(10)||
'        warning       => l_warning );'||chr(10)||
''||chr(10)||
'    dbms_lob.close( l_blob );'||chr(10)||
'  end;'||chr(10)||
''||chr(10)||
'  wwv_flow_utilities.g_xml_clob := l_clob;'||chr(10)||
' '||chr(10)||
'  l_sql := ''declare '';'||chr(10)||
'  l_sql := l_sql||''insCtx DBMS_XMLSave.ctxType; '';'||chr(10)||
'  l_sql := l_sql||''rows number; '';'||chr(10)||
'  l_sql := l_sql||''begin '';'||chr(10)||
'  l_sql := l_sql||''insCt';

p:=p||'x := DBMS_XMLSave.newContext(''''''||:F4300_P14_TARGET_SCHEMA;'||chr(10)||
'  l_sql := l_sql||''.''||:F4300_P16_TARGET_TABLE||''''''); '';'||chr(10)||
'  l_sql := l_sql||''DBMS_XMLSave.setDateFormat(insCtx,''''yyyy-MM-dd''''''''T''''''''HH:mm:ss.SSS''''); '';  '||chr(10)||
'  l_sql := l_sql||''rows := DBMS_XMLSave.insertXML(insCtx,wwv_flow_utilities.g_xml_clob); '';'||chr(10)||
'  l_sql := l_sql||''DBMS_XMLSave.closeContext(insCtx); '';'||chr(10)||
'  l_sql := l_sql||''end;'';'||chr(10)||
'  '||chr(10)||
'  wwv_flo';

p:=p||'w_f4000_util.run_block'||chr(10)||
'          ( p_sql    => l_sql,'||chr(10)||
'            p_user   => :F4300_P14_TARGET_SCHEMA);'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 7873510163151423.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create_load_xml',
  p_process_sql_clob => p, 
  p_process_error_message=> 'XMLのロード中にエラーが発生しました。',
  p_process_when_button_id=>184024014061659952.4309 + wwv_flow_api.g_id_offset,
  p_process_when=>'not wwv_flow_utilities.db_version_is_at_least(''10.1'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'XMLがロードされました。',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_blob blob;'||chr(10)||
'  l_clob clob;'||chr(10)||
'  l_sql  varchar2(32767) := null;'||chr(10)||
'  n      wwv_flow_global.vc_arr2;'||chr(10)||
'  r      wwv_flow_global.vc_arr2;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select blob_content'||chr(10)||
'             from  wwv_flow_file_objects$'||chr(10)||
'              where  name = :F4300_P17_FILE) loop'||chr(10)||
'    l_blob := c1.blob_content;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  declare'||chr(10)||
'    l_dest_offset  number := 1;'||chr(10)||
'    l_src_offset   number := 1;'||chr(10)||
'    l_lang_';

p:=p||'context number := dbms_lob.default_lang_ctx;'||chr(10)||
'    l_warning      number;'||chr(10)||
'  begin     '||chr(10)||
'    dbms_lob.createtemporary ( l_clob, FALSE, dbms_lob.SESSION );'||chr(10)||
'    dbms_lob.open( l_blob, dbms_lob.lob_readonly );'||chr(10)||
''||chr(10)||
'    dbms_lob.convertToCLOB('||chr(10)||
'        dest_lob      => l_clob,'||chr(10)||
'        src_blob      => l_blob,'||chr(10)||
'        amount        => dbms_lob.lobmaxsize,'||chr(10)||
'        dest_offset   => l_dest_offset,'||chr(10)||
'        src_offs';

p:=p||'et    => l_src_offset,'||chr(10)||
'        blob_csid     => nls_charset_id(''AL32UTF8''),'||chr(10)||
'        lang_context  => l_lang_context,'||chr(10)||
'        warning       => l_warning );'||chr(10)||
''||chr(10)||
'    dbms_lob.close( l_blob );'||chr(10)||
'  end;'||chr(10)||
''||chr(10)||
'  wwv_flow_utilities.g_xml_clob := l_clob;'||chr(10)||
' '||chr(10)||
'  l_sql := ''declare '';'||chr(10)||
'  l_sql := l_sql||''insCtx dbms_xmlstore.ctxType; '';'||chr(10)||
'  l_sql := l_sql||''rows number; '';'||chr(10)||
'  l_sql := l_sql||''l_nls_date_format      varchar2(';

p:=p||'255) := null; '';'||chr(10)||
'  l_sql := l_sql||''l_nls_timestamp_format varchar2(255) := null; '';'||chr(10)||
'  l_sql := l_sql||''c_nls_date_format      varchar2(255) := ''''rrrr-MM-dd"T"HH24:mi:ss."000"''''; '';  '||chr(10)||
'  l_sql := l_sql||''c_nls_timestamp_format varchar2(255) := ''''rrrr-MM-dd"T"HH24:mi:ss.FF3''''; '';  '||chr(10)||
'  l_sql := l_sql||''begin '';'||chr(10)||
'  l_sql := l_sql||''for c1 in (select parameter, value '';'||chr(10)||
'  l_sql := l_sql||''           from';

p:=p||' nls_session_parameters '';'||chr(10)||
'  l_sql := l_sql||''           where PARAMETER in (''''NLS_DATE_FORMAT'''',''''NLS_TIMESTAMP_FORMAT'''')) loop '';'||chr(10)||
'  l_sql := l_sql||''  if c1.parameter = ''''NLS_DATE_FORMAT'''' then '';'||chr(10)||
'  l_sql := l_sql||''    l_nls_date_format := c1.value; '';'||chr(10)||
'  l_sql := l_sql||''  elsif c1.parameter = ''''NLS_TIMESTAMP_FORMAT'''' then '';'||chr(10)||
'  l_sql := l_sql||''    l_nls_timestamp_format := c1.value; '';'||chr(10)||
'  l_sql';

p:=p||' := l_sql||''  end if; '';'||chr(10)||
'  l_sql := l_sql||''end loop; '';'||chr(10)||
'  l_sql := l_sql||''dbms_session.set_nls(''''NLS_DATE_FORMAT'''',''''''''''''''''||c_nls_date_format||''''''''''''''''); '';'||chr(10)||
'	l_sql := l_sql||''dbms_session.set_nls(''''NLS_TIMESTAMP_FORMAT'''',''''''''''''''''||c_nls_timestamp_format||''''''''''''''''); '';'||chr(10)||
'  l_sql := l_sql||''insCtx := dbms_xmlstore.newContext(''''''||:F4300_P14_TARGET_SCHEMA;'||chr(10)||
'  l_sql := l_sql||''.''||:F4300_P16_TARGET_TA';

p:=p||'BLE||''''''); '';  '||chr(10)||
'  l_sql := l_sql||''dbms_xmlstore.setRowTag(insCtx,''''ROW''''); '';'||chr(10)||
'  l_sql := l_sql||''rows := dbms_xmlstore.insertXML(insCtx,wwv_flow_utilities.g_xml_clob); '';'||chr(10)||
'  l_sql := l_sql||''dbms_xmlstore.closeContext(insCtx); '';'||chr(10)||
'  l_sql := l_sql||''dbms_session.set_nls(''''NLS_DATE_FORMAT'''',''''''''''''''''||l_nls_date_format||''''''''''''''''); '';'||chr(10)||
'  l_sql := l_sql||''dbms_session.set_nls(''''NLS_TIMESTAMP_FORMAT'''',''''';

p:=p||'''''''''''''||l_nls_timestamp_format||''''''''''''''''); '';'||chr(10)||
'  l_sql := l_sql||''end;'';'||chr(10)||
'  '||chr(10)||
'  wwv_flow_f4000_util.run_block'||chr(10)||
'          ( p_sql    => l_sql,'||chr(10)||
'            p_user   => :F4300_P14_TARGET_SCHEMA);'||chr(10)||
'/*exception when others then'||chr(10)||
'  wwv_flow.show_error_message(p_message  => '||chr(10)||
'         wwv_flow_lang.system_message(p_name=>''XML_LOAD_ERROR''), '||chr(10)||
'         p_footer   => null); '||chr(10)||
'*/'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 184026726681659973.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17.4309,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> '10.1 or greater:  create_load_xml',
  p_process_sql_clob => p, 
  p_process_error_message=> 'XMLのロード中にエラーが発生しました。',
  p_process_when_button_id=>184024014061659952.4309 + wwv_flow_api.g_id_offset,
  p_process_when=>'wwv_flow_utilities.db_version_is_at_least(''10.1'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'XMLがロードされました。',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P14_TARGET_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 69932630276906146.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17.4309,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 17.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_18.43
prompt  ...PAGE 18.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_imprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 18.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163404',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>18.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2157120477803132.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> 'アップロードするファイルは、テキスト・ベースである必要があります。.XLSファイルをアップロードするには、まずCSVとして保存します。<p />'||chr(10)||
'',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:17');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  Plain Text Data Import';

wwv_flow_api.create_page_plug (
  p_id=> 3939910944851245.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 3931814922814551 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6827802000688027.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 21283612328451431.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4309,
  p_plug_name=> 'グローバリゼーション',
  p_region_name=>'',
  p_plug_template=> 21175625245088699.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2158019343803135.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 2157120477803132+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2158311458803135.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4309,
  p_button_sequence=> 30,
  p_button_plug_id => 2157120477803132+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2158218927803135.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4309,
  p_button_sequence=> 20,
  p_button_plug_id => 2157120477803132+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>2586909632661028.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_branch_action=> '18',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_branch_condition=> 'F4300_P18_REUPLOAD',
  p_branch_condition_text=>'Y',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 24-SEP-2002 09:16 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>2159723337803140.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_branch_action=> '19',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2158311458803135.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
wwv_flow_api.create_page_branch(
  p_id=>2158707886803137.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_branch_action=> '9',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2158019343803135.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
wwv_flow_api.create_page_branch(
  p_id=>2159221254803139.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_branch_action=> '230',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2158218927803135.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'「<span class="fielddatabold">参照</span>」をクリックして、アップロードするファイルを検索してください。';

wwv_flow_api.create_page_item(
  p_id=>2157814244803134.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'F4300_P13_FILE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2157120477803132.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'テキスト・ファイル',
  p_source_type=> 'STATIC',
  p_display_as=> 'FILE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P13_FILE',
  p_display_when_type=>'ITEM_IS_NULL',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データの最初の行に列名が含まれる場合は、このボックスを選択してください。</p>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'<pre>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'名前     給与     コミッション'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Clark    1000       10'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Scott    2000       20'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'</pre>';

wwv_flow_api.create_page_item(
  p_id=>2243727316068250.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'F4300_P13_IS_COLUMN_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 2157120477803132.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'ISCOLUMN.NAME.TEXT',
  p_lov => 'select ''<span class="instructiontext">''||'||chr(10)||
'wwv_flow_lang.system_message(''F4300_INSTRUCT_TEXT'')||''</span>'' d, ''Y'' r from dual',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'列セパレータ文字を指定してください。タブ・セパレータには<code>\t</code>を使用してください。';

wwv_flow_api.create_page_item(
  p_id=>2329615063755442.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'F4300_P13_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 2157120477803132.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => ',',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'セパレータ: (\tはタブ)',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'アップロードするファイルの名前';

wwv_flow_api.create_page_item(
  p_id=>2583912702633467.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'F4300_P18_FILE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 2157120477803132.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ファイル名:',
  p_source=>'substr(:F4300_P13_FILE,instr(:F4300_P13_FILE,''/'')+1)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P13_FILE',
  p_display_when_type=>'ITEM_IS_NOT_NULL',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'ファイルを再アップロードするように指定 ';

wwv_flow_api.create_page_item(
  p_id=>2586326817656557.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'F4300_P18_REUPLOAD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 2157120477803132.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ファイルを再アップロード',
  p_display_as=> 'COMBOBOX_WITH_SUBMIT',
  p_named_lov=> 'YES.NO.RETURNS_Y_OR_N',
  p_lov => '.'||to_char(87930425596657700 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P13_FILE',
  p_display_when_type=>'ITEM_IS_NOT_NULL',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<div class="htmldbInfoBodyP">デリミタ文字を入力してください。この文字を使用して、データ値の開始境界および終了境界を区切ることができます。デリミタ文字を指定すると、データ・ワークショップではデータ値の開始境界および終了境界の前の空白が無視されます。また、このオプションを使用して、指定したデリミタ文字でデータ値を囲むことができます。</div>'||chr(10)||
'<div class="htmldbInfoBodyP">1行目に列名が含まれている場合は、「<span class="fielddatabold">1行目のデータに列名が含まれる</span>」を選択してください。</div>'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>2764003228797653.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'F4300_P13_ENCLOSED_BY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 2157120477803132.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'囲み文字(オプション)',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データに国際通貨記号が含まれている場合は、その記号をここに入力してください。</p>'||chr(10)||
'<p>たとえば、データに&euro;1,234.56または&yen;1,234.56が含まれている場合は、&euro;または&yen;と入力してください。  入力しない場合、データは正常にロードされません。</p>';

wwv_flow_api.create_page_item(
  p_id=>21284319254453394.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'P18_CURRENCY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 21283612328451431.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'declare'||chr(10)||
'    l_return_val varchar2(30) := ''$'';'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select value'||chr(10)||
'                 from nls_session_parameters'||chr(10)||
'                where parameter = ''NLS_CURRENCY'') loop'||chr(10)||
'        l_return_val := c1.value;'||chr(10)||
'        exit;'||chr(10)||
'    end loop;'||chr(10)||
'    --'||chr(10)||
'    return l_return_val;'||chr(10)||
'end;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'通貨記号',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>グループ・セパレータは、千の位や百万の位などの整数グループを区切ります。</p>'||chr(10)||
'<p>グループ・セパレータには、任意の文字を指定できます。指定した文字はシングルバイトで、グループ・セパレータは他の小数点文字と異なる必要があります。セパレータには、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21931121693474165.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'P18_GROUP_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 21283612328451431.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_group_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'グループ・セパレータ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>小数点文字は、数値の整数部分と小数部分を区切ります。</p>'||chr(10)||
'<p>小数点文字には、任意の文字を指定できます。指定した文字はシングルバイトで、小数点文字はグループ・セパレータと異なる必要があります。小数点文字には、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21932028965476228.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'P18_DECIMAL_CHARACTER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 21283612328451431.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_decimal_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'小数点文字',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'テキスト・ファイルをエンコードするキャラクタ・セットを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>143068503644769301.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_name=>'P18_FILE_CHARSET',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 45,
  p_item_plug_id => 2157120477803132.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'nvl(lower(trim(owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))),''utf-8'')',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'ファイルのキャラクタ・セット',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'I18N_IANA_CHARSET',
  p_lov => '.'||to_char(135399325911344822 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 49531609285689625.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_computation_sequence => 20,
  p_computation_item=> 'F4300_P13_IS_COLUMN_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'N',
  p_compute_when => 'F4300_P13_IS_COLUMN_NAME',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 2601228838903096.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P18_REUPLOAD',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'N',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2959116096955698.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18.4309,
  p_validation_name => 'file name not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P13_FILE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '「名」に値を指定する必要があります。',
  p_when_button_pressed=> 2158311458803135.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2157814244803134.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 165112819562074156.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18.4309,
  p_validation_name => 'SeparatorMand',
  p_validation_sequence=> 20,
  p_validation => 'F4300_P13_SEPARATOR',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'セパレータを指定する必要があります。',
  p_when_button_pressed=> 2158311458803135.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2329615063755442.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52214713959981319.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18.4309,
  p_validation_name => 'file not 0 byte',
  p_validation_sequence=> 30,
  p_validation => 'declare'||chr(10)||
'  l_doc_size number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select doc_size                     '||chr(10)||
'             from wwv_flow_file_objects$'||chr(10)||
'             where name = :F4300_P13_FILE)'||chr(10)||
'  loop'||chr(10)||
'    l_doc_size := c1.doc_size;'||chr(10)||
'  end loop;'||chr(10)||
'  if l_doc_size = 0 then'||chr(10)||
'    return false;'||chr(10)||
'  end if;'||chr(10)||
'  return true;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'アップロードされたファイルが無効か、コンテンツが含まれていません。  有効なファイルをアップロードしてください。',
  p_when_button_pressed=> 2158311458803135.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245259621035850537.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18.4309,
  p_validation_name => 'not valid file extension',
  p_validation_sequence=> 40,
  p_validation => 'return wwv_flow_load_data.valid_file_extension (p_filename => :F4300_P13_FILE)',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'ファイルに無効なファイル拡張子が含まれています。バイナリ・ファイル形式はサポートされていません。',
  p_when_button_pressed=> 2158311458803135.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2583912702633467.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare  '||chr(10)||
'  l_first_row_is_col_name boolean := false;'||chr(10)||
'  l_file_id               number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select id             '||chr(10)||
'             from wwv_flow_file_objects$'||chr(10)||
'             where name = :F4300_P13_FILE)'||chr(10)||
'  loop'||chr(10)||
'    l_file_id := c1.id;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  if l_file_id != 0 then'||chr(10)||
'    if :F4300_P13_IS_COLUMN_NAME = ''Y'' then'||chr(10)||
'      l_first_row_is_col_name := true;'||chr(10)||
'    end if;'||chr(10)||
'    wwv_flow_load';

p:=p||'_data.create_csv_collection ('||chr(10)||
'     p_file_id                => l_file_id,'||chr(10)||
'     p_separator              => lower(:F4300_P13_SEPARATOR),'||chr(10)||
'     p_enclosed_by            => :F4300_P13_ENCLOSED_BY,  '||chr(10)||
'     p_first_row_is_col_name  => l_first_row_is_col_name,'||chr(10)||
'     p_currency               => :P18_CURRENCY,'||chr(10)||
'     p_numeric_chars          => :P18_DECIMAL_CHARACTER||:P18_GROUP_SEPARATOR,'||chr(10)||
'     p_charset      ';

p:=p||'          => :P18_FILE_CHARSET'||chr(10)||
'     );'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 2324003064685753.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create table info collection',
  p_process_sql_clob => p, 
  p_process_error_message=> 'ロードしたデータを使用してコレクションを作成中に、エラーが発生しました。',
  p_process_when_button_id=>2158311458803135.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from wwv_flow_file_objects$'||chr(10)||
'where name = :F4300_P13_FILE;'||chr(10)||
''||chr(10)||
':F4300_P13_FILE := null;';

wwv_flow_api.create_page_process(
  p_id     => 23875226415655164.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4309,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete file and reupload',
  p_process_sql_clob => p, 
  p_process_error_message=> 'ファイルを削除できません。',
  p_process_when=>'F4300_P18_REUPLOAD',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_process_when2=>'Y',
  p_process_when_type2=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 18.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_19.43
prompt  ...PAGE 19.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph:=ph||'<script type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
'function f_ImportDataTypeOnload(){'||chr(10)||
'var lRow = html_GetElement(''importData'').rows[1];'||chr(10)||
'var lSelects = lRow.getElementsByTagName(''SELECT'');'||chr(10)||
'var lLength = lSelects.length;'||chr(10)||
'for(var i=0;i<lLength;i++){lSelects[i].onchange()}'||chr(10)||
'return;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
''||chr(10)||
'function f_ImportDataType(pThis,pThat){  '||chr(10)||
'var lCheckValues = new Array(''NUMBER'',''CLOB'',''DATE'',''BINARY_FLOAT'',''BINARY_DOUBLE'');'||chr(10)||
'  va';

ph:=ph||'r lTest2 = html_DisableOnValue(pThis,lCheckValues,pThat);'||chr(10)||
'  html_GetElement(pThat).disabled = false;'||chr(10)||
'  if(lTest2){'||chr(10)||
'    html_GetElement(pThat).setAttribute(''onfocus'',''this.blur()'');'||chr(10)||
'    }else{'||chr(10)||
'    html_GetElement(pThat).setAttribute(''onfocus'','''');'||chr(10)||
'  }'||chr(10)||
''||chr(10)||
'}'||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 19.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_html_page_onload=>'onload="f_ImportDataTypeOnload()"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163404',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>19.4309,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>19.4309,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2160319726803142.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:17');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_load_data.display_ntable_property(p_collection_name => ''CSV_IMPORT'' );';

wwv_flow_api.create_page_plug (
  p_id=> 2252818489103487.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4309,
  p_plug_name=> '表のプロパティを設定',
  p_region_name=>'',
  p_plug_template=> 279748823389483962.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  Plain Text Data Import';

wwv_flow_api.create_page_plug (
  p_id=> 3940715792852571.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 3931814922814551 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6829226934695175.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページでは、新しい表の外観をプレビューできます。表名を入力し、列名またはデータ型を変更し、挿入する列を指定してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221480323469295765.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2161222197803145.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 2160319726803142+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2161511969803145.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4309,
  p_button_sequence=> 30,
  p_button_plug_id => 2160319726803142+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2161401612803145.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4309,
  p_button_sequence=> 20,
  p_button_plug_id => 2160319726803142+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>2162930496803151.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_branch_action=> '21',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2161511969803145.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
wwv_flow_api.create_page_branch(
  p_id=>2161926887803146.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_branch_action=> '9',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2161222197803145.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
wwv_flow_api.create_page_branch(
  p_id=>2162430587803150.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_branch_action=> '18',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2161401612803145.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データを作成してロードするデータベース・スキーマを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>2161012050803145.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_name=>'F4300_P13_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2160319726803142.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'CREATE_TABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  q:=q||''select htf.escape_sc(c.schema) d, c.schema v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  if wwv_flow_global.g_xe then'||chr(10)||
'    q:=q||''  and exists (select null '';'||chr(10)||
'    q:=q||''              from sys.dba_sys_privs '';'||chr(10)||
'    q:=q||''              where privilege = ''''CREATE TABLE'''' '';'||chr(10)||
'    q:=q||''              and grantee = c.schema '';'||chr(10)||
'    q:=q||''              union all '';'||chr(10)||
'    q:=q||''              select null '';'||chr(10)||
'    q:=q||''              from sys.dba_sys_privs s, sys.dba_role_privs r '';'||chr(10)||
'    q:=q||''              where r.granted_role=s.grantee '';'||chr(10)||
'    q:=q||''              and r.grantee = c.schema '';'||chr(10)||
'    q:=q||''              and s.privilege = ''''CREATE TABLE'''') '';'||chr(10)||
'  else'||chr(10)||
'    q:=q||''  and exists (select null '';'||chr(10)||
'    q:=q||''               from sys.dba_sys_privs '';'||chr(10)||
'    q:=q||''               where privilege = ''''CREATE TABLE'''' '';'||chr(10)||
'    q:=q||''                 and grantee = c.schema)     '';'||chr(10)||
'  end if;         '||chr(10)||
'  q:=q||''  and exists (select null '';'||chr(10)||
'  q:=q||''                from sys.dba_users '';'||chr(10)||
'  q:=q||''               where username = c.schema) '';'||chr(10)||
'  q:=q||''order by 1 '';'||chr(10)||
'  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'return wwv_flow_global.g_xe',
  p_read_only_when_type=>'FUNCTION_BODY',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'作成する表名を指定してください。デフォルトでは、すべての表名は大文字に変換されます。このデフォルトの動作を無効にするには「<span class="fielddatabold">大/小文字を保持</span>」を選択してください。';

wwv_flow_api.create_page_item(
  p_id=>2267110534176923.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_name=>'F4300_P13_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 2160319726803142.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2269730619182732.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_name=>'F4300_P19_DUMMY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 2160319726803142.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Dummy',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>77772602360009347.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_name=>'P19_PRESERVE_CASE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 2160319726803142.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'PRESERVE.CASE.Y',
  p_lov => '.'||to_char(87931511182663028 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 77778717729023209.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_computation_sequence => 5,
  p_computation_item=> 'F4300_P13_TABLE_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(replace(wwv_flow_utilities.remove_spaces(:F4300_P13_TABLE_NAME),chr(32),''_''))',
  p_compute_when => 'P19_PRESERVE_CASE',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 2611527265139214.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P19_DUMMY',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'  l_col_name varchar2(4000) := null;'||chr(10)||
'begin'||chr(10)||
'for i in 1..wwv_flow.g_f06.count loop'||chr(10)||
'  if :P19_PRESERVE_CASE is null then'||chr(10)||
'    l_col_name := upper(wwv_flow_utilities.remove_spaces(wwv_flow.g_f01(i)));'||chr(10)||
'  else'||chr(10)||
'    l_col_name := wwv_flow_utilities.remove_spaces(wwv_flow.g_f01(i));'||chr(10)||
'  end if;'||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 1,'||chr(10)||
'     p_attr_value => l_col_name'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 2,'||chr(10)||
'     p_attr_value => wwv_flow.g_f02(i)'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 4,'||chr(10)||
'     p_attr_value => wwv_flow.g_f04(i)'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 5,'||chr(10)||
'     p_attr_value => wwv_flow.g_f05(i)'||chr(10)||
'     );'||chr(10)||
'     '||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 6,'||chr(10)||
'     p_attr_value => wwv_flow.g_f07(i)'||chr(10)||
'     );  '||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'return ''true'';'||chr(10)||
''||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2615902509169951.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'column name not null, not > 30',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
'begin'||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
''||chr(10)||
'  if wwv_flow.g_f04(i) = ''Y'' '||chr(10)||
'    then'||chr(10)||
'    if wwv_flow.g_f01(i) is not null then'||chr(10)||
'      if length(wwv_flow.g_f01(i)) > 30 then'||chr(10)||
'        return wwv_flow_lang.system_message(''F4300.COL_NAMES_NOT_LONGER_THAN_30'');'||chr(10)||
'      end if;'||chr(10)||
'    else'||chr(10)||
'      return wwv_flow_lang.system_message(''F4300.COL_NAMES_NOT_NULL'');'||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '列名エラーです。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2617025019176456.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'table name not > 30',
  p_validation_sequence=> 20,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'if length(:F4300_P13_TABLE_NAME) > 30 then'||chr(10)||
''||chr(10)||
'  return wwv_flow_lang.system_message(''F4300.TABLE_NAMES_NOT_LONGER_THAN_30'');'||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '表名が長すぎます。',
  p_associated_item=> 2267110534176923.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2617811990182089.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'at least one upload selected',
  p_validation_sequence=> 30,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'  l_no_count number := 0;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f04.count loop'||chr(10)||
''||chr(10)||
'    if wwv_flow.g_f04(i) = ''N'' then'||chr(10)||
''||chr(10)||
'      l_no_count := l_no_count + 1;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_no_count = wwv_flow.g_f04.count then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '1つ以上の列を指定して、新しい表に含める必要があります。 ',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2618831730187776.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'cannot have same table name',
  p_validation_sequence=> 40,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'if wwv_flow_load_excel_data.table_exists('||chr(10)||
''||chr(10)||
'  p_schema => :F4300_P13_OWNER,'||chr(10)||
''||chr(10)||
'  p_table_name => wwv_flow_utilities.remove_spaces(:F4300_P13_TABLE_NAME)'||chr(10)||
''||chr(10)||
'  ) then'||chr(10)||
''||chr(10)||
'  return wwv_flow_lang.system_message(''F4300.F4500.TABLE_ALREADY_EXISTS'');'||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '既存のオブジェクトですでに使用されている名前です。',
  p_associated_item=> 2267110534176923.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2620211429191428.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'table name not null',
  p_validation_sequence=> 50,
  p_validation => 'F4300_P13_TABLE_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '表名を指定する必要があります。',
  p_associated_item=> 2267110534176923.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2622018486202935.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'column length not zero or null',
  p_validation_sequence=> 70,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f05.count loop'||chr(10)||
''||chr(10)||
'    if wwv_flow.g_f05(i) is not null then'||chr(10)||
''||chr(10)||
'      if wwv_flow.g_f05(i) = 0 then'||chr(10)||
''||chr(10)||
'        return wwv_flow_lang.system_message(''F4300.COL_LENGTH_NOT_ZERO'');'||chr(10)||
''||chr(10)||
'      end if;'||chr(10)||
''||chr(10)||
'    else'||chr(10)||
''||chr(10)||
'      return wwv_flow_lang.system_message(''F4300.COL_LENGTH_NOT_NULL'');'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '列長エラーです。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 290889128494860177.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'reserved name',
  p_validation_sequence=> 80,
  p_validation => 'if wwv_flow_sw_util.is_database_reserved_word(p_word=>:F4300_P13_TABLE_NAME) then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '指定された表名は、Oracleの予約語です。  別の名前を選択してください。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 291061510906810726.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'column name reserved word',
  p_validation_sequence=> 90,
  p_validation => 'for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'  if wwv_flow_sw_util.is_database_reserved_word(p_word=>upper(wwv_flow.g_f01(i))) then'||chr(10)||
'    return false;'||chr(10)||
'  end if;'||chr(10)||
'end loop;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '指定された列名は、Oracleの予約語です。  別の名前を選択してください。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 25617203076189584.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_validation_name => 'F4300_P13_OWNER',
  p_validation_sequence=> 100,
  p_validation => 'F4300_P13_OWNER',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'スキーマを指定する必要があります。',
  p_when_button_pressed=> 2161511969803145.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2161012050803145.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'if :F4300_P13_OWNER is not null then'||chr(10)||
'wwv_flow_sw_api.check_priv(:F4300_P13_OWNER);'||chr(10)||
'end if;';

wwv_flow_api.create_page_process(
  p_id     => 70050317817678488.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 19.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 19.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_21.43
prompt  ...PAGE 21.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
'function displayPrimaryKey(theItem)'||chr(10)||
'{'||chr(10)||
'  if (theItem.value == ''EXISTING_KEY'')'||chr(10)||
'  {'||chr(10)||
'     disableItems(''document.getElementById(\''P13_PK1_OPTION\'').value = \''EXISTING_KEY\'''','||chr(10)||
'                  ''P13_PK1_2'');  '||chr(10)||
'     disableItems(''document.getElementById(\''P13_PK1_OPTION\'').value != \''EXISTING_KEY\'''','||chr(10)||
'                  ''P13_PK1'');                ';

ph:=ph||'      '||chr(10)||
'  }'||chr(10)||
'  else if (theItem.value == ''NEW_KEY'')'||chr(10)||
'  {'||chr(10)||
'     disableItems(''document.getElementById(\''P13_PK1_OPTION\'').value = \''NEW_KEY\'''','||chr(10)||
'                  ''P13_PK1'');     '||chr(10)||
'     disableItems(''document.getElementById(\''P13_PK1_OPTION\'').value != \''NEW_KEY\'''','||chr(10)||
'                  ''P13_PK1_2'');                                      '||chr(10)||
'  }  '||chr(10)||
'}'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 21.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163404',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>21.4309,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>21.4309,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2163507507803153.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_footer=> '<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
'displayPrimaryKey(document.getElementById(''P13_PK1_OPTION''));'||chr(10)||
'//-->'||chr(10)||
'</script>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:17');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  Plain Text Data Import';

wwv_flow_api.create_page_plug (
  p_id=> 3941420987854137.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 3931814922814551 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6830404555698181.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページを使用すると、表の主キーを指定できます。データ・セット内のいずれの列も主キーとして適切でない場合は、新しい列を主キーとして指定してください。主キーは、表の行を一意に識別するために使用されます。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221484502607308603.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2164426793803154.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 21.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 2163507507803153+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 21.4309,
  p_button_sequence=> 30,
  p_button_plug_id => 2163507507803153+wwv_flow_api.g_id_offset,
  p_button_name    => 'FINISH',
  p_button_image_alt=> 'データのロード',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2164626737803154.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 21.4309,
  p_button_sequence=> 20,
  p_button_plug_id => 2163507507803153+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>2166126845803162.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_branch_action=> '8',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2164724759803154.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
wwv_flow_api.create_page_branch(
  p_id=>29899701983651170.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_branch_action=> '21',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 30,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'P13_PK_TYPE',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 05-FEB-2003 11:30 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>52491202943423441.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_branch_action=> 'f?p=&FLOW_ID.:21:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 02-JUN-2003 11:08 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>2165605436803157.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_branch_action=> '19',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2164626737803154.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする表を所有するスキーマです。';

wwv_flow_api.create_page_item(
  p_id=>2164212316803154.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'F4300_P21_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ:',
  p_source=>'F4300_P13_OWNER',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする表の名前';

wwv_flow_api.create_page_item(
  p_id=>2290019463274070.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'F4300_P21_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名:',
  p_source=>'F4300_P13_TABLE_NAME',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表の主キーとなる列を指定してください。主キーは行を一意に識別する列です。Oracleでは表が主キーを持つ必要はありませんが、このウィザードでは主キーを指定する必要があります。';

wwv_flow_api.create_page_item(
  p_id=>29865802488537862.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P13_PK1',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'主キー',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(c001)||''(''||c002||'')'' a, c001'||chr(10)||
'  from wwv_flow_collections'||chr(10)||
' where collection_name = ''CSV_IMPORT'' and c001 is not null'||chr(10)||
' order by seq_id'||chr(10)||
'',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 主キーの選択 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P13_PK1_OPTION',
  p_display_when2=>'EXISTING_KEY',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キー制約名を入力してください。';

wwv_flow_api.create_page_item(
  p_id=>29868930193545840.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P13_PK1_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'主キー制約名',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キーの計算方法を選択してください。または、主キー値を設定しないように選択してください。';

wwv_flow_api.create_page_item(
  p_id=>29871919935552356.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P13_PK_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'NEW_SEQUENCE',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'主キーの移入',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP_WITH_SUBMIT',
  p_named_lov=> 'PK_TYPES',
  p_lov => '.'||to_char(29232624018252340 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キー値を移入するために使用する既存のデータベース順序の名前を指定してください。';

wwv_flow_api.create_page_item(
  p_id=>29874226299563636.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P13_EXISTING_SEQUENCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'順序',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(sequence_name) d, sequence_name v'||chr(10)||
' from sys.dba_sequences '||chr(10)||
'where sequence_owner = :F4300_P13_OWNER'||chr(10)||
'order by sequence_name',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 順序の選択 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P13_PK_TYPE',
  p_display_when2=>'EXISTING_SEQUENCE',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'この新しい表の主キーを移入するために作成される新しいデータベース順序の名前を指定してください。';

wwv_flow_api.create_page_item(
  p_id=>29876013271569281.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P13_NEW_SEQUENCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'順序',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P13_PK_TYPE',
  p_display_when2=>'NEW_SEQUENCE',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>51746727944629094.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P21_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キーとして既存の列を選択することも、新しい列を追加することもできます。';

wwv_flow_api.create_page_item(
  p_id=>52479416748399039.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P13_PK1_OPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'NEW_KEY',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'主キーの移入元:',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP_WITH_SUBMIT',
  p_named_lov=> 'USE.EXISTING.COL',
  p_lov => '.'||to_char(87933423434676001 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'新しい主キー列の名前を入力してください。';

wwv_flow_api.create_page_item(
  p_id=>52483906836405605.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_name=>'P13_PK1_2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 45,
  p_item_plug_id => 2163507507803153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'ID',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'新しい主キー列',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P13_PK1_OPTION',
  p_display_when2=>'NEW_KEY',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 29883807645586566.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P13_PK1_NAME',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'wwv_flow_sw_util.generate_pk_name(replace(:F4300_P13_TABLE_NAME,'' '',''_''));',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 29885422537590887.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P13_NEW_SEQUENCE',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'wwv_flow_sw_util.generate_seq_name(replace(:F4300_P13_TABLE_NAME,'' '',''_''));',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 29887722321600349.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P13_PK1',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'begin'||chr(10)||
'   for c1 in ('||chr(10)||
'     select c001'||chr(10)||
'     from wwv_flow_collections'||chr(10)||
'     where collection_name = ''CSV_IMPORT'''||chr(10)||
'     and upper(c001) = ''ID'''||chr(10)||
'   ) loop'||chr(10)||
'     return c1.c001;'||chr(10)||
'   end loop;'||chr(10)||
'   for c1 in ('||chr(10)||
'     select c001'||chr(10)||
'     from wwv_flow_collections'||chr(10)||
'     where collection_name = ''CSV_IMPORT'''||chr(10)||
'     and upper(c001) like ''%ID'''||chr(10)||
'   ) loop'||chr(10)||
'     return c1.c001;'||chr(10)||
'   end loop;'||chr(10)||
'end;',
  p_compute_when => 'P13_PK1',
  p_compute_when_type=>'ITEM_IS_NULL_OR_ZERO');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 48784624982313991.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P13_PK1_2',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'    l_pk    varchar2(40) := null;'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select c001'||chr(10)||
'                 from wwv_flow_collections'||chr(10)||
'                where collection_name = ''CSV_IMPORT'''||chr(10)||
'                  and upper(c001) = ''ID'') '||chr(10)||
'    loop'||chr(10)||
'        for i in 1..10 loop'||chr(10)||
'            for c2 in (select c001'||chr(10)||
'                         from wwv_flow_collections'||chr(10)||
'                        where collection_name = ''CSV_IMPORT'''||chr(10)||
'                          and upper(c001) = ''ID''||i) '||chr(10)||
'            loop'||chr(10)||
'                l_pk := ''ID'';'||chr(10)||
'            end loop;--c2'||chr(10)||
'            if l_pk is null then'||chr(10)||
'                return ''ID''||i;'||chr(10)||
'            else'||chr(10)||
'                l_pk := null;'||chr(10)||
'            end if;'||chr(10)||
'        end loop;--i'||chr(10)||
'    end loop;--c1'||chr(10)||
'    return ''ID'';'||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29890322799609950.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'ExSEQUENCE not null',
  p_validation_sequence=> 10,
  p_validation => 'P13_EXISTING_SEQUENCE',
  p_validation_type => 'ITEM_NOT_ZERO',
  p_error_message => '順序を指定する必要があります。',
  p_validation_condition=> 'P13_PK_TYPE',
  p_validation_condition2=> 'EXISTING_SEQUENCE',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29874226299563636.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29894220852618813.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'PK_NAME available',
  p_validation_sequence=> 20,
  p_validation => 'begin'||chr(10)||
''||chr(10)||
'if not wwv_flow_builder.is_valid_identifier(''"''||:P13_PK1_NAME||''"'') '||chr(10)||
'   then return '||chr(10)||
'        wwv_flow_lang.system_message(''F4300.NOT_VALID_PK_NAME'',:P13_PK1_NAME);'||chr(10)||
'end if;'||chr(10)||
'    '||chr(10)||
'if not wwv_flow_sw_util.is_available_name(:P13_PK1_NAME, :F4300_P21_OWNER ) '||chr(10)||
'   then return '||chr(10)||
'    wwv_flow_lang.system_message(''F4300.F4500.NAME_ALREADY_USED'',:P13_PK1_NAME);'||chr(10)||
'    end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'エラーです。',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29868930193545840.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29895317520627355.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'ExistingPK not null',
  p_validation_sequence=> 30,
  p_validation => 'P13_PK1',
  p_validation_type => 'ITEM_NOT_NULL_OR_ZERO',
  p_error_message => '主キーを指定する必要があります。',
  p_validation_condition=> 'P13_PK1_OPTION',
  p_validation_condition2=> 'EXISTING_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29865802488537862.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52517420651456956.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'NewPK not null',
  p_validation_sequence=> 35,
  p_validation => 'P13_PK1_2',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '主キーを指定する必要があります。',
  p_validation_condition=> 'P13_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 52483906836405605.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52521315588464886.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'PK not > 30 chars',
  p_validation_sequence=> 38,
  p_validation => 'if length(:P13_PK1_2) > 30 then'||chr(10)||
'  return false;'||chr(10)||
'end if;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '主キー列名は30文字を超えて指定できません。',
  p_validation_condition=> 'P13_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 52483906836405605.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52522413641473849.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'PK gen option needs to be auto',
  p_validation_sequence=> 39,
  p_validation => 'if :P13_PK_TYPE = ''NOT_GENERATED'' then'||chr(10)||
'  return false;'||chr(10)||
'end if;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '新しい主キーを作成するときは、主キーを順序から生成する必要があります。',
  p_validation_condition=> 'P13_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29871919935552356.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29896704837633092.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'PK_NAME not null',
  p_validation_sequence=> 40,
  p_validation => 'P13_PK1_NAME',
  p_validation_type => 'ITEM_NOT_NULL_OR_ZERO',
  p_error_message => '主キー名を指定する必要があります。',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29868930193545840.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29898416743646038.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'SEQ_NAME available',
  p_validation_sequence=> 50,
  p_validation => 'if not wwv_flow_builder.is_valid_identifier(''"''||:P13_NEW_SEQUENCE||''"'') then'||chr(10)||
'   return wwv_flow_lang.system_message(''F4300.F4500.NOT_VALID_SEQ_NAME'',:P13_NEW_SEQUENCE);'||chr(10)||
'end if;'||chr(10)||
'    '||chr(10)||
'if not wwv_flow_sw_util.is_available_name(:P13_NEW_SEQUENCE, :F4300_P21_OWNER) then'||chr(10)||
'   return wwv_flow_lang.system_message(''F4300.F4500.NAME_ALREADY_USED'',:P13_NEW_SEQUENCE);'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'エラーです。',
  p_validation_condition=> 'P13_PK_TYPE',
  p_validation_condition2=> 'NEW_SEQUENCE',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29876013271569281.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 48786206675337067.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_validation_name => 'no duplicate PK',
  p_validation_sequence=> 60,
  p_validation => 'declare'||chr(10)||
'    l_cnt pls_integer := 0;'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select count(c001) cnt'||chr(10)||
'               from wwv_flow_collections'||chr(10)||
'               where collection_name = ''CSV_IMPORT'''||chr(10)||
'               and upper(c001) = upper(:P13_PK1_2))'||chr(10)||
'    loop'||chr(10)||
'      l_cnt := c1.cnt;'||chr(10)||
'    end loop;'||chr(10)||
'    if l_cnt > 0 then'||chr(10)||
'      return wwv_flow_lang.system_message(''F4500.P602.DUP_COL_NAME'',:P13_PK1_2);'||chr(10)||
'    end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'エラーです。',
  p_validation_condition=> 'P13_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 52483906836405605.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare    '||chr(10)||
'  l_cnames     wwv_flow_global.vc_arr2;  '||chr(10)||
'  l_data_type  wwv_flow_global.vc_arr2;  '||chr(10)||
'  l_upload     wwv_flow_global.vc_arr2;'||chr(10)||
'  l_max_length wwv_flow_global.vc_arr2;'||chr(10)||
'  l_seq_name   varchar2(255) := null;'||chr(10)||
'  l_pk1        varchar2(255) := :P13_PK1;'||chr(10)||
'  l_pk1_name   varchar2(255) := null;'||chr(10)||
'  i            pls_integer := 0;'||chr(10)||
'begin     '||chr(10)||
'   if :P13_PK1_OPTION = ''NEW_KEY'' then'||chr(10)||
'      i := i+1;'||chr(10)||
'      l';

p:=p||'_pk1 := replace(wwv_flow_utilities.remove_spaces(:P13_PK1_2),chr(32),''_'');      '||chr(10)||
'      if :P19_PRESERVE_CASE is null then'||chr(10)||
'        l_pk1 := upper(l_pk1);'||chr(10)||
'      end if;'||chr(10)||
'      l_cnames(i) := l_pk1;'||chr(10)||
'      l_data_type(i) := ''NUMBER'';'||chr(10)||
'      l_upload(i) := ''Y'';'||chr(10)||
'      l_max_length(i) := 30;'||chr(10)||
'   end if;'||chr(10)||
''||chr(10)||
'   for c in (select * '||chr(10)||
'             from wwv_flow_collections '||chr(10)||
'             where collection_name=''CSV_I';

p:=p||'MPORT'') loop'||chr(10)||
'     i := i+1; '||chr(10)||
'     l_cnames(i) := c.c001;'||chr(10)||
'     l_data_type(i) := c.c002;'||chr(10)||
'     l_upload(i) := c.c004;'||chr(10)||
'     l_max_length(i) := c.c005;    '||chr(10)||
'   end loop;  '||chr(10)||
'  '||chr(10)||
'  if :P13_PK_TYPE = ''NEW_SEQUENCE'' then'||chr(10)||
'    l_seq_name := :P13_NEW_SEQUENCE;'||chr(10)||
'    if :P19_PRESERVE_CASE is null then'||chr(10)||
'      l_seq_name := upper(l_seq_name);'||chr(10)||
'    end if;'||chr(10)||
'  elsif :P13_PK_TYPE = ''EXISTING_SEQUENCE'' then'||chr(10)||
'    l_seq_name ';

p:=p||':= :P13_EXISTING_SEQUENCE;'||chr(10)||
'  else'||chr(10)||
'    l_seq_name := NULL;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
' l_pk1_name := :P13_PK1_NAME;'||chr(10)||
' if :P19_PRESERVE_CASE is null then'||chr(10)||
'   l_pk1_name := upper(l_pk1_name);'||chr(10)||
' end if;'||chr(10)||
' wwv_flow_load_excel_data.create_table ('||chr(10)||
'  p_schema        => :F4300_P13_OWNER,'||chr(10)||
'  p_table_name    => wwv_flow_utilities.remove_spaces(:F4300_P13_TABLE_NAME),'||chr(10)||
'  p_pk1           => l_pk1,'||chr(10)||
'  p_pk1_name      => l_pk1_name,'||chr(10)||
' ';

p:=p||' p_pk1_type      => :P13_PK_TYPE,'||chr(10)||
'  p_seq_name      => l_seq_name,'||chr(10)||
'  --'||chr(10)||
'  p_cnames        => l_cnames,'||chr(10)||
'  p_data_type     => l_data_type,  '||chr(10)||
'  p_upload        => l_upload,'||chr(10)||
'  p_max_length    => l_max_length '||chr(10)||
'  ); '||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 2632715940268420.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create table',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_file_id                number := 0;'||chr(10)||
'  l_first_row_is_col_name  boolean := false;  '||chr(10)||
'  l_cnames                 wwv_flow_global.vc_arr2;      '||chr(10)||
'  l_upload                 wwv_flow_global.vc_arr2;  '||chr(10)||
'  i                        number := 0;'||chr(10)||
'  --'||chr(10)||
'  l_data_type              wwv_flow_global.vc_arr2;'||chr(10)||
'  l_data_format            wwv_flow_global.vc_arr2;'||chr(10)||
'  l_parsed_data_format     wwv_flow_global.v';

p:=p||'c_arr2;'||chr(10)||
'begin'||chr(10)||
'  select id'||chr(10)||
'  into l_file_id'||chr(10)||
'  from wwv_flow_file_objects$'||chr(10)||
'  where name = :F4300_P13_FILE;'||chr(10)||
'  '||chr(10)||
'  for c in (select * '||chr(10)||
'            from wwv_flow_collections '||chr(10)||
'            where collection_name=''CSV_IMPORT'') loop'||chr(10)||
'    i := i + 1;'||chr(10)||
'    l_cnames(i) := c.c001;    '||chr(10)||
'    l_upload(i) := c.c004; '||chr(10)||
'    l_data_type(i) := c.c002;  '||chr(10)||
'    l_data_format(i) := c.c006;'||chr(10)||
'    l_parsed_data_format(i) := c.c027; ';

p:=p||''||chr(10)||
'  end loop;  '||chr(10)||
''||chr(10)||
'  if :F4300_P13_IS_COLUMN_NAME = ''Y'' then'||chr(10)||
'    l_first_row_is_col_name := true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  wwv_flow_load_data.load_csv_data ('||chr(10)||
'   p_file_id    => l_file_id,'||chr(10)||
'   p_cnames     => l_cnames,'||chr(10)||
'   p_upload     => l_upload,'||chr(10)||
'   p_schema     => :F4300_P13_OWNER,'||chr(10)||
'   p_table      => wwv_flow_utilities.remove_spaces(:F4300_P13_TABLE_NAME),'||chr(10)||
'   p_data_type             => l_data_type,'||chr(10)||
'   p_data_for';

p:=p||'mat           => l_data_format,'||chr(10)||
'   p_parsed_data_format    => l_parsed_data_format,'||chr(10)||
'   p_separator             => lower(:F4300_P13_SEPARATOR),'||chr(10)||
'   p_enclosed_by           => :F4300_P13_ENCLOSED_BY,'||chr(10)||
'   p_first_row_is_col_name => l_first_row_is_col_name,'||chr(10)||
'   p_load_to               => ''NEW'','||chr(10)||
'   p_currency              => :P18_CURRENCY,'||chr(10)||
'   p_numeric_chars         => :P18_DECIMAL_CHARACTER||:P18_GROUP_S';

p:=p||'EPARATOR,'||chr(10)||
'   p_charset               => :P18_FILE_CHARSET'||chr(10)||
'   );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 2634021612279507.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert data',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>2164724759803154.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P13_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 69940020626931717.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P13_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 122951803454637884.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 21.4309,
  p_process_sequence=> 20,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 21.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_22.43
prompt  ...PAGE 22.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 22.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163405',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>22.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2166903406803173.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:18');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>データをロードする表を所有するデータベース・スキーマを選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 2167203855803175.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:18');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  Plain Text Data Import2';

wwv_flow_api.create_page_plug (
  p_id=> 3942229644856578.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 3934205141830584 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23356522911631312.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2167730620803176.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 22.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 2166903406803173+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2167814861803176.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 22.4309,
  p_button_sequence=> 40,
  p_button_plug_id => 2166903406803173+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4117018823640385.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 22.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 2166903406803173+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>2169404691803182.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4309,
  p_branch_action=> '23',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2167814861803176.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:18');
 
wwv_flow_api.create_page_branch(
  p_id=>4117328710640389.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4309,
  p_branch_action=> '230',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>4117018823640385.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データをロードする表を所有するデータベース・スキーマを選択してください。</p>';

wwv_flow_api.create_page_item(
  p_id=>2167519385803175.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4309,
  p_name=>'F4300_P22_TABLE_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2166903406803173.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_SCHEMA_OWNERS',
  p_lov => 'select htf.escape_sc(c.schema) d, c.schema v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1'||chr(10)||
'',
  p_lov_columns=> null,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- スキーマを選択 - ',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'return wwv_flow_global.g_xe',
  p_read_only_when_type=>'FUNCTION_BODY',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => 'Generated 20-SEP-2002 14:00:18');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3375200229249004.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 22.4309,
  p_validation_name => 'F4300_P22_TABLE_OWNER Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4300_P22_TABLE_OWNER',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'スキーマを指定する必要があります。',
  p_associated_item=> 2167519385803175.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 25-SEP-2002 14:41');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 22.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_23.43
prompt  ...PAGE 23.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 23.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163405',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>23.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3342017713216245.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>データをロードするデータベース表を選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 3343527756219129.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  Plain Text Data Import2';

wwv_flow_api.create_page_plug (
  p_id=> 3942801378857925.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 3934205141830584 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23357801225634529.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3345108840223145.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3342017713216245+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3347624424227650.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3342017713216245+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3346317844225676.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3342017713216245+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3347902164227651.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4309,
  p_branch_action=> '24',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>3347624424227650.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>3346606261225679.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4309,
  p_branch_action=> '22',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>3346317844225676.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データをロードするデータベース表を選択してください。</p>';

wwv_flow_api.create_page_item(
  p_id=>3370703215240396.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4309,
  p_name=>'F4300_P22_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3342017713216245.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(table_name) d, table_name r'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner = :F4300_P22_TABLE_OWNER'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 表の選択 -',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3372314989243825.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4309,
  p_validation_name => 'F4300_P22_TABLE_NAME Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4300_P22_TABLE_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '「表名」に値を指定する必要があります。',
  p_associated_item=> 3370703215240396.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 25-SEP-2002 14:40');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P22_TABLE_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 71417327803995150.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 23.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Verify Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 23.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_24.43
prompt  ...PAGE 24.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 24.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163405',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>24.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3829922094433887.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<label for="file-upload" class="hideMe508">ファイルのアップロード</label>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:17');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページでは、アップロードするファイルを検索できます。</p> '||chr(10)||
'<p>1行目に列名が含まれる場合は、「<b>1行目のデータに列名が含まれる</b>」を選択してください。</p>'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 3833218839433914.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:17');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  Plain Text Data Import2';

wwv_flow_api.create_page_plug (
  p_id=> 3943707265859631.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 3934205141830584 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 21249425216360552.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4309,
  p_plug_name=> 'グローバリゼーション',
  p_region_name=>'',
  p_plug_template=> 21175625245088699.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23358908151636560.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3830106917433892.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3829922094433887+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3830706637433895.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24.4309,
  p_button_sequence=> 30,
  p_button_plug_id => 3829922094433887+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3830402542433895.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24.4309,
  p_button_sequence=> 20,
  p_button_plug_id => 3829922094433887+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3834709806433923.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_branch_action=> '24',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_branch_condition=> 'F4300_P24_REUPLOAD',
  p_branch_condition_text=>'Y',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 24-SEP-2002 09:16 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>3834410468433923.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_branch_action=> '25',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>3830706637433895.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
wwv_flow_api.create_page_branch(
  p_id=>3834101310433921.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_branch_action=> '23',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>3830402542433895.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'ファイルを再アップロードするように指定 ';

wwv_flow_api.create_page_item(
  p_id=>3831104189433900.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'F4300_P24_REUPLOAD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 3829922094433887.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ファイルを再アップロード',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX_WITH_SUBMIT',
  p_named_lov=> 'YES.NO.RETURNS_Y_OR_N',
  p_lov => '.'||to_char(87930425596657700 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P22_FILE',
  p_display_when_type=>'ITEM_IS_NOT_NULL',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'アップロードするファイルの名前';

wwv_flow_api.create_page_item(
  p_id=>3831424650433904.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'F4300_P24_FILE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3829922094433887.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ファイル名',
  p_source=>'F4300_P22_FILE',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P22_FILE',
  p_display_when_type=>'ITEM_IS_NOT_NULL',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>「<strong>参照</strong>」をクリックして、アップロードするファイルを検索してください。</p>';

wwv_flow_api.create_page_item(
  p_id=>3832007249433909.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'F4300_P22_FILE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3829922094433887.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ファイル',
  p_source_type=> 'STATIC',
  p_display_as=> 'FILE',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'id="file-upload"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P22_FILE',
  p_display_when_type=>'ITEM_IS_NULL',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => 'Generated 20-SEP-2002 14:00:17');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データの最初の行に列名が含まれる場合は、このオプションを選択してください。次の例を参照してください。</p>'||chr(10)||
'<pre>'||chr(10)||
'名前     給与     コミッション'||chr(10)||
'Clark    1000       10'||chr(10)||
'Scott    2000       20'||chr(10)||
'</pre>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'<pre>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'名前     給与     コミッション'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Clark    1000       10'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Scott    2000       20'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'</pre>';

wwv_flow_api.create_page_item(
  p_id=>3832316073433910.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'F4300_P22_IS_COLUMN_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3829922094433887.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'ISCOLUMN.NAME.TEXT',
  p_lov => 'select ''<span class="instructiontext">''||'||chr(10)||
'wwv_flow_lang.system_message(''F4300_INSTRUCT_TEXT'')||''</span>'' d, ''Y'' r from dual',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>列のセパレータ文字を指定してください。タブ区切りには、<strong>\t</strong>を使用します。</p>';

wwv_flow_api.create_page_item(
  p_id=>3832614597433912.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'F4300_P22_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3829922094433887.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => ',',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'セパレータ',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>オプションで囲み文字を指定してください。</p>';

wwv_flow_api.create_page_item(
  p_id=>3832902320433912.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'F4300_P22_ENCLOSED_BY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 3829922094433887.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'囲み文字(オプション)',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データに国際通貨記号が含まれている場合は、その記号をここに入力してください。</p>'||chr(10)||
'<p>たとえば、データに&euro;1,234.56または&yen;1,234.56が含まれている場合は、&euro;または&yen;と入力してください。  入力しない場合、データは正常にロードされません。</p>';

wwv_flow_api.create_page_item(
  p_id=>21250401452363148.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'P24_CURRENCY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 21249425216360552.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'declare'||chr(10)||
'    l_return_val varchar2(30) := ''$'';'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select value'||chr(10)||
'                 from nls_session_parameters'||chr(10)||
'                where parameter = ''NLS_CURRENCY'') loop'||chr(10)||
'        l_return_val := c1.value;'||chr(10)||
'        exit;'||chr(10)||
'    end loop;'||chr(10)||
'    --'||chr(10)||
'    return l_return_val;'||chr(10)||
'end;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'通貨記号',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>グループ・セパレータは、千の位や百万の位などの整数グループを区切ります。</p>'||chr(10)||
'<p>グループ・セパレータには、任意の文字を指定できます。指定した文字はシングルバイトで、グループ・セパレータは他の小数点文字と異なる必要があります。セパレータには、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21979404565582755.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'P24_GROUP_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 21249425216360552.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_group_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'グループ・セパレータ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>小数点文字は、数値の整数部分と小数部分を区切ります。</p>'||chr(10)||
'<p>小数点文字には、任意の文字を指定できます。指定した文字はシングルバイトで、小数点文字はグループ・セパレータと異なる必要があります。小数点文字には、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21983213138604079.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'P24_DECIMAL_CHARACTER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 21249425216360552.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_decimal_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'小数点文字',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'テキスト・ファイルをエンコードするキャラクタ・セットを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>143065000827740153.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_name=>'P24_FILE_CHARSET',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 45,
  p_item_plug_id => 3829922094433887.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'nvl(lower(trim(owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))),''utf-8'')',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'ファイルのキャラクタ・セット',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'I18N_IANA_CHARSET',
  p_lov => '.'||to_char(135399325911344822 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 3835011019433929.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P22_FILE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '',
  p_compute_when => 'F4300_P24_REUPLOAD',
  p_compute_when_text=>'Y',
  p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 49535021883702753.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_computation_sequence => 20,
  p_computation_item=> 'F4300_P22_IS_COLUMN_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'N',
  p_compute_when => 'F4300_P22_IS_COLUMN_NAME',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 3835314069433929.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P24_REUPLOAD',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'N',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3835908087433932.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 24.4309,
  p_validation_name => 'file name not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P22_FILE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'ファイルを指定する必要があります。',
  p_when_button_pressed=> 3830706637433895.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 3832007249433909.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare  '||chr(10)||
'  l_first_row_is_col_name boolean := false;'||chr(10)||
'  l_file_id               number := 0;'||chr(10)||
'begin'||chr(10)||
'  select id'||chr(10)||
'  into l_file_id'||chr(10)||
'  from wwv_flow_file_objects$'||chr(10)||
'  where name = :F4300_P22_FILE;'||chr(10)||
'  '||chr(10)||
'  '||chr(10)||
'  if :F4300_P22_IS_COLUMN_NAME = ''Y'' then'||chr(10)||
'    l_first_row_is_col_name := true;'||chr(10)||
'  end if;'||chr(10)||
'  wwv_flow_load_data.create_csv_collection ('||chr(10)||
'   p_file_id                => l_file_id,'||chr(10)||
'   p_separator              ';

p:=p||'=> lower(:F4300_P22_SEPARATOR),'||chr(10)||
'   p_enclosed_by            => :F4300_P22_ENCLOSED_BY,  '||chr(10)||
'   p_first_row_is_col_name  => l_first_row_is_col_name,'||chr(10)||
'   p_currency               => :P24_CURRENCY,'||chr(10)||
'   p_numeric_chars          => :P24_DECIMAL_CHARACTER||:P24_GROUP_SEPARATOR,'||chr(10)||
'   p_charset                => :P24_FILE_CHARSET'||chr(10)||
'   );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3836525951433937.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create table info collection',
  p_process_sql_clob => p, 
  p_process_error_message=> 'ロードしたデータを使用してコレクションを作成中に、エラーが発生しました。',
  p_process_when_button_id=>3830706637433895.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 24.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_25.43
prompt  ...PAGE 25.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 25.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163405',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>25.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3379027934257020.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページでは、データのロード方法をプレビューできます。データベース列名と、データ内の列を一致させます。列をアップロードするには「<b>はい</b>」を、しない場合は「<b>いいえ</b>」を選択します。アスタリスク(*)は、必須の列を示します。</p>'||chr(10)||
'<p>選択した表にデータをアップロードするには、「<b>データのインポート</b>」をクリックしてください。</p>'||chr(10)||
'<p>SQLワークショップを使用して、列長の変更、NOT NULL列の作成、列のデータ型の変更など、表属性を変更できます。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 3380716636263254.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_load_data.display_etable_property ('||chr(10)||
'    p_table_owner     => :F4300_P22_TABLE_OWNER,'||chr(10)||
'    p_table_name      => :F4300_P22_TABLE_NAME,'||chr(10)||
'    p_collection_name => ''CSV_IMPORT'''||chr(10)||
'    );';

wwv_flow_api.create_page_plug (
  p_id=> 3382431874267620.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4309,
  p_plug_name=> '列のマッピングの定義',
  p_region_name=>'',
  p_plug_template=> 279748823389483962.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  Plain Text Data Import2';

wwv_flow_api.create_page_plug (
  p_id=> 3944611767860950.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 3934205141830584 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23360325120641434.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3747714052076259.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3379027934257020+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3749803794082687.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3379027934257020+wwv_flow_api.g_id_offset,
  p_button_name    => 'FINISH',
  p_button_image_alt=> 'データのロード',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3748622363078595.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 3379027934257020+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3750125829082689.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4309,
  p_branch_action=> '8',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>3749803794082687.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 30,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>3748007079076265.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4309,
  p_branch_action=> '9',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>3747714052076259.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>3748901903078596.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4309,
  p_branch_action=> '24',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>3748622363078595.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする表を所有するスキーマです。';

wwv_flow_api.create_page_item(
  p_id=>3753406349092940.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4309,
  p_name=>'F4300_P25_TABLE_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3379027934257020.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ:',
  p_source=>'F4300_P22_TABLE_OWNER',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする表の名前';

wwv_flow_api.create_page_item(
  p_id=>3754218816096550.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4309,
  p_name=>'F4300_P25_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3379027934257020.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名:',
  p_source=>'F4300_P22_TABLE_NAME',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3872807706566435.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4309,
  p_name=>'F4300_P25_DUMMY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3379027934257020.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Dummy',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 3874326752571910.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P25_DUMMY',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'begin'||chr(10)||
'for i in 1..wwv_flow.g_f04.count loop'||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f04(i),'||chr(10)||
'     p_attr_number => 1,'||chr(10)||
'     p_attr_value => wwv_flow_utilities.remove_spaces(wwv_flow.g_f01(i))'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f04(i),'||chr(10)||
'     p_attr_number => 4,'||chr(10)||
'     p_attr_value => wwv_flow.g_f02(i)'||chr(10)||
'     );'||chr(10)||
'     '||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''CSV_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f04(i),'||chr(10)||
'     p_attr_number => 6,'||chr(10)||
'     p_attr_value => wwv_flow.g_f05(i)'||chr(10)||
'     );     '||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'return ''true'';'||chr(10)||
''||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3758426912108293.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4309,
  p_validation_name => 'column name not null',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'  l_null_found number := 0;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
''||chr(10)||
'    if wwv_flow.g_f02(i)=''Y'' then'||chr(10)||
''||chr(10)||
'      if replace(wwv_flow.g_f01(i),''%''||''null%'',null) is null then'||chr(10)||
''||chr(10)||
'        l_null_found := l_null_found + 1;'||chr(10)||
''||chr(10)||
'      end if;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_null_found > 0 then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '列名はNULLにできません。',
  p_when_button_pressed=> 3749803794082687.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3759521849116267.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4309,
  p_validation_name => 'at least one upload selected',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'  l_no_count number := 0;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f02.count loop'||chr(10)||
''||chr(10)||
'    if wwv_flow.g_f02(i) = ''N'' then'||chr(10)||
''||chr(10)||
'      l_no_count := l_no_count + 1;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_no_count = wwv_flow.g_f02.count then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'データをアップロードするには、1つ以上の列を指定する必要があります。',
  p_when_button_pressed=> 3749803794082687.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3762021418135076.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4309,
  p_validation_name => 'not null columns must be loaded',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'  l_not_null_error number := 0;'||chr(10)||
''||chr(10)||
'  l_columns        varchar2(32767) := null;'||chr(10)||
''||chr(10)||
'  l_not_null_cols  varchar2(32767) := null;'||chr(10)||
''||chr(10)||
'  l_trigger_body   long;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  l_columns := wwv_flow_utilities.table_to_string2(wwv_flow.g_f01);'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  -- get trigger body if it is before insert trigger on the selected table'||chr(10)||
''||chr(10)||
'  for c1 in (select trigger_body'||chr(10)||
''||chr(10)||
'             from sys.dba_triggers'||chr(10)||
''||chr(10)||
'             where table_name = :F4300_P22_TABLE_NAME'||chr(10)||
''||chr(10)||
'             and table_owner = :F4300_P22_TABLE_OWNER'||chr(10)||
''||chr(10)||
'             and trigger_type like ''%BEFORE%'''||chr(10)||
''||chr(10)||
'             and triggering_event like ''%INSERT%'')'||chr(10)||
''||chr(10)||
'  loop'||chr(10)||
''||chr(10)||
'     l_trigger_body := c1.trigger_body;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  -- get all not null columns'||chr(10)||
''||chr(10)||
'  for c1 in (select column_name'||chr(10)||
''||chr(10)||
'             from sys.dba_tab_columns'||chr(10)||
''||chr(10)||
'             where table_name = :F4300_P22_TABLE_NAME'||chr(10)||
''||chr(10)||
'             and owner = :F4300_P22_TABLE_OWNER'||chr(10)||
''||chr(10)||
'             and nullable = ''N'''||chr(10)||
''||chr(10)||
'             ) loop'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'      for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
''||chr(10)||
'        -- If column names user selected is equal to not null columns,'||chr(10)||
''||chr(10)||
'        -- user didn''t include to upload'||chr(10)||
''||chr(10)||
'        -- and the column doesn''t have trigger, raise an error.'||chr(10)||
''||chr(10)||
'        if (wwv_flow.g_f01(i) = c1.column_name) then'||chr(10)||
''||chr(10)||
'          if wwv_flow.g_f02(i) = ''N'' then'||chr(10)||
''||chr(10)||
'            if instr(nvl(UPPER(l_trigger_body),'' ''),c1.column_name) = 0 then'||chr(10)||
''||chr(10)||
'              l_not_null_error := l_not_null_error + 1;'||chr(10)||
''||chr(10)||
'              l_not_null_cols := l_not_null_cols||'',''||c1.column_name;'||chr(10)||
''||chr(10)||
'            end if;'||chr(10)||
''||chr(10)||
'          end if;'||chr(10)||
''||chr(10)||
'        else'||chr(10)||
''||chr(10)||
'          -- If user did not select not null columns,'||chr(10)||
''||chr(10)||
'          -- and the column doesn''t have trigger'||chr(10)||
''||chr(10)||
'          -- raise an error.'||chr(10)||
''||chr(10)||
'          if instr(l_columns,c1.column_name) = 0 then'||chr(10)||
''||chr(10)||
'            if instr(nvl(UPPER(l_trigger_body),'' ''),c1.column_name) = 0 then'||chr(10)||
''||chr(10)||
'              l_not_null_error := l_not_null_error + 1;'||chr(10)||
''||chr(10)||
'              l_not_null_cols := l_not_null_cols||'',''||c1.column_name;'||chr(10)||
''||chr(10)||
'            end if;'||chr(10)||
''||chr(10)||
'          end if;'||chr(10)||
''||chr(10)||
'        end if;'||chr(10)||
''||chr(10)||
'      end loop;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_not_null_error > 0 then'||chr(10)||
''||chr(10)||
'      return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'      return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '&F4300_P22_TABLE_OWNER..&F4300_P22_TABLE_NAME.には、NULL列がありません。エラーのないデータをアップロードするように選択してください。',
  p_when_button_pressed=> 3749803794082687.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3804414642293989.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4309,
  p_validation_name => 'duplicate column names',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
'  l_col       varchar2(32767) := null;'||chr(10)||
'  l_duplicate boolean := true;'||chr(10)||
'begin'||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'    -- if column selected is to be uploaded, check for duplicate column selection'||chr(10)||
'    if wwv_flow.g_f02(i) = ''Y'' then'||chr(10)||
'        if instr(nvl(l_col,'' ''), ('':'' || wwv_flow.g_f01(i) || '':'')) > 0 then'||chr(10)||
'          l_duplicate := false;'||chr(10)||
'        end if;'||chr(10)||
'        if i > 1 then'||chr(10)||
'            l_col := l_col || wwv_flow.g_f01(i) || '':'';'||chr(10)||
'        else'||chr(10)||
'            l_col := '':'' || wwv_flow.g_f01(i) || '':'' ;'||chr(10)||
'        end if;'||chr(10)||
'    end if;'||chr(10)||
'  end loop;'||chr(10)||
'  return l_duplicate;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '重複する列名が選択されました。',
  p_when_button_pressed=> 3749803794082687.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_file_id                number := 0;'||chr(10)||
'  l_first_row_is_col_name  boolean := false;'||chr(10)||
'  l_cnames                 wwv_flow_global.vc_arr2;'||chr(10)||
'  --'||chr(10)||
'  l_data_types             wwv_flow_global.vc_arr2;'||chr(10)||
'  l_parsed_data_format     wwv_flow_global.vc_arr2;'||chr(10)||
'  j                        pls_integer := 0;'||chr(10)||
'begin'||chr(10)||
'  select id'||chr(10)||
'  into l_file_id'||chr(10)||
'  from wwv_flow_file_objects$'||chr(10)||
'  where name = :F4300_P22_FILE;'||chr(10)||
''||chr(10)||
'  i';

p:=p||'f :F4300_P22_IS_COLUMN_NAME = ''Y'' then'||chr(10)||
'    l_first_row_is_col_name := true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'    l_cnames(i) := wwv_flow.g_f01(i);'||chr(10)||
'    '||chr(10)||
'    for c1 in (select data_type'||chr(10)||
'               from sys.dba_tab_columns'||chr(10)||
'               where owner = :F4300_P22_TABLE_OWNER'||chr(10)||
'               and table_name = :F4300_P22_TABLE_NAME'||chr(10)||
'               and column_name = wwv_flow.g_f01(i)'||chr(10)||
' ';

p:=p||'              order by column_id)'||chr(10)||
'    loop'||chr(10)||
'       l_data_types(i) := c1.data_type;    	'||chr(10)||
'    end loop;    '||chr(10)||
'  end loop;'||chr(10)||
'  '||chr(10)||
'  for c in (select * '||chr(10)||
'            from wwv_flow_collections '||chr(10)||
'            where collection_name=''CSV_IMPORT'') loop'||chr(10)||
'    j := j + 1;    '||chr(10)||
'    l_parsed_data_format(j) := c.c027; '||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  wwv_flow_load_data.load_csv_data ('||chr(10)||
'   p_file_id    => l_file_id,'||chr(10)||
'   p_cnames     => l_cnam';

p:=p||'es,'||chr(10)||
'   p_upload     => wwv_flow.g_f02,'||chr(10)||
'   p_schema     => :F4300_P22_TABLE_OWNER,'||chr(10)||
'   p_table      => :F4300_P22_TABLE_NAME,'||chr(10)||
'   p_data_type  => l_data_types,'||chr(10)||
'   p_data_format => wwv_flow.g_f05,'||chr(10)||
'   p_parsed_data_format => l_parsed_data_format,'||chr(10)||
'   p_separator  => lower(:F4300_P22_SEPARATOR),'||chr(10)||
'   p_enclosed_by => :F4300_P22_ENCLOSED_BY,'||chr(10)||
'   p_first_row_is_col_name => l_first_row_is_col_name,'||chr(10)||
'   p_load_t';

p:=p||'o               => ''EXIST'','||chr(10)||
'   p_currency              => :P24_CURRENCY,'||chr(10)||
'   p_numeric_chars         => :P24_DECIMAL_CHARACTER||:P24_GROUP_SEPARATOR,'||chr(10)||
'   p_charset               => :P24_FILE_CHARSET'||chr(10)||
'   );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3813707079395907.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert data',
  p_process_sql_clob => p, 
  p_process_error_message=> 'データの挿入中にエラーが発生しました。',
  p_process_when_button_id=>3749803794082687.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P22_TABLE_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 122948926694597204.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4309,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'security check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P22_TABLE_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 122950027302616323.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4309,
  p_process_sequence=> 1,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'security check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 25.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_70.43
prompt  ...PAGE 70.4309: XMLへのアンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 70.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'XMLへのアンロード',
  p_step_title=> 'XMLへのアンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731303316584395+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163405',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>70.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 242875176989.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 70.4309,
  p_plug_name=> 'XMLへのアンロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 242882205409.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 70.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 104417024127237376 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6689113332667276.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 70.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>表のコンテンツをXML文書にエクスポートできます。</p>'||chr(10)||
'<p>エクスポートする表を所有するデータベース・スキーマを選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221193914505845456.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 70.4309,
  p_plug_name=> 'XMLへのアンロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109086405456399267.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 70.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 242875176989+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 242885218072.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 70.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 242875176989+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>242888218082.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 70.4309,
  p_branch_action=> '80',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>242885218072.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'エクスポートするオブジェクトを所有するデータベース・スキーマを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>242877182288.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 70.4309,
  p_name=>'F4300_P70_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 242875176989.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_SCHEMA_OWNERS',
  p_lov => 'select htf.escape_sc(c.schema) d, c.schema v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1'||chr(10)||
'',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 61175806454801075.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 70.4309,
  p_validation_name => 'schema not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P70_SCHEMA',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'スキーマを指定する必要があります。',
  p_when_button_pressed=> 242885218072.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 242877182288.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 70.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_80.43
prompt  ...PAGE 80.4309: XMLへのアンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 80.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'XMLへのアンロード',
  p_step_title=> 'XMLへのアンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731303316584395+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163406',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>80.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 242897225300.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 80.4309,
  p_plug_name=> 'XMLへのアンロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 242901225302.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 80.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 104417024127237376 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6843332007762963.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 80.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>XML文書にエクスポートするデータベース表を選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221200328834859088.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 80.4309,
  p_plug_name=> 'XMLへのアンロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109094932121406894.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 80.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 242897225300+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 242891225267.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 80.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 242897225300+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 242908248383.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 80.4309,
  p_button_sequence=> 5,
  p_button_plug_id => 242897225300+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>242893225269.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 80.4309,
  p_branch_action=> '90',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>242891225267.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>242911248393.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 80.4309,
  p_branch_action=> '70',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>242908248383.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'XMLファイル形式にエクスポートするデータベース・オブジェクト名を選択してください。';

wwv_flow_api.create_page_item(
  p_id=>242895225276.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 80.4309,
  p_name=>'F4300_P80_XML_EXPORT_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 242897225300.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(table_name) d, table_name v'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner=:F4300_P70_SCHEMA'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 表の選択 -',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 61178725978816213.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 80.4309,
  p_validation_name => 'export table not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P80_XML_EXPORT_TABLE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '「エクスポート表」に値を指定する必要があります。',
  p_when_button_pressed=> 242891225267.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 242895225276.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P70_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 69926911444891227.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 80.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 80.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_90.43
prompt  ...PAGE 90.4309: XMLへのアンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 90.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'XMLへのアンロード',
  p_step_title=> 'XMLへのアンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731303316584395+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163406',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>90.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 242928263721.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 90.4309,
  p_plug_name=> 'XMLへのアンロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 242932263722.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 90.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 104417024127237376 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6844408589765628.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 90.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このXML文書に含める列を選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221208308449881533.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 90.4309,
  p_plug_name=> 'XMLへのアンロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109103601562416983.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 90.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 242928263721+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 242954438477.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 90.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 242928263721+wwv_flow_api.g_id_offset,
  p_button_name    => 'EXPORTDATA',
  p_button_image_alt=> 'データのアンロード',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:doSubmit(''EXPORTDATA'');',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 242920263706.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 90.4309,
  p_button_sequence=> 5,
  p_button_plug_id => 242928263721+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>242922263709.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 90.4309,
  p_branch_action=> '90',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>242924263709.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 90.4309,
  p_branch_action=> '80',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>242920263706.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'XML文書にエクスポートするデータベース・オブジェクト列を選択してください。';

wwv_flow_api.create_page_item(
  p_id=>242926263712.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 90.4309,
  p_name=>'F4300_P90_XML_EXPORT_COLUMNS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 242928263721.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'列',
  p_source_type=> 'STATIC',
  p_display_as=> 'MULTIPLESELECT',
  p_lov => 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
''||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
''||chr(10)||
'where table_name= :F4300_P80_XML_EXPORT_TABLE'||chr(10)||
''||chr(10)||
'and owner =:F4300_P70_SCHEMA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 10,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>73486104619415064.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 90.4309,
  p_name=>'P90_FILE_EXPORT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 242928263721.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'EXPORT.AS.FILE.Y',
  p_lov => '.'||to_char(87944005995777613 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>196679827776339627.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 90.4309,
  p_name=>'P90_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 242928263721.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'SQL WHERE句を入力して、選択される行を制限します。例:'||chr(10)||
'<pre>'||chr(10)||
'DEPTNO = 10'||chr(10)||
'</pre>';

wwv_flow_api.create_page_item(
  p_id=>196680604705342464.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 90.4309,
  p_name=>'P90_WHERE_CLAUSE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 242928263721.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'WHERE句',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 4000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 241192503550535804.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 90.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P90_WHERE_CLAUSE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare '||chr(10)||
'  w varchar2(30000);'||chr(10)||
'begin'||chr(10)||
'  w := :p90_where_clause;'||chr(10)||
'  for i in 1..10 loop'||chr(10)||
'    w := rtrim(rtrim(rtrim(trim(w),'';/ ''),chr(10)),chr(13));'||chr(10)||
'  end loop;'||chr(10)||
'  return w;'||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 61180608448820628.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 90.4309,
  p_validation_name => 'export cols not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P90_XML_EXPORT_COLUMNS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '「エクスポート列」に値を指定する必要があります。',
  p_when_button_pressed=> 242954438477.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 242926263712.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 99812303853555653.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 90.4309,
  p_validation_name => 'no row exists',
  p_validation_sequence=> 20,
  p_validation => 'declare'||chr(10)||
'  l_cnt    number := 0;  '||chr(10)||
'  l_sql    varchar2(32767) := null;'||chr(10)||
'begin    '||chr(10)||
'  l_sql := ''select count(*) from "''||:F4300_P80_XML_EXPORT_TABLE||''"'';'||chr(10)||
'                                             '||chr(10)||
'  l_cnt := wwv_flow_f4000_util.select_num (p_sql => l_sql, p_user => :F4300_P70_SCHEMA);'||chr(10)||
'  '||chr(10)||
'  if l_cnt = 0 then'||chr(10)||
'    return false;'||chr(10)||
'  else'||chr(10)||
'    return true;'||chr(10)||
'  end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '選択した表には、エクスポートするレコードがありません。表にデータを移入してから、エクスポートしてください。',
  p_when_button_pressed=> 242954438477.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'   xml_cols wwv_flow_global.vc_arr2;'||chr(10)||
'begin'||chr(10)||
'  insert into wwv_flow_data_load_unload (DATA_TYPE,  DATA_SCHEMA, DATA_TABLE)'||chr(10)||
'  values'||chr(10)||
'        (''XML EXPORT'', :F4300_P70_SCHEMA, :F4300_P80_XML_EXPORT_TABLE);'||chr(10)||
'  '||chr(10)||
'  --'||chr(10)||
'  -- if XML file export, define mime header'||chr(10)||
'  --'||chr(10)||
'  wwv_flow_init_htp_buffer;'||chr(10)||
'  wwv_flow.g_page_text_generated := true;'||chr(10)||
'  wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'  owa_util.mime_heade';

p:=p||'r (''text/xml'',false, ''utf-8'');  '||chr(10)||
'  if :P90_FILE_EXPORT = ''Y'' then'||chr(10)||
'    htp.p(''Content-Disposition: attachment; filename=''|| wwv_flow_utilities.escape_url( p_url => lower(:F4300_P80_XML_EXPORT_TABLE), p_url_charset => ''utf-8'')||''.xml'');'||chr(10)||
'  else'||chr(10)||
'    htp.p(''Content-Disposition: inline '' );'||chr(10)||
'  end if;'||chr(10)||
'  owa_util.http_header_close;'||chr(10)||
''||chr(10)||
'  xml_cols:= wwv_flow_utilities.string_to_table2(:F4300_P90_XML_EXPORT_CO';

p:=p||'LUMNS);'||chr(10)||
'  '||chr(10)||
'  wwv_flow_dataload_xml.GETQUERYXMLPAGE (p_schema=>:F4300_P70_SCHEMA, '||chr(10)||
'                  p_table=>:F4300_P80_XML_EXPORT_TABLE, '||chr(10)||
'                  p_columns=> xml_cols,'||chr(10)||
'                  p_where => :P90_WHERE_CLAUSE ); '||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 242990422910.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 90.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'start_xml_download',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>242954438477.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P70_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 122998032132816447.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 90.4309,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P70_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 122999317371821648.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 90.4309,
  p_process_sequence=> 20,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 90.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_150.4
prompt  ...PAGE 150.4309: テキストへのアンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 150.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'テキストへのアンロード',
  p_step_title=> 'テキストへのアンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163406',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>150.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6690319912669219.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 150.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27155313458825518.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 150.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27155716362825519.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 150.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 104358211508848205 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>表のコンテンツを構造化されたテキスト・ファイルにアンロードできます。たとえば、表全体をカンマ区切りファイル(.CSV)にエクスポートできます。</p>'||chr(10)||
'<p>テキストにアンロードする表を所有するデータベース・スキーマを選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 220843108075654305.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 150.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 20-SEP-2002 14:00:18');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109061621685375483.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 150.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27155313458825518+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27154700232825500.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 150.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27155313458825518+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>27154924917825505.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 150.4309,
  p_branch_action=> '160',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>27154700232825500.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'エクスポートするオブジェクトを所有するデータベース・スキーマを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>27155123411825508.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 150.4309,
  p_name=>'F4300_P150_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 27155313458825518.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_SCHEMA_OWNERS',
  p_lov => 'select htf.escape_sc(c.schema) d, c.schema v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1'||chr(10)||
'',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 65600608761173558.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 150.4309,
  p_validation_name => 'schema not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P150_SCHEMA',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'スキーマを指定する必要があります。',
  p_when_button_pressed=> 27154700232825500.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 27155123411825508.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 150.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_160.4
prompt  ...PAGE 160.4309: テキストへのアンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 160.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'テキストへのアンロード',
  p_step_title=> 'テキストへのアンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163406',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>160.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6846024866770273.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 160.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27157828903849867.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 160.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27158200800849869.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 160.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 104358211508848205 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>プレーン・テキスト形式でアンロードするデータベース表を選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 220882616789760954.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 160.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109067307618380928.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 160.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27157828903849867+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27156823847849862.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 160.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27157828903849867+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27157022916849863.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 160.4309,
  p_button_sequence=> 5,
  p_button_plug_id => 27157828903849867+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>27157426106849865.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 160.4309,
  p_branch_action=> '170',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>27156823847849862.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>27157223607849864.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 160.4309,
  p_branch_action=> '150',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>27157022916849863.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'プレーン・テキスト形式でエクスポートするデータベース表を選択してください。';

wwv_flow_api.create_page_item(
  p_id=>27157619740849866.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 160.4309,
  p_name=>'F4300_P160_ASC_EXPORT_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 27157828903849867.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(table_name) a, table_name b'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner=:F4300_P150_SCHEMA'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'order by table_name',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 表の選択 -',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 65603025384178278.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 160.4309,
  p_validation_name => 'export table not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P160_ASC_EXPORT_TABLE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'エクスポート表を指定する必要があります。',
  p_when_button_pressed=> 27156823847849862.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 27157619740849866.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P150_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 69925124126885447.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 160.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 160.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_170.4
prompt  ...PAGE 170.4309: テキストへのアンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 170.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'テキストへのアンロード',
  p_step_title=> 'テキストへのアンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163406',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>170.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6847402487773366.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 170.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27161124048881816.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 170.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27161504570881817.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 170.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 104358211508848205 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select owner, '||chr(10)||
'table_name, '||chr(10)||
'column_name,'||chr(10)||
'data_type'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner = :F4300_P150_SCHEMA'||chr(10)||
'and table_name = :F4300_P160_ASC_EXPORT_TABLE'||chr(10)||
'and data_type in (''SDO_GEOMETRY'',''BLOB'',''BFILE'',''ORDAUDIO'',''ORDIMAGE'',''ORDIMAGESIGNATURE'',''ORDVIDEO'',''ORDDOC'',''URITYPE'',''DBURITYPE'',''XDBURITYPE'',''HTTPURITYPE'',''XMLTYPE'')';

wwv_flow_api.create_report_region (
  p_id=> 57290213471124955.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 170.4309,
  p_name=> 'アップロードできない列',
  p_region_name=>'',
  p_template=> 21175625245088699.4309+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'select 1'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner = :F4300_P150_SCHEMA'||chr(10)||
'and table_name = :F4300_P160_ASC_EXPORT_TABLE'||chr(10)||
'and data_type in (''SDO_GEOMETRY'',''BLOB'',''BFILE'',''ORDAUDIO'',''ORDIMAGE'',''ORDIMAGESIGNATURE'',''ORDVIDEO'',''ORDDOC'',''URITYPE'',''DBURITYPE'',''XDBURITYPE'',''HTTPURITYPE'',''XMLTYPE'')',
  p_display_condition_type=> 'EXISTS',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 10583525904875984.4309+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1:2',
  p_query_no_data_found=> 'データが見つかりません。',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57290511758124966.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 57290213471124955.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 1,
  p_column_heading=> 'スキーマ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57290602602124966.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 57290213471124955.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> '表',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57290722093124966.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 57290213471124955.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> '列',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57312503868178994.4309 + wwv_flow_api.g_id_offset,
  p_region_id=> 57290213471124955.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_TYPE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'データ型',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このプレーン・テキスト・ファイルに含める列を選択してください。アンロードがサポートされているのは、BLOBおよびBFILEを除くOracle組込みデータ型のみです。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 220892315450788979.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 170.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109074823894385635.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 170.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27161124048881816+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27159721723881807.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 170.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27161124048881816+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27159912210881808.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 170.4309,
  p_button_sequence=> 5,
  p_button_plug_id => 27161124048881816+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>27160330589881809.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 170.4309,
  p_branch_action=> '180',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>27159721723881807.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>27160511447881810.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 170.4309,
  p_branch_action=> '160',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>27159912210881808.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'このプレーン・テキスト・ファイルに含める列を選択してください。アンロードがサポートされているのは、BLOBおよびBFILEを除くOracle組込みデータ型のみです。';

wwv_flow_api.create_page_item(
  p_id=>27160726961881811.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 170.4309,
  p_name=>'F4300_P170_ASC_EXPORT_COLUMNS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 27161124048881816.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'列',
  p_source_type=> 'STATIC',
  p_display_as=> 'MULTIPLESELECT',
  p_lov => 'select htf.escape_sc(column_name) a, column_name b'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where table_name= :F4300_P160_ASC_EXPORT_TABLE'||chr(10)||
'and owner =:F4300_P150_SCHEMA'||chr(10)||
'and data_type not in (''SDO_GEOMETRY'',''BLOB'',''BFILE'',''ORDAUDIO'',''ORDIMAGE'',''ORDIMAGESIGNATURE'',''ORDVIDEO'',''ORDDOC'',''URITYPE'',''DBURITYPE'',''XDBURITYPE'',''HTTPURITYPE'',''XMLTYPE'')',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 10,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'選択された表を示します。';

wwv_flow_api.create_page_item(
  p_id=>196659907635229752.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 170.4309,
  p_name=>'P170_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 27161124048881816.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => '&F4300_P160_ASC_EXPORT_TABLE.',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表:',
  p_source=>'F4300_P160_ASC_EXPORT_TABLE',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'SQL WHERE句を入力して、選択される行を制限します。例:'||chr(10)||
'<pre>'||chr(10)||
'DEPTNO = 10'||chr(10)||
'</pre>';

wwv_flow_api.create_page_item(
  p_id=>196663809497239782.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 170.4309,
  p_name=>'P170_WHERE_CLAUSE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 27161124048881816.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'WHERE句',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 6,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 2,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>196665229929245689.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 170.4309,
  p_name=>'P170_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 11,
  p_item_plug_id => 27161124048881816.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 241190207098517984.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 170.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P170_WHERE_CLAUSE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare w varchar2(30000);'||chr(10)||
'begin'||chr(10)||
'w := :P170_WHERE_CLAUSE;'||chr(10)||
'for i in 1..10 loop'||chr(10)||
'  w := rtrim(rtrim(rtrim(trim(w),'';/ ''),chr(10)),chr(13));'||chr(10)||
'end loop;'||chr(10)||
'return w;'||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 65604806815182367.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 170.4309,
  p_validation_name => 'export col not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P170_ASC_EXPORT_COLUMNS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'エクスポート列を指定する必要があります。',
  p_when_button_pressed=> 27159721723881807.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 27160726961881811.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P150_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 196656907504220271.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 170.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 170.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_180.4
prompt  ...PAGE 180.4309: テキストへのアンロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 180.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'テキストへのアンロード',
  p_step_title=> 'テキストへのアンロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215731706086585147+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163406',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>180.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6848509413775366.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 180.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27163003595914791.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 180.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27163907693981199.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 180.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 104358211508848205 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'各行で列の値を区切るためのセパレータの種類と、列のテキスト文字列の指定方法を指定してください。';

wwv_flow_api.create_page_plug (
  p_id=> 220896430126802623.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 180.4309,
  p_plug_name=> 'テキストへのアンロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109080707403390321.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 180.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27163003595914791+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27163504640971637.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 180.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27163003595914791+wwv_flow_api.g_id_offset,
  p_button_name    => 'EXPORTDATA',
  p_button_image_alt=> 'データのアンロード',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:doSubmit(''EXPORTDATA'');',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27164230828990784.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 180.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 27163003595914791+wwv_flow_api.g_id_offset,
  p_button_name    => 'previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>151088609408189516.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_branch_action=> 'f?p=&APP_ID.:180:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>27163504640971637.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-AUG-2003 17:18 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>27164522069990788.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_branch_action=> '170',
  p_branch_point=> 'BEFORE_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>27164230828990784.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'列名も含めてデータをエクスポートする場合は、このアイテムを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>5580720856115889.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_name=>'F4300_P180_INC_COLUMN_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 27163003595914791.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'INCLUDE.COL.NAMES.Y',
  p_lov => '.'||to_char(87945815476789819 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<div class="htmldbInfoBodyP">各行の列値を区切るために使用するセパレータ・タイプを指定してください。</div> '||chr(10)||
'<div class="htmldbInfoBodyP">デフォルトの値は、カンマ(<code>,</code>)です。列のセパレータとしてタブを使用するには、バックスラッシュの後にt (<code>	</code>)を入力してください。</div>';

wwv_flow_api.create_page_item(
  p_id=>27163402948965482.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_name=>'F4300_P180_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 27163003595914791.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => ',',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'セパレータ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'エクスポート・ファイルをエンコードするキャラクタ・セットを選択してください。'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>142827824937224518.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_name=>'P180_FILE_CHARSET',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 27163003595914791.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'nvl(lower(trim(owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))),''utf-8'')',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'ファイルのキャラクタ・セット',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'I18N_IANA_CHARSET',
  p_lov => '.'||to_char(135399325911344822 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'結果ファイルの行をキャリッジ・リターンおよび改行で終了させるには、DOSを選択してください。  結果ファイルの行を改行で終了させるには、UNIXを選択してください。  ';

wwv_flow_api.create_page_item(
  p_id=>143184623384792499.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_name=>'P180_FILE_FORMAT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 27163003595914791.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ファイル形式',
  p_source=>'wwv_flow_lang.system_message(p_name=>''F4300.P180_FILE_FORMAT'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'EXPORT.FILE_FORMAT',
  p_lov => '.'||to_char(143183002952786622 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'列内のテキスト文字列を識別する方法を指定するには、このオプションを使用してください。一重引用符または二重引用符を指定できます。';

wwv_flow_api.create_page_item(
  p_id=>162884825010392552.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_name=>'F4300_P180_ENCLOSED',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 27163003595914791.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'囲み文字(オプション)',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'選択された表を示します。';

wwv_flow_api.create_page_item(
  p_id=>196667304565257203.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 180.4309,
  p_name=>'P180_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 27163003595914791.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => '&F4300_P160_ASC_EXPORT_TABLE.',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表:',
  p_source=>'F4300_P160_ASC_EXPORT_TABLE',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'   ascii_cols  wwv_flow_global.vc_arr2;'||chr(10)||
'   l_query     varchar2(4000);'||chr(10)||
'   l_sep       varchar2(1):=NULL;'||chr(10)||
'   l_cnt       number;'||chr(10)||
'   w           varchar2(4000); '||chr(10)||
'begin'||chr(10)||
'  ascii_cols:= wwv_flow_utilities.string_to_table2(:F4300_P170_ASC_EXPORT_COLUMNS);'||chr(10)||
'  l_query:=''select '';'||chr(10)||
'  for i in 1..ascii_cols.count'||chr(10)||
'  loop  	'||chr(10)||
'    l_query:=l_query || l_sep || ''"''|| ascii_cols(i) ||''"'';'||chr(10)||
'    l_sep   :='',''; ';

p:=p||'  '||chr(10)||
'  end loop;'||chr(10)||
'  l_query := l_query || '' from "'' || :F4300_P150_SCHEMA || ''"."'' ||:F4300_P160_ASC_EXPORT_TABLE||''"'';'||chr(10)||
''||chr(10)||
'  if :P170_WHERE_CLAUSE is not null then'||chr(10)||
'     w := trim(:P170_WHERE_CLAUSE);'||chr(10)||
'     if upper(substr(w,1,5)) = ''WHERE'' then'||chr(10)||
'        w := substr(w,6);'||chr(10)||
'     end if;'||chr(10)||
'     l_query := l_query||'' where ''||:P170_WHERE_CLAUSE;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  l_cnt:=wwv_flow_load_data.dump_ascii ('||chr(10)||
'             p';

p:=p||'_schema => :F4300_P150_SCHEMA,'||chr(10)||
'             p_separator=> :F4300_P180_SEPARATOR,'||chr(10)||
'             p_enclosed_by => :F4300_P180_ENCLOSED,'||chr(10)||
'             p_inc_col_names => :F4300_P180_INC_COLUMN_NAME,'||chr(10)||
'             p_query => l_query,'||chr(10)||
'             p_mime_charset => :P180_FILE_CHARSET,'||chr(10)||
'             p_file_format => :P180_FILE_FORMAT,'||chr(10)||
'             p_file_name => lower(:F4300_P160_ASC_EXPORT_TABLE));'||chr(10)||
'  wwv_f';

p:=p||'low.g_excel_format := true;'||chr(10)||
'  wwv_flow.g_page_text_generated := true;'||chr(10)||
'  wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 27164904458230351.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 180.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'export data process',
  p_process_sql_clob => p, 
  p_process_error_message=> 'データをエクスポートできません。',
  p_process_when_button_id=>27163504640971637.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P150_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 196670309198268035.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 180.4309,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P150_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 196684208130390717.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 180.4309,
  p_process_sequence=> 30,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 180.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_200.4
prompt  ...PAGE 200.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_imprt.htm';

ph:=ph||'<script type="text/javascript">'||chr(10)||
'	function p200_ClobUpload(){'||chr(10)||
'		var clob = new apex.ajax.clob(p200_ClobFinish);'||chr(10)||
'		clob._set($x(''F4300_P200_EXCEL_DATA'').value);'||chr(10)||
'		return;'||chr(10)||
'	}'||chr(10)||
'	function p200_ClobFinish(){'||chr(10)||
'			if(p.readyState == 1){'||chr(10)||
'			}else if(p.readyState == 2){'||chr(10)||
'			}else if(p.readyState == 3){'||chr(10)||
'			}else if(p.readyState == 4){'||chr(10)||
'					$x(''F4300_P200_EXCEL_DATA'').value=" "'||chr(10)||
'					doSubmit(''NEXT'');'||chr(10)||
'					return';

ph:=ph||';'||chr(10)||
'			}else{return false;}'||chr(10)||
'	}'||chr(10)||
'</script>'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_page(
  p_id     => 200.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163407',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>200.4309,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>200.4309,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6692405152674393.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 200.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 21272823578416828.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 200.4309,
  p_plug_name=> 'グローバリゼーション',
  p_region_name=>'',
  p_plug_template=> 21175625245088699.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 112725909100220750.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 200.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 112730325478228304.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 200.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 112716503290208213 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Microsoft Excelなどのスプレッドシート・プログラムからロードするデータをコピーし、「データ」フィールドにペーストしてください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221507019931389373.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 200.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 112733728255232765.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 200.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 112725909100220750+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 112736203452235067.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 200.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 112725909100220750+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:p200_ClobUpload();',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204374305269310796.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 200.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 112725909100220750+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>51886005938559488.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_branch_action=> '210',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>112736203452235067.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 30-MAY-2003 14:04 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>204374726822310798.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_branch_action=> '230',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>204374305269310796.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>列のセパレータ文字を指定してください。タブ区切りには、<strong>\t</strong>を使用します。</p>';

wwv_flow_api.create_page_item(
  p_id=>4208210436082721.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'F4300_P200_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 112725909100220750.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => ',',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'セパレータ',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P230_LOAD_TYPE',
  p_display_when2=>'CSV',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_reference_id => 3832614597433912,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>オプションで囲み文字を指定してください。</p>';

wwv_flow_api.create_page_item(
  p_id=>4209527059087470.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'F4300_P200_ENCLOSED_BY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 112725909100220750.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'囲み文字',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P230_LOAD_TYPE',
  p_display_when2=>'CSV',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_reference_id => 3832902320433912,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データに国際通貨記号が含まれている場合は、その記号をここに入力してください。</p>'||chr(10)||
'<p>たとえば、データに&euro;1,234.56または&yen;1,234.56が含まれている場合は、&euro;または&yen;と入力してください。  入力しない場合、データは正常にロードされません。</p>';

wwv_flow_api.create_page_item(
  p_id=>21275331197419000.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'P200_CURRENCY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 21272823578416828.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'declare'||chr(10)||
'    l_return_val varchar2(30) := ''$'';'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select value'||chr(10)||
'                 from nls_session_parameters'||chr(10)||
'                where parameter = ''NLS_CURRENCY'') loop'||chr(10)||
'        l_return_val := c1.value;'||chr(10)||
'        exit;'||chr(10)||
'    end loop;'||chr(10)||
'    --'||chr(10)||
'    return l_return_val;'||chr(10)||
'end;     ',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'通貨記号',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>グループ・セパレータは、千の位や百万の位などの整数グループを区切ります。</p>'||chr(10)||
'<p>グループ・セパレータには、任意の文字を指定できます。指定した文字はシングルバイトで、グループ・セパレータは他の小数点文字と異なる必要があります。セパレータには、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21710714544355494.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'P200_GROUP_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 21272823578416828.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_group_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'グループ・セパレータ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>小数点文字は、数値の整数部分と小数部分を区切ります。</p>'||chr(10)||
'<p>小数点文字には、任意の文字を指定できます。指定した文字はシングルバイトで、小数点文字はグループ・セパレータと異なる必要があります。小数点文字には、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21713607056362785.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'P200_DECIMAL_CHARACTER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 21272823578416828.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_decimal_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'小数点文字',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'このフィールドには、最大30KBのスプレッドシート・データを貼り付けることができます。';

wwv_flow_api.create_page_item(
  p_id=>112740117271247331.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'F4300_P200_EXCEL_DATA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 112725909100220750.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'データ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 32000,
  p_cHeight=> 10,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データの最初の行に列名が含まれる場合は、このオプションを選択してください。次の例を参照してください。</p>'||chr(10)||
'<pre>'||chr(10)||
'名前     給与     コミッション'||chr(10)||
'Clark    1000       10'||chr(10)||
'Scott    2000       20'||chr(10)||
'</pre>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'<pre>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'名前     給与     コミッション'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Clark    1000       10'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Scott    2000       20'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'</pre>';

wwv_flow_api.create_page_item(
  p_id=>112749902593269315.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'F4300_P200_IS_FIELD_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 112725909100220750.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'ISCOLUMN.NAME.TEXT',
  p_lov => 'select ''<span class="instructiontext">''||'||chr(10)||
'wwv_flow_lang.system_message(''F4300_INSTRUCT_TEXT'')||''</span>'' d, ''Y'' r from dual',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddataboldl"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>112754820696276154.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_name=>'F4300_P200_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 112725909100220750.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 49528010062670927.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 200.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P200_IS_FIELD_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'N',
  p_compute_when => 'F4300_P200_IS_FIELD_NAME',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 118390630315447740.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 200.4309,
  p_validation_name => 'data not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P200_EXCEL_DATA',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'データを指定する必要があります。',
  p_associated_item=> 112740117271247331.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52678302539369530.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 200.4309,
  p_validation_name => 'cannot be greater than 30KB',
  p_validation_sequence=> 20,
  p_validation => 'if length(:F4300_P200_EXCEL_DATA) > 30000 then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '貼り付けたデータが30KBを超えています。カンマ区切り(csv)またはタブ区切り形式でファイルを保存してください。その後、ファイルをアップロードして、データをロードしてください。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4210720957095218.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 200.4309,
  p_validation_name => 'separator not null',
  p_validation_sequence=> 30,
  p_validation => 'F4300_P200_SEPARATOR',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'セパレータを指定する必要があります。',
  p_validation_condition=> 'F4300_P230_LOAD_TYPE',
  p_validation_condition2=> 'CSV',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 112736203452235067.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 4208210436082721.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare  '||chr(10)||
'  l_first_row_is_col_name boolean := false;'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'  l_data clob := empty_clob();'||chr(10)||
'begin'||chr(10)||
'  select clob001 into l_data from apex_collections where collection_name=''CLOB_CONTENT'';'||chr(10)||
'  if :F4300_P200_IS_FIELD_NAME = ''Y'' then'||chr(10)||
'    l_first_row_is_col_name := true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  wwv_flow_load_excel_data.get_table_info ('||chr(10)||
'   p_string                 => l_data,'||chr(10)||
'   p_separator    ';

p:=p||'          => lower(nvl(:F4300_P200_SEPARATOR,''\t'')),'||chr(10)||
'   p_enclosed_by            => :F4300_P200_ENCLOSED_BY,   '||chr(10)||
'   p_first_row_is_col_name  => l_first_row_is_col_name,'||chr(10)||
'   p_currency               => :P200_CURRENCY,'||chr(10)||
'   p_numeric_chars          => :P200_DECIMAL_CHARACTER||:P200_GROUP_SEPARATOR,'||chr(10)||
'   p_load_type              => ''EXCEL'''||chr(10)||
'   );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 117624930761654964.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 200.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create collection',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Excelデータのロード中にエラーが発生しました。',
  p_process_when_button_id=>112736203452235067.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 200.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_210.4
prompt  ...PAGE 210.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph:=ph||'<script type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
'function f_ImportDataTypeOnload(){'||chr(10)||
'var lRow = html_GetElement(''importData'').rows[1];'||chr(10)||
'var lSelects = lRow.getElementsByTagName(''SELECT'');'||chr(10)||
'var lLength = lSelects.length;'||chr(10)||
'for(var i=0;i<lLength;i++){lSelects[i].onchange()}'||chr(10)||
'return;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
''||chr(10)||
'function f_ImportDataType(pThis,pThat){  '||chr(10)||
'var lCheckValues = new Array(''NUMBER'',''CLOB'',''DATE'',''BINARY_FLOAT'',''BINARY_DOUBLE'');'||chr(10)||
'  va';

ph:=ph||'r lTest2 = html_DisableOnValue(pThis,lCheckValues,pThat);'||chr(10)||
'  html_GetElement(pThat).disabled = false;'||chr(10)||
'  if(lTest2){'||chr(10)||
'    html_GetElement(pThat).setAttribute(''onfocus'',''this.blur()'');'||chr(10)||
'    }else{'||chr(10)||
'    html_GetElement(pThat).setAttribute(''onfocus'','''');'||chr(10)||
'  }'||chr(10)||
''||chr(10)||
'}'||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 210.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_html_page_onload=>'onload="f_ImportDataTypeOnload()"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163407',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>210.4309,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>210.4309,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6693915541677404.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 210.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_load_data.display_ntable_property(p_collection_name => ''EXCEL_IMPORT'');';

wwv_flow_api.create_page_plug (
  p_id=> 112768526710303685.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 210.4309,
  p_plug_name=> '表のプロパティを設定',
  p_region_name=>'',
  p_plug_template=> 279748823389483962.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 112771111398310853.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 210.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 112716503290208213 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 112785418706337777.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 210.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページでは、表の外観をプレビューできます。表名を入力し、列名またはデータ型を変更し、挿入する列を指定してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221508920062398800.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 210.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 112775326318317322.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 210.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 112785418706337777+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 116940415820894908.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 210.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 112785418706337777+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 112777203593320251.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 210.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 112785418706337777+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>116940829853894912.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_branch_action=> '220',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>116940415820894908.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>112777626990320254.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_branch_action=> '200',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>112777203593320251.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>77784300806046762.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_name=>'P210_PRESERVE_CASE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 112785418706337777.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'PRESERVE.CASE.Y',
  p_lov => '.'||to_char(87931511182663028 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>100051613844477110.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_name=>'F4300_P210_DUMMY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 112785418706337777.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Dummy',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データを作成してロードするデータベース・スキーマを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>112792123870350640.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_name=>'F4300_P200_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 112785418706337777.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'CREATE_TABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  q:=q||''select htf.escape_sc(c.schema) d, c.schema v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  if wwv_flow_global.g_xe then'||chr(10)||
'    q:=q||''  and exists (select null '';'||chr(10)||
'    q:=q||''              from sys.dba_sys_privs '';'||chr(10)||
'    q:=q||''              where privilege = ''''CREATE TABLE'''' '';'||chr(10)||
'    q:=q||''              and grantee = c.schema '';'||chr(10)||
'    q:=q||''              union all '';'||chr(10)||
'    q:=q||''              select null '';'||chr(10)||
'    q:=q||''              from sys.dba_sys_privs s, sys.dba_role_privs r '';'||chr(10)||
'    q:=q||''              where r.granted_role=s.grantee '';'||chr(10)||
'    q:=q||''              and r.grantee = c.schema '';'||chr(10)||
'    q:=q||''              and s.privilege = ''''CREATE TABLE'''') '';'||chr(10)||
'  else'||chr(10)||
'    q:=q||''  and exists (select null '';'||chr(10)||
'    q:=q||''               from sys.dba_sys_privs '';'||chr(10)||
'    q:=q||''               where privilege = ''''CREATE TABLE'''' '';'||chr(10)||
'    q:=q||''                 and grantee = c.schema)     '';'||chr(10)||
'  end if;         '||chr(10)||
'  q:=q||''  and exists (select null '';'||chr(10)||
'  q:=q||''                from sys.dba_users '';'||chr(10)||
'  q:=q||''               where username = c.schema) '';'||chr(10)||
'  q:=q||''order by 1 '';'||chr(10)||
'  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'return wwv_flow_global.g_xe',
  p_read_only_when_type=>'FUNCTION_BODY',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<div class="htmldbInfoBodyP">作成する表名を指定してください。デフォルトでは、すべての表名は大文字に変換されます。このデフォルトの動作を無効にするには「<span class="fielddatabold">大/小文字を保持</span>」を選択してください。</div>';

wwv_flow_api.create_page_item(
  p_id=>112794014812354843.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_name=>'F4300_P200_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 112785418706337777.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 77787115351050931.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_computation_sequence => 5,
  p_computation_item=> 'F4300_P200_TABLE_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(replace(wwv_flow_utilities.remove_spaces(:F4300_P200_TABLE_NAME),chr(32),''_''))',
  p_compute_when => 'P210_PRESERVE_CASE',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 100053005864480800.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 210.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P210_DUMMY',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'  l_col_name varchar2(4000) := null;'||chr(10)||
'  '||chr(10)||
'  function primary_key('||chr(10)||
'    p_primary_key_value in number,'||chr(10)||
'    p_index             in number )'||chr(10)||
'    return varchar2'||chr(10)||
'  is'||chr(10)||
'    l_return_value varchar2(4000) := NULL;'||chr(10)||
'  begin'||chr(10)||
'    if p_primary_key_value is not null then'||chr(10)||
'      if p_primary_key_value = p_index then'||chr(10)||
'        l_return_value := ''<INPUT TYPE="radio" NAME="f03" VALUE="''||p_primary_key_value||''" checked>'';'||chr(10)||
'      else'||chr(10)||
'        l_return_value := ''<INPUT TYPE="radio" NAME="f03" VALUE="''||p_index||''">'';'||chr(10)||
'      end if;'||chr(10)||
'    end if;'||chr(10)||
'    return l_return_value;'||chr(10)||
'  exception'||chr(10)||
'    when others then'||chr(10)||
'        return ''<INPUT TYPE="radio" NAME="f03" VALUE="''||p_index||''">'';'||chr(10)||
'  end;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'for i in 1..wwv_flow.g_f06.count loop'||chr(10)||
'  if :P210_PRESERVE_CASE is null then'||chr(10)||
'    l_col_name := upper(wwv_flow_utilities.remove_spaces(wwv_flow.g_f01(i)));'||chr(10)||
'  else'||chr(10)||
'    l_col_name := wwv_flow_utilities.remove_spaces(wwv_flow.g_f01(i));'||chr(10)||
'  end if;'||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 1,'||chr(10)||
'     p_attr_value => l_col_name'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 2,'||chr(10)||
'     p_attr_value => wwv_flow.g_f02(i)'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
'  --wwv_flow_collection.update_member_attribute ('||chr(10)||
'  --   p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'  --   p_seq => wwv_flow.g_f06(i),'||chr(10)||
'  --   p_attr_number => 3,'||chr(10)||
'  --   p_attr_value => primary_key(wwv_flow.g_f03(1),i)'||chr(10)||
'  --   );'||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 4,'||chr(10)||
'     p_attr_value => wwv_flow.g_f04(i)'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 5,'||chr(10)||
'     p_attr_value => wwv_flow.g_f05(i)'||chr(10)||
'     );'||chr(10)||
'     '||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f06(i),'||chr(10)||
'     p_attr_number => 6,'||chr(10)||
'     p_attr_value => wwv_flow.g_f07(i)'||chr(10)||
'     ); '||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'return ''true'';'||chr(10)||
'exception when others then'||chr(10)||
'	raise_application_error (-20001,''f05=''||wwv_flow_utilities.table_to_string2(wwv_flow.g_f05)||'' f06=''||'||chr(10)||
'	wwv_flow_utilities.table_to_string2(wwv_flow.g_f06));'||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 114893927053188792.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'column name not null, not > 30',
  p_validation_sequence=> 1,
  p_validation => 'declare'||chr(10)||
'begin'||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'    if wwv_flow.g_f01(i) is not null then'||chr(10)||
'      if length(wwv_flow.g_f01(i)) > 30 then'||chr(10)||
'        return wwv_flow_lang.system_message(''F4300.COL_NAMES_NOT_LONGER_THAN_30'');'||chr(10)||
'      end if;'||chr(10)||
'    else'||chr(10)||
'      return wwv_flow_lang.system_message(''F4300.COL_NAMES_NOT_NULL'');'||chr(10)||
'    end if;'||chr(10)||
'  end loop;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '列名エラーです。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 118154731285520466.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'table name not > 30',
  p_validation_sequence=> 2,
  p_validation => 'if length(:F4300_P200_TABLE_NAME) > 30 then'||chr(10)||
''||chr(10)||
'  return wwv_flow_lang.system_message(''F4300.TABLE_NAMES_NOT_LONGER_THAN_30'');'||chr(10)||
''||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '表名が長すぎます。',
  p_associated_item=> 112794014812354843.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 91385502544995259.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'column length not zero or null',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
'begin'||chr(10)||
'  for i in 1..wwv_flow.g_f05.count loop'||chr(10)||
'    if wwv_flow.g_f05(i) is not null then'||chr(10)||
'      if wwv_flow.g_f05(i) = 0 then'||chr(10)||
'        return wwv_flow_lang.system_message(''F4300.COL_LENGTH_NOT_ZERO'');'||chr(10)||
'      end if;'||chr(10)||
'    else'||chr(10)||
'      return wwv_flow_lang.system_message(''F4300.COL_LENGTH_NOT_NULL'');'||chr(10)||
'    end if;'||chr(10)||
'  end loop;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '列長エラーです。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 114895819289192431.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'table name not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P200_TABLE_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '表名を指定する必要があります。',
  p_associated_item=> 112794014812354843.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 115047225043539180.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'cannot have same table name',
  p_validation_sequence=> 10,
  p_validation => 'if wwv_flow_load_excel_data.table_exists('||chr(10)||
'  p_schema => :F4300_P200_OWNER,'||chr(10)||
'  p_table_name => wwv_flow_utilities.remove_spaces(:F4300_P200_TABLE_NAME)'||chr(10)||
'  ) then'||chr(10)||
'  return wwv_flow_lang.system_message(''F4300.F4500.TABLE_ALREADY_EXISTS'');'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '既存のオブジェクトですでに使用されている名前です。',
  p_associated_item=> 112794014812354843.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 116959425397939432.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'primary key not null',
  p_validation_sequence=> 10,
  p_validation => 'wwv_flow_utilities.table_to_string2(wwv_flow.g_f03) is not null',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => '主キー列を指定する必要があります。主キー列を追加する場合は、「次へ」ボタンをクリックしてください。',
  p_when_button_pressed=> 112780607187330691.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 117872306579291939.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'at least one upload selected',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'  l_no_count number := 0;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f04.count loop'||chr(10)||
''||chr(10)||
'    if wwv_flow.g_f04(i) = ''N'' then'||chr(10)||
''||chr(10)||
'      l_no_count := l_no_count + 1;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_no_count = wwv_flow.g_f04.count then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '新しい表に含める1つ以上の列を指定する必要があります。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 289728718255300356.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'reserved name',
  p_validation_sequence=> 20,
  p_validation => 'if wwv_flow_sw_util.is_database_reserved_word(p_word=>:F4300_P200_TABLE_NAME) then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '指定された表名は、Oracleの予約語です。  別の名前を選択してください。',
  p_associated_item=> 112794014812354843.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 291055332677788667.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'column name reserved word',
  p_validation_sequence=> 30,
  p_validation => 'for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'  if wwv_flow_sw_util.is_database_reserved_word(p_word=>upper(wwv_flow.g_f01(i))) then'||chr(10)||
'    return false;'||chr(10)||
'  end if;'||chr(10)||
'end loop;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '指定された列名は、Oracleの予約語です。  別の名前を選択してください。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 25730909453566476.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_validation_name => 'F4300_P200_OWNER',
  p_validation_sequence=> 40,
  p_validation => 'F4300_P200_OWNER',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'スキーマを指定する必要があります。',
  p_when_button_pressed=> 116940415820894908.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 112792123870350640.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'if :F4300_P200_OWNER is not null then'||chr(10)||
'wwv_flow_sw_api.check_priv(:F4300_P200_OWNER);'||chr(10)||
'end if;';

wwv_flow_api.create_page_process(
  p_id     => 70053517733697322.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 210.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 210.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_220.4
prompt  ...PAGE 220.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 220.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163407',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>220.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6694924891680101.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 220.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 117056604391055559.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 220.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 117059228102059736.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 220.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 112716503290208213 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページを使用すると、表の主キーを指定できます。データ・セット内のいずれの列も主キーとして適切でない場合は、新しい列を主キーとして指定してください。主キーは、表の行を一意に識別するために使用されます。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221515609374424159.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 220.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 117068923158076792.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 220.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 117056604391055559+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 220.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 117056604391055559+wwv_flow_api.g_id_offset,
  p_button_name    => 'Finish',
  p_button_image_alt=> 'データのロード',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 117070800779079776.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 220.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 117056604391055559+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>117073412886083354.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_branch_action=> '11',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>117073012899083351.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>29278228032445971.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_branch_action=> '220',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 2,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'P200_PK_TYPE',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 04-FEB-2003 15:30 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>52010014229160977.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_branch_action=> 'f?p=&FLOW_ID.:220:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 30-MAY-2003 18:31 by MIKE');
 
wwv_flow_api.create_page_branch(
  p_id=>117071203531079778.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_branch_action=> '210',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>117070800779079776.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キー制約名を入力してください。';

wwv_flow_api.create_page_item(
  p_id=>29225226404227933.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P200_PK1_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 22,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'制約名',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キーの計算方法を選択してください。または、主キー値を設定しないように選択してください。';

wwv_flow_api.create_page_item(
  p_id=>29231303248249589.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P200_PK_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 23,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'NEW_SEQUENCE',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'主キーの移入:',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP_WITH_SUBMIT',
  p_named_lov=> 'PK_TYPES',
  p_lov => '.'||to_char(29232624018252340 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キー値を移入するために使用する既存のデータベース順序の名前を指定してください。';

wwv_flow_api.create_page_item(
  p_id=>29236325197265446.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P200_EXISTING_SEQUENCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'順序',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(sequence_name) a, sequence_name b from sys.dba_sequences '||chr(10)||
'where sequence_owner = :F4300_P200_OWNER'||chr(10)||
'order by sequence_name',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 順序の選択 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P200_PK_TYPE = ''EXISTING_SEQUENCE''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'この新しい表の主キーを移入するために作成される新しいデータベース順序の名前を指定してください。';

wwv_flow_api.create_page_item(
  p_id=>29241232039286358.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P200_NEW_SEQUENCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'順序',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P200_PK_TYPE = ''NEW_SEQUENCE''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>51623109797120855.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P220_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 16,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '&nbsp;',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'主キーとして既存の列を選択することも、新しい列を追加することもできます。';

wwv_flow_api.create_page_item(
  p_id=>52007705655139616.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P200_PK1_OPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'NEW_KEY',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'主キーの移入元:',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP_WITH_SUBMIT',
  p_named_lov=> 'USE.EXISTING.COL',
  p_lov => '.'||to_char(87933423434676001 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表の行を識別するために、新しい列の名前の入力';

wwv_flow_api.create_page_item(
  p_id=>52012902417204955.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P200_PK1_2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 21.5,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'ID',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'新しい主キー列',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P200_PK1_OPTION',
  p_display_when2=>'NEW_KEY',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表を所有するスキーマです。';

wwv_flow_api.create_page_item(
  p_id=>117095028927104885.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P220_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ:',
  p_source=>'F4300_P200_OWNER',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする表の名前';

wwv_flow_api.create_page_item(
  p_id=>117097720517108862.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P220_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名:',
  p_source=>'F4300_P200_TABLE_NAME',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表の主キーとなる列を指定してください。主キーは行を一意に識別する列です。Oracleでは表が主キーを持つ必要はありませんが、このウィザードでは主キーを指定する必要があります。';

wwv_flow_api.create_page_item(
  p_id=>117102827837120664.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_name=>'P200_PK1',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 21,
  p_item_plug_id => 117056604391055559.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'主キー',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(c001)||''(''||c002||'')'' a, c001'||chr(10)||
'  from wwv_flow_collections'||chr(10)||
' where collection_name = ''EXCEL_IMPORT'' and c001 is not null'||chr(10)||
' order by seq_id'||chr(10)||
'',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 主キーの選択 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P200_PK1_OPTION',
  p_display_when2=>'EXISTING_KEY',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 13590021101989074.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P200_PK1_2',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'    l_pk    varchar2(40) := null;'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select c001'||chr(10)||
'                 from wwv_flow_collections'||chr(10)||
'                where collection_name = ''EXCEL_IMPORT'''||chr(10)||
'                  and upper(c001) = ''ID'') '||chr(10)||
'    loop'||chr(10)||
'        for i in 1..10 loop'||chr(10)||
'            for c2 in (select c001'||chr(10)||
'                         from wwv_flow_collections'||chr(10)||
'                        where collection_name = ''EXCEL_IMPORT'''||chr(10)||
'                          and upper(c001) = ''ID''||i) '||chr(10)||
'            loop'||chr(10)||
'                l_pk := ''ID'';'||chr(10)||
'            end loop;--c2'||chr(10)||
'            if l_pk is null then'||chr(10)||
'                return ''ID''||i;'||chr(10)||
'            else'||chr(10)||
'                l_pk := null;'||chr(10)||
'            end if;'||chr(10)||
'        end loop;--i'||chr(10)||
'    end loop;--c1'||chr(10)||
'    return ''ID'';'||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 29248007498307620.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P200_PK1_NAME',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'wwv_flow_sw_util.generate_pk_name(replace(:F4300_P200_TABLE_NAME,'' '',''_''));',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 29250213170318666.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P200_NEW_SEQUENCE',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'wwv_flow_sw_util.generate_seq_name(replace(:F4300_P200_TABLE_NAME,'' '',''_''));',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 29253014255347439.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 220.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'P200_PK1',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'begin'||chr(10)||
'   for c1 in ('||chr(10)||
'     select c001'||chr(10)||
'     from wwv_flow_collections'||chr(10)||
'     where collection_name = ''EXCEL_IMPORT'''||chr(10)||
'     and upper(c001) = ''ID'''||chr(10)||
'   ) loop'||chr(10)||
'     return c1.c001;'||chr(10)||
'   end loop;'||chr(10)||
'   for c1 in ('||chr(10)||
'     select c001'||chr(10)||
'     from wwv_flow_collections'||chr(10)||
'     where collection_name = ''EXCEL_IMPORT'''||chr(10)||
'     and upper(c001) like ''%ID'''||chr(10)||
'   ) loop'||chr(10)||
'     return c1.c001;'||chr(10)||
'   end loop;'||chr(10)||
'end;',
  p_compute_when => 'P200_PK1',
  p_compute_when_type=>'ITEM_IS_NULL_OR_ZERO');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29254418196358029.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'SEQUENCE not null',
  p_validation_sequence=> 10,
  p_validation => 'P200_EXISTING_SEQUENCE',
  p_validation_type => 'ITEM_NOT_ZERO',
  p_error_message => '順序を指定する必要があります。',
  p_validation_condition=> 'P200_PK_TYPE',
  p_validation_condition2=> 'EXISTING_SEQUENCE',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29236325197265446.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29266319281386761.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'PK_NAME available',
  p_validation_sequence=> 20,
  p_validation => 'begin'||chr(10)||
''||chr(10)||
'if not wwv_flow_builder.is_valid_identifier(''"''||:P200_PK1_NAME||''"'') then'||chr(10)||
'   return '||chr(10)||
'       wwv_flow_lang.system_message(''F4300.NOT_VALID_PK_NAME'',:P200_PK1_NAME);'||chr(10)||
'end if;'||chr(10)||
'    '||chr(10)||
'if not wwv_flow_sw_util.is_available_name(:P200_PK1_NAME, :P220_OWNER ) then'||chr(10)||
'   return '||chr(10)||
'   wwv_flow_lang.system_message(''F4300.F4500.NAME_ALREADY_USED'',:P200_PK1_NAME);'||chr(10)||
'end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'エラーです。',
  p_associated_item=> 29225226404227933.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52417430985005732.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'PK not null',
  p_validation_sequence=> 30,
  p_validation => 'P200_PK1',
  p_validation_type => 'ITEM_NOT_ZERO',
  p_error_message => '主キーを指定する必要があります。',
  p_validation_condition=> 'P200_PK1_OPTION',
  p_validation_condition2=> 'EXISTING_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 117102827837120664.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52419018303011469.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'PK not null',
  p_validation_sequence=> 35,
  p_validation => 'P200_PK1_2',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '主キーを指定する必要があります。',
  p_validation_condition=> 'P200_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 52012902417204955.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52420808391018166.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'PK not > 30 chars',
  p_validation_sequence=> 38,
  p_validation => 'if length(:P200_PK1_2) > 30 then'||chr(10)||
'  return false;'||chr(10)||
'end if;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '主キー列名は30文字を超えて指定できません。',
  p_validation_condition=> 'P200_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52424804066054749.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'PK gen option needs to be auto',
  p_validation_sequence=> 39,
  p_validation => 'if :P200_PK_TYPE = ''NOT_GENERATED'' then'||chr(10)||
'  return false;'||chr(10)||
'end if;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '新しい主キーを作成するときは、主キーを順序から生成する必要があります。',
  p_validation_condition=> 'P200_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29231303248249589.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29270400759419169.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'PK_NAME not null',
  p_validation_sequence=> 40,
  p_validation => 'P200_PK1_NAME',
  p_validation_type => 'ITEM_NOT_NULL_OR_ZERO',
  p_error_message => '主キー名を指定する必要があります。',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29225226404227933.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29274101928429039.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'SEQ_NAME available',
  p_validation_sequence=> 50,
  p_validation => 'begin'||chr(10)||
'if not wwv_flow_builder.is_valid_identifier(''"''||:P200_NEW_SEQUENCE||''"'') then'||chr(10)||
'   return wwv_flow_lang.system_message(''F4300.F4500.NOT_VALID_SEQ_NAME'',:P200_NEW_SEQUENCE);'||chr(10)||
'end if;'||chr(10)||
'    '||chr(10)||
'if not wwv_flow_sw_util.is_available_name(:P200_NEW_SEQUENCE, :P220_OWNER ) then'||chr(10)||
'   return wwv_flow_lang.system_message(''F4300.F4500.NAME_ALREADY_USED'',:P200_NEW_SEQUENCE);'||chr(10)||
'end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'エラーです。',
  p_validation_condition=> 'P200_PK_TYPE',
  p_validation_condition2=> 'NEW_SEQUENCE',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 29241232039286358.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 48704226490898036.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_validation_name => 'no duplicate PK col',
  p_validation_sequence=> 60,
  p_validation => 'declare'||chr(10)||
'    l_cnt pls_integer := 0;'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select count(c001) cnt'||chr(10)||
'               from wwv_flow_collections'||chr(10)||
'               where collection_name = ''EXCEL_IMPORT'''||chr(10)||
'               and upper(c001) = upper(:P200_PK1_2))'||chr(10)||
'    loop'||chr(10)||
'      l_cnt := c1.cnt;'||chr(10)||
'    end loop;'||chr(10)||
'    if l_cnt > 0 then'||chr(10)||
'      return wwv_flow_lang.system_message(''F4500.P602.DUP_COL_NAME'',:P200_PK1_2);'||chr(10)||
'    end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'エラーです。',
  p_validation_condition=> 'P200_PK1_OPTION',
  p_validation_condition2=> 'NEW_KEY',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_when_button_pressed=> 117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_associated_item=> 52012902417204955.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare    '||chr(10)||
'  l_cnames     wwv_flow_global.vc_arr2;  '||chr(10)||
'  l_data_type  wwv_flow_global.vc_arr2;  '||chr(10)||
'  l_upload     wwv_flow_global.vc_arr2;'||chr(10)||
'  l_max_length wwv_flow_global.vc_arr2;'||chr(10)||
'  l_seq_name   varchar2(255) := null;'||chr(10)||
'  l_pk1        varchar2(255) := :P200_PK1;'||chr(10)||
'  l_pk1_name   varchar2(255) := null;'||chr(10)||
'  i            pls_integer := 0;'||chr(10)||
'begin   '||chr(10)||
'   if :P200_PK1_OPTION = ''NEW_KEY'' then'||chr(10)||
'      i := i+1;'||chr(10)||
'      l';

p:=p||'_pk1 := replace(wwv_flow_utilities.remove_spaces(:P200_PK1_2),chr(32),''_'');	'||chr(10)||
'      if :P210_PRESERVE_CASE is null then'||chr(10)||
'        l_pk1 := upper(l_pk1);'||chr(10)||
'      end if;'||chr(10)||
'      l_cnames(i) := l_pk1;'||chr(10)||
'      l_data_type(i) := ''NUMBER'';'||chr(10)||
'      l_upload(i) := ''Y'';'||chr(10)||
'      l_max_length(i) := 30;'||chr(10)||
'   end if;	 '||chr(10)||
'    '||chr(10)||
'   for c in (select * '||chr(10)||
'             from wwv_flow_collections '||chr(10)||
'             where collection_name=''EX';

p:=p||'CEL_IMPORT'') loop'||chr(10)||
'     i := i+1; '||chr(10)||
'     l_cnames(i) := c.c001;'||chr(10)||
'     l_data_type(i) := c.c002;'||chr(10)||
'     l_upload(i) := c.c004;'||chr(10)||
'     l_max_length(i) := c.c005;    '||chr(10)||
'   end loop;  '||chr(10)||
' '||chr(10)||
'  if :P200_PK_TYPE = ''NEW_SEQUENCE'' then    '||chr(10)||
'    l_seq_name := :P200_NEW_SEQUENCE;'||chr(10)||
'    if :P210_PRESERVE_CASE is null then'||chr(10)||
'      l_seq_name := upper(l_seq_name);'||chr(10)||
'    end if;'||chr(10)||
'  elsif :P200_PK_TYPE = ''EXISTING_SEQUENCE'' then'||chr(10)||
'   ';

p:=p||' l_seq_name := :P200_EXISTING_SEQUENCE;'||chr(10)||
'  else'||chr(10)||
'    l_seq_name := NULL;'||chr(10)||
'  end if;'||chr(10)||
'  '||chr(10)||
' l_pk1_name := :P200_PK1_NAME;'||chr(10)||
' if :P210_PRESERVE_CASE is null then'||chr(10)||
'   l_pk1_name := upper(l_pk1_name);'||chr(10)||
' end if;'||chr(10)||
' wwv_flow_load_excel_data.create_table ('||chr(10)||
'  p_schema        => :F4300_P200_OWNER,'||chr(10)||
'  p_table_name    => wwv_flow_utilities.remove_spaces(:F4300_P200_TABLE_NAME),'||chr(10)||
'  p_pk1           => l_pk1,'||chr(10)||
'  p_pk1_name   ';

p:=p||'   => l_pk1_name,'||chr(10)||
'  p_pk1_type      => :P200_PK_TYPE,'||chr(10)||
'  p_seq_name      => l_seq_name,'||chr(10)||
'  --'||chr(10)||
'  p_cnames        => l_cnames,'||chr(10)||
'  p_data_type     => l_data_type,  '||chr(10)||
'  p_upload        => l_upload,'||chr(10)||
'  p_max_length    => l_max_length '||chr(10)||
'  );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 117113015507171948.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create table with new primary key',
  p_process_sql_clob => p, 
  p_process_error_message=> '表の作成中にエラーが発生しました。',
  p_process_when_button_id=>117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare      '||chr(10)||
'  l_first_row_is_col_name boolean := false;  '||chr(10)||
'  l_cnames        wwv_flow_global.vc_arr2;      '||chr(10)||
'  l_upload        wwv_flow_global.vc_arr2;  '||chr(10)||
'  i               number := 0;'||chr(10)||
'  --'||chr(10)||
'  l_data_type     wwv_flow_global.vc_arr2;'||chr(10)||
'  l_data_format   wwv_flow_global.vc_arr2;'||chr(10)||
'  l_parsed_data_format wwv_flow_global.vc_arr2;'||chr(10)||
'  l_data               clob := empty_clob();'||chr(10)||
'begin  '||chr(10)||
'  for c in (select * '||chr(10)||
' ';

p:=p||'           from wwv_flow_collections '||chr(10)||
'            where collection_name=''EXCEL_IMPORT'') loop'||chr(10)||
'    i := i + 1;'||chr(10)||
'    l_cnames(i) := c.c001;    '||chr(10)||
'    l_upload(i) := c.c004; '||chr(10)||
'    l_data_type(i) := c.c002;  '||chr(10)||
'    l_data_format(i) := c.c006;'||chr(10)||
'    l_parsed_data_format(i) := c.c027;   '||chr(10)||
'  end loop;  '||chr(10)||
''||chr(10)||
'  if :F4300_P200_IS_FIELD_NAME = ''Y'' then'||chr(10)||
'    l_first_row_is_col_name := true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  select clob001 into';

p:=p||' l_data from apex_collections where collection_name=''CLOB_CONTENT'';'||chr(10)||
''||chr(10)||
'  wwv_flow_load_excel_data.load_excel_data ('||chr(10)||
'   p_string      => l_data,'||chr(10)||
'   p_cnames      => l_cnames,'||chr(10)||
'   p_upload      => l_upload,'||chr(10)||
'   p_schema      => :F4300_P200_OWNER,'||chr(10)||
'   p_table       => wwv_flow_utilities.remove_spaces(:F4300_P200_TABLE_NAME),'||chr(10)||
'   p_data_type   => l_data_type,'||chr(10)||
'   p_data_format => l_data_format,'||chr(10)||
'   p_parsed_d';

p:=p||'ata_format => l_parsed_data_format,'||chr(10)||
'   p_separator   => lower(nvl(:F4300_P200_SEPARATOR,''\t'')),'||chr(10)||
'   p_enclosed_by => :F4300_P200_ENCLOSED_BY,'||chr(10)||
'   p_first_row_is_col_name => l_first_row_is_col_name,'||chr(10)||
'   p_load_to               => :F4300_P230_LOAD_TO,'||chr(10)||
'   p_currency              => :P200_CURRENCY,'||chr(10)||
'   p_numeric_chars         => :P200_DECIMAL_CHARACTER||:P200_GROUP_SEPARATOR,'||chr(10)||
'   p_load_type             =>';

p:=p||' :F4300_P230_LOAD_TYPE'||chr(10)||
'   );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 117884026167328458.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert data',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>117073012899083351.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P200_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 69935124519913951.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 220.4309,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 220.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_230.4
prompt  ...PAGE 230.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_imprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 230.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163408',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>230.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6681905105645992.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 230.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23238502857624260.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 230.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 112716503290208213 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204342305194256542.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 230.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 204357924615288019.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 230.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204342305194256542+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:9:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204360203968291570.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 230.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204342305194256542+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>4107407002608653.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_branch_action=> 'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:18,19,21::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>204360203968291570.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':F4300_P230_LOAD_TO = ''NEW'' and :F4300_P230_LOAD_FROM = ''UPLOAD''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 26-SEP-2002 13:54 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>101365129882269401.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_branch_action=> 'f?p=4300:22:&SESSION.:::22,23,24,25',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>204360203968291570.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':F4300_P230_LOAD_TO = ''EXIST'' and :F4300_P230_LOAD_FROM = ''UPLOAD''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 21-AUG-2002 15:49 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>7218508617368954.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_branch_action=> 'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:200,210,220,230,240,250,260,270::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>204360203968291570.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':F4300_P230_LOAD_TO = ''NEW'' and :F4300_P230_LOAD_FROM = ''PASTE''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 23-JAN-2006 15:49 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>7222330435375211.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_branch_action=> 'f?p=&APP_ID.:240:&SESSION.::&DEBUG.:200,210,220,230,240,250,260,270::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>204360203968291570.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 30,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':F4300_P230_LOAD_TO = ''EXIST'' and :F4300_P230_LOAD_FROM = ''PASTE''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 23-JAN-2006 15:50 by CBCHO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4077631590265585.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_name=>'F4300_P230_LOAD_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 204342305194256542.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Load Type',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする対象を選択してください。データベース表が存在する場合は、「既存の表」を選択してください。新しい表を作成する場合は、「新しい表」を選択してください。';

wwv_flow_api.create_page_item(
  p_id=>4085714930308101.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_name=>'F4300_P230_LOAD_TO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 204342305194256542.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'NEW',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ロード先:',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'TABLE.OPTION',
  p_lov => '.'||to_char(87922429003554589 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データを、ファイルからアップロードするか、またはスプレッドシートからコピー・アンド・ペーストするかを指定します。';

wwv_flow_api.create_page_item(
  p_id=>4087612637316960.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_name=>'F4300_P230_LOAD_FROM',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 204342305194256542.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'PASTE',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ロード元:',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'LOAD.OPTION',
  p_lov => '.'||to_char(87921416882551159 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'ヘルプ・テキストは使用できません';

wwv_flow_api.create_page_item(
  p_id=>5930027351163943.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_name=>'P230_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 204342305194256542.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 144922211438995306.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 230.4309,
  p_computation_sequence => 40,
  p_computation_item=> 'F4300_P230_LOAD_TYPE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'EXCEL',
  p_compute_when => 'F4300_P230_LOAD_FROM',
  p_compute_when_text=>'PASTE',
  p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 230.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_240.4
prompt  ...PAGE 240.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 240.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163408',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>240.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23362613308685338.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 240.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204401222157339825.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 240.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204716203535971465.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 240.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 204693724897946351 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>データをロードする表を所有するデータベース・スキーマを選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221518500978440614.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 240.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 204418301768357118.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 240.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204401222157339825+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204420610772359727.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 240.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204401222157339825+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204423219430362194.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 240.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204401222157339825+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>204421016156359729.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 240.4309,
  p_branch_action=> '250',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>204420610772359727.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>204423618157362195.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 240.4309,
  p_branch_action=> '230',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>204423219430362194.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Excelデータをロードする表を所有するデータベース・スキーマを選択してください。';

wwv_flow_api.create_page_item(
  p_id=>204430218669387043.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 240.4309,
  p_name=>'F4300_P240_TABLE_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 204401222157339825.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_SCHEMA_OWNERS',
  p_lov => 'select htf.escape_sc(c.schema) d, c.schema v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1'||chr(10)||
'',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'return wwv_flow_global.g_xe',
  p_read_only_when_type=>'FUNCTION_BODY',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 204445117363402835.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 240.4309,
  p_validation_name => 'F4300_P240_TABLE_OWNER Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4300_P240_TABLE_OWNER',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '「表の所有者」に値を指定する必要があります。',
  p_associated_item=> 204430218669387043.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 16-APR-2002 11:44');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 240.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_250.4
prompt  ...PAGE 250.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 250.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163408',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>250.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 75404811081728816.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 250.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204455910665421153.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 250.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204719732421973249.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 250.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 204693724897946351 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>データをロードするデータベース表を選択してください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221519827644448330.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 250.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 204459408919425445.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 250.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204455910665421153+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204464324156429813.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 250.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204455910665421153+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204461717230427774.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 250.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204455910665421153+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>204464717218429815.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 250.4309,
  p_branch_action=> '270',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>204462102510427777.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 250.4309,
  p_branch_action=> '240',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>204461717230427774.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>77440924890766833.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 250.4309,
  p_name=>'P250_CASE_SENSITIVE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 204455910665421153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'CASE.SENSITIVE.Y',
  p_lov => '.'||to_char(87923517360560740 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表の所有者の名前';

wwv_flow_api.create_page_item(
  p_id=>77443220866775141.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 250.4309,
  p_name=>'P250_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 204455910665421153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ:',
  p_source=>'F4300_P240_TABLE_OWNER',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードするデータベース表を選択してください。デフォルトでは、すべての表名は大文字に変換されます。このデフォルトの動作を無効にするには「<span class="fielddatabold">大/小文字区別</span>」を選択してください。';

wwv_flow_api.create_page_item(
  p_id=>204473631344441945.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 250.4309,
  p_name=>'F4300_P250_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 204455910665421153.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP',
  p_lov => 'select table_name a, table_name b'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner = :F4300_P240_TABLE_OWNER'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 77442009784771937.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 250.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P250_TABLE_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(:F4300_P250_TABLE_NAME)',
  p_compute_when => 'P250_CASE_SENSITIVE',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 204475426599444098.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 250.4309,
  p_validation_name => 'F4300_P250_TABLE_NAME Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4300_P250_TABLE_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '「表名」に値を指定する必要があります。',
  p_associated_item=> 204473631344441945.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 16-APR-2002 11:51');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 77472003251798396.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 250.4309,
  p_validation_name => 'table exits',
  p_validation_sequence=> 10,
  p_validation => 'select 1'||chr(10)||
'from sys.dba_objects'||chr(10)||
'where owner = :F4300_P240_TABLE_OWNER'||chr(10)||
'and object_name = :F4300_P250_TABLE_NAME'||chr(10)||
'and object_type in (''TABLE'')',
  p_validation_type => 'EXISTS',
  p_error_message => '表が存在しません。',
  p_validation_condition=> 'Previous',
  p_validation_condition_type=> 'REQUEST_NOT_EQUAL_CONDITION',
  p_associated_item=> 204473631344441945.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P240_TABLE_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 71467820924021531.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 250.4309,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 250.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_260.4
prompt  ...PAGE 260.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 260.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163408',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>260.4309,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23365808244693361.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 260.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204491026143474742.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 260.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_load_data.display_etable_property ('||chr(10)||
'    p_table_owner     => :F4300_P240_TABLE_OWNER,'||chr(10)||
'    p_table_name      => :F4300_P250_TABLE_NAME,'||chr(10)||
'    p_collection_name => ''EXCEL_IMPORT'''||chr(10)||
'    );';

wwv_flow_api.create_page_plug (
  p_id=> 204502624837490516.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 260.4309,
  p_plug_name=> '列のマッピングの定義',
  p_region_name=>'',
  p_plug_template=> 279748823389483962.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 7082409118250737.4309+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L',
  p_plug_query_sum_cols => '::::::',
  p_plug_query_number_formats => '::::::',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204723028108975231.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 260.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 204693724897946351 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>このページでは、データのロード方法をプレビューできます。データベース列名と、データ内の列を一致させます。列をアップロードするには「<b>はい</b>」を、しない場合は「<b>いいえ</b>」を選択します。アスタリスク(*)は、必須の列を示します。</p>'||chr(10)||
'<p>選択した表にデータをアップロードするには、「<b>データのインポート</b>」をクリックしてください。</p>'||chr(10)||
'<p>SQLワークショップを使用して、列長の変更、NOT NULL列の作成、列のデータ型の変更など、表属性を変更できます。</p> ';

wwv_flow_api.create_page_plug (
  p_id=> 221526028729477051.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 260.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 204494532430479511.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 260.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204491026143474742+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204499923557486442.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 260.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204491026143474742+wwv_flow_api.g_id_offset,
  p_button_name    => 'Import',
  p_button_image_alt=> 'データのロード',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204496812129483108.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 260.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204491026143474742+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>204500300920486444.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 260.4309,
  p_branch_action=> '11',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>204499923557486442.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>204497212696483110.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 260.4309,
  p_branch_action=> '270',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>204496812129483108.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3876124806580817.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 260.4309,
  p_name=>'F4300_P260_DUMMY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 204491026143474742.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Dummy',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'表の所有者の名前';

wwv_flow_api.create_page_item(
  p_id=>204576022341643606.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 260.4309,
  p_name=>'F4300_P260_TABLE_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 204491026143474742.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'スキーマ:',
  p_source=>'F4300_P240_TABLE_OWNER',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'データをロードする表の名前';

wwv_flow_api.create_page_item(
  p_id=>204580511127648778.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 260.4309,
  p_name=>'F4300_P260_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 204491026143474742.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'表名:',
  p_source=>'F4300_P250_TABLE_NAME',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 3877004851584509.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 260.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P260_DUMMY',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
'begin'||chr(10)||
'for i in 1..wwv_flow.g_f04.count loop'||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f04(i),'||chr(10)||
'     p_attr_number => 1,'||chr(10)||
'     p_attr_value => wwv_flow_utilities.remove_spaces(wwv_flow.g_f01(i))'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f04(i),'||chr(10)||
'     p_attr_number => 4,'||chr(10)||
'     p_attr_value => wwv_flow.g_f02(i)'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
'  wwv_flow_collection.update_member_attribute ('||chr(10)||
'     p_collection_name => ''EXCEL_IMPORT'','||chr(10)||
'     p_seq => wwv_flow.g_f04(i),'||chr(10)||
'     p_attr_number => 6,'||chr(10)||
'     p_attr_value => wwv_flow.g_f05(i)'||chr(10)||
'     );'||chr(10)||
'end loop;'||chr(10)||
'return ''true'';'||chr(10)||
''||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 1970910321700429.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 260.4309,
  p_validation_name => 'column name not null',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  l_null_found number := 0;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
''||chr(10)||
'    if wwv_flow.g_f02(i)=''Y'' then'||chr(10)||
''||chr(10)||
'      if replace(wwv_flow.g_f01(i),''%''||''null%'',null) is null then'||chr(10)||
''||chr(10)||
'        l_null_found := l_null_found + 1;'||chr(10)||
''||chr(10)||
'      end if;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_null_found > 0 then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '列名はNULLにできません。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 1976413962729112.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 260.4309,
  p_validation_name => 'at least one upload selected',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'  l_no_count number := 0;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f02.count loop'||chr(10)||
''||chr(10)||
'    if wwv_flow.g_f02(i) = ''N'' then'||chr(10)||
''||chr(10)||
'      l_no_count := l_no_count + 1;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_no_count = wwv_flow.g_f02.count then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'データをアップロードするには、1つ以上の列を指定して含める必要があります。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2246727491917184.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 260.4309,
  p_validation_name => 'not null columns must be loaded',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'  l_not_null_error number := 0;'||chr(10)||
''||chr(10)||
'  l_columns        varchar2(32767) := null;'||chr(10)||
''||chr(10)||
'  l_not_null_cols  varchar2(32767) := null;'||chr(10)||
''||chr(10)||
'  l_trigger_body   long;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  l_columns := wwv_flow_utilities.table_to_string2(wwv_flow.g_f01);'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  -- get trigger body if it is before insert trigger on the selected table'||chr(10)||
''||chr(10)||
'  for c1 in (select trigger_body'||chr(10)||
''||chr(10)||
'             from sys.dba_triggers'||chr(10)||
''||chr(10)||
'             where table_name = :F4300_P250_TABLE_NAME'||chr(10)||
''||chr(10)||
'             and table_owner = :F4300_P240_TABLE_OWNER'||chr(10)||
''||chr(10)||
'             and trigger_type like ''%BEFORE%'''||chr(10)||
''||chr(10)||
'             and triggering_event like ''%INSERT%'')'||chr(10)||
''||chr(10)||
'  loop'||chr(10)||
''||chr(10)||
'     l_trigger_body := c1.trigger_body;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  -- get all not null columns'||chr(10)||
''||chr(10)||
'  for c1 in (select column_name'||chr(10)||
''||chr(10)||
'             from sys.dba_tab_columns'||chr(10)||
''||chr(10)||
'             where table_name = :F4300_P250_TABLE_NAME'||chr(10)||
''||chr(10)||
'             and owner = :F4300_P240_TABLE_OWNER'||chr(10)||
''||chr(10)||
'             and nullable = ''N'''||chr(10)||
''||chr(10)||
'             ) loop'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'      for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
''||chr(10)||
'        -- If column names user selected is equal to not null columns,'||chr(10)||
''||chr(10)||
'        -- user didn''t include to upload'||chr(10)||
''||chr(10)||
'        -- and the column doesn''t have trigger, raise an error.'||chr(10)||
''||chr(10)||
'        if (wwv_flow.g_f01(i) = c1.column_name) then'||chr(10)||
''||chr(10)||
'          if wwv_flow.g_f02(i) = ''N'' then'||chr(10)||
''||chr(10)||
'            if instr(nvl(UPPER(l_trigger_body),'' ''),c1.column_name) = 0 then'||chr(10)||
''||chr(10)||
'              l_not_null_error := l_not_null_error + 1;'||chr(10)||
''||chr(10)||
'              l_not_null_cols := l_not_null_cols||'',''||c1.column_name;'||chr(10)||
''||chr(10)||
'            end if;'||chr(10)||
''||chr(10)||
'          end if;'||chr(10)||
''||chr(10)||
'        else'||chr(10)||
''||chr(10)||
'          -- If user did not select not null columns,'||chr(10)||
''||chr(10)||
'          -- and the column doesn''t have trigger'||chr(10)||
''||chr(10)||
'          -- raise an error.'||chr(10)||
''||chr(10)||
'          if instr(l_columns,c1.column_name) = 0 then'||chr(10)||
''||chr(10)||
'            if instr(nvl(UPPER(l_trigger_body),'' ''),c1.column_name) = 0 then'||chr(10)||
''||chr(10)||
'              l_not_null_error := l_not_null_error + 1;'||chr(10)||
''||chr(10)||
'              l_not_null_cols := l_not_null_cols||'',''||c1.column_name;'||chr(10)||
''||chr(10)||
'            end if;'||chr(10)||
''||chr(10)||
'          end if;'||chr(10)||
''||chr(10)||
'        end if;'||chr(10)||
''||chr(10)||
'      end loop;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  if l_not_null_error > 0 then'||chr(10)||
''||chr(10)||
'      return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'      return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '&F4300_P240_TABLE_OWNER..&F4300_P250_TABLE_NAME.には、NULL列がありません。エラーのないデータをアップロードするように選択してください。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2416102541642929.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 260.4309,
  p_validation_name => 'duplicate column names',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
'  l_col       varchar2(32767) := null;'||chr(10)||
'  l_duplicate boolean := true;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'    -- if column selected is to be uploaded, check for duplicate column selection'||chr(10)||
'    if wwv_flow.g_f02(i) = ''Y'' then'||chr(10)||
'        if instr('':''||nvl(l_col,'' '')||'':'','':''||wwv_flow.g_f01(i)||'':'') > 0 then'||chr(10)||
'          l_duplicate := false;'||chr(10)||
'        end if;'||chr(10)||
''||chr(10)||
'        if i > 1 then'||chr(10)||
'            l_col := '':'';'||chr(10)||
'        end if;'||chr(10)||
'        l_col := l_col||wwv_flow.g_f01(i);'||chr(10)||
'    end if;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  return l_duplicate;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '重複する列名が選択されました。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare  '||chr(10)||
'  l_first_row_is_col_name boolean := false;'||chr(10)||
'  l_cnames                wwv_flow_global.vc_arr2;'||chr(10)||
'  --'||chr(10)||
'  l_data_types            wwv_flow_global.vc_arr2;'||chr(10)||
'  l_parsed_data_format    wwv_flow_global.vc_arr2;'||chr(10)||
'  j                       pls_integer := 0;'||chr(10)||
'  l_data                  clob := empty_clob();'||chr(10)||
'begin'||chr(10)||
'  if :F4300_P270_IS_FIELD_NAME = ''Y'' then'||chr(10)||
'    l_first_row_is_col_name := true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'';

p:=p||'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'    l_cnames(i) := wwv_flow.g_f01(i);'||chr(10)||
'    for c1 in (select data_type'||chr(10)||
'               from sys.dba_tab_columns'||chr(10)||
'               where owner = :F4300_P240_TABLE_OWNER'||chr(10)||
'               and table_name = upper(:F4300_P250_TABLE_NAME)'||chr(10)||
'               and column_name = wwv_flow.g_f01(i)'||chr(10)||
'               order by column_id)'||chr(10)||
'    loop'||chr(10)||
'       l_data_types(i) := c1.data_type; ';

p:=p||'   	'||chr(10)||
'    end loop;  '||chr(10)||
'  end loop;'||chr(10)||
'  '||chr(10)||
'  for c in (select * '||chr(10)||
'            from wwv_flow_collections '||chr(10)||
'            where collection_name=''EXCEL_IMPORT'') loop'||chr(10)||
'    j := j + 1;    '||chr(10)||
'    l_parsed_data_format(j) := c.c027;   '||chr(10)||
'  end loop; '||chr(10)||
''||chr(10)||
'  select clob001 into l_data from apex_collections where collection_name=''CLOB_CONTENT'';'||chr(10)||
''||chr(10)||
'  wwv_flow_load_excel_data.load_excel_data ('||chr(10)||
'   p_string      => l_data,'||chr(10)||
'   p_cnam';

p:=p||'es      => l_cnames,'||chr(10)||
'   p_upload      => wwv_flow.g_f02,'||chr(10)||
'   p_schema      => :F4300_P240_TABLE_OWNER,'||chr(10)||
'   p_table       => :F4300_P250_TABLE_NAME,'||chr(10)||
'   p_data_type   => l_data_types,'||chr(10)||
'   p_data_format => wwv_flow.g_f05,'||chr(10)||
'   p_parsed_data_format => l_parsed_data_format,'||chr(10)||
'   p_separator   => lower(nvl(:F4300_P270_SEPARATOR,''\t'')),'||chr(10)||
'   p_enclosed_by => :F4300_P270_ENCLOSED_BY,'||chr(10)||
'   p_first_row_is_col_name => ';

p:=p||'l_first_row_is_col_name,'||chr(10)||
'   p_load_to               => :F4300_P230_LOAD_TO,'||chr(10)||
'   p_currency              => :P270_CURRENCY,'||chr(10)||
'   p_numeric_chars         => :P270_DECIMAL_CHARACTER||:P270_GROUP_SEPARATOR,'||chr(10)||
'   p_load_type             => :F4300_P230_LOAD_TYPE'||chr(10)||
'   );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 1998328769813398.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 260.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert data',
  p_process_sql_clob => p, 
  p_process_error_message=> 'データの挿入中にエラーが発生しました。',
  p_process_when_button_id=>204499923557486442.4309 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4300_P240_TABLE_OWNER);';

wwv_flow_api.create_page_process(
  p_id     => 71470128327033191.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 260.4309,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '無効なスキーマ',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 260.4309
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_270.4
prompt  ...PAGE 270.4309: データのロード
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_exprt.htm';

ph:=ph||'<script type="text/javascript">'||chr(10)||
'    var gTextArea = ''F4300_P270_EXCEL_DATA''; // set to textarea item name'||chr(10)||
''||chr(10)||
'    function data_set(){'||chr(10)||
'		var CLobTest = new apex.ajax.clob(function(){'||chr(10)||
'		$x(gTextArea).value=" ";'||chr(10)||
'		doSubmit(''NEXT'')});'||chr(10)||
'        CLobTest._set($x(gTextArea).value);'||chr(10)||
'    }'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 270.4309,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'データのロード',
  p_step_title=> 'データのロード',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215729525348581243+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 3485606247566446.4309+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163408',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>270.4309,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>270.4309,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 21176307696090495.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 270.4309,
  p_plug_name=> 'グローバリゼーション',
  p_region_name=>'',
  p_plug_template=> 21175625245088699.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 23364531662690652.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 270.4309,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6678815232629976 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6680621597641306.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204523926135583458.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 270.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 103900825378122658.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 204526605078583471.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 270.4309,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 204693724897946351 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Microsoft Excelなどのスプレッドシート・プログラムからインポートするデータをコピーし、「データ」フィールドにペーストしてください。</p>';

wwv_flow_api.create_page_plug (
  p_id=> 221523002972460150.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 270.4309,
  p_plug_name=> 'データのロード',
  p_region_name=>'',
  p_plug_template=> 104263607591363808.4309+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 204524106105583459.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 270.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204523926135583458+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '取消',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4300:9:&FLOW_SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204524413345583460.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 270.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204523926135583458+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> '次へ &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:data_set();',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 204524712263583462.4309 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 270.4309,
  p_button_sequence=> 10,
  p_button_plug_id => 204523926135583458+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 戻る',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>204526930972583473.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_branch_action=> '260',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'NEXT',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>204527202242583475.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_branch_action=> '250',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>204524712263583462.4309+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>列のセパレータ文字を指定してください。タブ区切りには、<strong>\t</strong>を使用します。</p>';

wwv_flow_api.create_page_item(
  p_id=>4182706815845162.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'F4300_P270_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 204523926135583458.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => ',',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'セパレータ',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P230_LOAD_TYPE',
  p_display_when2=>'CSV',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_reference_id => 3832614597433912,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>オプションで囲み文字を指定してください。</p>';

wwv_flow_api.create_page_item(
  p_id=>4184502444853276.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'F4300_P270_ENCLOSED_BY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 204523926135583458.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'囲み文字',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 2,
  p_cMaxlength=> 2,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4300_P230_LOAD_TYPE',
  p_display_when2=>'CSV',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_reference_id => 3832902320433912,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データに国際通貨記号が含まれている場合は、その記号をここに入力してください。</p>'||chr(10)||
'<p>たとえば、データに&euro;1,234.56または&yen;1,234.56が含まれている場合は、&euro;または&yen;と入力してください。  入力しない場合、データは正常にロードされません。</p>';

wwv_flow_api.create_page_item(
  p_id=>21177230552097084.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'P270_CURRENCY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 21176307696090495.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'declare'||chr(10)||
'    l_return_val varchar2(30) := ''$'';'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select value'||chr(10)||
'                 from nls_session_parameters'||chr(10)||
'                where parameter = ''NLS_CURRENCY'') loop'||chr(10)||
'        l_return_val := c1.value;'||chr(10)||
'        exit;'||chr(10)||
'    end loop;'||chr(10)||
'    --'||chr(10)||
'    return l_return_val;'||chr(10)||
'end;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'通貨記号',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>グループ・セパレータは、千の位や百万の位などの整数グループを区切ります。</p>'||chr(10)||
'<p>グループ・セパレータには、任意の文字を指定できます。指定した文字はシングルバイトで、グループ・セパレータは他の小数点文字と異なる必要があります。セパレータには、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21863704163128428.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'P270_GROUP_SEPARATOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 21176307696090495.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_group_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'グループ・セパレータ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>小数点文字は、数値の整数部分と小数部分を区切ります。</p>'||chr(10)||
'<p>小数点文字には、任意の文字を指定できます。指定した文字はシングルバイトで、小数点文字はグループ・セパレータと異なる必要があります。小数点文字には、空白を指定できますが、数字および次に示す文字は指定できません。</p>'||chr(10)||
'<ul class="noIndent">'||chr(10)||
'<li>プラス(+)</li>'||chr(10)||
'<li>ハイフン(-)</li> '||chr(10)||
'<li>小なり記号(<)</li>'||chr(10)||
'<li>大なり記号(>)</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>21865509835139517.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'P270_DECIMAL_CHARACTER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 21176307696090495.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'return wwv_flow.get_nls_decimal_separator;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'小数点文字',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 1,
  p_cMaxlength=> 1,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'このフィールドには、最大30KBのデータを貼り付けることができます。';

wwv_flow_api.create_page_item(
  p_id=>204525129697583464.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'F4300_P270_EXCEL_DATA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 204523926135583458.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'データ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 32000,
  p_cHeight=> 10,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 103910729134154335.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>データの最初の行に列名が含まれる場合は、このボックスを選択してください。</p>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'<pre>'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'名前     給与     コミッション'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Clark    1000       10'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'Scott    2000       20'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'</pre>';

wwv_flow_api.create_page_item(
  p_id=>204525430553583465.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'F4300_P270_IS_FIELD_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 204523926135583458.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'ISCOLUMN.NAME.TEXT',
  p_lov => 'select ''<span class="instructiontext">''||'||chr(10)||
'wwv_flow_lang.system_message(''F4300_INSTRUCT_TEXT'')||''</span>'' d, ''Y'' r from dual',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddataboldl"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 103909823939152778.4309+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>204525716148583467.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_name=>'F4300_P270_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 204523926135583458.4309+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 49537626170713419.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 270.4309,
  p_computation_sequence => 10,
  p_computation_item=> 'F4300_P270_IS_FIELD_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'N',
  p_compute_when => 'F4300_P270_IS_FIELD_NAME',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4186717812867171.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 270.4309,
  p_validation_name => 'separator not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P270_SEPARATOR',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'セパレータを指定する必要があります。',
  p_validation_condition=> 'F4300_P230_LOAD_TYPE',
  p_validation_condition2=> 'CSV',
  p_validation_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_associated_item=> 4182706815845162.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 83593200492080009.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 270.4309,
  p_validation_name => 'data cannot be > 30KB',
  p_validation_sequence=> 10,
  p_validation => 'if length(:F4300_P270_EXCEL_DATA) > 30000 then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '貼り付けたデータが30KBを超えています。カンマ区切り(csv)またはタブ区切り形式でファイルを保存してください。その後、ファイルをアップロードして、データをロードしてください。',
  p_associated_item=> .4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 204527804107583477.4309 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 270.4309,
  p_validation_name => 'data not null',
  p_validation_sequence=> 10,
  p_validation => 'F4300_P270_EXCEL_DATA',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'データを指定する必要があります。',
  p_associated_item=> 204525129697583464.4309 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare  '||chr(10)||
'  l_first_row_is_col_name boolean := false;'||chr(10)||
'  l_data clob := empty_clob();'||chr(10)||
'begin'||chr(10)||
'  select clob001 into l_data from apex_collections where collection_name=''CLOB_CONTENT'';'||chr(10)||
''||chr(10)||
'  if :F4300_P270_IS_FIELD_NAME = ''Y'' then'||chr(10)||
'    l_first_row_is_col_name := true;'||chr(10)||
'  end if;'||chr(10)||
'  wwv_flow_load_excel_data.get_table_info ('||chr(10)||
'   p_string                 => l_data,'||chr(10)||
'   p_separator              => lower(nvl(:F4300';

p:=p||'_P270_SEPARATOR,''\t'')),'||chr(10)||
'   p_enclosed_by            => :F4300_P270_ENCLOSED_BY,  '||chr(10)||
'   p_first_row_is_col_name  => l_first_row_is_col_name,'||chr(10)||
'   p_currency               => :P270_CURRENCY,'||chr(10)||
'   p_numeric_chars          => :P270_DECIMAL_CHARACTER||:P270_GROUP_SEPARATOR,'||chr(10)||
'   p_load_type              => ''EXCEL'''||chr(10)||
'   );'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 204528110232583479.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 270.4309,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create collection',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Excelデータのロード中にエラーが発生しました。',
  p_process_when=>'NEXT',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 270.4309
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/lists/application_tabs
 
begin
 
wwv_flow_api.create_list (
  p_id=> 1452315428006354.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Application Tabs',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 19007815325351347 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 1453127548009865.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 1452315428006354.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> '',
  p_list_item_status=> '',
  p_item_displayed=> '',
  p_list_item_display_sequence=>1,
  p_list_item_link_text=> 'ホーム',
  p_list_item_link_target=> 'f?p=4500:1000:&SESSION.',
  p_list_text_01=> '',
  p_list_item_current_type=> '',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 1453401360011729.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 1452315428006354.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> '',
  p_list_item_status=> '',
  p_item_displayed=> '',
  p_list_item_display_sequence=>2,
  p_list_item_link_text=> 'アプリケーション・ビルダー',
  p_list_item_link_target=> 'f?p=4000:1500:&SESSION.',
  p_list_text_01=> '',
  p_list_item_current_type=> '',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 231618309407162514.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 1452315428006354.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>3,
  p_list_item_link_text=> 'レポート作成サービス',
  p_list_item_link_target=> 'f?p=4800:1:&SESSION.',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_required_patch   => 231617022436156832.4309 + wwv_flow_api.g_id_offset,
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 1453707594013511.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 1452315428006354.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> '',
  p_list_item_status=> '',
  p_item_displayed=> '',
  p_list_item_display_sequence=>4,
  p_list_item_link_text=> 'SQLワークショップ',
  p_list_item_link_target=> 'f?p=4500:3002:&SESSION.',
  p_list_text_01=> '',
  p_list_item_current_type=> '',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 1454014173015400.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 1452315428006354.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>5,
  p_list_item_link_text=> 'ユーティリティ',
  p_list_item_link_target=> 'f?p=4500:1005:&SESSION.',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'ALWAYS',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/data_workshop_home_page_icons
 
begin
 
wwv_flow_api.create_list (
  p_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Data Workshop Home Page Icons',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 24562507636595183 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 2202519319502755.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>5,
  p_list_item_link_text=> 'ロード',
  p_list_item_link_target=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::',
  p_list_item_icon   => 'htmldb/builder/dw_import_ctrl.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3920312040546373.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'テキスト・データ',
  p_list_item_link_target=> 'f?p=4300:230:&SESSION.::NO:13,18,19,21,22,23,24,25::',
  p_parent_list_item_id=> 2202519319502755.4309 + wwv_flow_api.g_id_offset,
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3920000266542977.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>15,
  p_list_item_link_text=> 'スプレッドシート・データ',
  p_list_item_link_target=> 'f?p=&APP_ID.:230:&SESSION.::&DEBUG.:200,210,220,230,240,250,260,270:::',
  p_parent_list_item_id=> 2202519319502755.4309 + wwv_flow_api.g_id_offset,
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3920618966548359.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'XMLデータ',
  p_list_item_link_target=> 'f?p=4300:14:&SESSION.::NO:14,16,17::',
  p_parent_list_item_id=> 2202519319502755.4309 + wwv_flow_api.g_id_offset,
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 2203026938504982.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'アンロード',
  p_list_item_link_target=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::::',
  p_list_item_icon   => 'htmldb/builder/dw_export_ctrl.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3923617712557453.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'テキストへ',
  p_list_item_link_target=> 'f?p=&APP_ID.:150:&SESSION.::&DEBUG.:150,160,170,180:::',
  p_parent_list_item_id=> 2203026938504982.4309 + wwv_flow_api.g_id_offset,
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3923923599559118.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'XMLへ',
  p_list_item_link_target=> 'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:70,80,90:::',
  p_parent_list_item_id=> 2203026938504982.4309 + wwv_flow_api.g_id_offset,
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 2206807807518397.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> 'リポジトリ',
  p_list_item_link_target=> 'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:RP:::',
  p_list_item_icon   => 'htmldb/builder/dw_repository_ctrl.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 260022612007597680.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'インポート・リポジトリ',
  p_list_item_link_target=> 'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:RP:::',
  p_parent_list_item_id=> 2206807807518397.4309 + wwv_flow_api.g_id_offset,
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 260023118587599550.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 2202106852499122.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'スプレッドシートのインポート',
  p_list_item_link_target=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:RP:::',
  p_parent_list_item_id=> 2206807807518397.4309 + wwv_flow_api.g_id_offset,
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/data_import
 
begin
 
wwv_flow_api.create_list (
  p_id=> 3648913903408259.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'data import',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 3482816826549973 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 220739912737841935.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3648913903408259.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'スプレッドシートのインポート・リポジトリ',
  p_list_item_link_target=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_EQUALS_CONDITION',
  p_list_item_disp_condition=> '8',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3653931134432189.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3648913903408259.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'テキスト・データのインポート・リポジトリ',
  p_list_item_link_target=> 'f?p=&APP_ID.:8:&SESSION.::&DEBUG.::::',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_EQUALS_CONDITION',
  p_list_item_disp_condition=> '11',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/plain_text_data_import
 
begin
 
wwv_flow_api.create_list (
  p_id=> 3931814922814551.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Plain Text Data Import',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 23332419498365678 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 3932708473822070.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3931814922814551.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'ファイルの詳細',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '18,19,21,13',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '18',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3933320594825587.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3931814922814551.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> '表のプロパティ',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '18,19,21,13',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '19',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3933729944828323.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3931814922814551.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>40,
  p_list_item_link_text=> '主キー',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '18,19,21,13',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '21',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/plain_text_data_import2
 
begin
 
wwv_flow_api.create_list (
  p_id=> 3934205141830584.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Plain Text Data Import2',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 23332419498365678 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 3935014837833421.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3934205141830584.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'スキーマ',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '22',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3935318993834617.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3934205141830584.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> '表名',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '23',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3935628343837346.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3934205141830584.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>40,
  p_list_item_link_text=> 'ファイルの詳細',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '24',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 3935901116838942.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 3934205141830584.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>50,
  p_list_item_link_text=> '列のマッピング',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '25',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/builder_tab_list
 
begin
 
wwv_flow_api.create_list (
  p_id=> 19099308342605075.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'builder.tab.list',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 19007815325351347 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 27346516565060394.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 19099308342605075.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>1,
  p_list_item_link_text=> '&PRODUCT_NAME.',
  p_list_item_link_target=> 'f?p=4350:1:&SESSION.',
  p_list_item_disp_cond_type=> 'NEVER',
  p_list_item_disp_condition=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 19099819424608241.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 19099308342605075.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'アプリケーション・ビルダー',
  p_list_item_link_target=> 'f?p=4000:1500:&SESSION.::&DEBUG.:::',
  p_list_item_disp_cond_type=> 'EXISTS',
  p_list_item_disp_condition=> 'select 1 from wwv_flows where security_group_id = :flow_security_group_id',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 19100127042610497.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 19099308342605075.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> 'SQLワークショップ',
  p_list_item_link_target=> 'f?p=4500:1000:&SESSION.',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'ALWAYS',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 19100405356613616.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 19099308342605075.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>50,
  p_list_item_link_text=> 'データ・ワークショップ',
  p_list_item_link_target=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::',
  p_list_item_disp_cond_type=> 'NEVER',
  p_list_item_disp_condition=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'ALWAYS',
  p_list_item_current_for_pages=> 'f?p=4300:9:&SESSION.',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 27700700995058326.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 19099308342605075.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>60,
  p_list_item_link_text=> '管理',
  p_list_item_link_target=> 'f?p=4350:1:&SESSION.',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/data_loading
 
begin
 
wwv_flow_api.create_list (
  p_id=> 74707671328250039.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Data Loading',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 338656104634716337 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 2638109323313851.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 74707671328250039.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'テキスト・データのロード',
  p_list_item_link_target=> 'f?p=&APP_ID.:230:&SESSION.::&DEBUG.:18,19,21,22,23,24,25:F4300_P230_LOAD_FROM:UPLOAD:',
  p_list_item_icon   => 'htmldb/builder/abc_upload.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> 'Load data from structured flat files, such as files with comma separated data(cvs) or tab separated data.',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 126669304926863145.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 74707671328250039.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>15,
  p_list_item_link_text=> 'スプレッドシート・データのロード',
  p_list_item_link_target=> 'f?p=&APP_ID.:230:&SESSION.::&DEBUG.:200,210,220,230,240,250,260,270:::',
  p_list_item_icon   => 'htmldb/builder/load_excel.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> 'Convert Spreadsheets into database tables.',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 74710220544263433.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 74707671328250039.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'XMLデータのロード',
  p_list_item_link_target=> 'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:14,16,17:::',
  p_list_item_icon   => 'htmldb/builder/xml_upload2.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> 'Load data from XML in canonical format.',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/data_unloading
 
begin
 
wwv_flow_api.create_list (
  p_id=> 75585889878824332.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Data Unloading',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 338656104634716337 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 75614520977877818.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 75585889878824332.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'テキストへのアンロード',
  p_list_item_link_target=> 'f?p=&APP_ID.:150:&SESSION.::&DEBUG.:150,160,170,180:::',
  p_list_item_icon   => 'htmldb/builder/load_ascii.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> 'Export database data to a flat file.',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 75616418561883144.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 75585889878824332.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> 'XMLへのアンロード',
  p_list_item_link_target=> 'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:70,80,90:::',
  p_list_item_icon   => 'htmldb/builder/load_xml.gif',
  p_list_item_icon_attributes=> 'width="100" height="75" title="#LIST_LABEL#" alt="#LIST_LABEL#"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> 'Export database data to an XML document.',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/plain_text_data_export
 
begin
 
wwv_flow_api.create_list (
  p_id=> 104358211508848205.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Plain Text Data Export',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 23332419498365678 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 104369115334180721.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 104358211508848205.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'スキーマ',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '150',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 104369811236182654.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 104358211508848205.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> '表名',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '160',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 104370507786184183.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 104358211508848205.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> '列',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '170',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 104371204982185568.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 104358211508848205.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>40,
  p_list_item_link_text=> 'オプション',
  p_list_item_link_target=> '',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '180',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/xml_export
 
begin
 
wwv_flow_api.create_list (
  p_id=> 104417024127237376.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'XML Export',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 23332419498365678 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 104418520029239322.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 104417024127237376.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'スキーマ',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '70',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 104419216794240816.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 104417024127237376.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> '表名',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '80',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 104419912481242811.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 104417024127237376.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> '列',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '90',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/excel_data_import
 
begin
 
wwv_flow_api.create_list (
  p_id=> 112716503290208213.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Excel Data Import',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 23332419498365678 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 204680314570920715.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 112716503290208213.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>5,
  p_list_item_link_text=> 'ターゲットと方法',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '230',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 112719626353212694.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 112716503290208213.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'データ',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '200,210,220,230',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '200',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 112720322256214662.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 112716503290208213.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> '表のプロパティ',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '200,210,220,230',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '210',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 117063907614069206.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 112716503290208213.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> '主キー',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '200,210,220,230',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '220',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/xml_import
 
begin
 
wwv_flow_api.create_list (
  p_id=> 184273927814400294.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'XML Import',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 23332419498365678 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 184275722854402592.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 184273927814400294.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'スキーマ',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '14',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 184276520050403915.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 184273927814400294.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> '表名',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '16',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 184277315952405815.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 184273927814400294.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> 'ファイル名',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '17',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/excel_data_import2
 
begin
 
wwv_flow_api.create_list (
  p_id=> 204693724897946351.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Excel Data Import2',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 23332419498365678 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 204695520153948493.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 204693724897946351.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'タイプと方法',
  p_list_item_link_target=> '',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '230',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 204698011742952420.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 204693724897946351.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'スキーマ',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '240,250,260,270',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '240',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 204699205057955553.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 204693724897946351.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> '表名',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '240,250,260,270',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '250',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 204702125748961090.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 204693724897946351.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>40,
  p_list_item_link_text=> 'データ',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '240,250,260,270',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '270',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 204711009357968724.4309 + wwv_flow_api.g_id_offset,
  p_list_id=> 204693724897946351.4309 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>50,
  p_list_item_link_text=> '列のマッピング',
  p_list_item_link_target=> '',
  p_list_item_disp_cond_type=> 'CURRENT_PAGE_IN_CONDITION',
  p_list_item_disp_condition=> '240,250,260,270',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '260',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
 
begin
 
wwv_flow_api.create_menu (
  p_id=> 6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'dataworkshop.menu');
 
wwv_flow_api.create_menu_option (
  p_id=>2211613627528920.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>28488306101493931.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード/アンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_page_id=>1,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2211613627528920.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'アンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_page_id=>4,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2211613627528920.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'ロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_page_id=>9,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6682115379645994.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:230:&SESSION.::&DEBUG.:::',
  p_page_id=>230,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6686911916662790.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'XMLデータのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::',
  p_page_id=>14,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6689302211667279.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'XMLへのアンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:::',
  p_page_id=>70,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6690530882669221.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'テキストへのアンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.:::',
  p_page_id=>150,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6692619668674394.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:::',
  p_page_id=>200,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6694113198677405.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.:::',
  p_page_id=>210,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6695107375680103.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:220:&SESSION.::&DEBUG.:::',
  p_page_id=>220,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6828030820688031.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::',
  p_page_id=>18,
  p_also_current_for_pages=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_menu_option (
  p_id=>6829415292695176.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:::',
  p_page_id=>19,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6830608822698182.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::',
  p_page_id=>21,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6837120647738320.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2211613627528920.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'テキスト・データのロード・リポジトリ',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::',
  p_page_id=>8,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6843500362762964.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'XMLへのアンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:80:&SESSION.::&DEBUG.:::',
  p_page_id=>80,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6844627307765634.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'XMLへのアンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:::',
  p_page_id=>90,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6846217171770275.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'テキストへのアンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:160:&SESSION.::&DEBUG.:::',
  p_page_id=>160,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6847610701773370.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'テキストへのアンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.:::',
  p_page_id=>170,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>6848706388775367.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2226021785570759.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'テキストへのアンロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:180:&SESSION.::&DEBUG.:::',
  p_page_id=>180,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>7700814894541393.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'ホーム',
  p_long_name=>'',
  p_link=>'f?p=4500:1000:&SESSION.',
  p_page_id=>99999,
  p_security_scheme=>'FLOW: ADMIN',
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>9390600588273869.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>2211613627528920.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'スプレッドシートのリポジトリ',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::',
  p_page_id=>11,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>23356717195631333.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::',
  p_page_id=>22,
  p_also_current_for_pages=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_menu_option (
  p_id=>23358010294634530.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:::',
  p_page_id=>23,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>23359105981636561.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:::',
  p_page_id=>24,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>23360528181641436.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_page_id=>25,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>23362831810685340.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:240:&SESSION.::&DEBUG.:::',
  p_page_id=>240,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>23364720380690653.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:270:&SESSION.::&DEBUG.:::',
  p_page_id=>270,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>23366014557693362.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.:::',
  p_page_id=>260,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>28488306101493931.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>7700814894541393.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'ユーティリティ',
  p_long_name=>'',
  p_link=>'f?p=4500:1005:&SESSION.',
  p_page_id=>77777,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>75399131516711549.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6837120647738320.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'テキスト・データのロードの詳細',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::',
  p_page_id=>7,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>75401212754720215.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'XMLデータのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:::',
  p_page_id=>16,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>75402808656722114.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'XMLデータのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::',
  p_page_id=>17,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>75405026975728819.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>6679330816634474.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'データのロード',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:250:&SESSION.::&DEBUG.:::',
  p_page_id=>250,
  p_also_current_for_pages=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_menu_option (
  p_id=>236917018865057364.4309 + wwv_flow_api.g_id_offset,
  p_menu_id=>6678815232629976.4309 + wwv_flow_api.g_id_offset,
  p_parent_id=>9390600588273869.4309 + wwv_flow_api.g_id_offset,
  p_option_sequence=>10,
  p_short_name=>'スプレッドシートのロードの詳細',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::',
  p_page_id=>2,
  p_also_current_for_pages=> '');
 
null;
 
end;
/

prompt  ...page templates for application: 4309
--
--application/shared_components/user_interface/templates/page/4300_printer_friendly_ja
prompt  ......Page template 9113661096283.4309
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>';

c2:=c2||'</body>'||chr(10)||
'</html>';

c3:=c3||'<br />#BOX_BODY#';

wwv_flow_api.create_template(
  p_id=> 9113661096283.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> '4300_printer-friendly.ja',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 3,
  p_theme_class_id => 5,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 80874804748045950,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/green_look_left_and_right_sidebars_from_4999_ja
prompt  ......Page template 3485606247566446.4309
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'||chr(10)||
'';

c2:=c2||'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>'||chr(10)||
'<div class="htmldbFlowV">#FLOW_VERSION#</div>'||chr(10)||
'<div class="htmldbNewBottom">'||chr(10)||
'<div class="htmldbNewBottom1"><span>&MSG_COMPANY.</span><span>&MSG_USER.: &USER.</span></div>'||chr(10)||
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>'||chr(10)||
'<br />'||chr(10)||
'</div>'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'<a name="END"><br /></a>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td align="left"><a id="htmldbLogo2" href="#HOME_LINK#">#LOGO#</a></td>'||chr(10)||
'<td valign="top" align="right" class="NavBar">#NAVIGATION_BAR#<td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td valign="bottom" align="right" colspan="2"><div id="htmldbPageTabs">#REGION_POSITION_07#</div></td><td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<div id="htmldbBreadcrumbTop"><br /></div>'||chr(10)||
'<div ';

c3:=c3||'class="htmldbBreadcrumbRegion"><div class="htmldbBreadcrumbs">#REGION_POSITION_08#<span id="htmldbCustomize">#CUSTOMIZE#</span></div></div>'||chr(10)||
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div class="htmldbBodyMargin">'||chr(10)||
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%" class="htmldbRightLeftSidebar">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="top">#REG';

c3:=c3||'ION_POSITION_01#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top" width="100%"><a name="SkipRepNav"></a><div>#REGION_POSITION_02##REGION_POSITION_04##BOX_BODY#</div></td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top"><div syle="float:right;">#REGION_POSITION_03##REGION_POSITION_05#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</tabl';

c3:=c3||'e>'||chr(10)||
'</div>';

wwv_flow_api.create_template(
  p_id=> 3485606247566446.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Green Look (Left And Right SideBars) From 4999.ja',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'||chr(10)||
'',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_08',
  p_theme_id  => 3,
  p_theme_class_id => 16,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 18525205721780073,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/green_look_right_sidebar_from_4999_ja
prompt  ......Page template 7505408382227958.4309
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>';

c2:=c2||'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>'||chr(10)||
'<div class="htmldbFlowV">#FLOW_VERSION#</div>'||chr(10)||
'<div class="htmldbNewBottom">'||chr(10)||
'<div class="htmldbNewBottom1"><span>&MSG_COMPANY.</span><span>&MSG_USER.: &USER.</span></div>'||chr(10)||
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>'||chr(10)||
'<br />'||chr(10)||
'</div>'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'<a name="END"><br /></a>'||chr(10)||
'</body>'||chr(10)||
'</html>'||chr(10)||
'';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td align="left"><a id="htmldbLogo2" href="#HOME_LINK#">#LOGO#</a></td>'||chr(10)||
'<td valign="top" align="right" class="NavBar">#NAVIGATION_BAR#<td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td valign="bottom" align="right" colspan="2"><div id="htmldbPageTabs">#REGION_POSITION_07#</div></td><td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<div id="htmldbBreadcrumbTop"><br /></div>'||chr(10)||
'<div ';

c3:=c3||'class="htmldbBreadcrumbRegion"><div class="htmldbBreadcrumbs">#REGION_POSITION_08#<span id="htmldbCustomize">#CUSTOMIZE#</span></div></div>'||chr(10)||
'<a name="SkipRepNav"></a>'||chr(10)||
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div class="htmldbBodyMargin">'||chr(10)||
'<div>#REGION_POSITION_01#</div>'||chr(10)||
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%">';

c3:=c3||''||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_02##BOX_BODY#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top"><div style="float:right">#REGION_POSITION_03##REGION_POSITION_05#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<div>#REGION_POSITION_04#</div>'||chr(10)||
'</div>';

wwv_flow_api.create_template(
  p_id=> 7505408382227958.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Green Look (Right SideBar) From 4999.ja',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'||chr(10)||
'',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_08',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 18525411970780075,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/gray_box
prompt  ......region template 9113673096289.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbGBR" cellspacing="0" cellpadding="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="BT">#CLOSE#&nbsp;#EDIT##EXPAND##HELP##DELETE##COPY##CREATE#<img src="#IMAGE_PREFIX#up_arrow.gif" alt="&TOP." class="pb" onclick="uF()"/></th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 9113673096289.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'gray-box',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 17353903289599940,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 9113673096289.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/tasks
prompt  ......region template 3477413584526840.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="htmldbTasks" summary="" id="#REGION_STATIC_ID#"><tbody><tr><th class="L"><br /></th><th class="C">#TITLE#</th><th class="R"><br /></th></tr><tr><td colspan="3" class="B">#BODY#</td></tr></tbody></table>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 3477413584526840.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Tasks',
  p_plug_table_bgcolor     => '#F7F7E7',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '#F7F7E7',
  p_plug_font_size => '-1',
  p_reference_id=> 30436620668141833,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 3477413584526840.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/topbar
prompt  ......region template 3918621721760114.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td width="10"><img src="#IMAGE_PREFIX#htmldb/builder/bar_top.png" width="10" height="8" alt="" /></td><td rowspan="3" valign="middle" class="L">#BODY#</td><td rowspan="3" width="30" class="C"><br /></td><td rowspan="3" valign="middle" class="R" align="r';

t:=t||'ight" style="white-space:nowrap;"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr><tr><td style="background-image:url(#IMAGE_PREFIX#htmldb/builder/bar_bg.png)"><br /></td></tr><tr><td><img src="#IMAGE_PREFIX#htmldb/builder/bar_bottom.png" width="10" height="8"  alt="" /></td></tr></tbody></table>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 3918621721760114.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'topBar',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 21,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 17356300146599944,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 3918621721760114.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/show_hide
prompt  ......region template 21175625245088699.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbShowHide" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead id="head#REGION_STATIC_ID#"><tr><th class="htmldbShowHide"><span onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#'')"><img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />#TITLE#</span></';

t:=t||'th></tr></thead><tbody style="display:none;" id="body#REGION_STATIC_ID#"><tr><td class="htmldbShowHide">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 21175625245088699.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Show / Hide',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 18662712241194598,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 21175625245088699.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/top_bar_white_collapsed
prompt  ......region template 28090214165193975.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table style="margin:0px;" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><tbody><tr><td valign="middle" nowrap="nowrap" style="border:none;">#BODY#</th><th width="30"><br /></th><td valign="middle" nowrap="nowrap" style="border:none;" valign="middle">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</th></tr></tbody></table>';

t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.create_plug_template (
  p_id       => 28090214165193975.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Top Bar (white) (collapsed)',
  p_plug_table_bgcolor     => '#FFFFFF',
  p_theme_id  => 3,
  p_theme_class_id => 21,
  p_plug_heading_bgcolor => '#FFFFFF',
  p_plug_font_size => '-1',
  p_reference_id=> 17586323272111445,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 28090214165193975.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/report_region
prompt  ......region template 101735615849237059.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbRR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="BT" valign="bottom">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE##CREATE##CREATE2#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT#</th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.create_plug_template (
  p_id       => 101735615849237059.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Report Region',
  p_plug_table_bgcolor     => '#FFFFFF',
  p_theme_id  => 3,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '#FFFFFF',
  p_plug_font_size => '-1',
  p_reference_id=> 17354512447599941,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 101735615849237059.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_box
prompt  ......region template 103900825378122658.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1">#TITLE#</th><th class="H2">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 103900825378122658.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Box',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 18253116293565611,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 103900825378122658.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/info_c_htmldbinfo_from_4999
prompt  ......region template 104263607591363808.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="htmldbInfo" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="L"><br /></th><th class="C">#TITLE#</th><th class="R"><br /></th></tr></thead><tbody><tr><td colspan="3" class="B">#BODY#</td></tr></tbody></table>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 104263607591363808.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Info (c:htmldbInfo)  From 4999',
  p_plug_table_bgcolor     => '#F7F7E7',
  p_theme_id  => 3,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#F7F7E7',
  p_plug_font_size => '-1',
  p_reference_id=> 17355419405599943,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 104263607591363808.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/top_bar_panel_ui_fix_collapsed
prompt  ......region template 108205605860896611.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><tbody><tr><td><img src="#IMAGE_PREFIX#htmldb/builder/builder_find_top.png" width="10" height="8" alt="" /></td><td rowspan="3" class="TopBarUIFixC" valign="middle"><a href="javascript:popupURL(''f?p=4000:577:&SESSION.:&APP_PAGE_ID.'')">&nbsp;</a></td><td rowspan="3" class="TopBarUIFixL" valign="';

t:=t||'middle" style="">#BODY#</td><td rowspan="3" width="30"><br /></td><td rowspan="3" class="TopBarUIFixR" valign="middle"><span style="margin-right:10px;">#CLOSE#</span><span>#EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</span></td>'||chr(10)||
'</tr><tr><td style="background-image:url(#IMAGE_PREFIX#htmldb/builder/builder_find_bg.png)"><br /></td></tr><tr><td><img src="#IMAGE_PREFIX#htmldb/builder/builder_find_';

t:=t||'bottom.png" width="10" height="8"  alt="" /></td></tr></tbody></table>'||chr(10)||
'';

t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.create_plug_template (
  p_id       => 108205605860896611.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Top Bar (Panel, UI Fix) (collapsed)',
  p_plug_table_bgcolor     => '#FFFFFF',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '#FFFFFF',
  p_plug_font_size => '-1',
  p_reference_id=> 107329211143388687,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 108205605860896611.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/done_wizard_box_collapse
prompt  ......region template 279748823389483962.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table style="width:auto;" class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1" style="white-space:nowrap;">#TITLE#</th><th class="H2" style="white-space:nowrap;">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody id="body#REGION_ID#"><tr><td colspan="2" class="B">#BODY#</td></tr></';

t:=t||'tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 279748823389483962.4309 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> '(Done) Wizard Box (Collapse)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 236935712467247464,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 279748823389483962.4309 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/new_nav_bar_tabs
prompt  ......list template 1450923080002287.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="current"><div class="current"><br /></div><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></td>';

t2:=t2||'<td><div><br /></div><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>1450923080002287.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'New Nav Bar (Tabs)',
  p_theme_id  => 3,
  p_theme_class_id => 9,
  p_list_template_before_rows=>'<table border="0" cellspacing="0" cellpadding="0" summary="0"><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_reference_id=>1319831631286285,
  p_translate_this_template => 'N',
  p_list_template_comment=>'<td><a href="&LOGOUT_URL." class="logout" style="display:block;"><img src="#IMAGE_PREFIX#htmldb/icons/small_close.gif" alt="&LOGOUT."/></a></td></tr>');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/unordered_list
prompt  ......list template 3482816826549973.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3482816826549973.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'unordered list',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="htmldbUl">',
  p_list_template_after_rows=>'</ul>',
  p_reference_id=>60219508156141083,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/htmldb_tab_navigation
prompt  ......list template 19007815325351347.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="OnL"><img src="#IMAGE_PREFIX#htmldb/misc/tabOnL.png" alt="" /></td>'||chr(10)||
'<td class="OnC"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></td>'||chr(10)||
'<td class="OnR"><img src="#IMAGE_PREFIX#htmldb/misc/tabOnR.png" alt="" /></td>';

t2:=t2||'<td class="OffL"><img src="#IMAGE_PREFIX#htmldb/misc/tabOffL.png" alt="" /></td>'||chr(10)||
'<td class="OffC"><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></td>'||chr(10)||
'<td class="OffR"><img src="#IMAGE_PREFIX#htmldb/misc/tabOffR.png" alt="" /></td>'||chr(10)||
'';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>19007815325351347.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'htmldb_tab_navigation',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="" class="htmldbPageTabs">'||chr(10)||
'<tbody>'||chr(10)||
'<tr>'||chr(10)||
'',
  p_list_template_after_rows=>'</tr>'||chr(10)||
'</tbody>'||chr(10)||
'</table>',
  p_reference_id=>18977811338254211,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/flowwizard
prompt  ......list template 23332419498365678.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="htmldbWizCurrent">#TEXT#</div>';

t2:=t2||'<div class="htmldbWizNon">#TEXT#</div>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>23332419498365678.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'FlowWizard',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_list_template_before_rows=>'<div class="htmldbWizBar">',
  p_list_template_after_rows=>'</div>',
  p_between_items=>'<div class="htmldbWizArrow"><img src="#IMAGE_PREFIX#arrow_down.gif" width="7" height="6" alt="Down" /></div>',
  p_reference_id=>60218330803141060,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist
prompt  ......list template 24562507636595183.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#htmldb/builder/green_icon_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt=""/><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#htmldb/builder/green_icon_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" /><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>';

t5 := null;
t6 := null;
t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

wwv_flow_api.create_list_template (
  p_id=>24562507636595183.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML List (Image) with Sublist',
  p_theme_id  => 3,
  p_theme_class_id => 10,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'||chr(10)||
'<li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_reference_id=>6245728734686542,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/standard_list_w_link
prompt  ......list template 119835024987557728.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="htmldbStandardList1"><a href="#LINK#" class="itemLink" title="#TEXT_ESC_SC#">#TEXT#</a></td></tr>';

t2:=t2||'<tr><td class="htmldbStandardList2"><a href="#LINK#" class="itemLink" title="#TEXT_ESC_SC#">#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>119835024987557728.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'standard-list-w-link',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_list_template_before_rows=>'<table class="htmldbStandardList" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tbody>',
  p_list_template_after_rows=>'</tbody></table>',
  p_reference_id=>17385324891888482,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_list_with_images_30px_c_htmldblistimages30px
prompt  ......list template 338656104634716337.4309
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon" /></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>';

t2:=t2||'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon"/></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>338656104634716337.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal List with Images 30px (c:htmldbListImages30px)',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="htmldbListImages30px" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_reference_id=>338219701416750315,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999_2
prompt  ......report template 10583525904875984.4309
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 10583525904875984.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> '(DHTML) Automatic PPR Pagination Report From 4999 (2)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">'||chr(10)||
'<tbody>',
  p_row_template_after_rows =>'</tbody>'||chr(10)||
'<tfoot>#PAGINATION#</tfoot>'||chr(10)||
'</table>'||chr(10)||
'<span class="htmldbCSV">#CSV_LINK#</span>'||chr(10)||
''||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'#TEXT#'||chr(10)||
'',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>',
  p_row_style_mouse_over=>'#CCCCCC',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 3,
  p_theme_class_id => 7,
  p_reference_id=> 6574616710304003,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 10583525904875984.4309 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report
prompt  ......report template 24534016112516813.4309
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 24534016112516813.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> '(DHTML) Automatic PPR Pagination Report',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">'||chr(10)||
'<tbody>',
  p_row_template_after_rows =>'</tbody>'||chr(10)||
'<tfoot>#PAGINATION#</tfoot>'||chr(10)||
'</table>'||chr(10)||
'<span class="htmldbCSV">#CSV_LINK#</span>'||chr(10)||
''||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'#TEXT#'||chr(10)||
'',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>',
  p_row_style_mouse_over=>'#CCCCCC',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 3,
  p_theme_class_id => 7,
  p_reference_id=> 6574616710304003,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 24534016112516813.4309 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/formfield_nonrequired
prompt  ......label template 103909823939152778.4309
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 103909823939152778.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Nonrequired',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 17388415351892041,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/formfield_required
prompt  ......label template 103910729134154335.4309
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 103910729134154335.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelRequired" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999"><img src="#IMAGE_PREFIX#requiredicon_status2.gif" alt="" />',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 17388508175892042,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/copy_of_htmldb_greenarealabel_c_htmldbgalabel
prompt  ......label template 346584010124457412.4309
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 346584010124457412.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Copy of htmldb_GreenAreaLabel (c:htmldbGALabel)',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbGALabel" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 57728329098847875,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/breadcrumbs
prompt  ......template 6680621597641306.4309
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 6680621597641306.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'breadcrumbs',
  p_before_first=>'',
  p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>',
  p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'<span class="htmldbBreadcrumbSep">&gt;</span>',
  p_after_last=>'',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_reference_id            => 60115300853820165,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 14450905155573152.4309
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 14450905155573152.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif',
  p_popup_icon_attr=>'width="18" height="18" alt="#LIST_OF_VALUES#" title="#LIST_OF_VALUES#"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'検索ダイアログ・ボックス',
  p_page_html_head=>'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
'<head>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" type="text/css" />'||chr(10)||
'<script src="#IMAGE_PREFIX#javascript/apex_builder.js" type="text/javascript"></script>'||chr(10)||
'<style>a{font-size:12px;}</style>'||chr(10)||
'</head>',
  p_page_body_attr=>'onload="first_field()" class="htmldbPopup"',
  p_before_field_text=>'',
  p_page_heading_text=>'<div style="padding:2px;"><table><tr><td valign="top"><img src="#IMAGE_PREFIX#magnifying_glass_white_bg.gif" /></td><td>',
  p_page_footer_text =>'</td></tr></table></div>',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'検索',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'閉じる',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'次へ >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< 戻る',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'500',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">行 #FIRST_ROW# - #LAST_ROW#</div><center>',
  p_result_rows_per_pg=>200,
  p_before_result_set=>'<div style="padding-left:6px;">',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_reference_id       => 17343114994581872,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
prompt  ...application themes
--
prompt  ...build options used by application 4309
--
 
begin
 
--application/shared_components/logic/build_options/xml_publisher
wwv_flow_api.create_build_option (
  p_id=> 231617022436156832.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_build_option_name=> 'XML Publisher',
  p_build_option_status=> 'EXCLUDE',
  p_build_option_comment=> '');
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4309
--
--application/shared_components/globalization/dyntranslations
prompt  ...dynamic translations used by application: 4309
--
--application/shared_components/globalization/language
prompt  ...Language Maps for Application 4309
--
 
begin
 
null;
 
end;
/

prompt  ...Shortcuts
--
--application/shared_components/user_interface/shortcuts/item_help
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999"><img src="#IMAGE_PREFIX#infoicon_status_gray.gif" width=16 height=16 border=0></a>';

wwv_flow_api.create_shortcut (
 p_id=> 180670925407283078.4309 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'ITEM_HELP',
 p_shortcut_type=> 'HTML_TEXT',
 p_error_text=> 'ヘルプを表示できません。',
 p_reference_id=> 24184979678,
 p_shortcut=> c1);
end;
null;
 
end;
/

prompt  ...web services (9iR2 or better)
--
prompt  ...shared queries
--
prompt  ...report layouts
--
prompt  ...authentication schemes
--
--application/shared_components/security/authentication/internal
prompt  ......scheme 60872513468265716.4309
 
begin
 
declare
  s1 varchar2(32767) := null;
  s2 varchar2(32767) := null;
  s3 varchar2(32767) := null;
  s4 varchar2(32767) := null;
  s5 varchar2(32767) := null;
begin
s1:=s1||'return wwv_flow_security.internal_page_sentry;';

s2 := null;
s3 := null;
s4:=s4||'-BUILTIN-';

s5 := null;
wwv_flow_api.create_auth_setup (
  p_id=> 60872513468265716.4309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> '$INTERNAL$',
  p_description=>'Common scheme for all internal flows using custom Login Page and account credentials verification',
  p_page_sentry_function=> s1,
  p_sess_verify_function=> s2,
  p_pre_auth_process=> s3,
  p_auth_function=> s4,
  p_post_auth_process=> s5,
  p_invalid_session_page=>'',
  p_invalid_session_url=>'f?p=4550:1:&SESSION.',
  p_cookie_name=>'ORA_WWV_USER',
  p_cookie_path=>'&CGI_SCRIPT_NAME.',
  p_cookie_domain=>'',
  p_use_secure_cookie_yn=>'',
  p_ldap_host=>'',
  p_ldap_port=>'',
  p_ldap_string=>'',
  p_attribute_01=>'',
  p_attribute_02=>'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_attribute_03=>'',
  p_attribute_04=>'',
  p_attribute_05=>'',
  p_attribute_06=>'',
  p_attribute_07=>'',
  p_attribute_08=>'',
  p_reference_id=> 60856310633085148,
  p_required_patch=>'');
end;
null;
 
end;
/

--application/end_environment
commit;
commit;
begin 
execute immediate 'alter session set nls_numeric_characters='''||wwv_flow_api.g_nls_numeric_chars||'''';
end;
/
set verify on
set feedback on
prompt  ...done
