Rem
Rem $Header: sdo/admin/locdbmig.sql /main/4 2009/03/11 13:28:43 sravada Exp $
Rem
Rem locdbmig.sql
Rem
Rem Copyright (c) 2005, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      locdbmig.sql - LOCatorDBMIGration
Rem
Rem    DESCRIPTION
Rem      Used for upgradig the Locator as part of DB upgrade if SDO is not
Rem      present
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     08/27/06 - bug 5453881
Rem    sravada     05/25/05 - sravada_cleanup_label_difs_2
Rem    sravada     05/25/05 - Created
Rem


Alter session set current_schema=MDSYS;

/* Performa any upgrade actions if SDO is not installed.
    If SDO is installed, all of these actions are done as part of
       sdodbmig.sql  script. */

COLUMN :script_name NEW_VALUE comp_file NOPRINT
Variable script_name varchar2(50)
Variable sdo_cnt  number;

begin
  -- Check whether SDO is installed.
  -- If not, install Locator
  select count(*) into :sdo_cnt from all_objects where owner='MDSYS' and
  object_name = 'SDO_GEOMETRY';
  if (:sdo_cnt = 0) then
    :script_name := '?/rdbms/admin/nothing.sql';
  elsif (dbms_registry.is_valid('SDO') is  NULL) then
    :script_name := '@sdomigrt.sql';
  else
    :script_name := '?/rdbms/admin/nothing.sql';
  end if;
end;
/

select :script_name from dual;
@&comp_file


/* Now load catmdloc.sql only of SDO is not installed. If SDO is installed,
  the top level script will load catmd.sql */

COLUMN :script_name NEW_VALUE comp_file NOPRINT
Variable script_name varchar2(50)
 
begin
  -- Check whether SDO is installed.
  -- If not, install Locator
  if (dbms_registry.is_valid('SDO') is NULL) then
    :script_name := '@catmdloc.sql';
  else
    :script_name := '?/rdbms/admin/nothing.sql';
  end if;
end;
/
 
select :script_name from dual;
@&comp_file
 

-- reset the session id back to SYS
Alter session set current_schema=SYS;


