declare
begin
  begin
  execute immediate
'create table sdo_cmt_cbk_fn_table (table_schema varchar2(32),
                                   table_name   varchar2(32),
                                   cbk_schema   varchar2(32),
                                   cbk_fn_name  varchar2(32))';
  exception when others then NULL;
 end;
end;
/
declare
begin
  begin
  execute immediate
  ' drop table sdo_cmt_cbk_dml_table';
  exception when others then NULL;
  end;
end;
/
Create global temporary table sdo_cmt_cbk_dml_table (table_schema varchar2(32),
					             table_name   varchar2(32),
						     txn_seq_val  number); 
declare
begin
  begin
   execute immediate 
 ' Create sequence sdo_cmt_cbk_txn_order ORDER START WITH 1 CACHE 100 ';
  exception when others then NULL;
 end;
end;
/
grant select on sdo_cmt_cbk_txn_order to public;
declare
begin
  begin
   execute immediate
  ' drop table sdo_cmt_cbk_rtree_tab ';
  exception when others then NULL;
 end;
end;
/
Create table sdo_cmt_cbk_rtree_tab(geom mdsys.sdo_geometry);
declare 
begin
mdsys.sdo_meta.change_all_sdo_geom_metadata('MDSYS', 
'SDO_CMT_CBK_RTREE_TAB', 'GEOM' , 
mdsys.sdo_dim_array( mdsys.sdo_dim_element('X',-180,180,.000000005), 
mdsys.sdo_dim_element('Y',-90,90,.000000005))); 
end;
/
commit;
create or replace trigger  sdo_cmt_cbk_trig 
  BEFORE DELETE ON sdo_txn_idx_inserts
  FOR EACH ROW 
declare
  stmt 		varchar2(1024);
  table_schema	varchar2(32);
  table_name 	varchar2(32);
  cbk_schema	varchar2(32);
  cbk_fn_name 	varchar2(32);
  tab_cur	SYS_REFCURSOR;
  retval 	number;
begin 
  
  stmt := ' SELECT a.table_schema,  a.table_name, ' ||
          ' b.cbk_schema, b.cbk_fn_name from ' ||
	  ' sdo_cmt_cbk_dml_table a, sdo_cmt_cbk_fn_table  b ' ||
	  ' where a.table_schema = b.table_schema ' ||
	  ' and a.table_name = b.table_name  order by a.txn_seq_val asc '; 
  OPEN tab_cur FOR stmt;
  LOOP
    FETCH tab_cur INTO table_schema, table_name, cbk_schema, cbk_fn_name;
    EXIT WHEN tab_cur%NOTFOUND;
     
    BEGIN 
      retval := 1;
  
      EXECUTE IMMEDIATE  'declare retval number; begin retval:=' || cbk_schema || '.' || cbk_fn_name
	|| '(' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(table_schema) || ',' || 
	          SYS.DBMS_ASSERT.ENQUOTE_LITERAL(table_name) || '); end; ';
      
    END;
  END LOOP;

  CLOSE tab_cur;


end;
/
CREATE OR REPLACE PACKAGE prvt_cmt_cbk wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
129 fb
GeUa09fptWfIjFYcIf4YjxFoRb8wg/DcLpmsZy/NRfkYrasw/PzebpDD9bEBcdfcmTJfymaS
czuU5jaz3Zg0eLtqqCpUZXHi/rpXQe/LSd0i+7gl8x41BOMYOZD2YwVCJtl3C7PAfSbg1nxR
aQLC+o/puiE0yB7k7+NJ6C9qFTw5eYMhZs7tC0vWPlRlqaI+RAj5ZIVvcnbkQ6m/VWSTFF9B
T2onCkKXqDgKhmp9HYgkmTr8+1SLLp8=

/
show errors;
CREATE OR REPLACE PACKAGE BODY prvt_cmt_cbk wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
bfd 4a4
w78Dftau3hwpYSPH3dzZyn8D+5kwg5UrBUiDZy/NCjoYQgNMk/NQ0myJ8tQZqZQPfSOhheuX
Ny7WnhtlG2wJIryYvAZw0S62lPrxMYFH/1itx59ARVJj/vPSek5vHIywddxv5L74REWapgTg
cmeL5+98XxmNInaDtJiotPzVorsx45LUpq17cR60BH1TOzVFivzLxW9cS0bVpk9XNhrPkzqD
JwqQkWq4valdSm4cFSkY0D9Q9lUZh4prvEPf8VUlBekfkdmB8xtwvtvWPfVYHQ7Mdn9gho/L
Qaw67DtnQJyc2yG1+pfgRSOHkL0KT36+cFLS2KAT16c57iMisZ9iUy7em1NuAn/wTyxYJSWj
7HzMx9ld0JekGjDxj6jHAtSFBPM2p4bK6yU6E93xP+PUOavT2dUivIjKH3plZ7RbZhn90zxi
LDIYU3xm74rJi+JYNHca+qLfBoBM4HIxtxs6JNujtk1yHSrnWacefCsiCrgsYh+N47BtvuO/
/4/+HW1ULkyoMegK+h26NlACbW9nL9wDQ3xUfC20GTnPLyDy0TXr9yC+ELQbqgJOLPcEHtOO
UvUf7CfJkIOOiLotrRPbjXaVE8jRjD5t/+Zh9EIdGt5u4ta+bk9F8Ph8m9ik2unxh+4K6YU1
XH8rzKeR1zdBUOsBKUJX713WFfYKCAmbwW2eXBG4dAXu4CcCnhAEuTRoNNSQNI8xSOnP6eSJ
mXzt9SYptJ6qFr6kZlpDzIZPDPEUdm7R2aM473a7VGefaKEJGSdhcgxinJ/D2rBS8/7LnA+2
pkrl3RB1f2vcGoIBtI03c8WlZO1PEvoFgQX+sQSCMFs9zi/leB0SCx1+CA3KEQ0JWxINqfFM
nQU7l0/HadAB+VSqnuEMlOH2BaDXd3czzIZMJbXi2HtsgUIGtTMJ90sXBQAiMT1VluYPDsyQ
zXwGUmzhC74bq4QZi6zGk5aEY1i/Nc1xBaFIgG6rd3jtd5YyL7MukH0StJDJWIYGf41g9OEI
7Prg+rha00kbBKiXtmBix1bZ9J3D16KQ9UFTJTe/hmZojQHG0iAQCHkZs0NNoP5KO/t79FQv
gnUCXmEmTxp9fkU3ATDnY+PCPCvz1k2j7PKYn/r64IpGMZ7CUtJ/4xevbhu6MVCTYXl7aeO1
hM8um3afInP7vR74tQ==

/
show errors;
/
CREATE OR REPLACE PACKAGE BODY sdo_cmt_cbk wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
ae4 49c
NAypJaG+OY/+827QEpGI1XctokUwgztceSCDfC8ZsaXVuWoaNr1r5njexfxbSX/IKvRYzaDS
XtsMg8KNH0RF5dMkP2GGL+dQFcMUUV25vsYXmlWGHMBIaVvWLmgSVErBCBFFGIBqJKlUY+FQ
jNuvSKJ/jy8xImFTz9RHKQamNx8VYlHcH7PJLqn+P4hXovv5L/y0eLDC8hHaaIw7rMZn7ogo
VwS+VSdxIZ1cupdqJrHMNwL+wlj4SjEDoMswbjP3L7AQIeiAzICKs2fzSai9Wtvg3MyFyGoA
0/Jf8Nrg6pTwvEMttuOdEF6/FmB22bG0mUxoIFwYNO78q1GHKF4KV05V5NnjR0UDt+HCMttj
Ys3g3xT4MQYin+DXhjm8MszZgiYBPrHfbirtP/8DJvFx2NZCVrKkWY3XgwH6JV446c3pda3y
t6/FN0Ke3sIwHF/TVGO3xsYURHw47Rmjke0ZKWW2QPpqei5wbnpJiGqRYVkljc8Sk1+UHlYX
rUfKBqiIX0HKkJ2sjxJu46kpMDph2JYlnQrPhfzvCARWb3LhGwMDjheVaf2+FzKxy1RfBGqJ
sVLO1WZR5LzGf+k/P3RciDg8j25aMkjF4oOskd9IN1iUk8SHYZmT3eNt85nhiiNRTncxyWdo
v7iu337LvB4GL+e74Jep2f7XN2ldf2jlBInOvGLb6FwwfNARTb2E6h+aqDWPUlPv0mCTRoD2
0M5ozBSxC8EMJfMu8QYIN5+gHUh+rewkIrpej3Y3zm4xtTB+/fgL/WC8TwAB/7WCLbAhEykJ
JR3XXqsxtxNQzl+56xCnDQ/anlyoSrnCESRMkFGVxZVF/R69nDyz1ANzdZr+y4GxOwe7SjoZ
zeoGvhKLzZnesFAbtSdICcNAB961VU++E0JgZiixVkM7epsM2t/Cy3T4tO5m61Qb3vP4sM5f
AMQ56rJN5hPxyuuL8RS6e7gi5JBfKwiRdCgpz56F/oZf1qQYrLGwonFETrFYU1fi7uW91jFX
wXWy6PQhhxxfiWcM7+ogmQLkG7vI8c2YhZJn5HqkbWwHIAWl5dyAcR8DnCkyhnRVb+DG9OWW
okeZ2sKR+IxMf3Qdy+Xo4lQ7FrM6hHWy6kJd8mKNLkVHXodpQtYpJjEJpgBuQ3+Oy97J0fps
O4FDLCyBUY8=

/
SHOW ERRORS;
