declare
begin  
   begin
   execute immediate 
    'CREATE SEQUENCE  SDO_TOPO_TRANSACT_SUBSEQ NOCACHE ORDER ';
   execute immediate 
   ' CREATE SEQUENCE  SDO_TOPO_TRANSACT_SEQ NOCACHE ORDER ';
   exception when others then NULL;
  end;
end;
/
declare
begin
  begin
   execute immediate 
    ' drop table SDO_TOPO_TRANSACT_DATA ';
   exception when others then NULL;
  end;
  begin
   execute immediate 
    ' drop table SDO_TOPO_MAPS ';
   exception when others then NULL;
  end;
end;
/
CREATE GLOBAL TEMPORARY TABLE MDSYS.SDO_TOPO_MAPS (
   TOPOLOGY_ID    VARCHAR2(20) );
CREATE GLOBAL TEMPORARY TABLE MDSYS.SDO_TOPO_TRANSACT_DATA (
   TOPO_SEQUENCE  NUMBER,
   TOPOLOGY_ID    VARCHAR2(20),
   TOPO_ID        NUMBER,
   TOPO_TYPE      NUMBER,
   TOPO_OP        VARCHAR2(3),
   PARENT_ID      NUMBER);
GRANT select ON MDSYS.SDO_TOPO_TRANSACT_DATA TO PUBLIC;
CREATE OR REPLACE  VIEW SDO_TOPO_TRANSACT_DATA$ 
as select TOPOLOGY_ID,TOPO_ID, TOPO_TYPE, TOPO_OP, PARENT_ID
       from SDO_TOPO_TRANSACT_DATA;
GRANT select, insert ON MDSYS.SDO_TOPO_TRANSACT_DATA$ TO PUBLIC;
create or replace public synonym SDO_TOPO_TRANSACT_DATA$ for  
     MDSYS.SDO_TOPO_TRANSACT_DATA$;
declare
begin
  begin
   execute immediate
    ' DROP table  MDSYS.SDO_TOPO_RELATION_DATA ';
   exception when others then NULL;
  end;
end;
/
CREATE GLOBAL TEMPORARY TABLE MDSYS.SDO_TOPO_RELATION_DATA (
            TG_Layer_ID Number, 
            TG_ID Number, 
            Topo_ID Number,  
            Topo_type  Number,  
            Topo_attribute VARCHAR2(100));
GRANT select,insert,delete on  MDSYS.SDO_TOPO_RELATION_DATA to public;
/* Break this into an internal package which is executed as MDSYS
  and an external package which is executed as the USER.
  Grant public execute only to the external package so 
  we have less number of interfaces to worry about at the public
  execute level.  */
Create or replace package SDO_TOPO_METADATA_INT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
7ca 233
5XevQqq8aS50CuzGFJNkz5lnhqkwg9eN2cBqynTpmDPqS1kXRfzf1UTD5tav720bhwi1qsxL
t3V6q9opC5eX1r7qBlpnHcAdq+kKz5GazlTv1uFAEXaZEQrl07JC9MUvnmnFUQv82+bOO4TT
+Dhuzqbx9g6xnPJxLDEZI1X0EqLUldbRqyrjcU3qWngGVBS4021XtvGnI7tliomiiHlT8JHS
7IyqbZ5jJq//adNhr8B/7h0sNXqWlqkekv1HOAGzNfC/ERrEa5+MEUpgWINkGa7OQ0ry6/Pj
DhKpzxvMUWldEyRIvBLFPbD+t2MjTStjfXZwuWw8wSYAoiCnYICZTCwRmrJzc1GzsNVARe7B
GnsskinvAW4VTHZ/iTLsTFW6leltXx/S+UlFmkA32hvIel1361R2eK0XvwfnAMa3XSNUhIsX
CG2lFSNpBaChne0c6qXRvy6fBCDxFcohKRBq1tLV0G76cIkc5nf66W4aqGLolcqxV81Lru/9
NERJMTBJ8WlIOUDelQalf4eqUZdc7meMKcLmsOIkPdmwrqbZ6FU=

/
show errors;
Create or replace package SDO_TOPO_METADATA wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
1ce 134
GaaOav3q8ZU1SRMOl133XY+eixwwgwL3LkhqZ+cCmDM+VOgJ6lUj6Ygn0ODWAmvc6ry1YhiG
oqF3nZNrsxIsKHXISrR/R+nqsaGx96SZe+FA/g2mAohtZH8D+/+yWejbbF83rkhavPj182Fq
K8uDEOaUzmeMHM2BYzckmjG9qz/H3Yg+V5tqtccSmhw5lcLDPkXkaB/koIs2/TXgzwsMtQDK
6HaJZDyaBLrxpMOVvgyeetsON15fd061RgxfsqUc5odcyvD1aL91GGoNWtvpkB6CM0v9A3lU
l/63Da4PMxEwLg==

/
show errors;
Create or replace package BODY SDO_TOPO_METADATA_INT wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
33a5 faa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==

/
show errors;
Create or replace package BODY SDO_TOPO_METADATA wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
358 181
5piBa9UMPWPVQkfSs+kQav1DBkAwg43rAErWfC9EjzutlYk15j5hY6uKk+BEeoW0DE1TtWKf
fC+bhFqn4YhLmvhfDjUy1PEOcFWECkKlaKVpt4DwHPsFNqvGGPW4NvUIy41Pi7gX+qTUOJUB
KNQVlnsy5v6QbEsS243dr2TVymCj2Cm5P8WhYOdpad6KBLoeYSDQrlCvVKpo7gEIZZhhGr5G
9z06zTMO4HeQLeyYzRA3nXRggGuyMjXR8EXQuP0xxxkRQhpGYG8lZQiNyVZYWiVnQ4wX0E5R
yrqCxFTlZt6AMlH+Gqqda/ClLv+uS5f9YcqCPUKe8bxqZS9QaJCp7yxonjRqR3IGxkUeRTuT
o+J2rQC1eDqxLIyNBq0=

/
show errors;
grant execute on sdo_topo_metadata to public;
declare
begin
  begin   
   execute immediate 
     ' drop  table SDO_TOPO_DATA$ ';
   exception when others then NULL;
  end;
end;
/
CREATE GLOBAL TEMPORARY TABLE MDSYS.SDO_TOPO_DATA$ (
   TOPOLOGY          VARCHAR2(20),
   TG_LAYER_ID  NUMBER,
   TG_ID        NUMBER,
   TOPO_ID           NUMBER,
   TOPO_TYPE         NUMBER);
GRANT select, insert ON MDSYS.SDO_TOPO_DATA$ TO PUBLIC;
create or replace public synonym SDO_TOPO_DATA$ for  MDSYS.SDO_TOPO_DATA$;
CREATE OR REPLACE  TRIGGER SDO_TOPO_TRIG_INS1
INSTEAD OF INSERT ON SDO_TOPO_TRANSACT_DATA$
REFERENCING NEW AS n
FOR EACH ROW
declare
  user_name varchar2(32);
  topo_name varchar2(32);
  tname varchar2(100);
begin

   
   







   INSERT INTO SDO_TOPO_TRANSACT_DATA 
      values(SDO_TOPO_TRANSACT_SUBSEQ.nextval, :n.topology_id, :n.topo_id,
                :n.topo_type, :n.topo_op, :n.parent_id);

end;
/
show errors;
