declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1771;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1771,
        'La Canoa to REGVEN (1)',
        'TRANSFORMATION',
        4247,
        4189,
        'IGSB-Ven',
        1,
        9636,
        NULL,
        NULL,
        'Instituto Geografia de Venezuela Simon Bolivar',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1772,
        'La Canoa to WGS84 (1)',
        'TRANSFORMATION',
        4247,
        4326,
        'EPSG-Ven',
        1,
        9636,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1773,
        'POSGAR 98 to WGS 84 (1)',
        'TRANSFORMATION',
        4190,
        4326,
        'EPSG-Arg',
        1,
        9603,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1774,
        'POSGAR 98 to SIRGAS (1)',
        'TRANSFORMATION',
        4190,
        4170,
        'IGM-Arg',
        1,
        9603,
        NULL,
        NULL,
        'ISBN 85-240-0647-1. Sistema de Referencia Geocentrico para a America do Sul: Relatorio Final. IGBE Rio de Janeiro 1997.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1775,
        'Pulkovo 1942(83) to ETRS89 (2)',
        'TRANSFORMATION',
        4178,
        4258,
        'IfAG-Deu E 0.1m',
        2,
        9606,
        NULL,
        NULL,
        'Institute for Cartography and Geodesy; Leipzig via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1776,
        'DHDN to ETRS89 (2)',
        'TRANSFORMATION',
        4314,
        4258,
        'IfAG-Deu W 3m',
        2,
        9606,
        NULL,
        NULL,
        'Institute for Cartography and Geodesy; Leipzig via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1777,
        'DHDN to WGS 84 (2)',
        'TRANSFORMATION',
        4314,
        4326,
        'EPSG-Deu W 3m',
        2,
        9606,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1778,
        'DHDN to ETRS89 (3)',
        'TRANSFORMATION',
        4314,
        4258,
        'IfAG-Deu W-S',
        3,
        9606,
        NULL,
        NULL,
        'Institute for Cartography and Geodesy; Leipzig via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1779,
        'DHDN to ETRS89 (4)',
        'TRANSFORMATION',
        4314,
        4258,
        'IfAG-Deu W-cen',
        4,
        9606,
        NULL,
        NULL,
        'Institute for Cartography and Geodesy; Leipzig via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1780,
        'DHDN to ETRS89 (5)',
        'TRANSFORMATION',
        4314,
        4258,
        'IfAG-Deu W-N',
        5,
        9606,
        NULL,
        NULL,
        'Institute for Cartography and Geodesy; Leipzig via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1781,
        'DHDN to ETRS89 (6)',
        'TRANSFORMATION',
        4314,
        4258,
        'IfAG-Deu Thur',
        6,
        9606,
        NULL,
        NULL,
        'Institute for Cartography and Geodesy; Leipzig via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1782,
        'DHDN to ETRS89 (7)',
        'TRANSFORMATION',
        4314,
        4258,
        'IfAG-Deu Sach',
        7,
        9606,
        NULL,
        NULL,
        'Institute for Cartography and Geodesy; Leipzig via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1783,
        'ED50 to ETRS89 (9)',
        'TRANSFORMATION',
        4230,
        4258,
        'HGK-Tur',
        9,
        9606,
        NULL,
        NULL,
        'General Command of Mapping via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1784,
        'ED50 to WGS 84 (30)',
        'TRANSFORMATION',
        4230,
        4326,
        'EPSG-Tur',
        30,
        9606,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1785,
        'MGI to ETRS89 (3)',
        'TRANSFORMATION',
        4312,
        4258,
        'GURS-Svn',
        3,
        9606,
        NULL,
        NULL,
        'Geodetska Uprava Republike Slovenij via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1786,
        'MGI to WGS 84 (5)',
        'TRANSFORMATION',
        4312,
        4326,
        'EPSG-Svn',
        5,
        9606,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1787,
        'RT90 to ETRS89 (2)',
        'TRANSFORMATION',
        4124,
        4258,
        'NLS-Swe 2001',
        2,
        9607,
        NULL,
        NULL,
        'National Land Survey of Sweden (http://www.lm.se/geodesi/refsys/eng/refsys-eng.htm) via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1788,
        'RT90 to WGS 84 (2)',
        'TRANSFORMATION',
        4124,
        4326,
        'EPSG-Swe 2001',
        2,
        9607,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1789,
        'Dealui Piscului 1933 to WGS 84 (1)',
        'TRANSFORMATION',
        4316,
        4326,
        'NAMR-Rom',
        1,
        9603,
        NULL,
        NULL,
        'Petromar and NAMR',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1790,
        'Lisbon to ETRS89 (2)',
        'TRANSFORMATION',
        4207,
        4258,
        'ICC-Prt 2001',
        2,
        9606,
        NULL,
        NULL,
        'Instituto Portugues de Cartografia e Cadastro via EuroGeographics; http://crs.ifag.de/   Also given to greater precision (but no more accuracy) using the coordinate frame method at the IGEO website www.igeo.pt',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1791,
        'Lisbon to WGS 84 (2)',
        'TRANSFORMATION',
        4207,
        4258,
        'EPSG-Prt 2001',
        2,
        9606,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1792,
        'Datum 73 to ETRS89 (2)',
        'TRANSFORMATION',
        4274,
        4258,
        'ICC-Prt 2001',
        2,
        9606,
        NULL,
        NULL,
        'Instituto Portugues de Cartografia e Cadastro via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1793,
        'Datum 73 to WGS 84 (2)',
        'TRANSFORMATION',
        4274,
        4258,
        'EPSG-Prt 2001',
        2,
        9606,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1794,
        'MGI to WGS 84 (6)',
        'TRANSFORMATION',
        4312,
        4326,
        'JPet-Yug',
        6,
        9603,
        NULL,
        NULL,
        'Jugopetrol',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1795,
        'MGI to WGS 84 (7)',
        'TRANSFORMATION',
        4312,
        4326,
        'JPET-Yug MB',
        7,
        9636,
        NULL,
        NULL,
        'Jugopetrol',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1796,
        'Manoca 1962 to WGS 84 (1)',
        'TRANSFORMATION',
        4193,
        4326,
        'ELF94-Cmr',
        1,
        9603,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1797;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1797,
        'Qornoq 1927 to WGS 84 (1)',
        'TRANSFORMATION',
        4194,
        4326,
        'DMA-Grl S',
        1,
        9603,
        NULL,
        NULL,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1798,
        'Qornoq 1927 to WGS 84 (2)',
        'TRANSFORMATION',
        4194,
        4326,
        'KMS-Grl',
        2,
        9606,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1799,
        'Scoresbysund 1952 to WGS 84 (1)',
        'TRANSFORMATION',
        4195,
        4326,
        'KMS-Grl Scosd',
        1,
        9606,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1800,
        'Ammassalik 1958 to WGS 84 (1)',
        'TRANSFORMATION',
        4196,
        4326,
        'KMS-Grl Ammlk',
        1,
        9606,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1801,
        'Pointe Noire to WGS 84 (2)',
        'TRANSFORMATION',
        4282,
        4326,
        'CGG94-Cog',
        2,
        9603,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1802,
        'Pointe Noire to WGS 84 (3)',
        'TRANSFORMATION',
        4282,
        4326,
        'ELF95-Cog',
        3,
        9606,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1803,
        'AGD66 to GDA94 (11)',
        'TRANSFORMATION',
        4202,
        4283,
        'ICSM-Aus 0.1m',
        11,
        9615,
        NULL,
        NULL,
        'GDA Technical Manual.  http://www.anzlic.org.au/icsm/gdatm/chapter7.htm',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1804,
        'AGD84 to GDA94 (5)',
        'TRANSFORMATION',
        4203,
        4283,
        'Auslig-Aus 0.1m',
        5,
        9615,
        NULL,
        NULL,
        'GDA Technical Manual.  http://www.anzlic.org.au/icsm/gdatm/chapter7.htm',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1805,
        'Garoua to WGS 72BE (1)',
        'TRANSFORMATION',
        4197,
        4324,
        'ELF-Cmr',
        1,
        9603,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1806,
        'Kousseri to WGS 72BE (1)',
        'TRANSFORMATION',
        4198,
        4324,
        'ELF-Cmr',
        1,
        9603,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1807,
        'Pulkovo 1942 to WGS 84 (13)',
        'TRANSFORMATION',
        4284,
        4326,
        'BP-Aze Aioc95',
        13,
        9606,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1808,
        'Pulkovo 1942 to WGS 84 (14)',
        'TRANSFORMATION',
        4284,
        4326,
        'BP-Aze Aioc97',
        14,
        9606,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1809,
        'Pulkovo 1942 to WGS 84 (15)',
        'TRANSFORMATION',
        4284,
        4326,
        'TFE-Aze97',
        15,
        9606,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1810,
        'ED50 to WGS 84 (31)',
        'TRANSFORMATION',
        4230,
        4326,
        'wgc72-Egy',
        31,
        9606,
        NULL,
        NULL,
        'Western Geophysical',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1811,
        'PSAD56 to WGS 84 (12)',
        'TRANSFORMATION',
        4248,
        4326,
        'PB-Braz N',
        12,
        9603,
        NULL,
        NULL,
        'Petrobras',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1812,
        'Indian 1975 to WGS 84 (4)',
        'TRANSFORMATION',
        4240,
        4326,
        'Auslig-Tha',
        4,
        9606,
        NULL,
        NULL,
        'Auslig via GPS World.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1813,
        'Batavia to WGS 84 (2)',
        'TRANSFORMATION',
        4211,
        4326,
        'ARCO-Idn ONWJ',
        2,
        9603,
        NULL,
        NULL,
        'Arco geodetic database',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1814,
        'Batavia to WGS 84 (3)',
        'TRANSFORMATION',
        4211,
        4326,
        'KOM-Idn EJGP',
        3,
        9603,
        NULL,
        NULL,
        'PT Komaritim report S808/91.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1815,
        'Nord Sahara 1959 to WGS 84 (4)',
        'TRANSFORMATION',
        4307,
        4326,
        'BP-Alg D3',
        4,
        9606,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1816,
        'Nord Sahara 1959 to WGS 84 (5)',
        'TRANSFORMATION',
        4307,
        4326,
        'BPA-Alg InAm',
        5,
        9603,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1817,
        'Nord Sahara 1959 to WGS 84 (6)',
        'TRANSFORMATION',
        4307,
        4326,
        'ARCO-Alg HBR',
        6,
        9603,
        NULL,
        NULL,
        'Arco geodetic database',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1818,
        'Minna to WGS 84 (4)',
        'TRANSFORMATION',
        4263,
        4326,
        'RSL-Nga',
        4,
        9606,
        NULL,
        NULL,
        'Racal Survey Nigeria',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1819,
        'Minna to WGS 84 (5)',
        'TRANSFORMATION',
        4263,
        4326,
        'SPD-Nga S',
        5,
        9606,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1820,
        'Minna to WGS 84 (6)',
        'TRANSFORMATION',
        4263,
        4326,
        'CON89-Nga',
        6,
        9603,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1821,
        'Minna to WGS 84 (7)',
        'TRANSFORMATION',
        4263,
        4326,
        'ELF94-Nga',
        7,
        9603,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 5400;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        5400,
        'Baltic to Caspian',
        'TRANSFORMATION',
        5705,
        5706,
        'Caspian Sea',
        1,
        9616,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        5401,
        'Belfast to Malin Head',
        'TRANSFORMATION',
        5732,
        5731,
        'OSNI-Gbr NI',
        1,
        9616,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        5402,
        'Baltic to AIOC95',
        'TRANSFORMATION',
        5705,
        5734,
        'AIOC95-Aze',
        1,
        9616,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        5403,
        'AIOC95 to Caspian',
        'TRANSFORMATION',
        5734,
        5706,
        'AIOC95-Aze',
        1,
        9616,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        5404,
        'Baltic to Black Sea',
        'TRANSFORMATION',
        5705,
        5735,
        'Black Sea',
        1,
        9616,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8046,
        'ED50 to WGS 84 (14)',
        'CONCATENATED OPERATION',
        4230,
        4326,
        '5Nat-NSea90',
        14,
        NULL,
        NULL,
        NULL,
        'Norwegian Mapping Authority publication 1990:1 "The transformation between ED50 and WGS84 for exploration purposes in the North Sea".',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8047,
        'ED50 to WGS 84 (15)',
        'CONCATENATED OPERATION',
        4230,
        4326,
        'NMA-Nor N65 1991',
        15,
        NULL,
        NULL,
        NULL,
        'Statenskartverk note of January 1991 "Om transformasjon mellom geodetiske datum i Norge".',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8094,
        'NTF (Paris) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4807,
        4326,
        'EPSG-Fra',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8174,
        'Bogota 1975 (Bogota) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4802,
        4326,
        'DMA-Col',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8175,
        'Monte Mario (Rome) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4806,
        4326,
        'EPSG-Ita',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8176,
        'Tananarive (Paris) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4810,
        4326,
        'EPSG-Mdg',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8178,
        'Batavia (Jakarta) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4813,
        4326,
        'EPSG-Idn Sumatra',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8186,
        'NTF (Paris) to ED50 (1)',
        'CONCATENATED OPERATION',
        4807,
        4230,
        'EPSG-Fra',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8188,
        'NTF (Paris) to WGS 72 (1)',
        'CONCATENATED OPERATION',
        4807,
        4322,
        'EPSG-Fra',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8211,
        'Voirol 1875 (Paris) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4811,
        4326,
        'EPSG-Dza N',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8241,
        'Madrid 1870 (Madrid) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4903,
        4326,
        'EPSG-Esp',
        1,
        NULL,
        NULL,
        NULL,
        'See individual transformations.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8263,
        'MGI (Ferro) to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4805,
        4326,
        'DMA-balk',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8460,
        'NAD27 to NAD83(HARN) (1)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa AL',
        1,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8461,
        'NAD27 to NAD83(HARN) (2)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa AZ',
        2,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8462,
        'NAD27 to NAD83(HARN) (3)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa CA n',
        3,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8463,
        'NAD27 to NAD83(HARN) (4)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa CA s',
        4,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8464,
        'NAD27 to NAD83(HARN) (5)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa CO',
        5,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8465,
        'NAD27 to NAD83(HARN) (6)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa GA',
        6,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8466,
        'NAD27 to NAD83(HARN) (7)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa FL',
        7,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8467,
        'NAD27 to NAD83(HARN) (8)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa ID MT e',
        8,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 8468;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8468,
        'NAD27 to NAD83(HARN) (9)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa ID MT w',
        9,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8469,
        'NAD27 to NAD83(HARN) (10)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa KY',
        10,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8470,
        'NAD27 to NAD83(HARN) (11)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa LA',
        11,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8471,
        'NAD27 to NAD83(HARN) (12)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa DE MD',
        12,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8472,
        'NAD27 to NAD83(HARN) (13)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa ME',
        13,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8473,
        'NAD27 to NAD83(HARN) (14)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa MI',
        14,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8474,
        'NAD27 to NAD83(HARN) (15)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa MS',
        15,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8475,
        'NAD27 to NAD83(HARN) (16)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa NE',
        16,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8476,
        'NAD27 to NAD83(HARN) (17)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa NewEng',
        17,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8477,
        'NAD27 to NAD83(HARN) (18)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa NM',
        18,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8478,
        'NAD27 to NAD83(HARN) (19)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa NY',
        19,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8479,
        'NAD27 to NAD83(HARN) (20)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa ND',
        20,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8480,
        'NAD27 to NAD83(HARN) (21)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa OK',
        21,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8481,
        'Puerto Rico to NAD83(HARN) (1)',
        'CONCATENATED OPERATION',
        4139,
        4152,
        'NGS-PRVI',
        1,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8482,
        'NAD27 to NAD83(HARN) (22)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa SD',
        22,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8483,
        'NAD27 to NAD83(HARN) (23)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa TN',
        23,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8484,
        'NAD27 to NAD83(HARN) (24)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa TX e',
        24,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8485,
        'NAD27 to NAD83(HARN) (25)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa TX w',
        25,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8486,
        'NAD27 to NAD83(HARN) (26)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa VA',
        26,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8487,
        'NAD27 to NAD83(HARN) (27)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa OR WA',
        27,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8488,
        'NAD27 to NAD83(HARN) (28)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa WI',
        28,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8489,
        'NAD27 to NAD83(HARN) (29)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa WY',
        29,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  www.ngs.noaa.gov  NADCON readme file',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8496,
        'NAD27 to WGS 84 (28)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'NGS-Usa conus',
        28,
        NULL,
        NULL,
        NULL,
        'Both transformations from US National Geodetic Survey.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8508,
        'Old Hawaiian to NAD83(HARN) (1)',
        'CONCATENATED OPERATION',
        4135,
        4152,
        'NGS-Usa HI',
        1,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8509,
        'NAD27 to NAD83(HARN) (30)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa IN',
        30,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 8510;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8510,
        'NAD27 to NAD83(HARN) (31)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa KS',
        31,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8511,
        'NAD27 to NAD83(HARN) (32)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa NV',
        32,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8512,
        'NAD27 to NAD83(HARN) (33)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa OH',
        33,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8513,
        'NAD27 to NAD83(HARN) (34)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa UT',
        34,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8514,
        'NAD27 to NAD83(HARN) (35)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa WV',
        35,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8517,
        'Chos Malal 1914 to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4160,
        4326,
        'TOT-Arg Neu',
        1,
        NULL,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8532,
        'Indian 1960 to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4131,
        4326,
        'PV-Vnm',
        1,
        NULL,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

  end if;
end;
/
commit;
select 'commit 59' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 8537;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8537,
        'Egypt 1907 to WGS 84 (2)',
        'CONCATENATED OPERATION',
        4229,
        4326,
        'MCE-Egy',
        2,
        NULL,
        NULL,
        NULL,
        'Maridive',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8553,
        'NAD27 to NAD83(HARN) (36)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa IL',
        36,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8554,
        'NAD27 to NAD83(HARN) (37)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa NJ',
        37,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8562,
        'Nord Sahara 1959 to WGS 84 (3)',
        'CONCATENATED OPERATION',
        4307,
        4326,
        'CGG-Alg HM',
        3,
        NULL,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8568,
        'Deir ez Zor to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4227,
        4326,
        'EPSG-Syr',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8569,
        'ED50 to WGS 84 (21)',
        'CONCATENATED OPERATION',
        4230,
        4326,
        'EPSG-Nor N65 1997',
        21,
        NULL,
        NULL,
        NULL,
        'EPSG guidance note #10.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8570,
        'ED50 to ETRS89 (2)',
        'CONCATENATED OPERATION',
        4230,
        4258,
        '5Nat-NSea98',
        2,
        NULL,
        NULL,
        NULL,
        'Statens Kartverk.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8571,
        'Accra to WGS 84 (2)',
        'CONCATENATED OPERATION',
        4168,
        4326,
        'EPSG-Gha',
        2,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8581,
        'PSD93 to WGS 84 (2)',
        'CONCATENATED OPERATION',
        4134,
        4326,
        'PDO-Omn 93',
        2,
        NULL,
        NULL,
        NULL,
        'Petroleum Development Oman',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8582,
        'Old Hawaiian to WGS 84 (2)',
        'CONCATENATED OPERATION',
        4135,
        4326,
        'EPSG-Usa Hi',
        2,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8583,
        'Puerto Rico to WGS 84 (2)',
        'CONCATENATED OPERATION',
        4139,
        4326,
        'EPSG-PRVI',
        2,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8584,
        'NAD27 to NAD83(CSRS98) (3)',
        'CONCATENATED OPERATION',
        4267,
        4140,
        'EPSG-Can AB',
        3,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8585,
        'NAD27 to WGS 84 (36)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Can AB',
        36,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8586,
        'NAD27 to NAD83(HARN) (38)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa AR',
        38,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8587,
        'NAD27 to NAD83(HARN) (39)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa IA',
        39,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8588,
        'NAD27 to NAD83(HARN) (40)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa MN',
        40,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8589,
        'NAD27 to NAD83(HARN) (41)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'NGS-Usa MO',
        41,
        NULL,
        NULL,
        NULL,
        'US Coast & Geodetic Survey  ftp://ftp.ngs.noaa.gov/pub/pcsoft/nadcon',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8590,
        'NAD27 to WGS 84 (37)',
        'CONCATENATED OPERATION',
        4267,
        4152,
        'EPSG-Usa AL',
        37,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 8591;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8591,
        'NAD27 to WGS 84 (38)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa AZ',
        38,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8592,
        'NAD27 to WGS 84 (39)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa AR',
        39,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8593,
        'NAD27 to WGS 84 (40)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa CA n',
        40,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8594,
        'NAD27 to WGS 84 (41)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa CA s',
        41,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8595,
        'NAD27 to WGS 84 (42)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa CO',
        42,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8596,
        'NAD27 to WGS 84 (43)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa FL',
        43,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8597,
        'NAD27 to WGS 84 (44)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa GA',
        44,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8598,
        'NAD27 to WGS 84 (45)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa IL',
        45,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8599,
        'NAD27 to WGS 84 (46)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa IN',
        46,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8600,
        'NAD27 to WGS 84 (47)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa IA',
        47,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8601,
        'NAD27 to WGS 84 (48)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa KS',
        48,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8602,
        'NAD27 to WGS 84 (49)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa KY',
        49,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8603,
        'NAD27 to WGS 84 (50)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa LA',
        50,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8604,
        'NAD27 to WGS 84 (51)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa ME',
        51,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8605,
        'NAD27 to WGS 84 (52)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa DE MD',
        52,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8606,
        'NAD27 to WGS 84 (53)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa NewEng',
        53,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8607,
        'NAD27 to WGS 84 (54)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa MI',
        54,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8608,
        'NAD27 to WGS 84 (55)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa MN',
        55,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8609,
        'NAD27 to WGS 84 (56)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa MS',
        56,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8610,
        'NAD27 to WGS 84 (57)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa MO',
        57,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8611,
        'NAD27 to WGS 84 (58)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa ID MT e',
        58,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8612,
        'NAD27 to WGS 84 (59)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa ID MT w',
        59,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8613,
        'NAD27 to WGS 84 (60)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa NE',
        60,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8614,
        'NAD27 to WGS 84 (61)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa NV',
        61,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8615,
        'NAD27 to WGS 84 (62)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa NJ',
        62,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8616,
        'NAD27 to WGS 84 (63)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa NM',
        63,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 8617;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8617,
        'NAD27 to WGS 84 (64)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa NY',
        64,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8618,
        'NAD27 to WGS 84 (65)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa ND',
        65,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8619,
        'NAD27 to WGS 84 (66)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa OH',
        66,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8620,
        'NAD27 to WGS 84 (67)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa OK',
        67,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8621,
        'NAD27 to WGS 84 (68)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa OR WA',
        68,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8622,
        'NAD27 to WGS 84 (69)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa SD',
        69,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8623,
        'NAD27 to WGS 84 (70)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa TN',
        70,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8624,
        'NAD27 to WGS 84 (71)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa TX e',
        71,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8625,
        'NAD27 to WGS 84 (72)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa TX w',
        72,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8626,
        'NAD27 to WGS 84 (73)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa UT',
        73,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8627,
        'NAD27 to WGS 84 (74)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa VA',
        74,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8628,
        'NAD27 to WGS 84 (75)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa WV',
        75,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8629,
        'NAD27 to WGS 84 (76)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa WI',
        76,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8630,
        'NAD27 to WGS 84 (77)',
        'CONCATENATED OPERATION',
        4267,
        4326,
        'EPSG-Usa WY',
        77,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8631,
        'Garoua to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4197,
        4326,
        'EPSG-Cmr',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        8632,
        'Kousseri to WGS 84 (1)',
        'CONCATENATED OPERATION',
        4198,
        4326,
        'EPSG-Cmr',
        1,
        NULL,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10101,
        'Alabama CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        2000067,
        'TM67 / TWD67',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Oracle Taiwan',
        'Oracle Taiwan',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        2000097,
        'TM97 / TWD97',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Oracle Taiwan',
        'Oracle Taiwan',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 60' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 10102;
  if(rec_count = 0) then
    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10102,
        'Alabama CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10131,
        'SPCS83 Alabama East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10132,
        'SPCS83 Alabama West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10201,
        'Arizona Coordinate System East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10202,
        'Arizona Coordinate System Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10203,
        'Arizona Coordinate System West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 10231;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10231,
        'SPCS83 Arizona East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10232,
        'SPCS83 Arizona Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10233,
        'SPCS83 Arizona West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10301,
        'Arkansas CS27 North',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10302,
        'Arkansas CS27 South',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10331,
        'SPCS83 Arkansas North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10332,
        'SPCS83 Arkansas South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10401,
        'California CS27 zone I',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10402,
        'California CS27 zone II',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10403,
        'California CS27 zone III',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10404,
        'California CS27 zone IV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10405,
        'California CS27 zone V',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10406,
        'California CS27 zone VI',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10407,
        'California CS27 zone VII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10431,
        'SPCS83 California zone 1 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10432,
        'SPCS83 California zone 2 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10433,
        'SPCS83 California zone 3 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10434,
        'SPCS83 California zone 4 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10435,
        'SPCS83 California zone 5 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10436,
        'SPCS83 California zone 6 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10501,
        'Colorado CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10502,
        'Colorado CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10503,
        'Colorado CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10531,
        'SPCS83 Colorado North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10532,
        'SPCS83 Colorado Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 10533;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10533,
        'SPCS83 Colorado South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10600,
        'Connecticut CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10630,
        'SPCS83 Connecticut zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10700,
        'Delaware CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10730,
        'SPCS83 Delaware zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10901,
        'Florida CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10902,
        'Florida CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10903,
        'Florida CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10931,
        'SPCS83 Florida East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10932,
        'SPCS83 Florida West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        10933,
        'SPCS83 Florida North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11001,
        'Georgia CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11002,
        'Georgia CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11031,
        'SPCS83 Georgia East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11032,
        'SPCS83 Georgia West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11101,
        'Idaho CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11102,
        'Idaho CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11103,
        'Idaho CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11131,
        'SPCS83 Idaho East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11132,
        'SPCS83 Idaho Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11133,
        'SPCS83 Idaho West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11201,
        'Illinois CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11202,
        'Illinois CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11231,
        'SPCS83 Illinois East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11232,
        'SPCS83 Illinois West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 11301;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11301,
        'Indiana CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11302,
        'Indiana CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11331,
        'SPCS83 Indiana East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11332,
        'SPCS83 Indiana West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11401,
        'Iowa CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11402,
        'Iowa CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11431,
        'SPCS83 Iowa North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11432,
        'SPCS83 Iowa South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 61' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 11501;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11501,
        'Kansas CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11502,
        'Kansas CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11531,
        'SPCS83 Kansas North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11532,
        'SPCS83 Kansas South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11601,
        'Kentucky CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11602,
        'Kentucky CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11632,
        'SPCS83 Kentucky South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11701,
        'Louisiana CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11702,
        'Louisiana CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11731,
        'SPCS83 Louisiana North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11732,
        'SPCS83 Louisiana South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11801,
        'Maine CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11802,
        'Maine CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11831,
        'SPCS83 Maine East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11832,
        'SPCS83 Maine West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11900,
        'Maryland CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        11930,
        'SPCS83 Maryland zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 12001;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12001,
        'Massachusetts CS27 Mainland zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12002,
        'Massachusetts CS27 Island zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12031,
        'SPCS83 Massachusetts Mainland zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12032,
        'SPCS83 Massachusetts Island zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12101,
        'Michigan State Plane East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12102,
        'Michigan State Plane Old Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12103,
        'Michigan State Plane West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12111,
        'Michigan CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12112,
        'Michigan CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12113,
        'Michigan CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12141,
        'SPCS83 Michigan North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12142,
        'SPCS83 Michigan Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12143,
        'SPCS83 Michigan South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12201,
        'Minnesota CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12202,
        'Minnesota CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12203,
        'Minnesota CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12231,
        'SPCS83 Minnesota North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12232,
        'SPCS83 Minnesota Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12233,
        'SPCS83 Minnesota South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12301,
        'Mississippi CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12302,
        'Mississippi CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12331,
        'SPCS83 Mississippi East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12332,
        'SPCS83 Mississippi West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12401,
        'Missouri CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12402,
        'Missouri CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12403,
        'Missouri CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 12431;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12431,
        'SPCS83 Missouri East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12432,
        'SPCS83 Missouri Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12433,
        'SPCS83 Missouri West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12501,
        'Montana CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12502,
        'Montana CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12503,
        'Montana CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12530,
        'SPCS83 Montana zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12601,
        'Nebraska CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12602,
        'Nebraska CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12630,
        'SPCS83 Nebraska zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12701,
        'Nevada CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12702,
        'Nevada CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12703,
        'Nevada CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12731,
        'SPCS83 Nevada East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12732,
        'SPCS83 Nevada Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12733,
        'SPCS83 Nevada West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12800,
        'New Hampshire CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12830,
        'SPCS83 New Hampshire zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12900,
        'New Jersey CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        12930,
        'SPCS83 New Jersey zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13001,
        'New Mexico CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13002,
        'New Mexico CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13003,
        'New Mexico CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13031,
        'SPCS83 New Mexico East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13032,
        'SPCS83 New Mexico Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 13033;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13033,
        'SPCS83 New Mexico West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13101,
        'New York CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13102,
        'New York CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13103,
        'New York CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13104,
        'New York CS27 Long Island zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13131,
        'SPCS83 New York East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13132,
        'SPCS83 New York Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13133,
        'SPCS83 New York West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13134,
        'SPCS83 New York Long Island zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13200,
        'North Carolina CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13230,
        'SPCS83 North Carolina zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13301,
        'North Dakota CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13302,
        'North Dakota CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13331,
        'SPCS83 North Dakota North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13332,
        'SPCS83 North Dakota South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13401,
        'Ohio CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13402,
        'Ohio CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13431,
        'SPCS83 Ohio North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13432,
        'SPCS83 Ohio South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13501,
        'Oklahoma CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13502,
        'Oklahoma CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13531,
        'SPCS83 Oklahoma North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13532,
        'SPCS83 Oklahoma South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13601,
        'Oregon CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13602,
        'Oregon CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 13631;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13631,
        'SPCS83 Oregon North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13632,
        'SPCS83 Oregon South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13701,
        'Pennsylvania CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13702,
        'Pennsylvania CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13731,
        'SPCS83 Pennsylvania North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13732,
        'SPCS83 Pennsylvania South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13800,
        'Rhode Island CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13830,
        'SPCS83 Rhode Island zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13901,
        'South Carolina CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13902,
        'South Carolina CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        13930,
        'SPCS83 South Carolina zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14001,
        'South Dakota CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14002,
        'South Dakota CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14031,
        'SPCS83 South Dakota North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14032,
        'SPCS83 South Dakota South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14130,
        'SPCS83 Tennessee zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14201,
        'Texas CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14202,
        'Texas CS27 North Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14203,
        'Texas CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14204,
        'Texas CS27 South Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14205,
        'Texas CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14231,
        'SPCS83 Texas North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14232,
        'SPCS83 Texas North Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14233,
        'SPCS83 Texas Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14234,
        'SPCS83 Texas South Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 14235;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14235,
        'SPCS83 Texas South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14301,
        'Utah CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14302,
        'Utah CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14303,
        'Utah CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14331,
        'SPCS83 Utah North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14332,
        'SPCS83 Utah Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14333,
        'SPCS83 Utah South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14400,
        'Vermont CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14430,
        'SPCS83 Vermont zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14501,
        'Virginia CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 62' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 14502;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14502,
        'Virginia CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14531,
        'SPCS83 Virginia North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14532,
        'SPCS83 Virginia South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14601,
        'Washington CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14602,
        'Washington CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14631,
        'SPCS83 Washington North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14632,
        'SPCS83 Washington South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14701,
        'West Virginia CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14702,
        'West Virginia CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14731,
        'SPCS83 West Virginia North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14732,
        'SPCS83 West Virginia South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14801,
        'Wisconsin CS27 North zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14802,
        'Wisconsin CS27 Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14803,
        'Wisconsin CS27 South zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14831,
        'SPCS83 Wisconsin North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 14832;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14832,
        'SPCS83 Wisconsin Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14833,
        'SPCS83 Wisconsin South zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14901,
        'Wyoming CS27 East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14902,
        'Wyoming CS27 East Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14903,
        'Wyoming CS27 West Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14904,
        'Wyoming CS27 West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14931,
        'SPCS83 Wyoming East zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14932,
        'SPCS83 Wyoming East Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14933,
        'SPCS83 Wyoming West Central zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        14934,
        'SPCS83 Wyoming West zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15001,
        'Alaska CS27 zone 1',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9812,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15002,
        'Alaska CS27 zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15003,
        'Alaska CS27 zone 3',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15004,
        'Alaska CS27 zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15005,
        'Alaska CS27 zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15006,
        'Alaska CS27 zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15007,
        'Alaska CS27 zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15008,
        'Alaska CS27 zone 8',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15009,
        'Alaska CS27 zone 9',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15010,
        'Alaska CS27 zone 10',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15031,
        'SPCS83 Alaska zone 1 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9812,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15032,
        'SPCS83 Alaska zone 2 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15033,
        'SPCS83 Alaska zone 3 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15034,
        'SPCS83 Alaska zone 4 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15035,
        'SPCS83 Alaska zone 5 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15036,
        'SPCS83 Alaska zone 6 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 15037;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15037,
        'SPCS83 Alaska zone 7 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15038,
        'SPCS83 Alaska zone 8 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15039,
        'SPCS83 Alaska zone 9 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15040,
        'SPCS83 Alaska zone 10 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15101,
        'Hawaii CS27 zone 1',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15102,
        'Hawaii CS27 zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15103,
        'Hawaii CS27 zone 3',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15104,
        'Hawaii CS27 zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15105,
        'Hawaii CS27 zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15131,
        'SPCS83 Hawaii zone 1 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15132,
        'SPCS83 Hawaii zone 2 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15133,
        'SPCS83 Hawaii zone 3 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15134,
        'SPCS83 Hawaii zone 4 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15135,
        'SPCS83 Hawaii zone 5 (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15201,
        'Puerto Rico CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15202,
        'St. Croix CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15230,
        'SPCS83 Puerto Rico & Virgin Islands zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15301,
        'American Samoa Lambert',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US National Geodetic Survey (NGS)',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15302,
        'Tennessee CS27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'USGS Professional Paper #1395',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15303,
        'SPCS83 Kentucky North zone (meters)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'NOAA manual NOS NGS 5',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15304,
        'SPCS83 Arizona East zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15305,
        'SPCS83 Arizona Central zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15306,
        'SPCS83 Arizona West zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15307,
        'SPCS83 California zone 1 (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15308,
        'SPCS83 California zone 2 (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 15309;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15309,
        'SPCS83 California zone 3 (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15310,
        'SPCS83 California zone 4 (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15311,
        'SPCS83 California zone 5 (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15312,
        'SPCS83 California zone 6 (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15313,
        'SPCS83 Colorado North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15314,
        'SPCS83 Colorado Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15315,
        'SPCS83 Colorado South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15316,
        'SPCS83 Connecticut zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15317,
        'SPCS83 Delaware zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15318,
        'SPCS83 Florida East zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15319,
        'SPCS83 Florida West zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15320,
        'SPCS83 Florida North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15321,
        'SPCS83 Georgia East zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15322,
        'SPCS83 Georgia West zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15323,
        'SPCS83 Idaho East zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15324,
        'SPCS83 Idaho Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15325,
        'SPCS83 Idaho West zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15326,
        'SPCS83 Indiana East zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15327,
        'SPCS83 Indiana West zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15328,
        'SPCS83 Kentucky North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15329,
        'SPCS83 Kentucky South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15330,
        'SPCS83 Maryland zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15331,
        'SPCS83 Massachusetts Mainland zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15332,
        'SPCS83 Massachusetts Island zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15333,
        'SPCS83 Michigan North zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 15334;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15334,
        'SPCS83 Michigan Central zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15335,
        'SPCS83 Michigan South zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15336,
        'SPCS83 Mississippi East zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15337,
        'SPCS83 Mississippi West zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15338,
        'SPCS83 Montana zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15339,
        'SPCS83 New Mexico East zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15340,
        'SPCS83 New Mexico Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15341,
        'SPCS83 New Mexico West zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15342,
        'SPCS83 New York East zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15343,
        'SPCS83 New York Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15344,
        'SPCS83 New York West zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15345,
        'SPCS83 New York Long Island zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15346,
        'SPCS83 North Carolina zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15347,
        'SPCS83 North Dakota North zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15348,
        'SPCS83 North Dakota South zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15349,
        'SPCS83 Oklahoma North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15350,
        'SPCS83 Oklahoma South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15351,
        'SPCS83 Oregon North zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15352,
        'SPCS83 Oregon South zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15353,
        'SPCS83 Pennsylvania North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15354,
        'SPCS83 Pennsylvania South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15355,
        'SPCS83 South Carolina zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15356,
        'SPCS83 Tennessee zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15357,
        'SPCS83 Texas North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15358,
        'SPCS83 Texas North Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15359,
        'SPCS83 Texas Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 15360;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15360,
        'SPCS83 Texas South Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15361,
        'SPCS83 Texas South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15362,
        'SPCS83 Utah North zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15363,
        'SPCS83 Utah Central zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15364,
        'SPCS83 Utah South zone (International feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15365,
        'SPCS83 Virginia North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15366,
        'SPCS83 Virginia South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15367,
        'SPCS83 Washington North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15368,
        'SPCS83 Washington South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15369,
        'SPCS83 Wisconsin North zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15370,
        'SPCS83 Wisconsin Central zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15371,
        'SPCS83 Wisconsin South zone (US Survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'National Geodetic Survey  http://www.ngs.noaa.gov/INFO/Policy/st_plane.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15914,
        'BLM zone 14N (US survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Minerals Management Service offshore protraction diagrams.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15915,
        'BLM zone 15N (US survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Minerals Management Service offshore protraction diagrams.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15916,
        'BLM zone 16N (US survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Minerals Management Service offshore protraction diagrams.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        15917,
        'BLM zone 17N (US survey feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Minerals Management Service offshore protraction diagrams.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16000,
        'UTM grid system (northern hemisphere)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9824,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16001,
        'UTM zone 1N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16002,
        'UTM zone 2N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16003,
        'UTM zone 3N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16004,
        'UTM zone 4N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16005,
        'UTM zone 5N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16006,
        'UTM zone 6N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16007,
        'UTM zone 7N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 63' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16008;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16008,
        'UTM zone 8N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16009;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16009,
        'UTM zone 9N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16010,
        'UTM zone 10N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16011,
        'UTM zone 11N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16012,
        'UTM zone 12N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16013,
        'UTM zone 13N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16014,
        'UTM zone 14N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16015,
        'UTM zone 15N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16016,
        'UTM zone 16N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16017,
        'UTM zone 17N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16018,
        'UTM zone 18N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16019,
        'UTM zone 19N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16020,
        'UTM zone 20N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16021,
        'UTM zone 21N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16022,
        'UTM zone 22N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16023,
        'UTM zone 23N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16024,
        'UTM zone 24N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16025,
        'UTM zone 25N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16026,
        'UTM zone 26N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16027,
        'UTM zone 27N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16028,
        'UTM zone 28N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16029,
        'UTM zone 29N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16030,
        'UTM zone 30N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16031,
        'UTM zone 31N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16032,
        'UTM zone 32N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16033,
        'UTM zone 33N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16034;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16034,
        'UTM zone 34N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16035,
        'UTM zone 35N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16036,
        'UTM zone 36N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16037,
        'UTM zone 37N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16038,
        'UTM zone 38N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16039,
        'UTM zone 39N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16040,
        'UTM zone 40N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16041,
        'UTM zone 41N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16042,
        'UTM zone 42N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16043,
        'UTM zone 43N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16044,
        'UTM zone 44N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16045,
        'UTM zone 45N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16046,
        'UTM zone 46N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16047,
        'UTM zone 47N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16048,
        'UTM zone 48N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16049,
        'UTM zone 49N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16050,
        'UTM zone 50N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16051,
        'UTM zone 51N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16052,
        'UTM zone 52N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16053,
        'UTM zone 53N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16054,
        'UTM zone 54N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16055,
        'UTM zone 55N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16056,
        'UTM zone 56N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16057,
        'UTM zone 57N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16058,
        'UTM zone 58N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16059;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16059,
        'UTM zone 59N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16060,
        'UTM zone 60N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16061,
        'Universal Polar Stereographic North',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9810,
        NULL,
        NULL,
        'NIMA TR8358.2',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16100,
        'UTM grid system (southern hemisphere)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9824,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16101,
        'UTM zone 1S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16102,
        'UTM zone 2S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16103,
        'UTM zone 3S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16104,
        'UTM zone 4S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16105,
        'UTM zone 5S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16106,
        'UTM zone 6S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16107,
        'UTM zone 7S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16108,
        'UTM zone 8S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16109,
        'UTM zone 9S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16110,
        'UTM zone 10S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16111,
        'UTM zone 11S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16112,
        'UTM zone 12S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16113,
        'UTM zone 13S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16114,
        'UTM zone 14S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16115,
        'UTM zone 15S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16116,
        'UTM zone 16S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16117,
        'UTM zone 17S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16118,
        'UTM zone 18S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16119,
        'UTM zone 19S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16120,
        'UTM zone 20S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16121,
        'UTM zone 21S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16122;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16122,
        'UTM zone 22S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16123,
        'UTM zone 23S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16124,
        'UTM zone 24S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16125,
        'UTM zone 25S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16126,
        'UTM zone 26S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16127,
        'UTM zone 27S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16128,
        'UTM zone 28S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16129,
        'UTM zone 29S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16130,
        'UTM zone 30S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16131,
        'UTM zone 31S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16132,
        'UTM zone 32S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16133,
        'UTM zone 33S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16134,
        'UTM zone 34S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16135,
        'UTM zone 35S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16136,
        'UTM zone 36S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16137,
        'UTM zone 37S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16138,
        'UTM zone 38S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16139,
        'UTM zone 39S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16140,
        'UTM zone 40S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16141,
        'UTM zone 41S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16142,
        'UTM zone 42S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16143,
        'UTM zone 43S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16144,
        'UTM zone 44S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16145,
        'UTM zone 45S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16146,
        'UTM zone 46S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16147,
        'UTM zone 47S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16148;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16148,
        'UTM zone 48S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16149,
        'UTM zone 49S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16150,
        'UTM zone 50S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16151,
        'UTM zone 51S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16152,
        'UTM zone 52S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16153,
        'UTM zone 53S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16154,
        'UTM zone 54S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16155,
        'UTM zone 55S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16156,
        'UTM zone 56S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16157,
        'UTM zone 57S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16158,
        'UTM zone 58S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16159,
        'UTM zone 59S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16160,
        'UTM zone 60S',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 64' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16161;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16161,
        'Universal Polar Stereographic South',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9810,
        NULL,
        NULL,
        'NIMA TR8358.2',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16202,
        '6-degree Gauss-Kruger zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16203,
        '6-degree Gauss-Kruger zone 3',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16204,
        '6-degree Gauss-Kruger zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16205,
        '6-degree Gauss-Kruger zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16206,
        '6-degree Gauss-Kruger zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16207,
        '6-degree Gauss-Kruger zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16208,
        '6-degree Gauss-Kruger zone 8',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16209,
        '6-degree Gauss-Kruger zone 9',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16210,
        '6-degree Gauss-Kruger zone 10',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16211,
        '6-degree Gauss-Kruger zone 11',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16212,
        '6-degree Gauss-Kruger zone 12',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16213;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16213,
        '6-degree Gauss-Kruger zone 13',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16214,
        '6-degree Gauss-Kruger zone 14',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16215,
        '6-degree Gauss-Kruger zone 15',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16216,
        '6-degree Gauss-Kruger zone 16',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16217,
        '6-degree Gauss-Kruger zone 17',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16218,
        '6-degree Gauss-Kruger zone 18',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16219,
        '6-degree Gauss-Kruger zone 19',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16220,
        '6-degree Gauss-Kruger zone 20',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16221,
        '6-degree Gauss-Kruger zone 21',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16222,
        '6-degree Gauss-Kruger zone 22',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16223,
        '6-degree Gauss-Kruger zone 23',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16224,
        '6-degree Gauss-Kruger zone 24',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16225,
        '6-degree Gauss-Kruger zone 25',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16226,
        '6-degree Gauss-Kruger zone 26',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16227,
        '6-degree Gauss-Kruger zone 27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16228,
        '6-degree Gauss-Kruger zone 28',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16229,
        '6-degree Gauss-Kruger zone 29',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16230,
        '6-degree Gauss-Kruger zone 30',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16231,
        '6-degree Gauss-Kruger zone 31',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16232,
        '6-degree Gauss-Kruger zone 32',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16261,
        '3-degree Gauss-Kruger zone 1',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16262,
        '3-degree Gauss-Kruger zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16263,
        '3-degree Gauss-Kruger zone 3',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16264,
        '3-degree Gauss-Kruger zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16265,
        '3-degree Gauss-Kruger zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16266;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16266,
        '3-degree Gauss-Kruger zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16267,
        '3-degree Gauss-Kruger zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16268,
        '3-degree Gauss-Kruger zone 8',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16269,
        '3-degree Gauss-Kruger zone 9',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16270,
        '3-degree Gauss-Kruger zone 10',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16271,
        '3-degree Gauss-Kruger zone 11',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16272,
        '3-degree Gauss-Kruger zone 12',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16273,
        '3-degree Gauss-Kruger zone 13',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16274,
        '3-degree Gauss-Kruger zone 14',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16275,
        '3-degree Gauss-Kruger zone 15',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16302,
        '6-degree Gauss-Kruger CM 9E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16303,
        '6-degree Gauss-Kruger CM 15E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16304,
        '6-degree Gauss-Kruger CM 21E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16305,
        '6-degree Gauss-Kruger CM 27E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16306,
        '6-degree Gauss-Kruger CM 33E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16307,
        '6-degree Gauss-Kruger CM 39E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16308,
        '6-degree Gauss-Kruger CM 45E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16309,
        '6-degree Gauss-Kruger CM 51E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16310,
        '6-degree Gauss-Kruger CM 57E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16311,
        '6-degree Gauss-Kruger CM 63E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16312,
        '6-degree Gauss-Kruger CM 69E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16313,
        '6-degree Gauss-Kruger CM 75E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16314,
        '6-degree Gauss-Kruger CM 81E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16315,
        '6-degree Gauss-Kruger CM 87E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16316,
        '6-degree Gauss-Kruger CM 93E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16317;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16317,
        '6-degree Gauss-Kruger CM 99E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16318,
        '6-degree Gauss-Kruger CM 105E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16319,
        '6-degree Gauss-Kruger CM 111E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16320,
        '6-degree Gauss-Kruger CM 117E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16321,
        '6-degree Gauss-Kruger CM 123E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16322,
        '6-degree Gauss-Kruger CM 129E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16323,
        '6-degree Gauss-Kruger CM 135E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16324,
        '6-degree Gauss-Kruger CM 141E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16325,
        '6-degree Gauss-Kruger CM 147E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16326,
        '6-degree Gauss-Kruger CM 153E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16327,
        '6-degree Gauss-Kruger CM 159E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16328,
        '6-degree Gauss-Kruger CM 165E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16329,
        '6-degree Gauss-Kruger CM 171E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16330,
        '6-degree Gauss-Kruger CM 177E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16331,
        '6-degree Gauss-Kruger CM 177W',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16332,
        '6-degree Gauss-Kruger CM 171W',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16361,
        '3-degree Gauss-Kruger CM 3E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16362,
        '3-degree Gauss-Kruger CM 6E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16363,
        '3-degree Gauss-Kruger CM 9E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16364,
        '3-degree Gauss-Kruger CM 12E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16365,
        '3-degree Gauss-Kruger CM 15E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16366,
        '3-degree Gauss-Kruger CM 18E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16367,
        '3-degree Gauss-Kruger CM 21E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16368,
        '3-degree Gauss-Kruger CM 24E',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16400,
        'TM 0 N',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Shell UK',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16405,
        'TM 5 NE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'NAM',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 16406;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16406,
        'TM 6 NE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'ExxonMobil',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16411,
        'TM 11 NE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16412,
        'TM 12 NE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16430,
        'TM 30 NE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16506,
        'TM 106 NE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'PetroVietnam',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16586,
        'GK 106 NE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'BP Amoco',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16611,
        'TM 11.30 SE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Esso Angola',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16612,
        'TM 12 SE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Shell Angola',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16636,
        'TM 36 SE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'BP Mozambique',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16709,
        'TM 109 SE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16716,
        'TM 116 SE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        16732,
        'TM 132 SE',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17001,
        'TM 1 NW',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Various industry sources',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17005,
        'TM 5 NW',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Various oil industry sources',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17054,
        'TM 54 NW',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Shell',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17348,
        'Map Grid of Australia zone 48',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17349,
        'Map Grid of Australia zone 49',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17350,
        'Map Grid of Australia zone 50',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17351,
        'Map Grid of Australia zone 51',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17352,
        'Map Grid of Australia zone 52',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17353,
        'Map Grid of Australia zone 53',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17354,
        'Map Grid of Australia zone 54',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17355,
        'Map Grid of Australia zone 55',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17356,
        'Map Grid of Australia zone 56',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17357,
        'Map Grid of Australia zone 57',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 17358;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17358,
        'Map Grid of Australia zone 58',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Australian Surveying and Land Information Group Internet WWW page.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17448,
        'Australian Map Grid zone 48',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17449,
        'Australian Map Grid zone 49',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17450,
        'Australian Map Grid zone 50',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17451,
        'Australian Map Grid zone 51',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17452,
        'Australian Map Grid zone 52',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17453,
        'Australian Map Grid zone 53',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17454,
        'Australian Map Grid zone 54',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17455,
        'Australian Map Grid zone 55',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17456,
        'Australian Map Grid zone 56',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17457,
        'Australian Map Grid zone 57',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17458,
        'Australian Map Grid zone 58',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'The Australian Map Grid Technical Manual; National Mapping Council of Australia; 1972',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17515,
        'South African Survey Grid zone 15',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17517,
        'South African Survey Grid zone 17',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17519,
        'South African Survey Grid zone 19',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 65' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 17521;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17521,
        'South African Survey Grid zone 21',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17523,
        'South African Survey Grid zone 23',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17525,
        'South African Survey Grid zone 25',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17527,
        'South African Survey Grid zone 27',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17529,
        'South African Survey Grid zone 29',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17531,
        'South African Survey Grid zone 31',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17533,
        'South African Survey Grid zone 33',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17611,
        'South West African Survey Grid zone 11',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17613,
        'South West African Survey Grid zone 13',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17615,
        'South West African Survey Grid zone 15',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 17617;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17617,
        'South West African Survey Grid zone 17',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17619,
        'South West African Survey Grid zone 19',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17621,
        'South West African Survey Grid zone 21',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17623,
        'South West African Survey Grid zone 23',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17625,
        'South West African Survey Grid zone 25',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9808,
        NULL,
        NULL,
        'Chief Directorate Surveys and Land Information; Mowbray; South Africa.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17700,
        'MTM Quebec zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17701,
        'MTM zone 1',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Geodetic Surveys Section; Newfoundland Department of Government Services and Lands.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17702,
        'MTM Newfoundland zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Geodetic Surveys Section; Newfoundland Department of Government Services and Lands.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17703,
        'MTM zone 3',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources. Also Geodetic Surveys Section; Newfoundland Department of Government Services and Lands.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17704,
        'MTM zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources. Also Geodetic Surveys Section; Newfoundland Department of Government Services and Lands.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17705,
        'MTM zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources. Also Geodetic Surveys Section; Newfoundland Department of Government Services and Lands.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17706,
        'MTM zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources. Also Geodetic Surveys Section; Newfoundland Department of Government Services and Lands.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17707,
        'MTM zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Topographic Mapping Section; Quebec Ministry of Natural Resources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17708,
        'MTM zone 8',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17709,
        'MTM zone 9',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17710,
        'MTM zone 10',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17711,
        'MTM zone 11',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17712,
        'MTM zone 12',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17713,
        'MTM zone 13',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17714,
        'MTM zone 14',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17715,
        'MTM zone 15',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17716,
        'MTM zone 16',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17717,
        'MTM zone 17',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Surveys and Mapping Section; Ontario Ministry of Transportation.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17794,
        'MTM Nova Scotia zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Geomatics Centre; Nova Scotia Ministry of Housing and Municipal Affairs.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17795,
        'MTM Nova Scotia zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Geomatics Centre; Nova Scotia Ministry of Housing and Municipal Affairs.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 17801;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17801,
        'Japan Plane Rectangular CS zone I',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17802,
        'Japan Plane Rectangular CS zone II',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17803,
        'Japan Plane Rectangular CS zone III',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17804,
        'Japan Plane Rectangular CS zone IV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17805,
        'Japan Plane Rectangular CS zone V',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17806,
        'Japan Plane Rectangular CS zone VI',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17807,
        'Japan Plane Rectangular CS zone VII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17808,
        'Japan Plane Rectangular CS zone VIII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17809,
        'Japan Plane Rectangular CS zone IX',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17810,
        'Japan Plane Rectangular CS zone X',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17811,
        'Japan Plane Rectangular CS zone XI',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17812,
        'Japan Plane Rectangular CS zone XII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17813,
        'Japan Plane Rectangular CS zone XIII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17814,
        'Japan Plane Rectangular CS zone XIV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17815,
        'Japan Plane Rectangular CS zone XV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17816,
        'Japan Plane Rectangular CS zone XVI',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17817,
        'Japan Plane Rectangular CS zone XVII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17818,
        'Japan Plane Rectangular CS zone XVIII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17819,
        'Japan Plane Rectangular CS zone XIX',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/image/heichoku2.gif',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17901,
        'Mount Eden Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17902,
        'Bay of Plenty Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17903,
        'Poverty Bay Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17904,
        'Hawkes Bay Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17905,
        'Taranaki Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17906,
        'Tuhirangi Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 17907;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17907,
        'Wanganui Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17908,
        'Wairarapa Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17909,
        'Wellington Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17910,
        'Collingwood Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17911,
        'Nelson Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17912,
        'Karamea Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17913,
        'Buller Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17914,
        'Grey Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17915,
        'Amuri Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17916,
        'Marlborough Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17917,
        'Hokitika Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17918,
        'Okarito Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17919,
        'Jacksons Bay Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17920,
        'Mount Pleasant Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17921,
        'Gawler Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17922,
        'Timaru Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17923,
        'Lindis Peak Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17924,
        'Mount Nicholas Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17925,
        'Mount York Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17926,
        'Observation Point Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17927,
        'North Taieri Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17928,
        'Bluff Circuit',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17931,
        'Mount Eden Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17932,
        'Bay of Plenty Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17933,
        'Poverty Bay Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17934,
        'Hawkes Bay Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 17935;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17935,
        'Taranaki Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17936,
        'Tuhirangi Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17937,
        'Wanganui Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17938,
        'Wairarapa Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17939,
        'Wellington Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17940,
        'Collingwood Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17941,
        'Nelson Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17942,
        'Karamea Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17943,
        'Buller Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17944,
        'Grey Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17945,
        'Amuri Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17946,
        'Marlborough Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17947,
        'Hokitika Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17948,
        'Okarito Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17949,
        'Jacksons Bay Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17950,
        'Mount Pleasant Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17951,
        'Gawler Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17952,
        'Timaru Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17953,
        'Lindis Peak Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17954,
        'Mount Nicholas Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17955,
        'Mount York Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17956,
        'Observation Point Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17957,
        'North Taieri Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        17958,
        'Bluff Circuit 2000',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand OSG Technical Report 8; April 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18011,
        'Nord Algerie (ancienne)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 18012;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18012,
        'Sud Algerie (ancienne)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18021,
        'Nord Algerie',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18022,
        'Sud Algerie',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18031,
        'Argentina zone 1',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18032,
        'Argentina zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18033,
        'Argentina zone 3',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18034,
        'Argentina zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18035,
        'Argentina zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18036,
        'Argentina zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18037,
        'Argentina zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18041,
        'Austria West Zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Bundesamt fur Eich- und Vermessungswesen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18042,
        'Austria Central Zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Bundesamt fur Eich- und Vermessungswesen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18043,
        'Austria East Zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Bundesamt fur Eich- und Vermessungswesen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18044,
        'Austria M28',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18045,
        'Austria M31',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18046,
        'Austria M34',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18051,
        'Colombia West zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18052,
        'Colombia Bogota zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18053,
        'Colombia East Central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18054,
        'Colombia East zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18061,
        'Cuba Norte',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18062,
        'Cuba Sur',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18071,
        'Egypt Blue Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18072,
        'Egypt Red Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18073,
        'Egypt Purple Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 18074;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18074,
        'Egypt Extended Purple Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18081,
        'Lambert zone I',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18082,
        'Lambert zone II',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18083,
        'Lambert zone III',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18084,
        'Lambert zone IV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18085,
        'Lambert-93',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'IGN - Paris',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18086,
        'France EuroLambert',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18091,
        'Lambert Nord France',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18092,
        'Lambert Centre France',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18093,
        'Lambert Sud France',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18094,
        'Lambert Corse',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18110,
        'India zone 0',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18111,
        'India zone I',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18112,
        'India zone IIa',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18113,
        'India zone IIb',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18114,
        'India zone IIIa',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18115,
        'India zone IIIb',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18116,
        'India zone IVa',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18117,
        'India zone IVb',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18121,
        'Italy zone 1',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 66' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 18122;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18122,
        'Italy zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18131,
        'Nord Maroc',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18132,
        'Sud Maroc',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18133,
        'Sahara',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18141,
        'New Zealand North Island National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 18142;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18142,
        'New Zealand South Island National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18151,
        'Nigeria West Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18152,
        'Nigeria Mid Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18153,
        'Nigeria East Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18161,
        'Peru west zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18162,
        'Peru central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18163,
        'Peru east zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18171,
        'Philippines zone I',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18172,
        'Philippines zone II',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18173,
        'Philippines zone III',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18174,
        'Philippines zone IV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18175,
        'Philippines zone V',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18181,
        'Nord Tunisie',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18182,
        'Sud Tunisie',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18191,
        'Finland zone 1',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18192,
        'Finland zone 2',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18193,
        'Finland Uniform Coordinate System',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18194,
        'Finland zone 4',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'www.nls.fi/maa/papers/kkj.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18201,
        'Palestine Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9806,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18202,
        'Palestine Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18203,
        'Israeli CS',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9806,
        NULL,
        NULL,
        'Survey of Israel   ftp://ftp.rd.soi.gov.il/doc',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18204,
        'Israeli TM',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Survey of Israel   ftp://ftp.rd.soi.gov.il/doc',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18211,
        'Guatemala Norte',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18212,
        'Guatemala Sur',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18221,
        'NGO zone I',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18222,
        'NGO zone II',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 18223;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18223,
        'NGO zone III',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18224,
        'NGO zone IV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18225,
        'NGO zone V',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18226,
        'NGO zone VI',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18227,
        'NGO zone VII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18228,
        'NGO zone VIII',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18231,
        'India zone I (1975 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18232,
        'India zone IIa (1975 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18233,
        'India zone IIIa (1975 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18234,
        'India zone IVa (1975 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18235,
        'India zone IIb (1975 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18236,
        'India zone I (1962 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18237,
        'India zone IIa (1962 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18238,
        'India zone IIb (1937 metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18240,
        'Libya zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18241,
        'Libya zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18242,
        'Libya zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18243,
        'Libya zone 8',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18244,
        'Libya zone 9',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18245,
        'Libya zone 10',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18246,
        'Libya zone 11',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18247,
        'Libya zone 12',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18248,
        'Libya zone 13',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Brown and Root',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18251,
        'Korea East Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Clifford J. Mugnier; Photogrammertric Engineering and Remote Sensing',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18252,
        'Korea Central Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Clifford J. Mugnier; Photogrammertric Engineering and Remote Sensing',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 18253;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18253,
        'Korea West Belt',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Clifford J. Mugnier; Photogrammertric Engineering and Remote Sensing',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18260,
        'Maracaibo Grid (M1)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18261,
        'Maracaibo Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18262,
        'Maracaibo Grid (M3)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18263,
        'Maracaibo La Rosa Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'Various oil company sources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18275,
        'Balkans zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18276,
        'Balkans zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18277,
        'Balkans zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18278,
        'Balkans zone 8',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18281,
        'Poland zone I',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18282,
        'Poland zone II',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18283,
        'Poland zone III',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18284,
        'Poland zone IV',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18285,
        'Poland zone V',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18300,
        'Poland CS92',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18305,
        'Poland CS2000 zone 5',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18306,
        'Poland CS2000 zone 6',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18307,
        'Poland CS2000 zone 7',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18308,
        'Poland CS2000 zone 8',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18401,
        'Kp2000 Jylland og Fyn',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18402,
        'Kp2000 Sjaelland',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18403,
        'Kp2000 Bornholm',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18411,
        'French West Africa Senegal zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotatFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18412,
        'French West Africa Ivory Coast zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotatFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18413,
        'French West Africa Dahomey zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotatFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 18414;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18414,
        'French West Africa Niger zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotatFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18415,
        'French Equatorial Africa west zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotatFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18416,
        'French Equatorial Africa central zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotatFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18417,
        'French Equatorial Africa east zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'TotatFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18421,
        'Greenland zone 1 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18422,
        'Greenland zone 2 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18423,
        'Greenland zone 3 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18424,
        'Greenland zone 4 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18425,
        'Greenland zone 5 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18426,
        'Greenland zone 6 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18427,
        'Greenland zone 7 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18428,
        'Greenland zone 8 east',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18432,
        'Greenland zone 2 west',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18433,
        'Greenland zone 3 west',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18434,
        'Greenland zone 4 west',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18435,
        'Greenland zone 5 west',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18436,
        'Greenland zone 6 west',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        18437,
        'Greenland zone 7 west',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9826,
        NULL,
        NULL,
        'Kort og Matrikelstyrelsen, Copenhagen.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19900,
        'Bahrain State Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19901,
        'Belge Lambert 50',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        '"Systemes de reference et formules de transformation en usage en Belgique"; IGN Brussels',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19902,
        'Belge Lambert 72',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9803,
        NULL,
        NULL,
        '"Systemes de reference et formules de transformation en usage en Belgique"; IGN Brussels',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19903,
        'Nord de Guerre',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19904,
        'Ghana Metre Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19905,
        'Netherlands East Indies Equatorial Zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9804,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19906,
        'Iraq zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19907,
        'Iraq National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 19909;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19909,
        'Jamaica (Old Grid)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19910,
        'Jamaica National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19911,
        'Laborde Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19913,
        'RD Old',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'Nederlandse Commissie voor Geodesie publication 30.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19914,
        'RD New',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'Nederlandse Commissie voor Geodesie publication 30.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19915,
        'Aden Zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19916,
        'British National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain.  http://www.gps.gov.uk/additionalInfo/images/A_guide_to_coord.pdf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19917,
        'New Zealand Map Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9811,
        NULL,
        NULL,
        'Dept. of Lands and Surveys Technical Circular 1973/32; 23 Nov 1973.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19919,
        'Qatar National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19920,
        'Singapore Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9806,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19921,
        'Spain',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19922,
        'Swiss New Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        '"Die Projektionen der schweizerischen Plan- und Kartenwerke"; J. Bolliger 1967',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19923,
        'Swiss Old Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        '"Die Projektionen der schweizerischen Plan- und Kartenwerke"; J. Bolliger 1967',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19924,
        'Tobago Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9806,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19925,
        'Trinidad Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9806,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19926,
        'Stereo 70',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19927,
        'Stereo 33',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19928,
        'Kuwait TM',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        NULL,
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 67' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 19929;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19929,
        'Sweden zone 2.5 gon V',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Lantmateriverket (National Land Survey of Sweden) private communication. Also http://www.lm.se/geodesi/refsys/rt/rt_projections.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19930,
        'Greek Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Geodesy Department; Public Petroleum Corporation of Greece.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19931,
        'Egyseges Orszagos Vetuleti',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        'http://lazarus.elte.hu/gb/geodez/geod2.htm',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19933,
        'Prince Edward Island Stereographic (ATS77)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'Geomatics Centre; Nova Scotia Ministry of Housing and Municipal Affairs.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19934,
        'Lithuania 1994',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'HNIT-BALTIC GeoInfoServisas',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19935,
        'Rectified Skew Orthomorphic Malaya Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9812,
        NULL,
        NULL,
        'UK Directorate of Overseas Surveys paper',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 19936;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19936,
        'Portuguese National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Instituto Portugues de Cartografia e Cadastro',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19937,
        'Tunisia Mining Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9816,
        NULL,
        NULL,
        'Mining decree of 1st January 1953',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19938,
        'Estonian National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'http://www.geo.ut.ee/~raivo/estcoord.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19939,
        'TM Baltic 93',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'http://www.geo.ut.ee/~raivo/estcoord.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19940,
        'Levant Zone',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9817,
        NULL,
        NULL,
        'US Army Map Service projection tables; 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19941,
        'Brazil Polyconic',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9818,
        NULL,
        NULL,
        'PetroBras',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19942,
        'British West Indies Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'UK Royal Engineers projection tables P10/25, 1943.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19943,
        'Barbados National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey of Great Britain',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19944,
        'Quebec Lambert Projection',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'Service de la Cartographie; Ministere des Ressources Naturelles; Quebec',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19945,
        'New Brunswick Stereographic (ATS77)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19946,
        'New Brunswick Stereographic (NAD83)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19947,
        'Austria Lambert',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'Bundesamt fur Eich- und Vermessungswesen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19948,
        'Syria Lambert',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9801,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19949,
        'Levant Stereographic',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'IGN Paris',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19950,
        'Landesvermessung 1995',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        'Bundesamt fur Landestopographie.  Aufbau der Landesvermessung der Schweiz ''LV95'' Teil 3: Terrestrische Bezugssysteme und Bezugsrahmen. L+T 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19951,
        'Nakhl e Taqi Oblique Mercator',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        'Total-Fina',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19952,
        'Krovak',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9819,
        NULL,
        NULL,
        'Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19953,
        'Qatar Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9806,
        NULL,
        NULL,
        'Maersk Oil and Gas',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19954,
        'Suriname Old TM',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Shell International',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19955,
        'Suriname TM',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Shell International',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19956,
        'Rectified Skew Orthomorphic Borneo Grid (chains)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        'Directorate of Colonial Surveys projection tables 1954 revision.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19957,
        'Rectified Skew Orthomorphic Borneo Grid (feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        'EPSG unit conversion of Directorate of Colonial Surveys projection tables 1954 revision.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19958,
        'Rectified Skew Orthomorphic Borneo Grid (metres)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9815,
        NULL,
        NULL,
        'EPSG unit conversion of Directorate of Colonial Surveys projection tables 1954 revision.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19959,
        'Ghana National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19960,
        'Prince Edward Isl. Stereographic (NAD83)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9809,
        NULL,
        NULL,
        'PEI Department of Transportation & Public Works; Mr. Serge Bernard',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19961,
        'Belgian Lambert 72',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'IGN Brussels www.ngi.be/FR/FR2-1-5-1.shtm and EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 19962;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19962,
        'Irish Transverse Mercator',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey of Ireland',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19963,
        'Sierra Leone New Colony Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19964,
        'New War Office Sierra Leone Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey International',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19965,
        'US National Atlas Equal Area',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9821,
        NULL,
        NULL,
        'United States Geological Survey, Western Geographic Science Center.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19966,
        'Luxembourg Gauss',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Administration du Cadastre et de la Topographie via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19967,
        'Slovenia Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Geodetska Uprava Republike Slovenije via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19968,
        'Plate Carree',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9823,
        NULL,
        NULL,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19969,
        'Portuguese Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Instituto Portugues de Cartografia e Cadastro via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19971,
        'New Zealand Transverse Mercator',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Land Information New Zealand',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19972,
        'Irish Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey of Ireland.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19973,
        'Irish National Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Ordnance Survey of Northern Ireland.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19974,
        'Modified Portuguese Grid',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9807,
        NULL,
        NULL,
        'Instituto Portugues de Cartografia e Cadastro via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19975,
        'Trinidad Grid (Clarke''s feet)',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9806,
        NULL,
        NULL,
        'BP',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19976,
        'ICN Regional',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'Institute Cartografica Nacional',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        19977,
        'Aramco Lambert',
        'CONVERSION',
        NULL,
        NULL,
        NULL,
        NULL,
        9802,
        NULL,
        NULL,
        'Saudi Aramco',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        101,
        'deg to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9637,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        102,
        'degH to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9638,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        103,
        'Hdeg to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9639,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        104,
        'DM to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9640,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        105,
        'DMH to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9641,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        106,
        'HDM to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9642,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        107,
        'DMS to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9643,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        108,
        'HDMS to DMSH',
        'CONVERSION',
        Null,
        Null,
        '',
        Null,
        9644,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1037,
        'Amersfoort / RD New to ED50 / TM 5 NE (1)',
        'TRANSFORMATION',
        28992,
        23095,
        'NAM-Nld',
        1,
        9632,
        9001,
        9001,
        'Shell / NAM',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1038,
        'ED50 / TM 5 NE to Amersfoort / RD New (1)',
        'TRANSFORMATION',
        23095,
        28992,
        'NAM-Nld',
        2,
        9632,
        9001,
        9001,
        'Shell / NAM',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0); 

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1039;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1039,
        'OSGB 1936 / British National Grid to ETRS89 (2)',
        'TRANSFORMATION',
        27700,
        4258,
        'OSGB-UK Gbr02',
        2,
        9633,
        Null,
        Null,
        'Ordnance Survey of Great Britain, http://www.gps.gov.uk',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1040,
        'OSGB 1936 / British National Grid to WGS 84 (2)',
        'TRANSFORMATION',
        27700,
        4326,
        'EPSG-UK Gbr02',
        2,
        9633,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1041,
        'TM75 to ETRS89 (1)',
        'TRANSFORMATION',
        4300,
        4258,
        'Osi-Ire',
        1,
        9648,
        9102,
        9102,
        'Ordnance Survey of Great Britain, http://www.gps.gov.uk',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1042,
        'TM75 to WGS 84 (1)',
        'TRANSFORMATION',
        4300,
        4326,
        'EPSG-Ire',
        1,
        9648,
        9102,
        9102,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1043,
        'ED50 to ED87 (1)',
        'TRANSFORMATION',
        4230,
        4231,
        '5Nat-NSea-90',
        1,
        9651,
        9102,
        9102,
        'Norwegian Mapping Authority publication 1990:1',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1044,
        'Amersfoort / RD New to ED50 / UTM zone 31N (1)',
        'TRANSFORMATION',
        28992,
        23031,
        'NCG-Nld',
        1,
        9653,
        9001,
        9001,
        'Nederlandse Commissie voor Geodesie publication 30; "Globale en Lokale Geodetische Systemen"; G. Strang van Hees.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1045,
        'ED50 / UTM zone 31N to Amersfoort / RD New (1)',
        'TRANSFORMATION',
        23031,
        28992,
        'NCG-Nld',
        1,
        9653,
        9001,
        9001,
        'Nederlandse Commissie voor Geodesie publication 30; "Globale en Lokale Geodetische Systemen"; G. Strang van Hees.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1046,
        'Amersfoort / RD New to ED50 / UTM zone 31N (2)',
        'TRANSFORMATION',
        28992,
        23031,
        'NAM-Nld',
        2,
        9653,
        9001,
        9001,
        'Shell / NAM',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1047,
        'ED50 / UTM zone 31N to Amersfoort / RD New (2)',
        'TRANSFORMATION',
        23031,
        28992,
        'NAM-Nld',
        2,
        9653,
        9001,
        9001,
        'Shell / NAM',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1048,
        'Belge 72 / Lambert to ED50 / UTM zone 31N (1)',
        'TRANSFORMATION',
        31300,
        23031,
        'NCG-Bel',
        1,
        9652,
        9001,
        9001,
        'Nederlandse Commissie voor Geodesie publication 30; "Globale en Lokale Geodetische Systemen"; G. Strang van Hees.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1049,
        'ED50 / UTM zone 31N to Belge 72 / Lambert (1)',
        'TRANSFORMATION',
        23031,
        31300,
        'NCG-Bel',
        1,
        9652,
        9001,
        9001,
        'Nederlandse Commissie voor Geodesie publication 30; "Globale en Lokale Geodetische Systemen"; G. Strang van Hees.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1050,
        'Amersfoort / RD New to ED50 / TM 5 NE (1)',
        'TRANSFORMATION',
        28992,
        23095,
        'NAM-Nld',
        1,
        9653,
        9001,
        9001,
        'Shell / NAM',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1051,
        'ED50 / TM 5 NE to Amersfoort / RD New (1)',
        'TRANSFORMATION',
        23095,
        28992,
        'NAM-Nld',
        2,
        9653,
        9001,
        9001,
        'Shell / NAM',
        'EPSG',
        1,
        'FALSE',
        NULL,
        0,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1052,
        'ED50 to WGS 84 (35)',
        'TRANSFORMATION',
        4230,
        4326,
        'DMA-Eur W',
        35,
        9654,
        9102,
        9102,
        'Landesbergamt for Lower Saxony.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1095,
        'PSAD56 to WGS84 (13)',
        'TRANSFORMATION',
        4248,
        4326,
        'EPSG-Ven',
        13,
        9636,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1096,
        'La Canoa to WGS84 (2)',
        'TRANSFORMATION',
        4247,
        4326,
        'EPSG-Ven',
        2,
        9636,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        0,
        0);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1097,
        'Dealul Piscului 1970 to WGS 84 (2)',
        'TRANSFORMATION',
        4317,
        4326,
        'EPSG-Rom',
        2,
        9603,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1098,
        'IGM95 to ETRS89 (1)',
        'TRANSFORMATION',
        4670,
        4258,
        'IGM-Ita',
        1,
        9603,
        Null,
        Null,
        'ENI',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1099,
        'IGM95 to WGS 84 (1)',
        'TRANSFORMATION',
        4670,
        4326,
        'IGM-Ita',
        1,
        9603,
        Null,
        Null,
        'ENI',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1211,
        'Qornoq to WGS 84 (1)',
        'TRANSFORMATION',
        4287,
        4326,
        'DMA-Grl S',
        1,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1258,
        'Bogota 1975 (Bogota) to Bogota 1975 (Greenwich)',
        'TRANSFORMATION',
        4802,
        4218,
        'IGAC-Col',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1259,
        'Lisbon (Lisbon) to Lisbon (Greenwich)',
        'TRANSFORMATION',
        4803,
        4207,
        'IGC-Prt',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1261,
        'MGI (Ferro) to MGI (Greenwich)',
        'TRANSFORMATION',
        4805,
        4312,
        'BEV-Aut balk',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1263,
        'Padang (Jakarta) to Padang (Greenwich)',
        'TRANSFORMATION',
        4808,
        4280,
        'EPSG-Idn Sumatra',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1268,
        'Batavia (Jakarta) to Batavia (Greenwich)',
        'TRANSFORMATION',
        4813,
        4211,
        'EPSG-Idn Java',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1269;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1269,
        'RT38 (Stockholm) to RT38 (Greenwich)',
        'TRANSFORMATION',
        4814,
        4308,
        'NLS-Swe',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1270,
        'Greek (Athens) to Greek (Greenwich)',
        'TRANSFORMATION',
        4815,
        4120,
        'NTU-Grc',
        1,
        9601,
        Null,
        Null,
        'Topography Department; National Technical University of Athens.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1310,
        'Pulkovo 1942 to ETRS89 (1)',
        'TRANSFORMATION',
        4284,
        4258,
        'IfAG-Deu E',
        1,
        9607,
        Null,
        Null,
        'Institute for Cartography and Geodesy; Leipzig.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1316,
        'Manoca to WGS 84 (1)',
        'TRANSFORMATION',
        4260,
        4326,
        'SCS-Cmr',
        1,
        9603,
        Null,
        Null,
        'Stolt Comex Seaway and Geoid for Elf.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1466,
        'NGO 1948 (Oslo) to NGO1948 (Greenwich)',
        'TRANSFORMATION',
        4817,
        4273,
        'NGO-Nor',
        1,
        9601,
        Null,
        Null,
        'J. Danielsen; "Transformasjoner ved Norges Geografiske Oppm?ling"; Kart Og Plan nr 1; 1982.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1467,
        'NTF (Paris) to NTF (Greenwich) (1)',
        'TRANSFORMATION',
        4807,
        4275,
        'IGN-Fra',
        1,
        9601,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1468,
        'NTF (Paris) to NTF (Greenwich) (2)',
        'TRANSFORMATION',
        4807,
        4275,
        'RGS',
        2,
        9601,
        Null,
        Null,
        'Royal Geographic Society; London',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1471,
        'MGI to WGS 84 (2)',
        'TRANSFORMATION',
        4312,
        4326,
        'BEV-Aut',
        1,
        9606,
        Null,
        Null,
        'Bundesamt fur Eich- und Vermessungswesen',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1508,
        'CH1903 to WGS 84 (1)',
        'TRANSFORMATION',
        4149,
        4326,
        'BfL-CH 1',
        1,
        9607,
        Null,
        Null,
        'Bundesamt fur Landestopographie.  Aufbau der Landesvermessung der Schweiz ''LV95'' Teil 3: Terrestrische Bezugssysteme und Bezugsrahmen. L+T 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1510,
        'CH1903 to WGS 84 (2)',
        'TRANSFORMATION',
        4149,
        4326,
        'BfL-CH 2',
        2,
        9603,
        Null,
        Null,
        'Bundesamt fur Landestopographie.  Aufbau der Landesvermessung der Schweiz ''LV95'' Teil 3: Terrestrische Bezugssysteme und Bezugsrahmen. L+T 1999.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1519,
        'Bern 1898 (Bern) to CH1903 (Greenwich)',
        'TRANSFORMATION',
        4801,
        4149,
        'BfL-CH',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1534,
        'Minna to WGS 84 (3)',
        'TRANSFORMATION',
        4263,
        4326,
        'SHL-Nig S',
        3,
        9606,
        Null,
        Null,
        'Shell Petroleum Development Company',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1559,
        'AGD84 to GDA94 (3)',
        'TRANSFORMATION',
        4203,
        4283,
        'DOLA-Aus WA 0.1m old',
        3,
        9615,
        Null,
        Null,
        'http://www.dola.wa.gov.au/lotl/survey_geodesy/gda1994/download.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1567,
        'NZGD49 to NZGD2000 (2)',
        'TRANSFORMATION',
        4272,
        4167,
        'OSG-Nzl 4m',
        2,
        9607,
        Null,
        Null,
        'http://www.linz.govt.nz/services/surveysystem/osgpublications/nzgd2000_trans.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1571,
        'Amersfoort to ETRS89 (1)',
        'TRANSFORMATION',
        4258,
        4326,
        'NCG-Nld 2000',
        1,
        9607,
        Null,
        Null,
        'http://rdnap.kadaster.nl/rd/index.html  Also Nederlandse Commissie voor Geodesie publication 30; 3rd edition 1997.  Also with change of method and parameter units at EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1598,
        'POSGAR to WGS 84 (1)',
        'TRANSFORMATION',
        4172,
        4326,
        'EPSG-Arg',
        1,
        9603,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1602,
        'NAD83 to NAD83(CSRS98) (3)',
        'TRANSFORMATION',
        4267,
        4140,
        'AB Env-Can AB',
        2,
        9615,
        Null,
        Null,
        'Geodetic Control Section; Land and Forest Svc; Alberta Environment; http://www.gov.ab.ca/env/land/dos/ or email to geoff.banham@gov.ab.ca',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1656,
        'Lisbon to WGS 84 (1)',
        'TRANSFORMATION',
        4207,
        4258,
        'EPSG-Prt 2000',
        1,
        9606,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1658,
        'Datum 73 to WGS 84 (1)',
        'TRANSFORMATION',
        4274,
        4258,
        'EPSG-Prt 2000',
        1,
        9606,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1822,
        'Minna to WGS 84 (8)',
        'TRANSFORMATION',
        4263,
        4326,
        'SHL-Nga OPL W',
        8,
        9603,
        Null,
        Null,
        'Shell Nigeria Exploration and Production Company',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1823,
        'Minna to WGS 84 (9)',
        'TRANSFORMATION',
        4263,
        4326,
        'SHL-Nga OPL S',
        9,
        9603,
        Null,
        Null,
        'Shell Nigeria Exploration and Production Company',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1824,
        'Minna to WGS 84 (10)',
        'TRANSFORMATION',
        4263,
        4326,
        'SHL-Nga Gongola',
        10,
        9603,
        Null,
        Null,
        'Shell International Exploration and Production',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1825,
        'Hong Kong 1980 to WGS 84 (1)',
        'TRANSFORMATION',
        4611,
        4326,
        'LSD-HKG 2002',
        1,
        9606,
        Null,
        Null,
        'Geodetic Survey Section, Survey and Mapping Office, Lands Department, Hong Kong. http://www.info.gov.hk/landsd/mapping/tindex.htm',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1826,
        'JGD2000 to WGS 84 (1)',
        'TRANSFORMATION',
        4612,
        4326,
        'EPSG-Jpn',
        1,
        9603,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1827,
        'Tokyo to WGS 84 (6)',
        'TRANSFORMATION',
        4301,
        4326,
        'GSI-Jpn 452141',
        6,
        9618,
        Null,
        Null,
        'http://vldb.gsi.go.jp/sokuchi/coordinates/localtrans.html   (Geographical Survey Institute).',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1828,
        'Yoff to WGS 72 (1)',
        'TRANSFORMATION',
        4310,
        4322,
        'DMA-SEN',
        1,
        9603,
        Null,
        Null,
        'DMA',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1829;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1829,
        'HD72 to ETRS89 (1)',
        'TRANSFORMATION',
        4237,
        4258,
        'FOMI-Hun',
        1,
        9607,
        Null,
        Null,
        'Institute of Geodetic Survey and Remote Sensing (FOMI) reflected at http://lazarus.elte.hu/gb/geodez/geod5.htm',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1830,
        'HD72 to WGS 84 (1)',
        'TRANSFORMATION',
        4237,
        4326,
        'EPSG-Hun',
        1,
        9607,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1831,
        'HD72 to WGS 84 (2)',
        'TRANSFORMATION',
        4237,
        4326,
        'ELTE-Hun',
        2,
        9603,
        Null,
        Null,
        'Timar, Molnar and Pasztor; Eotvos University, in Geodezia es Kartografia 54(1) pp11-16.  www.fomi.hu/internet/magyar/szaklap/geodkart.htm',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1832,
        'ID74 to WGS 84 (2)',
        'TRANSFORMATION',
        4238,
        4326,
        'Rac91-Idn',
        2,
        9606,
        Null,
        Null,
        'Racal Survey',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1833,
        'ID74 to WGS 84 (3)',
        'TRANSFORMATION',
        4238,
        4326,
        'Bak-Idn',
        3,
        9607,
        Null,
        Null,
        'Bakosurtanal.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1834,
        'Segara to WGS 84 (1)',
        'TRANSFORMATION',
        4294,
        4326,
        'NIMA-Idn Kal',
        1,
        9603,
        Null,
        Null,
        'U.S. National Imagery and Mapping Agency  TR8350.2 revision of October 1997; http://164.214.2.59/geospatial/products/GandG/tr83502b/toc.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1835,
        'Segara to WGS 84 (2)',
        'TRANSFORMATION',
        4294,
        4326,
        'Shl-Idn Kal E',
        2,
        9603,
        Null,
        Null,
        'Shell',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1836,
        'Segara to WGS 84 (3)',
        'TRANSFORMATION',
        4294,
        4326,
        'Shl-Idn Kal NE',
        3,
        9603,
        Null,
        Null,
        'Shell',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1837,
        'Makassar to WGS 84 (1)',
        'TRANSFORMATION',
        4257,
        4326,
        'Shl-Idn Sul SW',
        1,
        9603,
        Null,
        Null,
        'Shell',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1838,
        'Segara to WGS 84 (4)',
        'TRANSFORMATION',
        4613,
        4326,
        'TOT-Idn Mah',
        4,
        9603,
        Null,
        Null,
        'Total Indonesia.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1839,
        'Beduaram to WGS 72BE (1)',
        'TRANSFORMATION',
        4213,
        4324,
        'ELF-Ner SE',
        1,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1840,
        'QND95 to WGS 84 (1)',
        'TRANSFORMATION',
        4614,
        4326,
        'CGIS-Qat',
        1,
        9606,
        Null,
        Null,
        'Qatar Centre for Geographic Information.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1841,
        'ATS77 to NAD83(CSRS) (1)',
        'TRANSFORMATION',
        4122,
        4617,
        'GIC-Can NB',
        1,
        9615,
        Null,
        Null,
        'New Brunswick Geographic Information Corporation land and water information standards manual.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1842,
        'NAD83(CSRS) to WGS 84 (1)',
        'TRANSFORMATION',
        4617,
        4326,
        'EPSG-Can',
        1,
        9603,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1843,
        'NAD83 to NAD83(CSRS) (1)',
        'TRANSFORMATION',
        4269,
        4617,
        'SGQ-Can QC',
        1,
        9615,
        Null,
        Null,
        'Geodetic Service of Quebec.  Contact alain.bernard@mrn.gouv.qc.ca',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1844,
        'NAD27 to NAD83(CSRS) (1)',
        'TRANSFORMATION',
        4267,
        4617,
        'SGQ-Can QC',
        1,
        9615,
        Null,
        Null,
        'Geodetic Service of Quebec.  Contact alain.bernard@mrn.gouv.qc.ca',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1845,
        'NAD27(CGQ77) to NAD83(CSRS) (1)',
        'TRANSFORMATION',
        4609,
        4617,
        'SGQ-Can QC',
        1,
        9615,
        Null,
        Null,
        'Geodetic Service of Quebec.  Contact alain.bernard@mrn.gouv.qc.ca',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1846,
        'ATS77 to NAD83(CSRS) (2)',
        'TRANSFORMATION',
        4122,
        4617,
        'PEI DOT-Can PEI',
        2,
        9615,
        Null,
        Null,
        'PEI Department of Transportation & Public Works',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1847,
        'NAD27 to NAD83(CSRS) (2)',
        'TRANSFORMATION',
        4267,
        4617,
        'SK PMC-Can SK',
        2,
        9615,
        Null,
        Null,
        'Dir Geodetic Surveys; SaskGeomatics Div.; Saskatchewan Property Management Company.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1848,
        'NAD83 to NAD83(CSRS) (2)',
        'TRANSFORMATION',
        4269,
        4617,
        'SK PMC-Can SK',
        2,
        9615,
        Null,
        Null,
        'Dir Geodetic Surveys; SaskGeomatics Div.; Saskatchewan Property Management Company.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
select 'commit 68' from dual;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1849;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1849,
        'NAD83 to NAD83(CSRS) (3)',
        'TRANSFORMATION',
        4269,
        4617,
        'AB Env-Can AB',
        3,
        9615,
        Null,
        Null,
        'Geodetic Control Section; Land and Forest Svc; Alberta Environment; http://www.gov.ab.ca/env/land/dos/ or email to geoff.banham@gov.ab.ca',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1850,
        'ATS77 to NAD83(CSRS) (3)',
        'TRANSFORMATION',
        4122,
        4617,
        'NSGC-Can NS',
        3,
        9615,
        Null,
        Null,
        'Nova Scotia Geomatics Centre -   Contact aflemmin@linux1.nsgc.gov.ns.ca or telephone 902-667-6409',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1851,
        'ATS77 to WGS 84 (3)',
        'TRANSFORMATION',
        4122,
        4326,
        'EPSG-Can NS',
        2,
        9615,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1852,
        'Timbalai 1948 to WGS 84 (4)',
        'TRANSFORMATION',
        4298,
        4326,
        'SSB-Mys E',
        4,
        9606,
        Null,
        Null,
        'Sarawak Shell Berhard',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1854,
        'FD58 to WGS 84 (2)',
        'TRANSFORMATION',
        4132,
        4326,
        'TFE-Irn Lavan',
        2,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1855;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1855,
        'FD58 to WGS 84 (3)',
        'TRANSFORMATION',
        4132,
        4326,
        'TFE-Irn Kharg',
        3,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1856,
        'ED50(ED77) to WGS 84 (3)',
        'TRANSFORMATION',
        4154,
        4326,
        'TFE-Irn SPars',
        3,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1857,
        'ED50(ED77) to WGS 84 (4)',
        'TRANSFORMATION',
        4154,
        4326,
        'TFE-Irn Lavan',
        4,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1858,
        'ED50(ED77) to WGS 84 (5)',
        'TRANSFORMATION',
        4154,
        4326,
        'TFE-Irn Kharg',
        5,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1859,
        'ELD79 to WGS 84 (1)',
        'TRANSFORMATION',
        4159,
        4326,
        'REP-Lby MZQ',
        1,
        9603,
        Null,
        Null,
        'Oil industry sources.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1860,
        'ELD79 to WGS 84 (2)',
        'TRANSFORMATION',
        4159,
        4326,
        'TFE-Lby MZQ',
        2,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1861,
        'ELD79 to WGS 84 (3)',
        'TRANSFORMATION',
        4159,
        4326,
        'TFE-Lby MBK94',
        3,
        9603,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1862,
        'ELD79 to WGS 84 (4)',
        'TRANSFORMATION',
        4159,
        4326,
        'TFE-Lby MBK00',
        4,
        9606,
        Null,
        Null,
        'TotalFinaElf',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1863,
        'ELD79 to WGS 84 (5)',
        'TRANSFORMATION',
        4159,
        4326,
        'GMRA-Lby',
        5,
        9607,
        Null,
        Null,
        'Norsk Hydro',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1864,
        'SAD69 to WGS 84 (1)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-mean',
        1,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1865,
        'SAD69 to WGS 84 (2)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Arg',
        2,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1866,
        'SAD69 to WGS 84 (3)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Bol',
        3,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1867,
        'SAD69 to WGS 84 (4)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Bra',
        4,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1868,
        'SAD69 to WGS 84 (5)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Chile',
        5,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1869,
        'SAD69 to WGS 84 (6)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Col',
        6,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1870,
        'SAD69 to WGS 84 (7)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Ecu',
        7,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1871,
        'SAD69 to WGS 84 (8)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Ecu Gal',
        8,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1872,
        'SAD69 to WGS 84 (9)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Guy',
        9,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1873,
        'SAD69 to WGS 84 (10)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Pgy',
        10,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1874,
        'SAD69 to WGS 84 (11)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Peru',
        11,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1875,
        'SAD69 to WGS 84 (12)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Tto',
        12,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1876,
        'SAD69 to WGS 84 (13)',
        'TRANSFORMATION',
        4618,
        4326,
        'DMA-Ven',
        13,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1877,
        'SAD69 to WGS 84 (14)',
        'TRANSFORMATION',
        4618,
        4326,
        'IGBE-Bra',
        14,
        9603,
        Null,
        Null,
        'Agencia Nacional do Petroleo (ANP).',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1878,
        'SWEREF99 to ETRS89 (1)',
        'TRANSFORMATION',
        4619,
        4258,
        'NLS-Swe',
        1,
        9603,
        Null,
        Null,
        'National Land Survey',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1879,
        'SWEREF99 to WGS 84 (1)',
        'TRANSFORMATION',
        4619,
        4326,
        'EPSG-Swe',
        1,
        9603,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1880;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1880,
        'Point 58 to WGS 84 (1)',
        'TRANSFORMATION',
        4620,
        4326,
        'NIMA-Bfa Ner',
        1,
        9603,
        Null,
        Null,
        'NIMA TR8350.2',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1881,
        'Carthage (Paris) to Carthage',
        'TRANSFORMATION',
        4816,
        4223,
        'IGN-Fra',
        1,
        9601,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1882,
        'Nord Sahara 1959 (Paris) to Nord Sahara 1959',
        'TRANSFORMATION',
        4819,
        4307,
        'IGN-Fra',
        1,
        9601,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1883,
        'Segara (Jakarta) to Segara',
        'TRANSFORMATION',
        4820,
        4613,
        'EPSG-Idn Kal E',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1884,
        'S-JTSK (Ferro) to S-JTSK',
        'TRANSFORMATION',
        4818,
        4156,
        'EPSG-Cze',
        1,
        9601,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1885,
        'Azores Oriental 1940 to WGS 84 (1)',
        'TRANSFORMATION',
        4184,
        4326,
        'DMA-Prt Az E',
        1,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 rev 3, January 2000. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1886,
        'Azores Central 1948 to WGS 84 (1)',
        'TRANSFORMATION',
        4183,
        4326,
        'DMA-Prt Az C',
        1,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 rev 3, January 2000. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1887,
        'Azores Occidental 1939 to WGS 84 (1)',
        'TRANSFORMATION',
        4182,
        4326,
        'DMA-Prt Az W',
        1,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 rev 3, January 2000. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1888,
        'Porto Santo to WGS 84 (1)',
        'TRANSFORMATION',
        4615,
        4326,
        'DMA-Prt Mad',
        1,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 rev 3, January 2000. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1889,
        'Selvagen Grande to WGS 84 (1)',
        'TRANSFORMATION',
        4616,
        4326,
        'DMA-Prt Sel',
        1,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 rev 3, January 2000. http://164.214.2.59/GandG/tr8350_2.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1890,
        'Australian Antarctic to WGS 84 (1)',
        'TRANSFORMATION',
        4176,
        4326,
        'EPSG-Ant Aus',
        1,
        9603,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1891,
        'Greek to GGRS87 (1)',
        'TRANSFORMATION',
        4120,
        4121,
        'HGS-Grc',
        1,
        9619,
        Null,
        Null,
        'Hellenic Petroleum',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1892,
        'Hito XVIII 1963 to WGS 84 (2)',
        'TRANSFORMATION',
        4254,
        4326,
        'NIMA-Chl',
        2,
        9603,
        Null,
        Null,
        '',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1893,
        'Puerto Rico to WGS 84 (3)',
        'TRANSFORMATION',
        4139,
        4326,
        'NIMA-Pri',
        3,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1894,
        'Gandajika 1970 to WGS 84 (1)',
        'TRANSFORMATION',
        4233,
        4326,
        'NIMA-Mdv',
        3,
        9603,
        Null,
        Null,
        'U.S. Defense Mapping Agency  TR8350.2 December 1987.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1895,
        'RT90 to SWEREF99 (1)',
        'TRANSFORMATION',
        4124,
        4619,
        'NLS-Swe 2001',
        1,
        9607,
        Null,
        Null,
        'National Land Survey of Sweden (http://www.lm.se/geodesi/refsys/eng/refsys-eng.htm) via EuroGeographics; http://crs.ifag.de/',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1896,
        'RT90 to WGS 84 (2)',
        'TRANSFORMATION',
        4124,
        4326,
        'EPSG-Swe 2001',
        2,
        9607,
        Null,
        Null,
        'EPSG',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1897,
        'Segara to WGS 84 (1)',
        'TRANSFORMATION',
        4613,
        4326,
        'NIMA-Idn Kal',
        1,
        9603,
        Null,
        Null,
        'U.S. National Imagery and Mapping Agency  TR8350.2 revision of October 1997; http://164.214.2.59/geospatial/products/GandG/tr83502b/toc.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1898,
        'Segara to WGS 84 (2)',
        'TRANSFORMATION',
        4613,
        4326,
        'Shl-Idn Kal E',
        2,
        9603,
        Null,
        Null,
        'Shell',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1899,
        'Segara to WGS 84 (3)',
        'TRANSFORMATION',
        4613,
        4326,
        'Shl-Idn Kal NE',
        3,
        9603,
        Null,
        Null,
        'Shell',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1900,
        'NAD83(HARN) to WGS 84 (2)',
        'TRANSFORMATION',
        4152,
        4326,
        'NGS-Usa ITRF94',
        2,
        9607,
        Null,
        Null,
        'US National Geodetic Survey  http://www.ngs.noaa.gov/CORS/Derivation.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1901,
        'NAD83(HARN) to WGS 84 (3)',
        'TRANSFORMATION',
        4152,
        4326,
        'NGS-Usa ITRF96',
        3,
        9607,
        Null,
        Null,
        'http://www.ngs.noaa.gov/CORS/Derivation.html',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1902,
        'Manoca 1962 to WGS 72BE (1)',
        'TRANSFORMATION',
        4193,
        4324,
        '',
        1,
        9603,
        Null,
        Null,
        '',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1903,
        'Fort Marigot to WGS 84 (1)',
        'TRANSFORMATION',
        4621,
        4326,
        'IGN-Glp',
        1,
        9603,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1904,
        'Sainte Anne to WGS 84 (1)',
        'TRANSFORMATION',
        4622,
        4326,
        'IGN-Glp 10m',
        1,
        9603,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

  end if;
end;
/
commit;
declare

  rec_count NUMBER;
begin
  select count(*) into rec_count from MDSYS.SDO_COORD_OPS WHERE COORD_OP_ID = 1905;
  if(rec_count = 0) then

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1905,
        'Sainte Anne to WGS 84 (2)',
        'TRANSFORMATION',
        4622,
        4326,
        'IGN-Glp 1m',
        2,
        9606,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1906,
        'CSG67 to WGS 84 (1)',
        'TRANSFORMATION',
        4623,
        4326,
        'IGN-Guf',
        1,
        9603,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1907,
        'RGFG95 to WGS 84 (1)',
        'TRANSFORMATION',
        4624,
        4326,
        'IGN-Guf',
        1,
        9603,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1908,
        'CSG67 to RGFG95 (1)',
        'TRANSFORMATION',
        4623,
        4624,
        'IGN-Guf',
        1,
        9606,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1909,
        'Fort Desaix to WGS 84 (1)',
        'TRANSFORMATION',
        4625,
        4326,
        'IGN-Mtq 10m',
        1,
        9603,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS (
        COORD_OP_ID,
        COORD_OP_NAME,
        COORD_OP_TYPE,
        SOURCE_SRID,
        TARGET_SRID,
        COORD_TFM_VERSION,
        COORD_OP_VARIANT,
        COORD_OP_METHOD_ID,
        UOM_ID_SOURCE_OFFSETS,
        UOM_ID_TARGET_OFFSETS,
        INFORMATION_SOURCE,
        DATA_SOURCE,
        SHOW_OPERATION,
        IS_LEGACY,
        LEGACY_CODE,
        REVERSE_OP,
        IS_IMPLEMENTED_FORWARD,
        IS_IMPLEMENTED_REVERSE)
      VALUES (
        1910,
        'Fort Desaix to WGS 84 (2)',
        'TRANSFORMATION',
        4625,
        4326,
        'IGN-Mtq 1m',
        2,
        9606,
        Null,
        Null,
        'IGN Paris.',
        'EPSG',
        1,
        'FALSE',
        NULL,
        1,
        1,
        1);

    insert into MDSYS.SDO_COORD_OPS