Rem
Rem $Header: sdogmlsc.sql 12-may-2005.10:37:42 sravada Exp $
Rem
Rem sdogmlsc.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdogmlsc.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This file is used to register the 3 schemas required for GML 212
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     05/12/05 - sravada_sdo_text_object
Rem    sravada     05/03/05 - Created
Rem

declare
begin
  begin
   execute immediate
'CREATE TABLE SDO_XML_SCHEMAS
(
   id               NUMBER PRIMARY KEY,
   description      VARCHAR2(300),
   xmlSchema        CLOB) ';
  exception when others then NULL;
 end;
end;
/
                                                                                
GRANT SELECT ON SDO_XML_SCHEMAS TO PUBLIC;
create or replace public synonym SDO_XML_SCHEMAS
for MDSYS.SDO_XML_SCHEMAS;

-- first delete all the GML related schemas
declare
  usr varchar2(30);
  url varchar2(200);
  loc clob;
  cnt number;
begin
  usr := 'MDSYS';
  url := 'http://www.opengis.net/cartographicText.xsd';

  execute immediate
    'SELECT count(*) FROM dba_xml_schemas WHERE owner=:1 AND schema_url=:2'
    into cnt using usr, url;
  if cnt <> 0 then
    dbms_xmlschema.deleteSchema(url, dbms_xmlschema.DELETE_CASCADE);
  end if;

  url := 'http://www.opengis.net/gml/feature.xsd';
  execute immediate
    'SELECT count(*) FROM dba_xml_schemas WHERE owner=:1 AND schema_url=:2'
    into cnt using usr, url;   if cnt <> 0 then
    dbms_xmlschema.deleteSchema(url, dbms_xmlschema.DELETE_CASCADE);
  end if;

  url := 'http://www.opengis.net/gml/geometry.xsd';
  execute immediate
    'SELECT count(*) FROM dba_xml_schemas WHERE owner=:1 AND schema_url=:2'
    into cnt using usr, url;   if cnt <> 0 then
    dbms_xmlschema.deleteSchema(url, dbms_xmlschema.DELETE_CASCADE);
  end if;

  url := 'http://www.w3.org/1999/xlink/xlinks.xsd';
  execute immediate
    'SELECT count(*) FROM dba_xml_schemas WHERE owner=:1 AND schema_url=:2'
    into cnt using usr, url;   if cnt <> 0 then
    dbms_xmlschema.deleteSchema(url, dbms_xmlschema.DELETE_CASCADE);
  end if;
end;
/
 
  -- register the schema
DECLARE
   schemaclob   CLOB;
   amt          NUMBER;
   buf          VARCHAR2(32767);
   pos          NUMBER;
BEGIN
 
   DELETE FROM SDO_XML_SCHEMAS WHERE id=1;
   INSERT INTO SDO_XML_SCHEMAS VALUES (1, 'GML:2.1.2  xlinks.xsd', empty_clob())
     RETURNING xmlSchema into schemaclob;
   SELECT xmlSchema into schemaclob from SDO_XML_SCHEMAS
     WHERE id = 1 FOR UPDATE;
 
   DBMS_LOB.OPEN(schemaclob, DBMS_LOB.LOB_READWRITE);
 
   buf := '<?xml version="1.0" encoding="UTF-8"?>
<schema targetNamespace="http://www.w3.org/1999/xlink" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2001/XMLSchema" version="2.1.2">
  <annotation>
    <appinfo>xlinks.xsd v2.1.2 2002-07</appinfo>
    <documentation xml:lang="en">
      This schema provides the XLink attributes for general use.
    </documentation>
  </annotation>
  <!-- ==============================================================
       global declarations
  =============================================================== -->
  <!-- locator attribute -->
  <attribute name="href" type="anyURI"/>
  <!-- semantic attributes -->
  <attribute name="role" type="anyURI"/>
  <attribute name="arcrole" type="anyURI"/>
  <attribute name="title" type="string"/>
  <!-- behavior attributes -->
  <attribute name="show">
    <annotation>
      <documentation>
        The show attribute is used to communicate the desired presentation 
        of the ending resource on traversal from the starting resource; its 
        value should be treated as follows: 
        new - load ending resource in a new window, frame, pane, or other 
              presentation context
        replace - load the resource in the same window, frame, pane, or 
                  other presentation context
        embed - load ending resource in place of the presentation of the 
                starting resource
        other - behavior is unconstrained; examine other markup in the 
                link for hints 
        none - behavior is unconstrained 
      </documentation>
    </annotation>
    <simpleType>
      <restriction base="string">
        <enumeration value="new"/>
        <enumeration value="replace"/>
        <enumeration value="embed"/>
        <enumeration value="other"/>
        <enumeration value="none"/>
      </restriction>
    </simpleType>
  </attribute>
  <attribute name="actuate">
    <annotation>
      <documentation>
        The actuate attribute is used to communicate the desired timing 
        of traversal from the starting resource to the ending resource; 
        its value should be treated as follows:
        onLoad - traverse to the ending resource immediately on loading 
                 the starting resource 
        onRequest - traverse from the starting resource to the ending 
                    resource only on a post-loading event triggered for 
                    this purpose 
        other - behavior is unconstrained; examine other markup in link 
                for hints 
        none - behavior is unconstrained
      </documentation>
    </annotation>
    <simpleType>
      <restriction base="string">
        <enumeration value="onLoad"/>
        <enumeration value="onRequest"/>
        <enumeration value="other"/>
        <enumeration value="none"/>
      </restriction>
    </simpleType>
  </attribute>
  <!-- traversal attributes -->
  <attribute name="label" type="string"/>
  <attribute name="from" type="string"/>
  <attribute name="to" type="string"/>
  <!-- ==============================================================
       Attributes grouped by XLink type, as specified by the allowed usage patterns 
       in sec. 4.1 of the W3C Recommendation (dated 2001-06-27)
  =================================================================== -->
  <attributeGroup name="simpleLink">
    <attribute name="type" type="string" use="optional" fixed="simple" form="qualified"/>
    <attribute ref="xlink:href" use="optional"/>
    <attribute ref="xlink:role" use="optional"/>
    <attribute ref="xlink:arcrole" use="optional"/>
    <attribute ref="xlink:title" use="optional"/>
    <attribute ref="xlink:show" use="optional"/>
    <attribute ref="xlink:actuate" use="optional"/>
  </attributeGroup>
  <attributeGroup name="extendedLink">
    <attribute name="type" type="string" use="required" fixed="extended" form="qualified"/>
    <attribute ref="xlink:role" use="optional"/>
    <attribute ref="xlink:title" use="optional"/>
  </attributeGroup>
  <attributeGroup name="locatorLink">
    <attribute name="type" type="string" use="required" fixed="locator" form="qualified"/>
    <attribute ref="xlink:href" use="required"/>
    <attribute ref="xlink:role" use="optional"/>
    <attribute ref="xlink:title" use="optional"/>
    <attribute ref="xlink:label" use="optional"/>
  </attributeGroup>
  <attributeGroup name="arcLink">
    <attribute name="type" type="string" use="required" fixed="arc" form="qualified"/>
    <attribute ref="xlink:arcrole" use="optional"/>
    <attribute ref="xlink:title" use="optional"/>
    <attribute ref="xlink:show" use="optional"/>
    <attribute ref="xlink:actuate" use="optional"/>
    <attribute ref="xlink:from" use="optional"/>
    <attribute ref="xlink:to" use="optional"/>
  </attributeGroup>
  <attributeGroup name="resourceLink">
    <attribute name="type" type="string" use="required" fixed="resource" form="qualified"/>
    <attribute ref="xlink:role" use="optional"/>
    <attribute ref="xlink:title" use="optional"/>
    <attribute ref="xlink:label" use="optional"/>
  </attributeGroup>
  <attributeGroup name="titleLink">
    <attribute name="type" type="string" use="required" fixed="title" form="qualified"/>
  </attributeGroup>
  <attributeGroup name="emptyLink">
    <attribute name="type" type="string" use="required" fixed="empty" form="qualified"/>
  </attributeGroup>
</schema> ';
   amt := length(buf);
   pos := 1;
 
   DBMS_LOB.WRITE(schemaclob, amt, pos, buf);
 
   DBMS_LOB.CLOSE(schemaclob);
 
   COMMIT;
 
END;
/
SHOW ERRORS;


declare
  usr varchar2(30);
  url varchar2(200);
  loc clob;
  cnt number;
begin
  usr := 'MDSYS';
  url := 'http://www.w3.org/1999/xlink/xlinks.xsd';
 
  -- First check whether the schema has been registered already.
  -- If it has, de-register it. This might cause an error to be raised if
  -- there are dependent tables or schemas. User then needs to manually
  -- remove/evolve the depdendent objects and run this script again.
 
  execute immediate
    'SELECT count(*) FROM dba_xml_schemas WHERE owner=:1 AND schema_url=:2'
    into cnt using usr, url;
  if cnt <> 0 then
    dbms_xmlschema.deleteSchema(url, dbms_xmlschema.DELETE_CASCADE);
  end if;
 
  select xmlSchema into loc from SDO_XML_SCHEMAS
   where id = 1; 
 
  -- register the schema
  dbms_xmlschema.registerSchema(url,
                 loc, FALSE, FALSE, FALSE, FALSE, FALSE, usr);
 
end;
/



DECLARE
   schemaclob   CLOB;
   amt          NUMBER;
   buf          VARCHAR2(32767);
   pos          NUMBER;
BEGIN
 
   DELETE FROM SDO_XML_SCHEMAS WHERE id=2;
   INSERT INTO SDO_XML_SCHEMAS VALUES (2, 'GML:2.1.2 geometry.xsd', empty_clob())
     RETURNING xmlSchema into schemaclob;
   SELECT xmlSchema into schemaclob from SDO_XML_SCHEMAS
     WHERE id = 2 FOR UPDATE;
 
   DBMS_LOB.OPEN(schemaclob, DBMS_LOB.LOB_READWRITE);
 
   buf := '<?xml version="1.0" encoding="UTF-8"?>
<schema targetNamespace="http://www.opengis.net/gml" 
 xmlns:xlink="http://www.w3.org/1999/xlink" 
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://www.w3.org/1999/xlink
         http://www.w3.org/1999/xlink/xlinks.xsd"
 xmlns:gml="http://www.opengis.net/gml" 
 xmlns="http://www.w3.org/2001/XMLSchema" 
  elementFormDefault="qualified" version="2.1.2">
  <annotation>
    <appinfo>geometry.xsd v2.1.2 2002-07</appinfo>
    <documentation xml:lang="en">
      GML Geometry schema. Copyright (c) 2001,2002 OGC, All Rights Reserved.
    </documentation>
  </annotation>
  <!-- bring in the XLink attributes -->
 
  <import namespace="http://www.w3.org/1999/xlink" schemaLocation="http://www.w3.org/1999/xlink/xlinks.xsd"/>

  <!-- ==============================================================
       global declarations
  =================================================================== -->
  <element name="_Geometry" type="gml:AbstractGeometryType" abstract="true"/>
  <element name="_GeometryCollection" type="gml:GeometryCollectionType" abstract="true" substitutionGroup="gml:_Geometry"/>
  <element name="geometryMember" type="gml:GeometryAssociationType"/>
  <element name="pointMember" type="gml:PointMemberType" substitutionGroup="gml:geometryMember"/>
  <element name="lineStringMember" type="gml:LineStringMemberType" substitutionGroup="gml:geometryMember"/>
  <element name="polygonMember" type="gml:PolygonMemberType" substitutionGroup="gml:geometryMember"/>
  <element name="outerBoundaryIs" type="gml:LinearRingMemberType"/>
  <element name="innerBoundaryIs" type="gml:LinearRingMemberType"/>
  <!-- primitive geometry elements -->
  <element name="Point" type="gml:PointType" substitutionGroup="gml:_Geometry"/>
  <element name="LineString" type="gml:LineStringType" substitutionGroup="gml:_Geometry"/>
  <element name="LinearRing" type="gml:LinearRingType" substitutionGroup="gml:_Geometry"/>
  <element name="Polygon" type="gml:PolygonType" substitutionGroup="gml:_Geometry"/>
  <element name="Box" type="gml:BoxType"/>
  <!-- aggregate geometry elements -->
  <element name="MultiGeometry" type="gml:GeometryCollectionType" substitutionGroup="gml:_Geometry"/>
  <element name="MultiPoint" type="gml:MultiPointType" substitutionGroup="gml:_Geometry"/>
  <element name="MultiLineString" type="gml:MultiLineStringType" substitutionGroup="gml:_Geometry"/>
  <element name="MultiPolygon" type="gml:MultiPolygonType" substitutionGroup="gml:_Geometry"/>
  <!-- coordinate elements -->
  <element name="coord" type="gml:CoordType"/>
  <element name="coordinates" type="gml:CoordinatesType"/>
  <!-- this attribute gives the location where an element is defined -->
  <attribute name="remoteSchema" type="anyURI"/>
  <!-- ==============================================================
       abstract supertypes
  =================================================================== -->
  <complexType name="AbstractGeometryType" abstract="true">
    <annotation>
      <documentation>
        All geometry elements are derived from this abstract supertype; 
        a geometry element may have an identifying attribute (gid). 
        It may be associated with a spatial reference system.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="anyType">
        <attribute name="gid" type="ID" use="optional"/>
        <attribute name="srsName" type="anyURI" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="AbstractGeometryCollectionBaseType" abstract="true">
    <annotation>
      <documentation>
        This abstract base type for geometry collections just makes the 
        srsName attribute mandatory.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:AbstractGeometryType">
        <attribute name="gid" type="ID" use="optional"/>
        <attribute name="srsName" type="anyURI" use="required"/>
      </restriction>
    </complexContent>
  </complexType>
  <attributeGroup name="AssociationAttributeGroup">
    <annotation>
      <documentation>
        These attributes can be attached to any element, thus allowing it 
        to act as a pointer. The remoteSchema attribute allows an element 
        that carries link attributes to indicate that the element is declared 
        in a remote schema rather than by the schema that constrains the 
        current document instance.  
      </documentation>
    </annotation>
    <attributeGroup ref="xlink:simpleLink"/>
    <attribute ref="gml:remoteSchema" use="optional"/>
  </attributeGroup>
  <complexType name="GeometryAssociationType">
    <annotation>
      <documentation>
        An instance of this type (e.g. a geometryMember) can either 
        enclose or point to a primitive geometry element. When serving 
        as a simple link that references a remote geometry instance, 
        the value of the gml:remoteSchema attribute can be used to 
        locate a schema fragment that constrains the target instance.
      </documentation>
    </annotation>
    <sequence minOccurs="0">
      <element ref="gml:_Geometry"/>
    </sequence>
    <!-- <attributeGroup ref="gml:AssociationAttributeGroup"/> -->
    <attributeGroup ref="xlink:simpleLink"/>
    <attribute ref="gml:remoteSchema" use="optional"/>
  </complexType>
  <complexType name="PointMemberType">
    <annotation>
      <documentation>Restricts the geometry member to being a Point instance.</documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:Point"/>
        </sequence>
        <attributeGroup ref="gml:AssociationAttributeGroup"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="LineStringMemberType">
    <annotation>
      <documentation>Restricts the geometry member to being a LineString instance.</documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:LineString"/>
        </sequence>
        <attributeGroup ref="gml:AssociationAttributeGroup"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="PolygonMemberType">
    <annotation>
      <documentation>Restricts the geometry member to being a Polygon instance.</documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:Polygon"/>
        </sequence>
        <attributeGroup ref="gml:AssociationAttributeGroup"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="LinearRingMemberType">
    <annotation>
      <documentation>Restricts the outer or inner boundary of a polygon instance 
			to being a LinearRing.</documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:LinearRing"/>
        </sequence>
        <attributeGroup ref="gml:AssociationAttributeGroup"/>
      </restriction>
    </complexContent>
  </complexType>
  <!-- ==============================================================
       primitive geometry types
  =================================================================== -->
  <complexType name="PointType">
    <annotation>
      <documentation>
        A Point is defined by a single coordinate tuple.
      </documentation>
    </annotation>
    <complexContent>
      <extension base="gml:AbstractGeometryType">
        <sequence>
          <choice>
            <element ref="gml:coord"/>
            <element ref="gml:coordinates"/>
          </choice>
        </sequence>
      </extension>
    </complexContent>
  </complexType>
  <complexType name="LineStringType">
    <annotation>
      <documentation>
        A LineString is defined by two or more coordinate tuples, with 
        linear interpolation between them. 
      </documentation>
    </annotation>
    <complexContent>
      <extension base="gml:AbstractGeometryType">
        <sequence>
          <choice>
            <element ref="gml:coord" minOccurs="2" maxOccurs="unbounded"/>
            <element ref="gml:coordinates"/>
          </choice>
        </sequence>
      </extension>
    </complexContent>
  </complexType>
  <complexType name="LinearRingType">
    <annotation>
      <documentation>
        A LinearRing is defined by four or more coordinate tuples, with 
        linear interpolation between them; the first and last coordinates 
        must be coincident.
      </documentation>
    </annotation>
    <complexContent>
      <extension base="gml:AbstractGeometryType">
        <sequence>
          <choice>
            <element ref="gml:coord" minOccurs="4" maxOccurs="unbounded"/>
            <element ref="gml:coordinates"/>
          </choice>
        </sequence>
      </extension>
    </complexContent>
  </complexType>
  <complexType name="BoxType">
    <annotation>
      <documentation>
        The Box structure defines an extent using a pair of coordinate tuples.
      </documentation>
    </annotation>
    <complexContent>
      <extension base="gml:AbstractGeometryType">
        <sequence>
          <choice>
            <element ref="gml:coord" minOccurs="2" maxOccurs="2"/>
            <element ref="gml:coordinates"/>
          </choice>
        </sequence>
      </extension>
    </complexContent>
  </complexType>
  <complexType name="PolygonType">
    <annotation>
      <documentation>
        A Polygon is defined by an outer boundary and zero or more inner 
        boundaries which are in turn defined by LinearRings.
      </documentation>
    </annotation>
    <complexContent>
      <extension base="gml:AbstractGeometryType">
        <sequence>
          <element ref="gml:outerBoundaryIs"/>
          <element ref="gml:innerBoundaryIs" minOccurs="0" maxOccurs="unbounded"/>
        </sequence>
      </extension>
    </complexContent>
  </complexType>
  <!-- ==============================================================
       aggregate geometry types
  =================================================================== -->
  <complexType name="GeometryCollectionType">
    <annotation>
      <documentation>
        A geometry collection must include one or more geometries, referenced 
        through geometryMember elements. User-defined geometry collections 
        that accept GML geometry classes as members must instantiate--or 
        derive from--this type.
      </documentation>
    </annotation>
    <complexContent>
      <extension base="gml:AbstractGeometryCollectionBaseType">
        <sequence>
          <element ref="gml:geometryMember" maxOccurs="unbounded"/>
        </sequence>
      </extension>
    </complexContent>
  </complexType>
  <complexType name="MultiPointType">
    <annotation>
      <documentation>
        A MultiPoint is defined by one or more Points, referenced through 
        pointMember elements.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryCollectionType">
        <sequence>
          <element ref="gml:pointMember" maxOccurs="unbounded"/>
        </sequence>
        <attribute name="gid" type="ID" use="optional"/>
        <attribute name="srsName" type="anyURI" use="required"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="MultiLineStringType">
    <annotation>
      <documentation>
        A MultiLineString is defined by one or more LineStrings, referenced 
        through lineStringMember elements.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryCollectionType">
        <sequence>
          <element ref="gml:lineStringMember" maxOccurs="unbounded"/>
        </sequence>
        <attribute name="gid" type="ID" use="optional"/>
        <attribute name="srsName" type="anyURI" use="required"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="MultiPolygonType">
    <annotation>
      <documentation>
        A MultiPolygon is defined by one or more Polygons, referenced through 
        polygonMember elements. 
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryCollectionType">
        <sequence>
          <element ref="gml:polygonMember" maxOccurs="unbounded"/>
        </sequence>
        <attribute name="gid" type="ID" use="optional"/>
        <attribute name="srsName" type="anyURI" use="required"/>
      </restriction>
    </complexContent>
  </complexType>
  <!-- ==============================================================
       There are two ways to represent coordinates: (1) as a sequence 
       of <coord> elements that encapsulate tuples, or (2) using a 
       single <coordinates> string.
  =================================================================== -->
  <complexType name="CoordType">
    <annotation>
      <documentation>
        Represents a coordinate tuple in one, two, or three dimensions.
      </documentation>
    </annotation>
    <sequence>
      <element name="X" type="decimal"/>
      <element name="Y" type="decimal" minOccurs="0"/>
      <element name="Z" type="decimal" minOccurs="0"/>
    </sequence>
  </complexType>
  <complexType name="CoordinatesType">
    <annotation>
      <documentation>
        Coordinates can be included in a single string, but there is no 
        facility for validating string content. The value of the cs attribute 
        is the separator for coordinate values, and the value of the ts 
        attribute gives the tuple separator (a single space by default); the 
        default values may be changed to reflect local usage.
      </documentation>
    </annotation>
    <simpleContent>
      <extension base="string">
        <attribute name="decimal" type="string" use="optional" default="."/>
        <attribute name="cs" type="string" use="optional" default=","/>
        <attribute name="ts" type="string" use="optional" default="&#x20;"/>
      </extension>
    </simpleContent>
  </complexType>
</schema> ';
   amt := length(buf);
   pos := 1;
 
   DBMS_LOB.WRITE(schemaclob, amt, pos, buf);
 
   DBMS_LOB.CLOSE(schemaclob);
 
   COMMIT;
 
END;
/
SHOW ERRORS;


declare
  usr varchar2(30);
  url varchar2(200);
  loc clob;
  cnt number;
begin
  usr := 'MDSYS';
  url := 'http://www.opengis.net/gml/geometry.xsd';
 
  -- First check whether the schema has been registered already.
  -- If it has, de-register it. This might cause an error to be raised if
  -- there are dependent tables or schemas. User then needs to manually
  -- remove/evolve the depdendent objects and run this script again.
 
  execute immediate
    'SELECT count(*) FROM dba_xml_schemas WHERE owner=:1 AND schema_url=:2'
    into cnt using usr, url;
  if cnt <> 0 then
    dbms_xmlschema.deleteSchema(url, dbms_xmlschema.DELETE_CASCADE);
  end if;
 
  select xmlSchema into loc from SDO_XML_SCHEMAS
   where id = 2; 
 
  -- register the schema
  dbms_xmlschema.registerSchema(url,
                 loc, FALSE, FALSE, FALSE, FALSE, FALSE, usr);
 
end;
/

DECLARE
   schemaclob   CLOB;
   amt          NUMBER;
   buf          VARCHAR2(32767);
   pos          NUMBER;
BEGIN
 
   DELETE FROM SDO_XML_SCHEMAS WHERE id=3;
   INSERT INTO SDO_XML_SCHEMAS VALUES (3,  'GML:2.1.2 feature.xsd', empty_clob())
     RETURNING xmlSchema into schemaclob;
   SELECT xmlSchema into schemaclob from SDO_XML_SCHEMAS
     WHERE id = 3 FOR UPDATE;
 
   DBMS_LOB.OPEN(schemaclob, DBMS_LOB.LOB_READWRITE);
 
   buf := '<?xml version="1.0" encoding="UTF-8"?>
<schema targetNamespace="http://www.opengis.net/gml"
 xmlns="http://www.w3.org/2001/XMLSchema"
 xmlns:gml="http://www.opengis.net/gml" 
 xmlns:xlink="http://www.w3.org/1999/xlink" 
  elementFormDefault="qualified" version="2.1.2">
  <annotation>
    <appinfo>feature.xsd v2.1.2 2002-07</appinfo>
    <documentation xml:lang="en">
      GML Feature schema. Copyright (c) 2002 OGC, All Rights Reserved.
    </documentation>
  </annotation>
  <!-- include constructs from the GML Geometry schema -->
  <include schemaLocation="http://www.opengis.net/gml/geometry.xsd"/>
  <!-- bring in the XLink namespace -->
 <import namespace="http://www.w3.org/1999/xlink" schemaLocation="http://www.w3.org/1999/xlink/xlinks.xsd"/>

  
  <!-- ==============================================================
       global declarations
  =================================================================== -->
  <element name="_Feature" type="gml:AbstractFeatureType" abstract="true"/>
  <element name="_FeatureCollection" type="gml:AbstractFeatureCollectionType" abstract="true" substitutionGroup="gml:_Feature"/>
  <element name="featureMember" type="gml:FeatureAssociationType"/>
  <!-- some basic geometric properties of features -->
  <element name="_geometryProperty" type="gml:GeometryAssociationType" abstract="true"/>
  <element name="geometryProperty" type="gml:GeometryAssociationType"/>
  <element name="boundedBy" type="gml:BoundingShapeType"/>
  <element name="pointProperty" type="gml:PointPropertyType" substitutionGroup="gml:_geometryProperty"/>
  <element name="polygonProperty" type="gml:PolygonPropertyType" substitutionGroup="gml:_geometryProperty"/>
  <element name="lineStringProperty" type="gml:LineStringPropertyType" substitutionGroup="gml:_geometryProperty"/>
  <element name="multiPointProperty" type="gml:MultiPointPropertyType" substitutionGroup="gml:_geometryProperty"/>
  <element name="multiLineStringProperty" type="gml:MultiLineStringPropertyType" substitutionGroup="gml:_geometryProperty"/>
  <element name="multiPolygonProperty" type="gml:MultiPolygonPropertyType" substitutionGroup="gml:_geometryProperty"/>
  <element name="multiGeometryProperty" type="gml:MultiGeometryPropertyType" substitutionGroup="gml:_geometryProperty"/>
  <!-- common aliases for geometry properties -->
  <element name="location" type="gml:PointPropertyType" substitutionGroup="gml:pointProperty"/>
  <element name="centerOf" type="gml:PointPropertyType" substitutionGroup="gml:pointProperty"/>
  <element name="position" type="gml:PointPropertyType" substitutionGroup="gml:pointProperty"/>
  <element name="extentOf" type="gml:PolygonPropertyType" substitutionGroup="gml:polygonProperty"/>
  <element name="coverage" type="gml:PolygonPropertyType" substitutionGroup="gml:polygonProperty"/>
  <element name="edgeOf" type="gml:LineStringPropertyType" substitutionGroup="gml:lineStringProperty"/>
  <element name="centerLineOf" type="gml:LineStringPropertyType" substitutionGroup="gml:lineStringProperty"/>
  <element name="multiLocation" type="gml:MultiPointPropertyType" substitutionGroup="gml:multiPointProperty"/>
  <element name="multiCenterOf" type="gml:MultiPointPropertyType" substitutionGroup="gml:multiPointProperty"/>
  <element name="multiPosition" type="gml:MultiPointPropertyType" substitutionGroup="gml:multiPointProperty"/>
  <element name="multiCenterLineOf" type="gml:MultiLineStringPropertyType" substitutionGroup="gml:multiLineStringProperty"/>
  <element name="multiEdgeOf" type="gml:MultiLineStringPropertyType" substitutionGroup="gml:multiLineStringProperty"/>
  <element name="multiCoverage" type="gml:MultiPolygonPropertyType" substitutionGroup="gml:multiPolygonProperty"/>
  <element name="multiExtentOf" type="gml:MultiPolygonPropertyType" substitutionGroup="gml:multiPolygonProperty"/>
  <!-- common feature descriptors -->
  <element name="description" type="string"/>
  <element name="name" type="string"/>
  <!-- ==============================================================
       abstract supertypes
  =================================================================== -->
  <complexType name="AbstractFeatureType" abstract="true">
    <annotation>
      <documentation>
        An abstract feature provides a set of common properties. A concrete 
        feature type must derive from this type and specify additional 
        properties in an application schema. A feature may optionally 
        possess an identifying attribute (fid).
      </documentation>
    </annotation>
    <sequence>
      <element ref="gml:description" minOccurs="0"/>
      <element ref="gml:name" minOccurs="0"/>
      <element ref="gml:boundedBy" minOccurs="0"/>
      <!-- additional properties must be specified in an application schema -->
    </sequence>
    <attribute name="fid" type="ID" use="optional"/>
  </complexType>
  <complexType name="AbstractFeatureCollectionBaseType" abstract="true">
    <annotation>
      <documentation>
        This abstract base type just makes the boundedBy element mandatory 
        for a feature collection.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:AbstractFeatureType">
        <sequence>
          <element ref="gml:description" minOccurs="0"/>
          <element ref="gml:name" minOccurs="0"/>
          <element ref="gml:boundedBy"/>
        </sequence>
        <attribute name="fid" type="ID" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="AbstractFeatureCollectionType" abstract="true">
    <annotation>
      <documentation>
        A feature collection contains zero or more featureMember elements.
      </documentation>
    </annotation>
    <complexContent>
      <extension base="gml:AbstractFeatureCollectionBaseType">
        <sequence>
          <element ref="gml:featureMember" minOccurs="0" maxOccurs="unbounded"/>
        </sequence>
      </extension>
    </complexContent>
  </complexType>
  <complexType name="GeometryPropertyType">
		<annotation>
			<documentation>
        A simple geometry property encapsulates a geometry element.
        Alternatively, it can function as a pointer (simple-type link) 
        that refers to a remote geometry element.
      </documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:_Geometry"/>
		</sequence>
		<attributeGroup ref="xlink:simpleLink"/>
             <attribute ref="gml:remoteSchema" use="optional"/>
  </complexType>
  <complexType name="FeatureAssociationType">
    <annotation>
      <documentation>
        An instance of this type (e.g. a featureMember) can either 
        enclose or point to a feature (or feature collection); this 
        type can be restricted in an application schema to allow only 
        specified features as valid participants in the association. 
        When serving as a simple link that references a remote feature 
        instance, the value of the gml:remoteSchema attribute can be 
        used to locate a schema fragment that constrains the target 
        instance.
      </documentation>
    </annotation>
    <sequence minOccurs="0">
      <element ref="gml:_Feature"/>
    </sequence>
    <attributeGroup ref="xlink:simpleLink"/>
    <attribute ref="gml:remoteSchema" use="optional"/>
  </complexType>
  <complexType name="BoundingShapeType">
    <annotation>
      <documentation>
        Bounding shapes--a Box or a null element are currently allowed.
      </documentation>
    </annotation>
    <sequence>
      <choice>
        <element ref="gml:Box"/>
        <element name="null" type="gml:NullType"/>
      </choice>
    </sequence>
  </complexType>
  <!-- ==============================================================
       geometry properties
  =================================================================== -->
  <complexType name="PointPropertyType">
    <annotation>
      <documentation>
        Encapsulates a single point to represent position, location, or 
        centerOf properties.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:Point"/>
        </sequence>
        <attributeGroup ref="xlink:simpleLink"/>
        <attribute ref="gml:remoteSchema" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="PolygonPropertyType">
    <annotation>
      <documentation>
        Encapsulates a single polygon to represent coverage or extentOf 
        properties.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:Polygon"/>
        </sequence>
        <attributeGroup ref="xlink:simpleLink"/>
        <attribute ref="gml:remoteSchema" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="LineStringPropertyType">
    <annotation>
      <documentation>
        Encapsulates a single LineString to represent centerLineOf or 
        edgeOf properties.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:LineString"/>
        </sequence>
        <attributeGroup ref="xlink:simpleLink"/>
        <attribute ref="gml:remoteSchema" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="MultiPointPropertyType">
    <annotation>
      <documentation>
        Encapsulates a MultiPoint element to represent the following 
        discontiguous geometric properties: multiLocation, multiPosition, 
        multiCenterOf.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:MultiPoint"/>
        </sequence>
        <attributeGroup ref="xlink:simpleLink"/>
        <attribute ref="gml:remoteSchema" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="MultiLineStringPropertyType">
    <annotation>
      <documentation>
        Encapsulates a MultiLineString element to represent the following 
        discontiguous geometric properties: multiEdgeOf, multiCenterLineOf.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:MultiLineString"/>
        </sequence>
        <attributeGroup ref="xlink:simpleLink"/>
        <attribute ref="gml:remoteSchema" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="MultiPolygonPropertyType">
    <annotation>
      <documentation>
        Encapsulates a MultiPolygon to represent the following discontiguous 
        geometric properties: multiCoverage, multiExtentOf.
      </documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:MultiPolygon"/>
        </sequence>
        <attributeGroup ref="xlink:simpleLink"/>
        <attribute ref="gml:remoteSchema" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <complexType name="MultiGeometryPropertyType">
    <annotation>
      <documentation>Encapsulates a MultiGeometry element.</documentation>
    </annotation>
    <complexContent>
      <restriction base="gml:GeometryAssociationType">
        <sequence minOccurs="0">
          <element ref="gml:MultiGeometry"/>
        </sequence>
        <attributeGroup ref="xlink:simpleLink"/>
        <attribute ref="gml:remoteSchema" use="optional"/>
      </restriction>
    </complexContent>
  </complexType>
  <simpleType name="NullType">
    <annotation>
      <documentation>
        If a bounding shape is not provided for a feature collection, 
        explain why. Allowable values are:
        innapplicable - the features do not have geometry
        unknown - the boundingBox cannot be computed
        unavailable - there may be a boundingBox but it is not divulged
        missing - there are no features
      </documentation>
    </annotation>
    <restriction base="string">
      <enumeration value="inapplicable"/>
      <enumeration value="unknown"/>
      <enumeration value="unavailable"/>
      <enumeration value="missing"/>
    </restriction>
  </simpleType>
</schema> ';
   amt := length(buf);
   pos := 1;
 
   DBMS_LOB.WRITE(schemaclob, amt, pos, buf);
 
   DBMS_LOB.CLOSE(schemaclob);
 
   COMMIT;
 
END;
/
SHOW ERRORS;


declare
  usr varchar2(30);
  url varchar2(200);
  loc clob;
  cnt number;
begin
  usr := 'MDSYS';
  url := 'http://www.opengis.net/gml/feature.xsd';
 
  -- First check whether the schema has been registered already.
  -- If it has, de-register it. This might cause an error to be raised if
  -- there are dependent tables or schemas. User then needs to manually
  -- remove/evolve the depdendent objects and run this script again.
 
  execute immediate
    'SELECT count(*) FROM dba_xml_schemas WHERE owner=:1 AND schema_url=:2'
    into cnt using usr, url;
  if cnt <> 0 then
    dbms_xmlschema.deleteSchema(url, dbms_xmlschema.DELETE_CASCADE);
  end if;
 
  select xmlSchema into loc from SDO_XML_SCHEMAS
   where id = 3; 
 
  -- register the schema
  dbms_xmlschema.registerSchema(url,
                 loc, FALSE, FALSE, FALSE, FALSE, FALSE, usr);
 
end;
/

commit;

