begin
  execute immediate
'CREATE or replace TYPE RDF_MATCH_impl_t authid current_user AS OBJECT
(
  curnum           integer,
  nCols            integer,
  done             integer,
  cnt              integer,        -- count, for count(*) optimization
  el_typ           SYS.AnyType,    -- return type
  attrset          SYS.ODCINumberList,
  isCLOBvec        SYS.ODCINumberList,
  startcnt         integer,
  iUseMagicSets    integer,
  modelIDs         SYS.ODCINumberList,
  rulebaseIds      SYS.ODCINumberList,
  filter           varchar2(4000),
  aliases          MDSYS.RDF_Aliases,
  index_status     varchar2(30),
  options          varchar2(4000),
  iBadFilter       integer,            -- 1 if we are handling bad filter special case
  iUnionQuery      integer,            -- 1 if this is a SPARQL UNION query
  coveringColsPos  SYS.ODCINumberList, -- positions of value_id columns in covering order
  currCoveringRow  SYS.ODCINumberList, -- value_ids of the current covering row
  unionKey         varchar2(4000),     -- identifier the current union component ... used to
                                       -- determine a covering relationship for union queries

  STATIC PROCEDURE record_given_and_trans_query(
    Query_Trans_Tabname     varchar2
  , trans_start_time        timestamp
  , trans_end_time          timestamp
  , given_query             varchar2
  , trans_query             varchar2
  , comments                varchar2 default NULL
  ),

  static function ODCIGetInterfaces(ifclist OUT SYS.ODCIObjectList)
  return number,

  static function ODCITableDescribe(rtype OUT SYS.AnyType, 
                                    query         varchar2,
                                    models        MDSYS.RDF_Models,
                                    rulebases     MDSYS.RDF_Rulebases,
                                    aliases       MDSYS.RDF_Aliases,
                                    filter        varchar2,
                                    index_status  varchar2 default NULL,
                                    options       varchar2 default null)
  return number,

  static function ODCITableRewrite(sctx         OUT RDF_MATCH_impl_t,
                                   ti           IN SYS.ODCITabFuncInfo,
                                   str          OUT varchar2,
                                   query        varchar2,
                                   models_in    MDSYS.RDF_Models,
                                   rulebases_in MDSYS.RDF_Rulebases,
                                   aliases      MDSYS.RDF_Aliases,
                                   filter       varchar2,
                                   index_status varchar2 default NULL,
                                   options      varchar2 default null)
  return number,

  static function ODCITablePrepare(sctx    OUT NOCOPY RDF_MATCH_impl_t, 
                                   ti      IN         SYS.ODCITabFuncInfo,
                                   query              varchar2,
                                   models             MDSYS.RDF_Models,
                                   rulebases          MDSYS.RDF_Rulebases,
                                   aliases            MDSYS.RDF_Aliases,
                                   filter             varchar2,
                                   index_status       varchar2 default NULL,
                                   options            varchar2 default null)
  return number,

  STATIC FUNCTION ODCITableStart(sctx    IN OUT NOCOPY RDF_MATCH_impl_t,
                                 query                 varchar2,
                                 models_in             MDSYS.RDF_Models,
                                 rulebases_in          MDSYS.RDF_Rulebases,
                                 aliases               MDSYS.RDF_Aliases,
                                 filter                varchar2,
                                 index_status          varchar2 default NULL,
                                 options               varchar2 default null)
  RETURN PLS_INTEGER ,
 
  MEMBER FUNCTION ODCITableFetch(self   IN OUT NOCOPY RDF_MATCH_impl_t,
                                 nrows  IN            NUMBER, 
                                 outSet OUT NOCOPY    SYS.AnyDataSet)
  RETURN PLS_INTEGER,

  MEMBER FUNCTION Fetch_CountStar(self   IN OUT NOCOPY RDF_MATCH_impl_t,
                                  nrows  IN            NUMBER, 
                                  outSet OUT NOCOPY    SYS.AnyDataSet)
  RETURN PLS_INTEGER,

  MEMBER FUNCTION ODCITableClose(self IN RDF_MATCH_impl_t)
  RETURN PLS_INTEGER,

  STATIC FUNCTION getCollectionElementType(typ SYS.AnyType) 
  RETURN SYS.AnyType,


  MEMBER PROCEDURE dump,

  STATIC FUNCTION R_PARSE_SPARQL(sctx             RDF_MATCH_impl_t,
                               ps_attrset         SYS.ODCINumberList,
                               query              varchar2,
                               models             MDSYS.RDF_Models,
                               modelIDs           SYS.ODCINumberList,
                               rulebaseIDs        SYS.ODCINumberList,
                               aliases            MDSYS.RDF_Aliases,
                               filter             varchar2,
                               reqIdxStatus       varchar2,
                               precompIdx     OUT varchar2,
                               precompIdxId   OUT number,
                               sql_str        OUT varchar2,
                               options            varchar2,
                               vmViewName         varchar2,
                               flag_out       OUT int)
  return number,

  STATIC FUNCTION PARSE_SPARQL(sctx IN OUT NOCOPY RDF_MATCH_impl_t,
                               query               varchar2,
                               models  IN OUT      MDSYS.RDF_Models,
                               modelIDs IN OUT     SYS.ODCINumberList,
                               rulebaseIDs         SYS.ODCINumberList,
                               aliases             MDSYS.RDF_Aliases,
                               filter              varchar2,
                               reqIdxStatus        varchar2,
                               precompIdx     OUT  varchar2,
                               options             varchar2)
  return number,

  MEMBER FUNCTION belongsInResult(self IN OUT NOCOPY RDF_MATCH_impl_t)
  return boolean,

  STATIC PROCEDURE SPARQL_to_SQL(attrs       SYS.ODCINumberList,
                                 query       varchar2,
                                 models      RDF_Models,
                                 precompIdx  varchar2,
                                 idxStatus   varchar2,
                                 nsp         MDSYS.RDF_Aliases,
                                 flag        number,
                                 str_out OUT RDF_longVarcharArray,
                                 sig_out OUT RDF_varcharArray) is
  language java name 
    ''oracle.spatial.rdf.server.SQLEntryPoints.translateQueryPattern(
       oracle.sql.ARRAY,
       java.lang.String,
       oracle.sql.ARRAY,
       java.lang.String,
       java.lang.String,
       oracle.sql.ARRAY, 
       int,
       oracle.sql.ARRAY[],
       oracle.sql.ARRAY[])'',


  STATIC PROCEDURE SPARQL_to_SQL(attrs              SYS.ODCINumberList,
                                 query              varchar2,
                                 models             RDF_Models,
                                 precompIdx         varchar2,
                                 idxStatus          varchar2,
                                 nsp                MDSYS.RDF_Aliases,
                                 flag               number,
                                 str_out        OUT RDF_longVarcharArray,
                                 sig_out        OUT RDF_varcharArray,
                                 options            varchar2,
                                 vmViewName         varchar2,
                                 flag_out       OUT number,
                                 valIdCover_out OUT SYS.ODCINumberList,
                                 orderBy_out    OUT varchar2) is
  language java name 
    ''oracle.spatial.rdf.server.SQLEntryPoints.translateQueryPattern(
       oracle.sql.ARRAY,
       java.lang.String,
       oracle.sql.ARRAY,
       java.lang.String,
       java.lang.String,
       oracle.sql.ARRAY, 
       int,
       oracle.sql.ARRAY[],
       oracle.sql.ARRAY[],
       java.lang.String,
       java.lang.String,
       int[],
       oracle.sql.ARRAY[],
       java.lang.String[])'',

  STATIC FUNCTION SPARQL_to_PRED(attrs       SYS.ODCINumberList,
                                 query       varchar2,
                                 models      RDF_Models,
                                 precompIdx  varchar2,
                                 idxStatus   varchar2,
                                 nsp         MDSYS.RDF_Aliases,
                                 flag        number)
 return sem_pred_array as
  language java name 
    ''oracle.spatial.rdf.server.SQLEntryPoints.translateQuerytoPredicates(
       oracle.sql.ARRAY,
       java.lang.String,
       oracle.sql.ARRAY,
       java.lang.String,
       java.lang.String,
       oracle.sql.ARRAY, 
       int)
  return oracle.sql.ARRAY'',

  STATIC FUNCTION SPARQL_get_cols(query varchar2)
  return RDF_varcharArray as
  language java name
    ''oracle.spatial.rdf.server.SQLEntryPoints.getPatternVariables(
       java.lang.String)
  return oracle.sql.STRUCT''
)';
 
end;
/
show errors;
create or replace type body RDF_MATCH_impl_t wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
9ba8 2422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/
show errors;
CREATE OR REPLACE FUNCTION RDF_MATCH wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
224 107
/cZDE+QtAQTU0CNsp7TEOZHK4fwwg5Dxf8sVfHTpWK0CgMgvHdW33nar+i7Wzcp7Q/nEDvBp
a7pGSR7ZP8L5xHItA3xgL8HZqTyBB4AbWHAmSfKxjHHcEhEKOPXbo9qwt0HVoCfX5/pZeMMl
LNvlKl7IhAHkHJuz7IgiS/fkQ4TjSofpsmIeRbJKesnf41i+iCrobBwCLsr9w7YpV669k6fn
bSwESQffBTjI5mbL93aRsgj5EEbTQNuV4ph47qonRg==

/
show errors;
grant execute on MDSYS.RDF_MATCH to public;
create or replace public synonym SDO_RDF_MATCH for MDSYS.RDF_MATCH;
create or replace public synonym SEM_MATCH for MDSYS.RDF_MATCH;
