<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:variable name="auto_refresh"
    select="/report/sql_monitor_list_report/@auto_refresh"/>

  <xsl:variable name ="max_duration">
    <xsl:call-template name ="max">
      <xsl:with-param name ="list"
        select="/report/sql_monitor_list_report/sql/
                stats[@type = 'monitor']/stat[@name = 'duration']"/>  
    </xsl:call-template>
  </xsl:variable>

  <xsl:variable name ="max_elapsed_time">
    <xsl:call-template name ="max">
      <xsl:with-param name ="list"
        select="/report/sql_monitor_list_report/sql/
                stats[@type = 'monitor']/stat[@name = 'elapsed_time']"/>  
    </xsl:call-template>
  </xsl:variable>

  <xsl:variable name ="max_io_requests">
    <xsl:call-template name ="max_io_requests">
      <xsl:with-param name ="list"
        select="/report/sql_monitor_list_report/sql/
                stats[@type = 'monitor']"/>  
    </xsl:call-template>
  </xsl:variable>

  <xsl:variable name ="min_inst_id">
    <xsl:call-template name ="min">
      <xsl:with-param name ="list"
        select="/report/sql_monitor_list_report/sql/inst_id"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:variable name ="max_inst_id">
    <xsl:call-template name ="max">
      <xsl:with-param name ="list"
        select="/report/sql_monitor_list_report/sql/inst_id"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:template match="/">
    <html>
     <head>
     <title> SQL Monitor List </title>
       <style type="text/css"> 
         body, table, input, select, textarea
         {font:normal normal 8pt Verdana,Arial;text-decoration:none;
          color:#000000;}
         .s8 {font-size:8pt;color:#006699}
         .s9 {font-size:10pt;color:#006699}
         .s10 {font-size:14pt;color:#006699;}
         .s16 {border-width : 1px; border-color : #CCCC99;
              border-style: solid; color:#006699;font-size:8pt; 
              background-color:#CCCC99; }
        .s17 {border-width : 1px; border-color : #CCCC99;
              border-style: solid; font-size:8pt; 
              background-color:#E8E8E6; empty-cells: show }
        .s17a {border-width : 1px; border-color : #BDCCC3;
              border-style: solid; font-size:8pt; 
              background-color:#F5F5F5; empty-cells: show}
        .s17b {border-width : 1px; border-color : #BDCCC3;
               border-style: solid; font-size:8pt; 
               background-color:#F1F5DD; empty-cells: show}
        .s27 {border-width : 1px; border-color : #CCCC99; 
              border-style: solid;}

        .graph {
          border: solid 0px ; empty-cells: show
        }

        .bar {
          border-left: solid 0px;
          padding-right: 0.5em;
          font-size:1pt;
        }

        .sql {border-width : 1px; border-color : #CCCC99;
              border-style: solid; font-size:8pt; 
              background-color:#E8E8E6;
              empty-cells: show; text-align: left }

        .nodisp { font-size: 1% ; height: 10px; color:#F2F2F2 }
        
        .bar div { 
          text-align: center;
          float: left;
        }

        .executing { 
          background-color: #7CFF44;
        }      

        .error { 
          background-color: red;
        }      

        .div_Cpu { 
          border-top: solid 3px #1EC162;
          background-color: #19A352;
          color: #19A352;
          border-bottom: solid 3px #0E5D2F;
        }      

        .div_cpu_time { 
          border-top: solid 3px #1EC162;
          background-color: #19A352;
          color: #19A352;
          border-bottom: solid 3px #0E5D2F;
        }      

        .div_duration { 
          border-top: solid 3px #A2C8E4;
          background-color: #8CADC5;
          color: #8CADC5;
          border-bottom: solid 3px #617888;
          cursor: default;
        }      

        .div_executing_time { 
          border-top: solid 3px #A2C8E4;
          background-color: #8CADC5;
          color: #8CADC5;
          border-bottom: solid 3px #617888;
          cursor: default;
        }

        .div_queuing_time {
          border-top: solid 3px #C5FFB7;
          background-color: #86FF86;
          color: #86FF86;
          border-bottom: solid 3px #74DD74;
          cursor: default;
        } 

        .div_read_reqs { 
          border-top: solid 3px #FFC846;
          background-color: #DDAD3D;
          color: #DDAD3D;
          border-bottom: solid 3px #B99133;
          cursor: default;
        }

        .div_write_reqs { 
          border-top: solid 3px #F76838;
          background-color: #BC4F2B;
          color: #BC4F2B;
          border-bottom: solid 3px #9C4223;
          cursor: default;
        }

        .div_read_bytes { 
          border-top: solid 3px #FFC846;
          background-color: #DDAD3D;
          color: #DDAD3D;
          border-bottom: solid 3px #B99133;
          cursor: default;
        }

        .div_write_bytes { 
          border-top: solid 3px #F76838;
          background-color: #BC4F2B;
          color: #BC4F2B;
          border-bottom: solid 3px #9C4223;
          cursor: default;
        }

        .div_buffer_gets { 
          border-top: solid 3px #FFAB9A;
          background-color: #D89182;
          color: #D89182;
          border-bottom: solid 3px #BC7E72;
          cursor: default;
        }      

        .div_sql_cpu_time { 
          border-top: solid 3px #1EC162;
          background-color: #19A352;
          color: #19A352;
          border-bottom: solid 3px #0E5D2F;
          cursor: default;
        }      

       .div_UserIO { 
          border-top: solid 3px #49A1FF;
          background-color: #3C85D2;
          color: #3C85D2;
          border-bottom: solid 3px #28588B;
          cursor: default;
        }      

        .div_application_wait_time { 
          border-top: solid 3px #C8C6FF;
          background-color: #B5B3E7;
          color: #B5B3E7;
          border-bottom: solid 3px #7C7B9E;
          cursor: default;
        }      

       .div_user_io_wait_time { 
          border-top: solid 3px #FF8C6C;
          background-color: #E27C60;
          color: #E27C60;
          border-bottom: solid 3px #B1614B;
          cursor: default;
        }

       .div_SystemIO { 
          border-top: solid 3px #49A1FF;
          background-color: #3C85D2;
          color: #3C85D2;
          border-bottom: solid 3px #28588B;
          cursor: default;
        }      

        .div_Concurrency { 
          border-top: solid 3px #E81B1F;
          background-color: #BE1619;
          color: #BE1619;
          border-bottom: solid 3px #760E10;
          cursor: default;
        }      

        .div_concurrency_wait_time { 
          border-top: solid 3px #E81B1F;
          background-color: #BE1619;
          color: #BE1619;
          border-bottom: solid 3px #760E10;
          cursor: default;
        }      

        .div_cluster_wait_time { 
          border-top: solid 3px #D43B61;
          background-color: #8B2740;
          color: #8B2740;
          border-bottom: solid 3px #5A1929;
          cursor: default;
        }      

        .div_plsql_exec_time { 
          border-top: solid 3px #EDD957;
          background-color: #B1A241;
          color: #B1A241;
          border-bottom: solid 3px #8B7F33;
          cursor: default;
        }      

        .div_java_exec_time { 
          border-top: solid 3px #B40FEB;
          background-color: #8E0CB9;
          color: #8E0CB9;
          border-bottom: solid 3px #6A098B;
          cursor: default;
        }

        .div_other_wait_time { 
          border-top: solid 3px #4AFDEB;
          background-color: #41DECD;
          color: #41DECD;
          border-bottom: solid 3px #2B9389;
          cursor: default;
        }

        .div_disk_reads { 
          border-top: solid 3px #FFC846;
          background-color: #DDAD3D;
          color: #DDAD3D;
          border-bottom: solid 3px #B99133;
          cursor: default;
        }

        .div_direct_writes { 
          border-top: solid 3px #F76838;
          background-color: #BC4F2B;
          color: #BC4F2B;
          border-bottom: solid 3px #9C4223;
          cursor: default;
        }

        .div_user_fetch_count { 
          border-top: solid 3px #DFFF6C;
          background-color: #CAE762;
          color: #CAE762;
          border-bottom: solid 3px #9EB44C;
          cursor: default;
        }

        .div_Other { 
          border-top: solid 3px #4AFDEB;
          background-color: #41DECD;
          color: #41DECD;
          border-bottom: solid 3px #2B9389;
          cursor: default;
        }      

        .progress_Disp { 
          border-top: solid 3px #F59582;
          background-color: #E08877;
          text-align: center;
          border-bottom: solid 3px #B46D5F;
          cursor: default;
          height: 13px;
          float:left;
        }      

        .progress_Nodisp { 
          border-top: solid 3px #F59582;
          background-color: #E08877;
          color: #E08877;
          border-bottom: solid 3px #B46D5F;
          cursor: default;
          font-size: 1% ; color:#F2F2F2
          height: 13px; 
          float:left;
        }

        .pxtype_QC { 
          border-top: solid 2px #FAA589;
          background-color: #E2967C;
          border-bottom: solid 2px #BC7C67;
          cursor: default;
        }      

        .pxtype_S1 { 
          border-top: solid 2px #88F3B8;
          background-color: #79D8A4;
          border-bottom: solid 2px #60AC82;
          cursor: default;
        }      

        .pxtype_S2 { 
          border-top: solid 2px #9DF5FB;
          background-color: #87D2D7;
          border-bottom: solid 2px #70AEB2;
          cursor: default;
        }      

        .pxtype_Instance { 
          border: solid 1px #FFFFFF;
          cursor: default;
        }      

        .active_period { 
          border-top: solid 3px #A2C8E4;
          background-color: #8CADC5;
          color: #8CADC5;
          border-bottom: solid 3px #617888;
          cursor: default;
        }      

        a.info span {
          display: none;
        }

        a.info:hover {
          position: relative;
        }

        a.info:hover span {
          display: block;
          position: absolute;
          border: thin solid black;
          background-color: #FFFF99;
        }

       </style>
       <xsl:call-template name="auto_refresh"/>
   </head>
   <body bgcolor="#FFFFFF">
     <h1 align="center">SQL Monitoring List</h1>
     <br/>
     <br/>
     <table class="s17" border="1" ora_borderstyle="headeronly"
            cellspacing="0" cellpadding="0" width="100%">
       <tr class="s16">
        <th>
           Status
         </th>
         <th width="120">
           Duration
         </th>
         <xsl:if test="$min_inst_id != $max_inst_id">
           <th>
             Inst Id
           </th>
         </xsl:if>
         <th>
           SQL Id
         </th>
         <th>
           User
         </th>
         <th>
           Dop
         </th>
         <th width="120">
           DB Time
         </th>
         <th width="120">
           IOs
         </th>
         <th>
           Start
         </th>
         <th>
           End
         </th>
         <th width="30%">
           SQL Text
         </th>
       </tr>
         <xsl:apply-templates
                select="/report/sql_monitor_list_report/sql"/>
     </table>
   </body>
 </html>
</xsl:template>


<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!--                         begin function definitions                     -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

<!-- ++++++++++++++++++++++++++++ normalize +++++++++++++++++++++++++++++++ -->
<xsl:template name="normalize">
<xsl:param name="n"/>
<xsl:choose>
  <xsl:when test="boolean($n) = false() or $n = ''">
    <P class="nodisp">.</P>
  </xsl:when>
  <xsl:when test="$n &lt; 100000">
    <xsl:value-of select="string($n)"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000">
    <xsl:value-of select="concat(string(round($n div 1000)), 'K')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000">
    <xsl:value-of select="concat(string(round($n div 1000000)), 'M')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000">
    <xsl:value-of select="concat(string(round($n div 1000000000)), 'G')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000000">
    <xsl:value-of select="concat(string(round($n div 1000000000000)), 'T')"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of
       select="concat(string(round($n div 1000000000000000)), 'P')"/>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- +++++++++++++++++++++++++ normalize_bytes ++++++++++++++++++++++++++++ -->
<xsl:template name="normalize_bytes">
<xsl:param name="n"/>
<xsl:choose>
  <xsl:when test="boolean($n) = false() or $n = ''">
    <P class="nodisp">.</P>
  </xsl:when>
  <xsl:when test="$n &lt; 100000">
    <xsl:value-of select="concat(string($n), 'Bytes')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000">
    <xsl:value-of select="concat(string(round($n div 1024)), 'KB')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000">
    <xsl:value-of select="concat(string(round($n div 1048576)), 'MB')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000">
    <xsl:value-of select="concat(string(round($n div 1073741824)), 'GB')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000000">
    <xsl:value-of select="concat(string(round($n div 1099511627776)), 'TB')"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of
              select="concat(string(round($n div 1125899906842624)), 'PB')"/>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- ++++++++++++++ translate monitor name template ++++++++++++++++++++++ -->
<xsl:template name="translate_monitor_name">
<xsl:param name="label"/>
<xsl:choose>
  <xsl:when test="$label = 'elapsed_time'">Elapsed</xsl:when>
  <xsl:when test="$label = 'cpu_time'">Cpu</xsl:when>
  <xsl:when test="$label = 'sql_cpu_time'">Sql Cpu Time</xsl:when>
  <xsl:when test="$label = 'user_io_wait_time'">IO Time</xsl:when>
  <xsl:when
    test="$label = 'application_wait_time'">Application Wait Time</xsl:when>
  <xsl:when
    test="$label = 'concurrency_wait_time'">Concurrency Wait Time</xsl:when>
  <xsl:when test="$label = 'cluster_wait_time'">Cluster Wait Time</xsl:when>
  <xsl:when test="$label = 'other_wait_time'">Other Wait Time</xsl:when>
  <xsl:when test="$label = 'user_fetch_count'">Fetch Calls</xsl:when>
  <xsl:when test="$label = 'buffer_gets'">Buffer Gets</xsl:when>
  <xsl:when test="$label = 'plsql_exec_time'">PL/SQL Time</xsl:when>
  <xsl:when test="$label = 'java_exec_time'">Java Time</xsl:when>
  <xsl:when test="$label = 'io_cell_filter_perc'">IO Cell<br/>Filter(%)
  </xsl:when>
  <xsl:when test="$label = 'read_reqs'">Read Requests</xsl:when>
  <xsl:when test="$label = 'read_bytes'">Read Bytes</xsl:when>
  <xsl:when test="$label = 'write_reqs'">Write Requests</xsl:when>
  <xsl:when test="$label = 'write_bytes'">Write Bytes</xsl:when>
  <xsl:when test="$label = 'queuing_time'">Queuing Time</xsl:when>
  <xsl:when test="$label = 'executing_time'">Executing Time</xsl:when>
  <xsl:otherwise><xsl:value-of select="$label"/></xsl:otherwise>
</xsl:choose>
</xsl:template>


<!-- +++++++++++++++++++++++ auto-refresh template +++++++++++++++++++++++ -->
<xsl:template name="auto_refresh">
  <xsl:if test="$auto_refresh">
    <meta http-equiv="refresh">
      <xsl:attribute name="content">
        <xsl:value-of select="$auto_refresh"/>
      </xsl:attribute>
    </meta>
  </xsl:if>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ max +++++++++++++++++++++++++++++++ -->
<xsl:template name ="max">
  <xsl:param name ="list" />
  <xsl:choose >
   <xsl:when test ="$list">
    <xsl:variable name ="first" select ="$list[1]"/>
    <xsl:variable name ="rest">
     <xsl:call-template name ="max">
      <xsl:with-param name ="list" select ="$list[position() != 1]" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$first &gt; $rest">
      <xsl:value-of select ="$first"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select ="$rest"/>      
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>0</xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ max_io_requests +++++++++++++++++++++ -->
<xsl:template name ="max_io_requests">
  <xsl:param name ="list"/>
  <xsl:choose>
   <xsl:when test ="$list[1]">
     <xsl:variable name ="first"
       select ="sum($list[1]/stat[@name = 'read_reqs' or
                                  @name = 'write_reqs'])"/>
    <xsl:variable name ="rest">
     <xsl:call-template name ="max_io_requests">
       <xsl:with-param name ="list" select ="$list[position() != 1]" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$first &gt; $rest">
      <xsl:value-of select ="$first"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select ="$rest"/>      
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>0</xsl:otherwise>   
  </xsl:choose>
</xsl:template>

<!-- ++++++++++++++++++++++++++++ min +++++++++++++++++++++++++++++++ -->
<xsl:template name ="min">
  <xsl:param name ="list" />
  <xsl:choose >
   <xsl:when test ="$list">
    <xsl:variable name ="first" select ="$list[1]"/>
    <xsl:variable name ="rest">
     <xsl:call-template name ="min">
      <xsl:with-param name ="list" select ="$list[position() != 1]" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$first &lt; $rest">
      <xsl:value-of select ="$first"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select ="$rest"/>      
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>9999999999999</xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!--                         begin template definitions                     -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- ++++++++++++++++++++++++++++ main template +++++++++++++++++++++++++++ -->
<xsl:template match="sql">

  <xsl:variable name="module" select="module"/>

  <xsl:variable name ="action" select="action"/>

  <xsl:variable name="module_action">
    <xsl:choose>
      <xsl:when test="$action and $module">
        <xsl:value-of select="concat($module, '/', $action)"/>
      </xsl:when>
      <xsl:when test="$action">
        <xsl:value-of select="concat('-/', $action)"/>
      </xsl:when>
      <xsl:when test="$module">
        <xsl:value-of select="concat($module, '/-')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <tr width="100%">
    <td>
      <a>
        <xsl:choose>
          <xsl:when test="@report_ref and $auto_refresh and
                          $auto_refresh != ''">
            <xsl:attribute name="href">
              <xsl:value-of
                select="concat(@report_ref, '&amp;format=html',
                               '&amp;auto_refresh=', $auto_refresh)"/>
            </xsl:attribute>
          </xsl:when>
          <xsl:when test="@report_ref">
            <xsl:attribute name="href">
              <xsl:value-of select="concat(@report_ref, '&amp;format=html')"/>
            </xsl:attribute>
          </xsl:when>
        </xsl:choose>
        <xsl:if test="status = 'EXECUTING'">
          <xsl:attribute name="class">
            executing
          </xsl:attribute>      
        </xsl:if>
        <xsl:if test="status = 'DONE (ERROR)'">
          <xsl:attribute name="class">
            error
          </xsl:attribute>      
        </xsl:if>
        <xsl:value-of select="status"/>
      </a>
    </td>
    <td>
      <!-- We are running into a restriction in XSLT 1.0, which prevents    --> 
      <!-- processing of transformation results. Here, we would like to     -->
      <!-- create an executing duration node based on the duration node and -->
      <!-- queuing_time node (duration-queuing_time). However, such -->
      <!-- action would result in a result tree fragment which cannot be    -->
      <!-- be further processed by another template, unless we use          -->
      <!-- a lang extention function of XSLT 1.0, exsl:node-set which       -->
      <!-- converts the result tree fragment to a node set. Then it can     -->
      <!-- be passed to the build-linear-pie template. Instead, we chose    -->
      <!-- to change the build-linear-pie function (even though it is not   -->
      <!-- as clean as using exsl function)                                 -->
      <xsl:call-template name="build-linear-pie">
        <xsl:with-param name="node_list"
          select="stats[@type='monitor']/
                  stat[@name='duration' or @name='queuing_time']"/>
        <xsl:with-param name="max_value" select="$max_duration"/>
        <xsl:with-param name="unit" select="'d'"/>
      </xsl:call-template>
    </td>
    <xsl:if test="$min_inst_id != $max_inst_id">
      <td align="center">
        <xsl:value-of select="inst_id"/>
      </td>
    </xsl:if>
    <td align="center">
      <a class="info" >
        <xsl:value-of select="@sql_id"/>
        <span>
          <xsl:value-of select="concat('Exec_id:', @sql_exec_id)"/>
        </span>
      </a>
    </td>
    <td align="center">
      <a class="info" >
        <xsl:value-of select="user"/>
        <span>
          <xsl:if test="user_id">
            <xsl:value-of select="concat('UId:', user_id)"/>
            <br/>
          </xsl:if>
          <xsl:if test="session_id">
            <xsl:value-of select="concat('Sid:', session_id, ':',
                                         session_serial)"/>
            <br/>
          </xsl:if>
          <xsl:if test="$module_action and $module_action != ''">
              <xsl:value-of select="concat('Mod/Act:', $module_action)"/>
            <br/>
          </xsl:if>
          <xsl:if test="program">
            <xsl:value-of select="concat('Prg:', program)"/>
            <br/>
          </xsl:if>
          <xsl:if test="service">
            <xsl:value-of select="concat('Svc:', service)"/>
            <br/>
          </xsl:if>
          <xsl:if test="client_info">
            <xsl:value-of select="concat('Cinfo:', client_info)"/>
            <br/>
          </xsl:if>
          <xsl:if test="client_id">
            <xsl:value-of select="concat('Cid:', client_id)"/>
            <br/>
          </xsl:if>
        </span>
      </a>
    </td>
    <td align="center">
      <a class="info">
        <xsl:variable name="downgrade">
          <xsl:if test="px_servers_requested and
                        px_servers_requested != px_servers_allocated">
            <xsl:value-of select="'-'"/>
          </xsl:if>      
        </xsl:variable>
        <xsl:variable name="downgrade_perc">
          <xsl:if test="$downgrade = '-'">
            <xsl:value-of select="round(((px_servers_requested -
                                          px_servers_allocated)
                                         div px_servers_requested)*100)"/>
          </xsl:if>      
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="instances and instances > 1">
            <xsl:value-of select="concat(string(dop), ':', string(instances),
                                  $downgrade)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(string(dop), $downgrade)"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="$downgrade = '-'">
          <span>
            <xsl:value-of
              select="concat('Downgraded:', $downgrade_perc, '%')"/>
            <br/>
            <xsl:value-of
              select="concat(px_servers_requested, '->', px_servers_allocated,
                             ' px_servers')"/>
          </span>
        </xsl:if>
      </a>
    </td>
    <td>
      <xsl:call-template name="build-linear-pie">
        <xsl:with-param 
          name="node_list" 
            select="stats[@type='monitor']/
                  stat[@name!='elapsed_time' and
                       substring(@name, 1 + string-length(@name)-5)='_time']"/>
        <xsl:with-param name="max_value" select="$max_elapsed_time"/>
        <xsl:with-param name="unit" select="'s'"/>
      </xsl:call-template>
    </td>
    <td>
      <xsl:call-template name="build-linear-pie">
        <xsl:with-param 
          name="node_list" 
          select="stats[@type='monitor']/
                  stat[@name = 'read_reqs' or @name = 'write_reqs']"/>
        <xsl:with-param name="max_value" select="$max_io_requests"/>
        <xsl:with-param 
          name="node_tooltip_list" 
          select="stats[@type='monitor']/
                  stat[@name = 'read_bytes' or @name = 'write_bytes']"/>
      </xsl:call-template>
    </td>
    <td align="center">
      <xsl:value-of select="@sql_exec_start"/>
    </td>
    <td align="center">
      <xsl:if test="status != 'EXECUTING' and status != 'QUEUED'">
        <xsl:value-of select="last_refresh_time"/>
      </xsl:if>
    </td>
    <td>
      <a class="info" >
        <xsl:choose>
          <xsl:when test="string-length(sql_text) &gt; 80">
            <xsl:value-of select="concat(substring(sql_text, 1, 80), '...')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="sql_text"/>          
          </xsl:otherwise>
        </xsl:choose>
        <span>
          <xsl:value-of select="sql_text"/>
        </span>
      </a>
    </td>
  </tr>
</xsl:template>


<!-- +++++++++++++++++++++++++++++ build-linear-pie +++++++++++++++++++++ -->
<xsl:template name="build-linear-pie">

  <!-- list of stat nodes for which to build the pie chart -->
  <xsl:param name="node_list"/>

  <!-- list of additional tooltip info -->
  <xsl:param name="node_tooltip_list" select="null"/>

  <!-- optional: when building a table of pie-charts, value for the -->
  <!--           biggest one                                        -->
  <xsl:param name="max_value" select="null"/>

  <!-- optional: when building a table of pie-charts, value for the -->
  <!--           overall total (over all pie charts) -->
  <xsl:param name="total_value" select="null"/>

  <!-- unit. Use 's' for time, nothing for plain counts  -->
  <xsl:param name="unit" select="null"/>

  <!-- duration  -->
  <xsl:variable name="duration"
                select="sum($node_list[@name='duration'])"/> 

  <!-- queuing duration  -->
  <xsl:variable name="queuing_time"
                select="sum($node_list[@name='queuing_time'])"/> 

  <!-- sum of java and pl/sql exec time  -->
  <xsl:variable name="sum_java_plsql"
                select="sum($node_list[@name='java_exec_time' or
                                       @name='plsql_exec_time'])"/>

  <!-- sum of all values -->
  <xsl:variable name="sum_value">
    <xsl:choose>
      <xsl:when test="$duration">
        <xsl:value-of select="sum($node_list) - $queuing_time"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="sum($node_list) - $sum_java_plsql"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
         
  <!-- total value is the sum of all values when not specified -->
  <xsl:variable name="total_valuem">
    <xsl:choose>
      <xsl:when test="$total_value">
        <xsl:value-of select="$total_value"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$sum_value"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- percentage of this pie-chart over the grand total  -->
  <xsl:variable name="perc_value" 
    select="($sum_value * 100) div $total_valuem"/>

  <!-- percentage of this pie-chart compare to the other pie-charts  -->
  <xsl:variable name="total_value_width" >
    <xsl:choose>
      <xsl:when test="$max_value">
        <xsl:value-of 
          select="ceiling((($sum_value * 100) div $max_value)*0.6)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="80"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- class prefix, e.g. 'div_'. This allows to build a unique name  -->
  <!-- for the class associated to each pie-chart                    -->
  <xsl:variable name="class-prefix" select="'div_'"/>

  <!--  now display the bars -->
  <table cellspacing="0" cellpadding="0" width="100%">
   <tbody>
   <xsl:if test="$perc_value &gt; 0 and
                 $total_value_width &gt; 1">
     <td>
       <xsl:attribute name="style">
         width:<xsl:value-of select="$total_value_width"/>%
       </xsl:attribute>
     <table class="graph" cellspacing="0" cellpadding="0" width="100%">
     <tbody>
       <tr>
          <td class="bar">
            <xsl:for-each select="$node_list">

              <!--  determine node name and value -->
              <xsl:variable name="node_name">
                <xsl:choose>
                  <xsl:when test="@name = 'duration' and $queuing_time != 0">
                    <xsl:value-of select="'executing_time'"/>
                  </xsl:when>
                  <xsl:when test="@name != 'cpu_time' or
                                  $sum_java_plsql = 0">
                    <xsl:value-of select="@name"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="'sql_cpu_time'"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="node_value">
                <xsl:choose>
                  <xsl:when test="@name = 'queuing_time' and $duration">
                    <xsl:value-of select=". div 1000000"/>
                  </xsl:when>
                  <!-- executing duartion = (duration - queuing duration) -->
                  <xsl:when test="@name = 'duration' and $queuing_time != 0">
                    <xsl:value-of select=". - $queuing_time div 1000000"/>
                  </xsl:when>
                  <xsl:when test="@name != 'cpu_time' or
                                  $sum_java_plsql = 0">
                    <xsl:value-of select="."/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select=". - $sum_java_plsql"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>

              <!--  compute relative and absolute percentatge -->
              <xsl:variable name="relative_value_perc" 
                  select="floor(($node_value * 100) div $sum_value)"/>
              <xsl:variable name="raw_value_perc" 
                  select="($node_value * 100) div $total_valuem"/>
              <xsl:variable name="absolute_value_perc">
                <xsl:choose>
                  <xsl:when test="$raw_value_perc &lt; 10">
                    <xsl:value-of
                      select="format-number($raw_value_perc, '#.0')"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of
                      select="format-number($raw_value_perc, '#')"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>

              <!--  determine tool-tip of value -->
              <xsl:variable name="label_name">
                <xsl:call-template name="translate_monitor_name">
                  <xsl:with-param name="label" select="$node_name"/>
                </xsl:call-template>
              </xsl:variable>

              <xsl:variable name="label_value">
                <xsl:choose>
                  <xsl:when test="$unit = 's'">
                    <xsl:value-of 
                      select="concat($label_name, ' - ',
                          string(round($node_value div 10000) div 100), 's')"/>
                  </xsl:when>
                  <xsl:when test="$unit = 'd' and $node_value &lt; 1">
                    <xsl:value-of 
                      select="concat($label_name, ' - ',
                                   format-number($node_value, '0.00'), 's')"/>
                  </xsl:when>
                  <xsl:when test="$unit = 'd' and $node_value &lt; 10">
                    <xsl:value-of 
                      select="concat($label_name, ' - ',
                                   format-number($node_value, '0.0'), 's')"/>
                  </xsl:when>
                  <xsl:when test="$unit = 'd'">
                    <xsl:value-of 
                      select="concat($label_name, ' - ',
                                   format-number($node_value, '0'), 's')"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:variable name="norm_value">
                      <xsl:call-template name="normalize">
                        <xsl:with-param name="n" select="$node_value"/>
                      </xsl:call-template>
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$node_tooltip_list">
                        <xsl:variable name="node_pos" select="position()"/>
                        <xsl:variable name="norm_value_bytes">
                          <xsl:call-template name="normalize_bytes">
                            <xsl:with-param name="n"
                            select="$node_tooltip_list[position()=$node_pos]"/>
                          </xsl:call-template>
                        </xsl:variable>
                        <xsl:value-of select="concat($label_name, ': ',
                                           string($norm_value), $unit, ' = ',
                                           $norm_value_bytes)"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="concat($label_name, ': ',
                                           string($norm_value), $unit)"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="label_perc">
                <xsl:if test="$absolute_value_perc != 100">
                  <xsl:value-of 
                      select="concat(' (', $absolute_value_perc, '%)')"/>
                </xsl:if>
              </xsl:variable>

              <xsl:variable name="label_final"
                select="concat($label_value, $label_perc)"/>

              <!--  build div if not 0 -->
              <xsl:if test="$relative_value_perc &gt; 0">
                <div>
                  <xsl:attribute name="class">
                    <xsl:value-of select="$class-prefix"/>
                    <xsl:value-of 
                      select="translate(translate(@name, ' ', ''), '/', '')"/>
                  </xsl:attribute> 
                  <xsl:attribute name="style">
                    width:<xsl:value-of select="$relative_value_perc"/>%
                  </xsl:attribute>
                  <xsl:attribute name="title">
                    <xsl:value-of select="$label_final"/>
                  </xsl:attribute>
                  <P class="nodisp">.</P>
                </div>
              </xsl:if>
            </xsl:for-each>
          </td>
       </tr>
     </tbody>
     </table>
     </td> 
  </xsl:if>

  <td align="left">

    <xsl:if test="$perc_value &gt; 0">

       <!--  compute value for total lable -->
       <xsl:variable name="label_value_total">
         <xsl:choose>
           <xsl:when test="$unit = 's'">
             <xsl:value-of 
               select="concat(string(round($sum_value div 1000000)), 's')"/>
           </xsl:when>
           <xsl:when test="$unit = 'd' and $sum_value &lt; 1">
                <xsl:value-of 
                      select="concat(format-number($sum_value, '0.00'), 's')"/>
           </xsl:when>
           <xsl:when test="$unit = 'd' and $sum_value &lt; 10">
               <xsl:value-of 
                      select="concat(format-number($sum_value, '0.0'), 's')"/>
           </xsl:when>
           <xsl:when test="$unit = 'd'">
              <xsl:value-of 
                      select="concat(format-number($sum_value, '0'), 's')"/>
           </xsl:when>
           <xsl:otherwise>
             <xsl:variable name="norm_value">
               <xsl:call-template name="normalize">
                 <xsl:with-param name="n" select="$sum_value"/>
               </xsl:call-template>
             </xsl:variable>
             <xsl:value-of 
               select="concat(string($norm_value), $unit)"/>
           </xsl:otherwise>
         </xsl:choose>
       </xsl:variable>

       <!-- add percentage of total if there are multiple values -->
       <xsl:variable name="label_name_total">
         <xsl:choose>
           <xsl:when test="$total_value and $perc_value &lt; 0.1">
             <xsl:value-of
               select="concat($label_value_total, ' (&lt;0.1%)')"/>
           </xsl:when>
           <xsl:when test="$total_value and $perc_value &lt; 10">
             <xsl:value-of
               select="concat($label_value_total, ' (',
                              format-number($perc_value, '#.0'), '%)')"/>
           </xsl:when>
           <xsl:when test="$perc_value != 100">
             <xsl:value-of
               select="concat($label_value_total, ' (',
                              format-number($perc_value, '#'), '%)')"/>
           </xsl:when>
           <xsl:otherwise>
             <xsl:value-of select="$label_value_total"/>
           </xsl:otherwise>
         </xsl:choose>
       </xsl:variable>

       <!-- display result -->
       <xsl:value-of select="$label_name_total"/>

    </xsl:if>
  </td>
  </tbody>
  </table>
</xsl:template>

</xsl:stylesheet>
